/*
 * Decompiled with CFR 0.152.
 */
package mage.game.jumpstart;

import com.google.common.base.Charsets;
import com.google.common.io.CharSource;
import com.google.common.io.Resources;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import mage.cards.Card;
import mage.cards.decks.Deck;
import mage.cards.decks.DeckCardInfo;
import mage.cards.decks.DeckCardLists;
import mage.game.GameException;

public class JumpstartPoolGenerator {
    private static final String RESOURCE_NAME = "jumpstart/jumpstart.txt";
    private static final List<JumpstartPack> JUMPSTART_PACKS;

    private static List<JumpstartPack> getPacks(String jumpstartPacks, boolean useDefault) {
        try {
            CharSource source = useDefault ? Resources.asCharSource((URL)Resources.getResource((String)RESOURCE_NAME), (Charset)Charsets.UTF_8) : CharSource.wrap((CharSequence)jumpstartPacks);
            ArrayList<JumpstartPack> packs = new ArrayList<JumpstartPack>();
            JumpstartPack pack = new JumpstartPack();
            packs.add(pack);
            for (String line : source.readLines()) {
                if (line.isEmpty()) {
                    if (pack.isEmpty()) continue;
                    pack = new JumpstartPack();
                    packs.add(pack);
                    continue;
                }
                if (line.startsWith("#")) continue;
                String[] ls = line.split(" ", 4);
                int quantity = Integer.parseInt(ls[0]);
                for (int i = 0; i < quantity; ++i) {
                    pack.add(new DeckCardInfo(ls[3], ls[2], ls[1]));
                }
            }
            return packs;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static Set<Card> doGeneratePool(List<JumpstartPack> packs) {
        try {
            DeckCardLists list = new DeckCardLists();
            SecureRandom random = new SecureRandom();
            for (int i = 0; i < 2; ++i) {
                int index = random.nextInt(packs.size());
                list.getCards().addAll(packs.get(index).getCards());
            }
            return Deck.load(list, false, false).getCards();
        }
        catch (GameException e) {
            throw new RuntimeException(e);
        }
    }

    public static Set<Card> generatePool() {
        return JumpstartPoolGenerator.doGeneratePool(JUMPSTART_PACKS);
    }

    public static Set<Card> generatePool(String userJumpstartPacks) {
        if (userJumpstartPacks == null || userJumpstartPacks.length() > 300000) {
            return JumpstartPoolGenerator.generatePool();
        }
        List<JumpstartPack> packs = JumpstartPoolGenerator.getPacks(userJumpstartPacks, false);
        return JumpstartPoolGenerator.doGeneratePool(packs);
    }

    static {
        List<JumpstartPack> packs = JumpstartPoolGenerator.getPacks("", true);
        JUMPSTART_PACKS = Collections.unmodifiableList(packs);
    }

    public static class JumpstartPack {
        private final List<DeckCardInfo> cards = new ArrayList<DeckCardInfo>();

        public void add(DeckCardInfo card) {
            this.cards.add(card);
        }

        public boolean isEmpty() {
            return this.cards.isEmpty();
        }

        public List<DeckCardInfo> getCards() {
            return Collections.unmodifiableList(this.cards);
        }
    }
}

