/*
 * Decompiled with CFR 0.152.
 */
package mage.game.match;

import java.util.Date;
import java.util.List;
import java.util.UUID;
import mage.cards.decks.Deck;
import mage.game.Game;
import mage.game.GameException;
import mage.game.GameInfo;
import mage.game.events.Listener;
import mage.game.events.TableEvent;
import mage.game.match.MatchOptions;
import mage.game.match.MatchPlayer;
import mage.game.result.ResultProtos;
import mage.players.Player;

public interface Match {
    public static final int SIDEBOARD_TIME = 180;

    public UUID getId();

    public String getName();

    public boolean hasEnded();

    public boolean hasStarted();

    public boolean checkIfMatchEnds();

    public List<MatchPlayer> getPlayers();

    public MatchPlayer getPlayer(UUID var1);

    public void addPlayer(Player var1, Deck var2);

    public boolean quitMatch(UUID var1);

    public void submitDeck(UUID var1, Deck var2);

    public void updateDeck(UUID var1, Deck var2, boolean var3);

    public void startMatch();

    public void startGame() throws GameException;

    public void sideboard();

    public void endGame();

    public Game getGame();

    public List<Game> getGames();

    public int getWinsNeeded();

    public int getFreeMulligans();

    public void addDraw();

    public int getDraws();

    public int getNumGames();

    public void addGame();

    public boolean isDoneSideboarding();

    public UUID getChooser();

    public MatchOptions getOptions();

    public void addTableEventListener(Listener<TableEvent> var1);

    public void fireSideboardEvent(UUID var1, Deck var2);

    public Date getStartTime();

    public Date getEndTime();

    public boolean isReplayAvailable();

    public void setReplayAvailable(boolean var1);

    public void cleanUpOnMatchEnd(boolean var1, boolean var2);

    public void cleanUp();

    public GameInfo createGameInfo(Game var1);

    public List<GameInfo> getGamesInfo();

    public void setTableId(UUID var1);

    public void setTournamentRound(int var1);

    public ResultProtos.MatchProto toProto();
}

