/*
 * Decompiled with CFR 0.152.
 */
package mage.game.permanent.token;

import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class AshiokNightmareMuseTokenEffect
extends OneShotEffect {
    AshiokNightmareMuseTokenEffect() {
        super(Outcome.Benefit);
        this.staticText = "each opponent exiles the top two cards of their library.";
    }

    private AshiokNightmareMuseTokenEffect(AshiokNightmareMuseTokenEffect effect) {
        super(effect);
    }

    @Override
    public AshiokNightmareMuseTokenEffect copy() {
        return new AshiokNightmareMuseTokenEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        Set cards = game.getOpponents(source.getControllerId(), true).stream().map(game::getPlayer).filter(Objects::nonNull).map(Player::getLibrary).map(library -> library.getTopCards(game, 2)).flatMap(Collection::stream).collect(Collectors.toSet());
        return player.moveCards(cards, Zone.EXILED, source, game);
    }
}

