/*
 * Decompiled with CFR 0.152.
 */
package mage.game.permanent.token;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.effects.common.continuous.SetBasePowerToughnessSourceEffect;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.game.permanent.token.GutterGrimeCountersCount;
import mage.game.permanent.token.TokenImpl;

public final class GutterGrimeToken
extends TokenImpl {
    public GutterGrimeToken() {
        this((UUID)null);
        this.power = new MageInt(3);
        this.toughness = new MageInt(3);
    }

    public GutterGrimeToken(UUID sourceId) {
        super("Ooze Token", "green Ooze creature token with \"This creature's power and toughness are each equal to the number of slime counters on Gutter Grime.\"");
        this.cardType.add(CardType.CREATURE);
        this.subtype.add(SubType.OOZE);
        this.color.setGreen(true);
        this.power = new MageInt(0);
        this.toughness = new MageInt(0);
        this.addAbility(new SimpleStaticAbility(new SetBasePowerToughnessSourceEffect(new GutterGrimeCountersCount(sourceId))));
    }

    private GutterGrimeToken(GutterGrimeToken token) {
        super(token);
    }

    @Override
    public GutterGrimeToken copy() {
        return new GutterGrimeToken(this);
    }
}

