/*
 * Decompiled with CFR 0.152.
 */
package mage.game.permanent.token;

import java.util.LinkedHashSet;
import java.util.Set;
import mage.abilities.common.SpellCastControllerTriggeredAbility;
import mage.abilities.keyword.HexproofAbility;
import mage.constants.CardType;
import mage.constants.SuperType;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.TokenImpl;
import mage.game.permanent.token.VolosJournalTokenEffect;
import mage.game.permanent.token.VolosJournalTokenHint;

public final class VolosJournalToken
extends TokenImpl {
    public VolosJournalToken() {
        super("Volo's Journal", "Volo's Journal, a legendary colorless artifact token with hexproof and \"Whenever you cast a creature spell, note one of its creature types that hasn't been noted for this artifact.\"");
        this.supertype.add(SuperType.LEGENDARY);
        this.cardType.add(CardType.ARTIFACT);
        this.addAbility(HexproofAbility.getInstance());
        this.addAbility(new SpellCastControllerTriggeredAbility(new VolosJournalTokenEffect(), StaticFilters.FILTER_SPELL_A_CREATURE, false).addHint(VolosJournalTokenHint.instance));
    }

    private VolosJournalToken(VolosJournalToken token) {
        super(token);
    }

    @Override
    public VolosJournalToken copy() {
        return new VolosJournalToken(this);
    }

    public static Set<String> getNotedTypes(Game game, Permanent permanent) {
        if (permanent == null) {
            return new LinkedHashSet<String>();
        }
        String key = "notedTypes_" + permanent.getId() + '_' + permanent.getZoneChangeCounter(game);
        Object value = game.getState().getValue(key);
        if (value == null) {
            LinkedHashSet<String> types = new LinkedHashSet<String>();
            game.getState().setValue(key, types);
            return types;
        }
        return (Set)value;
    }
}

