/*
 * Decompiled with CFR 0.152.
 */
package mage.game.permanent.token;

import java.util.Set;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.choices.ChoiceCreatureType;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.SubTypeSet;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.VolosJournalToken;
import mage.game.stack.Spell;
import mage.players.Player;

class VolosJournalTokenEffect
extends OneShotEffect {
    VolosJournalTokenEffect() {
        super(Outcome.Benefit);
        this.staticText = "note one of its creature types that hasn't been noted for this artifact";
    }

    private VolosJournalTokenEffect(VolosJournalTokenEffect effect) {
        super(effect);
    }

    @Override
    public VolosJournalTokenEffect copy() {
        return new VolosJournalTokenEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Spell spell = (Spell)this.getValue("spellCast");
        if (spell == null) {
            return false;
        }
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (permanent == null) {
            return false;
        }
        Set<String> notedTypes = VolosJournalToken.getNotedTypes(game, permanent);
        ChoiceCreatureType choice = new ChoiceCreatureType(game, source);
        if (!spell.isAllCreatureTypes(game)) {
            choice.getKeyChoices().clear();
            spell.getSubtype(game).stream().filter(subType -> subType.getSubTypeSet() == SubTypeSet.CreatureType).map(SubType::getDescription).forEach(subType -> choice.withItem((String)subType, (String)subType, null, null, null));
        }
        choice.getKeyChoices().keySet().removeIf(notedTypes::contains);
        switch (choice.getKeyChoices().size()) {
            case 0: {
                return false;
            }
            case 1: {
                notedTypes.add((String)choice.getKeyChoices().keySet().stream().findFirst().get());
                return true;
            }
        }
        if (!player.choose(this.outcome, choice, game)) {
            return false;
        }
        notedTypes.add(choice.getChoiceKey());
        return true;
    }
}

