/*
 * Decompiled with CFR 0.152.
 */
package mage.game.stack;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mage.MageIdentifier;
import mage.MageInt;
import mage.MageObject;
import mage.MageObjectReference;
import mage.Mana;
import mage.ObjectColor;
import mage.abilities.Abilities;
import mage.abilities.AbilitiesImpl;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.SpellAbility;
import mage.abilities.costs.mana.ActivationManaAbilityStep;
import mage.abilities.costs.mana.ManaCost;
import mage.abilities.costs.mana.ManaCosts;
import mage.abilities.effects.Effect;
import mage.abilities.keyword.BestowAbility;
import mage.abilities.keyword.PrototypeAbility;
import mage.abilities.keyword.TransformAbility;
import mage.cards.Card;
import mage.cards.CardWithSpellOption;
import mage.cards.FrameStyle;
import mage.cards.ModalDoubleFacedCard;
import mage.cards.ModalDoubleFacedCardHalf;
import mage.cards.SpellOptionCard;
import mage.cards.SplitCard;
import mage.constants.CardType;
import mage.constants.PutCards;
import mage.constants.Rarity;
import mage.constants.SpellAbilityCastMode;
import mage.constants.SpellAbilityType;
import mage.constants.SubType;
import mage.constants.SuperType;
import mage.constants.Zone;
import mage.counters.Counter;
import mage.counters.Counters;
import mage.filter.FilterMana;
import mage.filter.predicate.mageobject.MageObjectReferencePredicate;
import mage.game.Game;
import mage.game.GameState;
import mage.game.MageObjectAttribute;
import mage.game.events.CopiedStackObjectEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.Token;
import mage.game.stack.StackObjectImpl;
import mage.players.Player;
import mage.target.Target;
import mage.util.CardUtil;
import mage.util.GameLog;
import mage.util.ManaUtil;
import mage.util.SubTypes;
import mage.util.functions.CopyTokenFunction;
import mage.util.functions.StackObjectCopyApplier;
import org.apache.log4j.Logger;

public class Spell
extends StackObjectImpl
implements Card {
    private static final Logger logger = Logger.getLogger(Spell.class);
    private final List<SpellAbility> spellAbilities = new ArrayList<SpellAbility>();
    private final Card card;
    private ManaCosts<ManaCost> manaCost;
    private final ObjectColor color;
    private final ObjectColor frameColor;
    private final FrameStyle frameStyle;
    private final SpellAbility ability;
    private final Zone fromZone;
    private final UUID id;
    protected int zoneChangeCounter;
    private UUID controllerId;
    private boolean copy;
    private MageObject copyFrom;
    private boolean faceDown;
    private boolean countered;
    private boolean resolving = false;
    private UUID commandedByPlayerId = null;
    private String commandedByInfo;
    private boolean prototyped;
    private int startingLoyalty;
    private int startingDefense;
    private ActivationManaAbilityStep currentActivatingManaAbilitiesStep = ActivationManaAbilityStep.BEFORE;

    public Spell(Card card, SpellAbility ability, UUID controllerId, Zone fromZone, Game game) {
        this(card, ability, controllerId, fromZone, game, false);
    }

    private Spell(Card card, SpellAbility ability, UUID controllerId, Zone fromZone, Game game, boolean isCopy) {
        if (card == null) {
            throw new IllegalArgumentException("Wrong code usage: can't create spell without card: " + ability, new Throwable());
        }
        Card affectedCard = card;
        if (ability.getSpellAbilityCastMode().isTransformed() && affectedCard.getSecondCardFace() != null) {
            affectedCard = TransformAbility.transformCardSpellStatic(card, card.getSecondCardFace(), game);
        }
        if (ability instanceof PrototypeAbility) {
            affectedCard = ((PrototypeAbility)ability).prototypeCardSpell(card);
            this.prototyped = true;
        }
        this.card = affectedCard;
        this.manaCost = affectedCard.getManaCost().copy();
        this.color = affectedCard.getColor(null).copy();
        this.frameColor = affectedCard.getFrameColor(null).copy();
        this.frameStyle = affectedCard.getFrameStyle();
        this.startingLoyalty = affectedCard.getStartingLoyalty();
        this.startingDefense = affectedCard.getStartingDefense();
        this.id = ability.getId();
        this.zoneChangeCounter = affectedCard.getZoneChangeCounter(game);
        this.ability = ability;
        this.ability.setControllerId(controllerId);
        if (ability.getSpellAbilityCastMode().isFaceDown()) {
            this.faceDown = true;
            this.getColor(game).setColor(null);
            game.getState().getCreateMageObjectAttribute(this.getCard(), game).getSubtype().clear();
        }
        if (ability.getSpellAbilityType() == SpellAbilityType.SPLIT_FUSED) {
            if (!isCopy) {
                SpellAbility left = ((SplitCard)affectedCard).getLeftHalfCard().getSpellAbility().copy();
                SpellAbility right = ((SplitCard)affectedCard).getRightHalfCard().getSpellAbility().copy();
                left.setSourceId(ability.getSourceId());
                right.setSourceId(ability.getSourceId());
                this.spellAbilities.add(left);
                this.spellAbilities.add(right);
            }
        } else {
            this.spellAbilities.add(ability);
        }
        this.controllerId = controllerId;
        this.fromZone = fromZone;
        this.countered = false;
    }

    protected Spell(Spell spell) {
        this.id = spell.id;
        this.zoneChangeCounter = spell.zoneChangeCounter;
        for (SpellAbility spellAbility : spell.spellAbilities) {
            this.spellAbilities.add(spellAbility.copy());
        }
        this.ability = spell.spellAbilities.get(0).equals(spell.ability) ? this.spellAbilities.get(0) : spell.ability.copy();
        this.card = spell.card.copy();
        this.fromZone = spell.fromZone;
        this.manaCost = spell.getManaCost().copy();
        this.color = spell.color.copy();
        this.frameColor = spell.color.copy();
        this.frameStyle = spell.frameStyle;
        this.controllerId = spell.controllerId;
        this.copy = spell.copy;
        this.copyFrom = spell.copyFrom != null ? spell.copyFrom.copy() : null;
        this.faceDown = spell.faceDown;
        this.countered = spell.countered;
        this.resolving = spell.resolving;
        this.commandedByPlayerId = spell.commandedByPlayerId;
        this.commandedByInfo = spell.commandedByInfo;
        this.currentActivatingManaAbilitiesStep = spell.currentActivatingManaAbilitiesStep;
        this.targetChanged = spell.targetChanged;
        this.prototyped = spell.prototyped;
        this.startingLoyalty = spell.startingLoyalty;
        this.startingDefense = spell.startingDefense;
    }

    public boolean activate(Game game, Set<MageIdentifier> allowedIdentifiers, boolean noMana) {
        this.setCurrentActivatingManaAbilitiesStep(ActivationManaAbilityStep.BEFORE);
        if (!this.ability.activate(game, allowedIdentifiers, noMana)) {
            return false;
        }
        for (SpellAbility spellAbility : this.spellAbilities) {
            if (this.ability.equals(spellAbility)) continue;
            boolean payNoMana = noMana;
            payNoMana |= spellAbility.getSpellAbilityType() == SpellAbilityType.SPLICE;
            if (spellAbility.activate(game, allowedIdentifiers, payNoMana |= this.ability.getSpellAbilityType() == SpellAbilityType.SPLIT_FUSED)) continue;
            return false;
        }
        this.setCurrentActivatingManaAbilitiesStep(ActivationManaAbilityStep.NORMAL);
        return true;
    }

    public String getActivatedMessage(Game game, Zone fromZone) {
        StringBuilder sb = new StringBuilder();
        sb.append(" casts ");
        if (this.isCopy()) {
            sb.append("a copied ");
        }
        sb.append(this.ability.getGameLogMessage(game));
        sb.append(" from ");
        sb.append(fromZone.toString().toLowerCase(Locale.ENGLISH));
        return sb.toString();
    }

    public String getSpellCastText(Game game) {
        if (this.getSpellAbility().getSpellAbilityCastMode().isFaceDown()) {
            return "a " + GameLog.getColoredObjectIdName(this.getSpellAbility().getCharacteristics(game)) + " using " + (Object)((Object)this.getSpellAbility().getSpellAbilityCastMode());
        }
        if (this.card instanceof SpellOptionCard) {
            CardWithSpellOption parentCard = (CardWithSpellOption)((SpellOptionCard)this.card).getParentCard();
            String type = ((SpellOptionCard)this.card).getSpellType();
            return GameLog.replaceNameByColoredName(this.card, this.getSpellAbility().toString(), parentCard) + " as " + type + " spell of " + GameLog.getColoredObjectIdName(parentCard);
        }
        if (this.card instanceof ModalDoubleFacedCardHalf) {
            ModalDoubleFacedCard mdfCard = (ModalDoubleFacedCard)this.card.getMainCard();
            return GameLog.replaceNameByColoredName(this.card, this.getSpellAbility().toString(), mdfCard) + " as mdf side of " + GameLog.getColoredObjectIdName(mdfCard);
        }
        return GameLog.replaceNameByColoredName(this.card, this.getSpellAbility().toString());
    }

    @Override
    public String getExpansionSetCode() {
        return this.card.getExpansionSetCode();
    }

    @Override
    public void setExpansionSetCode(String expansionSetCode) {
        throw new IllegalStateException("Wrong code usage: you can't change set code for the spell");
    }

    @Override
    public String getCardNumber() {
        return this.card.getCardNumber();
    }

    @Override
    public void setCardNumber(String cardNumber) {
        throw new IllegalStateException("Wrong code usage: you can't change card number for the spell");
    }

    @Override
    public String getImageFileName() {
        return this.card.getImageFileName();
    }

    @Override
    public void setImageFileName(String imageFile) {
        throw new IllegalStateException("Wrong code usage: you can't change image file name for the spell");
    }

    @Override
    public Integer getImageNumber() {
        return this.card.getImageNumber();
    }

    @Override
    public void setImageNumber(Integer imageNumber) {
        throw new IllegalStateException("Wrong code usage: you can't change image number for the spell");
    }

    @Override
    public boolean resolve(Game game) {
        Player newTurnController;
        Player controller = game.getPlayer(this.getControllerId());
        if (controller == null) {
            return false;
        }
        this.resolving = true;
        if (this.commandedByPlayerId != null && !this.commandedByPlayerId.equals(this.getControllerId()) && (newTurnController = game.getPlayer(this.commandedByPlayerId)) != null) {
            newTurnController.controlPlayersTurn(game, controller.getId(), this.commandedByInfo);
        }
        if (this.isInstantOrSorcery(game)) {
            int index = 0;
            boolean result = false;
            boolean legalParts = false;
            boolean notTargeted = true;
            for (SpellAbility spellAbility : this.spellAbilities) {
                if (!this.hasTargets(spellAbility, game)) continue;
                notTargeted = false;
                legalParts |= this.spellAbilityHasLegalParts(spellAbility, game);
            }
            if (notTargeted || legalParts) {
                for (SpellAbility spellAbility : this.spellAbilities) {
                    if (!this.spellAbilityCheckTargetsAndDeactivateModes(spellAbility, game)) continue;
                    for (UUID modeId : spellAbility.getModes().getSelectedModes()) {
                        spellAbility.getModes().setActiveMode(modeId);
                        result |= spellAbility.resolve(game);
                    }
                    ++index;
                }
                if (game.getState().getZone(this.card.getMainCard().getId()) == Zone.STACK) {
                    if (this.isCopy()) {
                        game.getStack().remove(this, game);
                    } else {
                        controller.moveCards(this.card, Zone.GRAVEYARD, (Ability)this.ability, game);
                    }
                }
                return result;
            }
            if (!game.isSimulation()) {
                game.informPlayers(this.getName() + " has been fizzled.");
            }
            this.counter(null, game);
            return false;
        }
        if (this.isEnchantment(game) && this.hasSubtype(SubType.AURA, game)) {
            boolean bestow = SpellAbilityCastMode.BESTOW.equals((Object)this.ability.getSpellAbilityCastMode());
            if (this.ability.getTargets().stillLegal(this.ability, game)) {
                boolean permanentCreated;
                UUID permId;
                MageObject token;
                if (bestow) {
                    BestowAbility.becomeAura(game, this.card);
                }
                if (this.isCopy()) {
                    token = CopyTokenFunction.createTokenCopy(this.card, game, this);
                    if (token.putOntoBattlefield(1, game, this.ability, this.getControllerId(), false, false, null, null, false)) {
                        permId = token.getLastAddedTokenIds().stream().findFirst().orElse(null);
                        permanentCreated = true;
                    } else {
                        permId = null;
                        permanentCreated = false;
                    }
                } else {
                    permId = this.card.getId();
                    MageObjectReference mor = new MageObjectReference(this.getSpellAbility());
                    game.storePermanentCostsTags(mor, this.getSpellAbility());
                    permanentCreated = controller.moveCards(this.card, Zone.BATTLEFIELD, (Ability)this.ability, game, false, this.faceDown, false, null);
                }
                if (permanentCreated) {
                    if (bestow) {
                        Permanent permanent = game.getPermanent(permId);
                        permanent.setSpellAbility(this.ability);
                        BestowAbility.becomeAura(game, permanent);
                    }
                    if (this.isCopy()) {
                        token = game.getPermanent(permId);
                        if (token == null) {
                            return false;
                        }
                        for (Ability ability2 : token.getAbilities()) {
                            if (!(ability2 instanceof SpellAbility) || ability2.getTargets().size() != 1) continue;
                            ((Target)ability2.getTargets().get(0)).add(this.ability.getFirstTarget(), game);
                            ((Effect)ability2.getEffects().get(0)).apply(game, ability2);
                            return ability2.resolve(game);
                        }
                        return false;
                    }
                    return this.ability.resolve(game);
                }
                return false;
            }
            if (bestow) {
                MageObjectReference mor = new MageObjectReference(this.getSpellAbility());
                game.storePermanentCostsTags(mor, this.getSpellAbility());
                return controller.moveCards(this.card, Zone.BATTLEFIELD, (Ability)this.ability, game, false, this.faceDown, false, null);
            }
            if (!game.isSimulation()) {
                game.informPlayers(this.getName() + " has been fizzled.");
            }
            this.counter(null, game);
            return false;
        }
        if (this.isCopy()) {
            Token token = CopyTokenFunction.createTokenCopy(this.card, game, this);
            token.putOntoBattlefield(1, game, this.ability, this.getControllerId(), false, false, null, null, false);
            return true;
        }
        MageObjectReference mor = new MageObjectReference(this.getSpellAbility());
        game.storePermanentCostsTags(mor, this.getSpellAbility());
        return controller.moveCards(this.card, Zone.BATTLEFIELD, (Ability)this.ability, game, false, this.faceDown, false, null);
    }

    private boolean hasTargets(SpellAbility spellAbility, Game game) {
        if (spellAbility.getModes().getSelectedModes().size() < 2) {
            return !spellAbility.getTargets().isEmpty();
        }
        for (UUID modeId : spellAbility.getModes().getSelectedModes()) {
            if (spellAbility.getModes().get(modeId).getTargets().isEmpty()) continue;
            return true;
        }
        return false;
    }

    private boolean spellAbilityCheckTargetsAndDeactivateModes(SpellAbility spellAbility, Game game) {
        boolean legalModes = false;
        Iterator<UUID> iterator = spellAbility.getModes().getSelectedModes().iterator();
        while (iterator.hasNext()) {
            UUID nextSelectedModeId = iterator.next();
            Mode mode = spellAbility.getModes().get(nextSelectedModeId);
            if (!mode.getTargets().isEmpty() && !mode.getTargets().stillLegal(spellAbility, game)) {
                spellAbility.getModes().removeSelectedMode(mode.getId());
                iterator.remove();
                continue;
            }
            legalModes = true;
        }
        return legalModes;
    }

    private boolean spellAbilityHasLegalParts(SpellAbility spellAbility, Game game) {
        if (spellAbility.getModes().getSelectedModes().size() > 1) {
            boolean targetedMode = false;
            boolean legalTargetedMode = false;
            for (UUID modeId : spellAbility.getModes().getSelectedModes()) {
                Mode mode = spellAbility.getModes().get(modeId);
                if (mode.getTargets().isEmpty()) continue;
                targetedMode = true;
                if (!mode.getTargets().stillLegal(spellAbility, game)) continue;
                legalTargetedMode = true;
            }
            if (targetedMode) {
                return legalTargetedMode;
            }
            return true;
        }
        return spellAbility.getTargets().stillLegal(spellAbility, game);
    }

    @Override
    public void counter(Ability source, Game game) {
        this.counter(source, game, PutCards.GRAVEYARD);
    }

    @Override
    public void counter(Ability source, Game game, PutCards putCard) {
        this.countered = true;
        if (this.isCopy()) {
            game.getStack().remove(this, game);
            return;
        }
        Player player = game.getPlayer(source == null ? this.getControllerId() : source.getControllerId());
        if (player != null) {
            putCard.moveCard(player, this.card, source, game, "countered spell");
        }
    }

    public ActivationManaAbilityStep getCurrentActivatingManaAbilitiesStep() {
        return this.currentActivatingManaAbilitiesStep;
    }

    public void setCurrentActivatingManaAbilitiesStep(ActivationManaAbilityStep currentActivatingManaAbilitiesStep) {
        this.currentActivatingManaAbilitiesStep = currentActivatingManaAbilitiesStep;
    }

    @Override
    public UUID getSourceId() {
        return this.card.getId();
    }

    @Override
    public UUID getControllerId() {
        return this.controllerId;
    }

    @Override
    public UUID getControllerOrOwnerId() {
        return this.getControllerId();
    }

    @Override
    public String getName() {
        return this.card.getName();
    }

    @Override
    public String getIdName() {
        String idName = this.card != null ? (this.card instanceof SpellOptionCard ? ((CardWithSpellOption)((SpellOptionCard)this.card).getParentCard()).getId().toString().substring(0, 3) : this.card.getId().toString().substring(0, 3)) : this.getId().toString().substring(0, 3);
        return this.getName() + " [" + idName + ']';
    }

    @Override
    public String getLogName() {
        if (this.faceDown) {
            return "face down spell";
        }
        return GameLog.getColoredObjectIdName(this.card);
    }

    @Override
    public void setName(String name) {
    }

    @Override
    public Rarity getRarity() {
        return this.card.getRarity();
    }

    @Override
    public void setRarity(Rarity rarity) {
        throw new IllegalArgumentException("Un-supported operation: " + this, new Throwable());
    }

    @Override
    public List<CardType> getCardType(Game game) {
        if (this.faceDown) {
            ArrayList<CardType> cardTypes = new ArrayList<CardType>();
            cardTypes.add(CardType.CREATURE);
            return cardTypes;
        }
        if (SpellAbilityCastMode.BESTOW.equals((Object)this.getSpellAbility().getSpellAbilityCastMode())) {
            Card modifiedCard = this.getSpellAbility().getSpellAbilityCastMode().getTypeModifiedCardObjectCopy(this.card, this.getSpellAbility(), game);
            return modifiedCard.getCardType(game);
        }
        return this.card.getCardType(game);
    }

    @Override
    public SubTypes getSubtype() {
        return this.card.getSubtype();
    }

    @Override
    public SubTypes getSubtype(Game game) {
        if (SpellAbilityCastMode.BESTOW.equals((Object)this.getSpellAbility().getSpellAbilityCastMode())) {
            Card modifiedCard = this.getSpellAbility().getSpellAbilityCastMode().getTypeModifiedCardObjectCopy(this.card, this.getSpellAbility(), game);
            return modifiedCard.getSubtype();
        }
        return this.card.getSubtype(game);
    }

    @Override
    public boolean hasSubtype(SubType subtype, Game game) {
        if (SpellAbilityCastMode.BESTOW.equals((Object)this.getSpellAbility().getSpellAbilityCastMode())) {
            Card modifiedCard = this.getSpellAbility().getSpellAbilityCastMode().getTypeModifiedCardObjectCopy(this.card, this.getSpellAbility(), game);
            return modifiedCard.hasSubtype(subtype, game);
        }
        return this.card.hasSubtype(subtype, game);
    }

    @Override
    public List<SuperType> getSuperType(Game game) {
        return this.card.getSuperType(game);
    }

    public List<SpellAbility> getSpellAbilities() {
        return this.spellAbilities;
    }

    @Override
    public Abilities<Ability> getAbilities() {
        return this.card.getAbilities();
    }

    @Override
    public Abilities<Ability> getInitAbilities() {
        return new AbilitiesImpl<Ability>();
    }

    @Override
    public Abilities<Ability> getAbilities(Game game) {
        return this.card.getAbilities(game);
    }

    @Override
    public boolean hasAbility(Ability ability, Game game) {
        return this.card.hasAbility(ability, game);
    }

    @Override
    public ObjectColor getColor() {
        return this.color;
    }

    @Override
    public ObjectColor getColor(Game game) {
        MageObjectAttribute mageObjectAttribute;
        if (game != null && (mageObjectAttribute = game.getState().getMageObjectAttribute(this.getId())) != null) {
            return mageObjectAttribute.getColor();
        }
        return this.color;
    }

    @Override
    public ObjectColor getFrameColor(Game game) {
        return this.frameColor;
    }

    @Override
    public FrameStyle getFrameStyle() {
        return this.frameStyle;
    }

    @Override
    public ManaCosts<ManaCost> getManaCost() {
        return this.manaCost;
    }

    @Override
    public void setManaCost(ManaCosts<ManaCost> costs) {
        this.manaCost = costs.copy();
    }

    @Override
    public int getManaValue() {
        int cmc = 0;
        if (this.faceDown) {
            return 0;
        }
        for (SpellAbility spellAbility : this.spellAbilities) {
            cmc += spellAbility.getConvertedXManaCost(this.getCard());
        }
        return cmc += this.manaCost.manaValue();
    }

    @Override
    public MageInt getPower() {
        return this.card.getPower();
    }

    @Override
    public MageInt getToughness() {
        return this.card.getToughness();
    }

    @Override
    public int getStartingLoyalty() {
        return this.startingLoyalty;
    }

    @Override
    public void setStartingLoyalty(int startingLoyalty) {
        this.startingLoyalty = startingLoyalty;
    }

    @Override
    public int getStartingDefense() {
        return this.startingDefense;
    }

    @Override
    public void setStartingDefense(int startingDefense) {
        this.startingDefense = startingDefense;
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    public UUID getOwnerId() {
        return this.card.getOwnerId();
    }

    public void addSpellAbility(SpellAbility spellAbility) {
        this.spellAbilities.add(spellAbility);
    }

    @Override
    public void addAbility(Ability ability) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public void addAbilityForCopy(Ability ability) {
        this.card.addAbility(ability);
    }

    @Override
    public SpellAbility getSpellAbility() {
        return this.ability;
    }

    public void setControllerId(UUID controllerId) {
        this.ability.setControllerId(controllerId);
        for (SpellAbility spellAbility : this.spellAbilities) {
            spellAbility.setControllerId(controllerId);
        }
        this.controllerId = controllerId;
    }

    @Override
    public void setOwnerId(UUID controllerId) {
    }

    @Override
    public List<String> getRules() {
        return this.card.getRules();
    }

    @Override
    public List<String> getRules(Game game) {
        return this.card.getRules(game);
    }

    @Override
    public void setFaceDown(boolean value, Game game) {
        this.faceDown = value;
    }

    @Override
    public boolean turnFaceUp(Ability source, Game game, UUID playerId) {
        throw new IllegalStateException("Spells un-support turn face up commands");
    }

    @Override
    public boolean turnFaceDown(Ability source, Game game, UUID playerId) {
        throw new IllegalStateException("Spells un-support turn face up commands");
    }

    @Override
    public boolean isFaceDown(Game game) {
        return this.faceDown;
    }

    @Override
    public boolean isFlipCard() {
        return false;
    }

    @Override
    public String getFlipCardName() {
        return null;
    }

    @Override
    public boolean isTransformable() {
        return false;
    }

    @Override
    public Card getSecondCardFace() {
        return this.card.getSecondCardFace();
    }

    @Override
    public SpellAbility getSecondFaceSpellAbility() {
        return null;
    }

    @Override
    public boolean isNightCard() {
        return false;
    }

    public boolean isPrototyped() {
        return this.prototyped;
    }

    @Override
    public Spell copy() {
        return new Spell(this);
    }

    public Spell copySpell(Game game, Ability source, UUID newController) {
        Card copiedMainCard = game.copyCard(this.card.getMainCard(), source, newController);
        Map<UUID, MageObject> mapOldToNew = CardUtil.getOriginalToCopiedPartsMap(this.card.getMainCard(), copiedMainCard);
        if (!mapOldToNew.containsKey(this.card.getId())) {
            throw new IllegalStateException("Can't find card id after main card copy: " + copiedMainCard.getName());
        }
        Card copiedPart = (Card)mapOldToNew.get(this.card.getId());
        Spell spellCopy = new Spell(copiedPart, this.ability.copySpell(this.card, copiedPart), this.controllerId, this.fromZone, game, true);
        UUID copiedSourceId = spellCopy.ability.getSourceId();
        boolean skipFirst = this.ability.getSpellAbilityType() != SpellAbilityType.SPLIT_FUSED;
        for (SpellAbility spellAbility : this.getSpellAbilities()) {
            if (skipFirst) {
                skipFirst = false;
                continue;
            }
            SpellAbility newAbility = spellAbility.copy();
            newAbility.newId();
            newAbility.setSourceId(copiedSourceId);
            spellCopy.addSpellAbility(newAbility);
        }
        spellCopy.setCopy(true, this);
        spellCopy.setControllerId(newController);
        spellCopy.syncZoneChangeCounterOnStack(this, game);
        return spellCopy;
    }

    @Override
    public boolean removeFromZone(Game game, Zone fromZone, Ability source) {
        return this.card.removeFromZone(game, fromZone, source);
    }

    @Override
    public boolean moveToZone(Zone zone, Ability source, Game game, boolean flag) {
        return this.moveToZone(zone, source, game, flag, null);
    }

    @Override
    public boolean moveToZone(Zone zone, Ability source, Game game, boolean flag, List<UUID> appliedEffects) {
        if (this.isCopy() && zone != Zone.STACK) {
            return true;
        }
        return this.card.moveToZone(zone, source, game, flag, appliedEffects);
    }

    @Override
    public boolean moveToExile(UUID exileId, String name, Ability source, Game game) {
        return this.moveToExile(exileId, name, source, game, null);
    }

    @Override
    public boolean moveToExile(UUID exileId, String name, Ability source, Game game, List<UUID> appliedEffects) {
        if (this.isCopy()) {
            game.getStack().remove(this, game);
            return true;
        }
        return this.card.moveToExile(exileId, name, source, game, appliedEffects);
    }

    @Override
    public boolean putOntoBattlefield(Game game, Zone fromZone, Ability source, UUID controllerId) {
        throw new UnsupportedOperationException("Unsupported operation");
    }

    @Override
    public boolean putOntoBattlefield(Game game, Zone fromZone, Ability source, UUID controllerId, boolean tapped) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean putOntoBattlefield(Game game, Zone fromZone, Ability source, UUID controllerId, boolean tapped, boolean facedown) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean putOntoBattlefield(Game game, Zone fromZone, Ability source, UUID controllerId, boolean tapped, boolean facedown, List<UUID> appliedEffects) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean getUsesVariousArt() {
        return this.card.getUsesVariousArt();
    }

    @Override
    public void setUsesVariousArt(boolean usesVariousArt) {
        this.card.setUsesVariousArt(usesVariousArt);
    }

    @Override
    public List<Mana> getMana() {
        return this.card.getMana();
    }

    @Override
    public boolean cast(Game game, Zone fromZone, SpellAbility ability, UUID controllerId) {
        throw new UnsupportedOperationException("Unsupported operation");
    }

    @Override
    public Ability getStackAbility() {
        return this.ability;
    }

    @Override
    public void assignNewId() {
        throw new UnsupportedOperationException("Unsupported operation");
    }

    @Override
    public int getZoneChangeCounter(Game game) {
        return this.zoneChangeCounter;
    }

    @Override
    public void updateZoneChangeCounter(Game game, ZoneChangeEvent event) {
        throw new UnsupportedOperationException("Unsupported operation");
    }

    @Override
    public void setZoneChangeCounter(int value, Game game) {
        throw new UnsupportedOperationException("Unsupported operation");
    }

    public void syncZoneChangeCounterOnStack(Card card, Game game) {
        this.zoneChangeCounter = card.getZoneChangeCounter(game);
    }

    public void syncZoneChangeCounterOnStack(Spell spell, Game game) {
        this.zoneChangeCounter = spell.getZoneChangeCounter(game);
    }

    @Override
    public void addInfo(String key, String value, Game game) {
    }

    public Zone getFromZone() {
        return this.fromZone;
    }

    @Override
    public void setCopy(boolean isCopy, MageObject copyFrom) {
        this.copy = isCopy;
        this.copyFrom = copyFrom != null ? copyFrom.copy() : null;
    }

    @Override
    public boolean isCopy() {
        return this.copy;
    }

    @Override
    public MageObject getCopyFrom() {
        return this.copyFrom;
    }

    @Override
    public Counters getCounters(Game game) {
        return this.card.getCounters(game);
    }

    @Override
    public Counters getCounters(GameState state) {
        return this.card.getCounters(state);
    }

    @Override
    public boolean addCounters(Counter counter, Ability source, Game game) {
        return this.card.addCounters(counter, source, game);
    }

    @Override
    public boolean addCounters(Counter counter, UUID playerAddingCounters, Ability source, Game game) {
        return this.card.addCounters(counter, playerAddingCounters, source, game);
    }

    @Override
    public boolean addCounters(Counter counter, UUID playerAddingCounters, Ability source, Game game, boolean isEffect) {
        return this.card.addCounters(counter, playerAddingCounters, source, game, isEffect);
    }

    @Override
    public boolean addCounters(Counter counter, UUID playerAddingCounters, Ability source, Game game, List<UUID> appliedEffects) {
        return this.card.addCounters(counter, playerAddingCounters, source, game, appliedEffects);
    }

    @Override
    public boolean addCounters(Counter counter, UUID playerAddingCounters, Ability source, Game game, List<UUID> appliedEffects, boolean isEffect) {
        return this.card.addCounters(counter, playerAddingCounters, source, game, appliedEffects, isEffect);
    }

    @Override
    public boolean addCounters(Counter counter, UUID playerAddingCounters, Ability source, Game game, List<UUID> appliedEffects, boolean isEffect, int maxCounters) {
        return this.card.addCounters(counter, playerAddingCounters, source, game, appliedEffects, isEffect, maxCounters);
    }

    @Override
    public int removeCounters(String counterName, int amount, Ability source, Game game, boolean isDamage) {
        return this.card.removeCounters(counterName, amount, source, game, isDamage);
    }

    @Override
    public int removeCounters(Counter counter, Ability source, Game game, boolean isDamage) {
        return this.card.removeCounters(counter, source, game, isDamage);
    }

    @Override
    public int removeAllCounters(Ability source, Game game, boolean isDamage) {
        return this.card.removeAllCounters(source, game, isDamage);
    }

    @Override
    public int removeAllCounters(String counterName, Ability source, Game game, boolean isDamage) {
        return this.card.removeAllCounters(counterName, source, game, isDamage);
    }

    public Card getCard() {
        return this.card;
    }

    @Override
    public Card getMainCard() {
        return this.card.getMainCard();
    }

    @Override
    public FilterMana getColorIdentity() {
        return ManaUtil.getColorIdentity(this);
    }

    @Override
    public void setZone(Zone zone, Game game) {
        this.card.setZone(zone, game);
        game.getState().setZone(this.getId(), zone);
    }

    @Override
    public void setSpellAbility(SpellAbility ability) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public boolean isCountered() {
        return this.countered;
    }

    public boolean isResolving() {
        return this.resolving;
    }

    @Override
    public void applyEnterWithCounters(Permanent permanent, Ability source, Game game) {
        this.card.applyEnterWithCounters(permanent, source, game);
    }

    @Override
    public void createSingleCopy(UUID newControllerId, StackObjectCopyApplier applier, MageObjectReferencePredicate newTargetFilterPredicate, Game game, Ability source, boolean chooseNewTargets) {
        Spell spellCopy = this.copySpell(game, source, newControllerId);
        if (applier != null) {
            applier.modifySpell(spellCopy, game);
        }
        spellCopy.setZone(Zone.STACK, game);
        game.getStack().push(game, spellCopy);
        if (newTargetFilterPredicate != null) {
            spellCopy.chooseNewTargets(game, newControllerId, true, false, newTargetFilterPredicate);
        } else if (chooseNewTargets || applier != null) {
            spellCopy.chooseNewTargets(game, newControllerId);
        }
        game.fireEvent(new CopiedStackObjectEvent(this, spellCopy, newControllerId));
    }

    @Override
    public boolean canBeCopied() {
        return this.getSpellAbility().canBeCopied();
    }

    @Override
    public boolean isAllCreatureTypes(Game game) {
        return this.card.isAllCreatureTypes(game);
    }

    @Override
    public void setIsAllCreatureTypes(boolean value) {
        this.card.setIsAllCreatureTypes(value);
    }

    @Override
    public void setIsAllCreatureTypes(Game game, boolean value) {
        this.card.setIsAllCreatureTypes(game, value);
    }

    @Override
    public boolean isAllNonbasicLandTypes(Game game) {
        return this.card.isAllNonbasicLandTypes(game);
    }

    @Override
    public void setIsAllNonbasicLandTypes(boolean value) {
        this.card.setIsAllNonbasicLandTypes(value);
    }

    @Override
    public void setIsAllNonbasicLandTypes(Game game, boolean value) {
        this.card.setIsAllNonbasicLandTypes(game, value);
    }

    @Override
    public List<UUID> getAttachments() {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public boolean cantBeAttachedBy(MageObject attachment, Ability source, Game game, boolean silentMode) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public boolean addAttachment(UUID permanentId, Ability source, Game game) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public boolean removeAttachment(UUID permanentId, Ability source, Game game) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public void setCommandedBy(UUID newTurnControllerId, String info) {
        this.commandedByPlayerId = newTurnControllerId;
        this.commandedByInfo = info;
    }

    public UUID getCommandedByPlayerId() {
        return this.commandedByPlayerId;
    }

    public String getCommandedByInfo() {
        return this.commandedByInfo == null ? "" : this.commandedByInfo;
    }

    @Override
    public void looseAllAbilities(Game game) {
        throw new UnsupportedOperationException("Spells should not loose all abilities. Check if this operation is correct.");
    }

    public String toString() {
        return this.ability.toString();
    }

    @Override
    public List<CardType> getCardTypeForDeckbuilding() {
        throw new UnsupportedOperationException("Must call for cards only.");
    }

    @Override
    public boolean hasCardTypeForDeckbuilding(CardType cardType) {
        return false;
    }

    @Override
    public boolean hasSubTypeForDeckbuilding(SubType subType) {
        return false;
    }
}

