/*
 * Decompiled with CFR 0.152.
 */
package mage.game.tournament;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import mage.cards.ExpansionSet;
import mage.cards.decks.Deck;
import mage.constants.TournamentPlayerState;
import mage.game.draft.Draft;
import mage.game.draft.DraftCube;
import mage.game.events.Listener;
import mage.game.events.PlayerQueryEvent;
import mage.game.events.PlayerQueryEventSource;
import mage.game.events.TableEvent;
import mage.game.events.TableEventSource;
import mage.game.jumpstart.JumpstartPoolGenerator;
import mage.game.match.Match;
import mage.game.match.MatchPlayer;
import mage.game.result.ResultProtos;
import mage.game.tournament.MultiplayerRound;
import mage.game.tournament.Round;
import mage.game.tournament.Tournament;
import mage.game.tournament.TournamentOptions;
import mage.game.tournament.TournamentPairing;
import mage.game.tournament.TournamentPlayer;
import mage.game.tournament.TournamentType;
import mage.players.Player;
import mage.players.PlayerType;
import mage.util.RandomUtil;
import org.apache.log4j.Logger;

public abstract class TournamentImpl
implements Tournament {
    private static final Logger logger = Logger.getLogger(TournamentImpl.class);
    protected UUID id = UUID.randomUUID();
    protected UUID tableId = null;
    protected List<Round> rounds = new CopyOnWriteArrayList<Round>();
    protected Map<UUID, TournamentPlayer> players = new HashMap<UUID, TournamentPlayer>();
    protected TournamentOptions options;
    protected TournamentType tournamentType;
    protected List<ExpansionSet> sets = new ArrayList<ExpansionSet>();
    protected String setsInfoShort;
    protected TableEventSource tableEventSource = new TableEventSource();
    protected PlayerQueryEventSource playerQueryEventSource = new PlayerQueryEventSource();
    protected Date startTime;
    protected Date endTime;
    protected Date stepStartTime;
    protected boolean abort;
    protected String tournamentState;
    protected Draft draft;

    protected TournamentImpl(TournamentOptions options) {
        this.options = options;
        this.draft = null;
        this.startTime = new Date();
        this.abort = false;
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    public void addPlayer(Player player, PlayerType playerType) {
        this.players.put(player.getId(), new TournamentPlayer(player, playerType));
    }

    @Override
    public void removePlayer(UUID playerId) {
        this.players.remove(playerId);
    }

    @Override
    public TournamentPlayer getPlayer(UUID playerId) {
        return this.players.get(playerId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void autoSubmit(UUID playerId, Deck deck) {
        if (this.players.containsKey(playerId)) {
            this.players.get(playerId).submitDeck(deck);
        }
        TournamentImpl tournamentImpl = this;
        synchronized (tournamentImpl) {
            this.notifyAll();
        }
    }

    @Override
    public TournamentOptions getOptions() {
        return this.options;
    }

    @Override
    public Collection<TournamentPlayer> getPlayers() {
        return this.players.values();
    }

    @Override
    public int getNumberRounds() {
        return this.options.getNumberRounds();
    }

    @Override
    public Collection<Round> getRounds() {
        return this.rounds;
    }

    @Override
    public List<ExpansionSet> getSets() {
        return this.sets;
    }

    @Override
    public void setBoosterInfo(String setsInfoShort) {
        this.setsInfoShort = setsInfoShort;
    }

    @Override
    public String getBoosterInfo() {
        return this.setsInfoShort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void quit(UUID playerId) {
        TournamentImpl tournamentImpl = this;
        synchronized (tournamentImpl) {
            this.notifyAll();
        }
    }

    @Override
    public void leave(UUID playerId) {
        this.players.remove(playerId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void submitDeck(UUID playerId, Deck deck) {
        if (this.players.containsKey(playerId)) {
            this.players.get(playerId).submitDeck(deck);
        }
        TournamentImpl tournamentImpl = this;
        synchronized (tournamentImpl) {
            this.notifyAll();
        }
    }

    @Override
    public void updateDeck(UUID playerId, Deck deck, boolean ignoreMainBasicLands) {
        TournamentPlayer player = this.players.getOrDefault(playerId, null);
        if (player == null) {
            return;
        }
        player.updateDeck(deck, ignoreMainBasicLands);
    }

    protected Round createRoundRandom() {
        TournamentPlayer player1;
        Round round = new Round(this.rounds.size() + 1, this);
        this.rounds.add(round);
        List<TournamentPlayer> roundPlayers = this.getActivePlayers();
        List<TournamentPlayer> playerWithByes = this.getTournamentPlayersWithBye(roundPlayers);
        while (roundPlayers.size() > 1) {
            player1 = this.getNextAvailablePlayer(roundPlayers, playerWithByes);
            TournamentPlayer player2 = this.getNextAvailablePlayer(roundPlayers, playerWithByes);
            round.addPairing(new TournamentPairing(player1, player2));
        }
        if (!roundPlayers.isEmpty()) {
            player1 = roundPlayers.get(0);
            round.getPlayerByes().add(player1);
            player1.setState(TournamentPlayerState.WAITING);
            player1.setStateInfo("Round Bye");
            this.updateResults();
        }
        return round;
    }

    private TournamentPlayer getNextAvailablePlayer(List<TournamentPlayer> roundPlayers, List<TournamentPlayer> playerWithByes) {
        TournamentPlayer nextPlayer;
        if (playerWithByes.isEmpty()) {
            int i = RandomUtil.nextInt(roundPlayers.size());
            nextPlayer = roundPlayers.get(i);
            roundPlayers.remove(i);
        } else {
            Iterator<TournamentPlayer> iterator = playerWithByes.iterator();
            nextPlayer = iterator.next();
            iterator.remove();
            roundPlayers.remove(nextPlayer);
        }
        return nextPlayer;
    }

    private List<TournamentPlayer> getTournamentPlayersWithBye(List<TournamentPlayer> roundPlayers) {
        ArrayList<TournamentPlayer> playersWithBye = new ArrayList<TournamentPlayer>();
        if (this.rounds.size() > 1) {
            for (int i = this.rounds.size() - 2; i >= 0; --i) {
                TournamentPlayer tournamentPlayerWithBye;
                Round oldRound = this.rounds.get(i);
                if (oldRound == null || oldRound.getPlayerByes().isEmpty() || !roundPlayers.contains(tournamentPlayerWithBye = oldRound.getPlayerByes().iterator().next())) continue;
                playersWithBye.add(tournamentPlayerWithBye);
            }
        }
        return playersWithBye;
    }

    protected void playRound(Round round) {
        for (TournamentPairing pair : round.getPairs()) {
            this.playMatch(pair);
        }
        this.updateResults();
        while (!round.isRoundOver()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(TournamentImpl.class).warn((Object)"TournamentImpl playRound error ", (Throwable)ex);
                break;
            }
        }
        this.updateResults();
    }

    protected void playMultiplayerRound(MultiplayerRound round) {
        this.updateResults();
        this.playMultiPlayerMatch(round);
    }

    protected List<TournamentPlayer> getActivePlayers() {
        ArrayList<TournamentPlayer> activePlayers = new ArrayList<TournamentPlayer>();
        for (TournamentPlayer player : this.players.values()) {
            if (player.isEliminated()) continue;
            activePlayers.add(player);
        }
        return activePlayers;
    }

    @Override
    public void updateResults() {
        for (TournamentPlayer player : this.players.values()) {
            player.setResults("");
            player.setPoints(0);
            player.setStateInfo("");
        }
        for (Round round : this.rounds) {
            for (TournamentPairing pair : round.getPairs()) {
                Match match = pair.getMatch();
                if (match == null || !match.hasEnded()) continue;
                TournamentPlayer tp1 = pair.getPlayer1();
                TournamentPlayer tp2 = pair.getPlayer2();
                MatchPlayer mp1 = match.getPlayer(pair.getPlayer1().getPlayer().getId());
                MatchPlayer mp2 = match.getPlayer(pair.getPlayer2().getPlayer().getId());
                if (round.getRoundNumber() == this.rounds.size()) {
                    match.setTournamentRound(round.getRoundNumber());
                    if (tp1.getState() == TournamentPlayerState.DUELING) {
                        if (round.getRoundNumber() == this.getNumberRounds()) {
                            tp1.setState(TournamentPlayerState.FINISHED);
                        } else {
                            tp1.setState(TournamentPlayerState.WAITING);
                        }
                    }
                    if (tp2.getState() == TournamentPlayerState.DUELING) {
                        if (round.getRoundNumber() == this.getNumberRounds()) {
                            tp2.setState(TournamentPlayerState.FINISHED);
                        } else {
                            tp2.setState(TournamentPlayerState.WAITING);
                        }
                    }
                }
                tp1.setResults(TournamentImpl.addRoundResult(round.getRoundNumber(), pair, tp1, tp2));
                tp2.setResults(TournamentImpl.addRoundResult(round.getRoundNumber(), pair, tp2, tp1));
                if (!mp1.hasQuit() && mp1.getWins() > mp2.getWins() || mp2.hasQuit()) {
                    tp1.setPoints(tp1.getPoints() + 3);
                    continue;
                }
                if (!mp2.hasQuit() && mp1.getWins() < mp2.getWins() || mp1.hasQuit()) {
                    tp2.setPoints(tp2.getPoints() + 3);
                    continue;
                }
                tp1.setPoints(tp1.getPoints() + 1);
                tp2.setPoints(tp2.getPoints() + 1);
            }
            for (TournamentPlayer tp : round.getPlayerByes()) {
                tp.setResults(tp.getResults() + 'R' + round.getRoundNumber() + ' ' + "Bye ");
                tp.setPoints(tp.getPoints() + 3);
            }
        }
    }

    private static String addRoundResult(int round, TournamentPairing pair, TournamentPlayer tournamentPlayer, TournamentPlayer opponentPlayer) {
        String playerResult = tournamentPlayer.getResults() + 'R' + round + ' ' + TournamentImpl.getMatchResultString(tournamentPlayer, opponentPlayer, pair.getMatch());
        return playerResult;
    }

    private static String getMatchResultString(TournamentPlayer p1, TournamentPlayer p2, Match match) {
        MatchPlayer mp1 = match.getPlayer(p1.getPlayer().getId());
        MatchPlayer mp2 = match.getPlayer(p2.getPlayer().getId());
        StringBuilder matchResult = new StringBuilder();
        matchResult.append(p2.getPlayer().getName());
        matchResult.append(" [").append(mp1.getWins());
        if (mp1.hasQuit()) {
            matchResult.append(mp1.getPlayer().hasIdleTimeout() ? "I" : (mp1.getPlayer().hasTimerTimeout() ? "T" : "Q"));
        }
        matchResult.append('-').append(mp2.getWins());
        if (mp2.hasQuit()) {
            matchResult.append(mp2.getPlayer().hasIdleTimeout() ? "I" : (mp2.getPlayer().hasTimerTimeout() ? "T" : "Q"));
        }
        if (match.getDraws() > 0) {
            matchResult.append('-').append(match.getDraws());
        }
        matchResult.append("] ");
        return matchResult.toString();
    }

    @Override
    public boolean isDoneConstructing() {
        for (TournamentPlayer player : this.players.values()) {
            if (player.isDoneConstructing()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean allJoined() {
        for (TournamentPlayer player : this.players.values()) {
            if (player.isJoined()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void addTableEventListener(Listener<TableEvent> listener) {
        this.tableEventSource.addListener(listener);
    }

    @Override
    public void addPlayerQueryEventListener(Listener<PlayerQueryEvent> listener) {
        this.playerQueryEventSource.addListener(listener);
    }

    @Override
    public void fireConstructEvent(UUID playerId) {
        this.playerQueryEventSource.construct(playerId, "Construct", this.getOptions().getLimitedOptions().getConstructionTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void construct() {
        this.tableEventSource.fireTableEvent(TableEvent.EventType.CONSTRUCT);
        if (!this.isAbort()) {
            for (TournamentPlayer player : this.players.values()) {
                player.setConstructing();
                new Thread(() -> player.getPlayer().construct(this, player.getDeck())).start();
            }
            TournamentImpl tournamentImpl = this;
            synchronized (tournamentImpl) {
                while (!this.isDoneConstructing()) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
        this.nextStep();
    }

    protected void openBoosters() {
        for (TournamentPlayer player : this.players.values()) {
            player.setDeck(new Deck());
            if (this.options.getLimitedOptions().getDraftCube() != null) {
                DraftCube cube = this.options.getLimitedOptions().getDraftCube();
                for (int i = 0; i < this.options.getLimitedOptions().getNumberBoosters(); ++i) {
                    player.getDeck().getSideboard().addAll(cube.createBooster());
                }
                continue;
            }
            if (this.options.getLimitedOptions().getIsJumpstart()) {
                if (this.options.getLimitedOptions().jumpstartPacks == null) {
                    player.getDeck().getCards().addAll(JumpstartPoolGenerator.generatePool());
                    continue;
                }
                player.getDeck().getCards().addAll(JumpstartPoolGenerator.generatePool(this.options.getLimitedOptions().jumpstartPacks));
                continue;
            }
            for (ExpansionSet set : this.sets) {
                player.getDeck().getSideboard().addAll(set.createBooster());
            }
        }
        this.nextStep();
    }

    public void playMatch(TournamentPairing pair) {
        this.options.getMatchOptions().getPlayerTypes().clear();
        this.options.getMatchOptions().getPlayerTypes().add(pair.getPlayer1().getPlayerType());
        this.options.getMatchOptions().getPlayerTypes().add(pair.getPlayer2().getPlayerType());
        this.tableEventSource.fireTableEvent(TableEvent.EventType.START_MATCH, pair, this.options.getMatchOptions());
    }

    public void playMultiPlayerMatch(MultiplayerRound round) {
        this.tableEventSource.fireTableEvent(TableEvent.EventType.START_MULTIPLAYER_MATCH, round, this.options.getMatchOptions());
    }

    public void end() {
        this.endTime = new Date();
        this.tableEventSource.fireTableEvent(TableEvent.EventType.END);
    }

    protected abstract void runTournament();

    @Override
    public Date getStartTime() {
        return new Date(this.startTime.getTime());
    }

    @Override
    public Date getEndTime() {
        if (this.endTime == null) {
            return null;
        }
        return new Date(this.endTime.getTime());
    }

    @Override
    public TournamentType getTournamentType() {
        return this.tournamentType;
    }

    @Override
    public void setTournamentType(TournamentType tournamentType) {
        this.tournamentType = tournamentType;
    }

    protected void winners() {
        ArrayList<TournamentPlayer> winners = new ArrayList<TournamentPlayer>();
        int pointsWinner = 1;
        for (TournamentPlayer tournamentPlayer : this.getPlayers()) {
            if (pointsWinner < tournamentPlayer.getPoints()) {
                winners.clear();
                winners.add(tournamentPlayer);
                pointsWinner = tournamentPlayer.getPoints();
                continue;
            }
            if (pointsWinner != tournamentPlayer.getPoints()) continue;
            winners.add(tournamentPlayer);
        }
        for (TournamentPlayer tournamentPlayer : winners) {
            tournamentPlayer.setStateInfo("Winner");
        }
    }

    @Override
    public void cleanUpOnTournamentEnd() {
        for (TournamentPlayer tournamentPlayer : this.players.values()) {
            tournamentPlayer.cleanUpOnTournamentEnd();
        }
    }

    @Override
    public boolean isAbort() {
        return this.abort;
    }

    @Override
    public void setAbort(boolean abort) {
        this.abort = abort;
    }

    @Override
    public String getTournamentState() {
        return this.tournamentState;
    }

    @Override
    public void setTournamentState(String tournamentState) {
        this.tournamentState = tournamentState;
    }

    @Override
    public Date getStepStartTime() {
        if (this.stepStartTime != null) {
            return new Date(this.stepStartTime.getTime());
        }
        return null;
    }

    @Override
    public void setStartTime() {
        this.startTime = new Date();
    }

    @Override
    public void setStepStartTime(Date stepStartTime) {
        this.stepStartTime = stepStartTime;
    }

    @Override
    public void clearDraft() {
        this.draft = null;
    }

    @Override
    public Draft getDraft() {
        return this.draft;
    }

    @Override
    public ResultProtos.TourneyProto toProto() {
        ResultProtos.TourneyProto.Builder tourneyBuilder = ResultProtos.TourneyProto.newBuilder().setBoosterInfo(this.getBoosterInfo());
        for (TournamentPlayer player : this.players.values()) {
            TournamentPlayer replacedPlayer = player.getReplacedTournamentPlayer();
            if (replacedPlayer != null) {
                player = replacedPlayer;
            }
            tourneyBuilder.addPlayersBuilder().mergeFrom(player.toProto());
        }
        for (Round round : this.rounds) {
            ResultProtos.TourneyRoundProto.Builder roundBuilder = tourneyBuilder.addRoundsBuilder().setRound(round.getRoundNumber());
            for (TournamentPairing pair : round.getPairs()) {
                Match match = pair.getMatch();
                if (match == null || !match.hasEnded()) continue;
                ResultProtos.MatchProto.Builder builder = roundBuilder.addMatchesBuilder().setName(match.getName()).setGameType(match.getOptions().getGameType()).setDeckType(match.getOptions().getDeckType()).setGames(match.getNumGames()).setDraws(match.getDraws()).addPlayers(this.matchToProto(match, pair.getPlayer1())).addPlayers(this.matchToProto(match, pair.getPlayer2())).setMatchOptions(match.getOptions().toProto()).setEndTimeMs((match.getEndTime() != null ? match.getEndTime() : new Date()).getTime());
            }
            for (TournamentPlayer tp : round.getPlayerByes()) {
                roundBuilder.addByes(tp.getPlayer().getName());
            }
        }
        return tourneyBuilder.build();
    }

    private ResultProtos.MatchPlayerProto matchToProto(Match match, TournamentPlayer player) {
        MatchPlayer matchPlayer = match.getPlayer(player.getPlayer().getId());
        ResultProtos.MatchQuitStatus quit = !matchPlayer.hasQuit() ? ResultProtos.MatchQuitStatus.NO_MATCH_QUIT : (matchPlayer.getPlayer().hasIdleTimeout() ? ResultProtos.MatchQuitStatus.IDLE_TIMEOUT : (matchPlayer.getPlayer().hasTimerTimeout() ? ResultProtos.MatchQuitStatus.TIMER_TIMEOUT : ResultProtos.MatchQuitStatus.QUIT));
        return ResultProtos.MatchPlayerProto.newBuilder().setName(player.getPlayer().getName()).setHuman(player.getPlayer().isHuman()).setWins(matchPlayer.getWins()).setQuit(quit).build();
    }
}

