/*
 * Decompiled with CFR 0.152.
 */
package mage.game.turn;

import java.io.Serializable;
import java.util.UUID;
import mage.constants.PhaseStep;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.util.Copyable;

public abstract class Step
implements Serializable,
Copyable<Step> {
    private final PhaseStep type;
    private final boolean hasPriority;
    protected GameEvent.EventType stepEvent;
    protected GameEvent.EventType preStepEvent;
    protected GameEvent.EventType postStepEvent;
    protected StepPart stepPart;

    @Override
    public abstract Step copy();

    public Step(PhaseStep type, boolean hasPriority) {
        this.type = type;
        this.hasPriority = hasPriority;
    }

    protected Step(Step step) {
        this.type = step.type;
        this.hasPriority = step.hasPriority;
        this.stepEvent = step.stepEvent;
        this.preStepEvent = step.preStepEvent;
        this.postStepEvent = step.postStepEvent;
        this.stepPart = step.stepPart;
    }

    public PhaseStep getType() {
        return this.type;
    }

    public void beginStep(Game game, UUID activePlayerId) {
        this.stepPart = StepPart.PRE;
        game.fireEvent(new GameEvent(this.preStepEvent, null, null, activePlayerId));
    }

    public void resumeBeginStep(Game game, UUID activePlayerId) {
        this.stepPart = StepPart.PRE;
    }

    public void priority(Game game, UUID activePlayerId, boolean resuming) {
        if (this.hasPriority) {
            this.stepPart = StepPart.PRIORITY;
            game.fireEvent(new GameEvent(this.stepEvent, null, null, activePlayerId));
            game.playPriority(activePlayerId, resuming);
        }
    }

    public void endStep(Game game, UUID activePlayerId) {
        this.stepPart = StepPart.POST;
        game.fireEvent(new GameEvent(this.postStepEvent, null, null, activePlayerId));
    }

    public boolean skipStep(Game game, UUID activePlayerId) {
        return game.replaceEvent(new GameEvent(this.stepEvent, null, null, activePlayerId));
    }

    public boolean getHasPriority() {
        return this.hasPriority;
    }

    public StepPart getStepPart() {
        return this.stepPart;
    }

    public String toString() {
        return this.type.getStepText();
    }

    public static enum StepPart {
        PRE,
        PRIORITY,
        POST;

    }
}

