/*
 * Decompiled with CFR 0.152.
 */
package mage.game.turn;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.constants.PhaseStep;
import mage.constants.TurnPhase;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.PhaseChangedEvent;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;
import mage.game.stack.StackObject;
import mage.game.turn.BeginningPhase;
import mage.game.turn.CombatPhase;
import mage.game.turn.EndPhase;
import mage.game.turn.Phase;
import mage.game.turn.PostCombatMainPhase;
import mage.game.turn.PreCombatMainPhase;
import mage.game.turn.Step;
import mage.game.turn.TurnMod;
import mage.players.Player;
import mage.util.ThreadLocalStringBuilder;

public class Turn
implements Serializable {
    private static final ThreadLocalStringBuilder threadLocalBuilder = new ThreadLocalStringBuilder(50);
    private Phase currentPhase;
    private UUID activePlayerId;
    private final List<Phase> phases = new ArrayList<Phase>();
    private boolean declareAttackersStepStarted = false;
    private boolean endTurn;

    public Turn() {
        this.endTurn = false;
        this.phases.add(new BeginningPhase());
        this.phases.add(new PreCombatMainPhase());
        this.phases.add(new CombatPhase());
        this.phases.add(new PostCombatMainPhase());
        this.phases.add(new EndPhase());
    }

    protected Turn(Turn turn) {
        if (turn.currentPhase != null) {
            this.currentPhase = turn.currentPhase.copy();
        }
        this.activePlayerId = turn.activePlayerId;
        for (Phase phase : turn.phases) {
            this.phases.add(phase.copy());
        }
        this.declareAttackersStepStarted = turn.declareAttackersStepStarted;
        this.endTurn = turn.endTurn;
    }

    public Phase getPhase() {
        return this.currentPhase;
    }

    public Phase getPhase(TurnPhase turnPhase) {
        for (Phase phase : this.phases) {
            if (phase.getType() != turnPhase) continue;
            return phase;
        }
        return null;
    }

    public void setPhase(Phase phase) {
        this.currentPhase = phase;
    }

    public Step getStep() {
        if (this.currentPhase != null) {
            return this.currentPhase.getStep();
        }
        return null;
    }

    public boolean play(Game game, Player activePlayer) {
        activePlayer.becomesActivePlayer();
        this.setDeclareAttackersStepStarted(false);
        if (game.isPaused() || game.checkIfGameIsOver()) {
            return false;
        }
        TurnMod skipTurnMod = game.getState().getTurnMods().useNextSkipTurn(activePlayer.getId());
        if (skipTurnMod != null) {
            game.informPlayers(String.format("%s skips their turn%s", activePlayer.getLogName(), skipTurnMod.getInfo()));
            return true;
        }
        this.logStartOfTurn(game, activePlayer);
        this.resetCounts();
        this.activePlayerId = activePlayer.getId();
        this.currentPhase = null;
        this.checkTurnIsControlledByOtherPlayer(game, activePlayer.getId());
        game.getPlayer(activePlayer.getId()).beginTurn(game);
        GameEvent event = new GameEvent(GameEvent.EventType.BEGIN_TURN, null, null, activePlayer.getId());
        game.fireEvent(event);
        for (Phase phase : this.phases) {
            if (game.isPaused() || game.checkIfGameIsOver()) {
                return false;
            }
            if (this.isEndTurnRequested() && phase.getType() != TurnPhase.END) continue;
            this.currentPhase = phase;
            TurnMod skipPhaseMod = game.getState().getTurnMods().useNextSkipPhase(activePlayer.getId(), this.currentPhase.getType());
            if (skipPhaseMod != null) {
                game.informPlayers(String.format("%s skips %s phase%s", new Object[]{activePlayer.getLogName(), this.currentPhase.getType(), skipPhaseMod.getInfo()}));
                continue;
            }
            game.fireEvent(new PhaseChangedEvent(activePlayer.getId(), null));
            if (!phase.play(game, activePlayer.getId())) continue;
            if (game.executingRollback()) {
                return false;
            }
            game.emptyManaPools(null);
            game.saveState(false);
            while (this.playExtraPhases(game, phase.getType())) {
            }
        }
        return false;
    }

    public void resumePlay(Game game, boolean wasPaused) {
        Phase nextPhase;
        this.activePlayerId = game.getActivePlayerId();
        Player activePlayer = game.getPlayer(this.activePlayerId);
        TurnPhase needPhaseType = game.getTurnPhaseType();
        PhaseStep needStepType = game.getTurnStepType();
        Iterator<Phase> it = this.phases.iterator();
        do {
            nextPhase = it.next();
        } while (nextPhase.type != needPhaseType);
        TurnMod skipPhaseMod = game.getState().getTurnMods().useNextSkipPhase(this.activePlayerId, nextPhase.getType());
        if (skipPhaseMod != null && activePlayer != null) {
            game.informPlayers(String.format("%s skips %s phase%s", new Object[]{activePlayer.getLogName(), nextPhase.getType(), skipPhaseMod.getInfo()}));
        } else {
            if (game.isPaused() || game.checkIfGameIsOver()) {
                return;
            }
            this.currentPhase = nextPhase;
            game.fireEvent(new PhaseChangedEvent(this.activePlayerId, null));
            if (nextPhase.resumePlay(game, needStepType, wasPaused)) {
                game.emptyManaPools(null);
                this.playExtraPhases(game, nextPhase.getType());
            }
        }
        while (it.hasNext()) {
            nextPhase = it.next();
            if (game.isPaused() || game.checkIfGameIsOver()) {
                return;
            }
            skipPhaseMod = game.getState().getTurnMods().useNextSkipPhase(this.activePlayerId, nextPhase.getType());
            if (skipPhaseMod != null && activePlayer != null) {
                game.informPlayers(String.format("%s skips %s phase%s", new Object[]{activePlayer.getLogName(), nextPhase.getType(), skipPhaseMod.getInfo()}));
            } else {
                this.currentPhase = nextPhase;
                game.fireEvent(new PhaseChangedEvent(this.activePlayerId, null));
                if (nextPhase.play(game, this.activePlayerId)) {
                    game.emptyManaPools(null);
                    this.playExtraPhases(game, nextPhase.getType());
                }
            }
            if (this.currentPhase.equals(nextPhase)) continue;
            game.fireEvent(new PhaseChangedEvent(this.activePlayerId, null));
            break;
        }
    }

    private void checkTurnIsControlledByOtherPlayer(Game game, UUID activePlayerId) {
        game.getPlayers().values().forEach(player -> {
            if (player.isInGame() && !player.isGameUnderControl()) {
                Player controllingPlayer = game.getPlayer(player.getTurnControlledBy());
                if (player != controllingPlayer && controllingPlayer != null) {
                    game.informPlayers(controllingPlayer.getLogName() + " lost control over " + player.getLogName());
                }
                player.setGameUnderYourControl(game, true);
            }
        });
        TurnMod newControllerMod = game.getState().getTurnMods().useNextNewController(activePlayerId);
        if (newControllerMod != null && !newControllerMod.getNewControllerId().equals(activePlayerId)) {
            game.getPlayer(newControllerMod.getNewControllerId()).controlPlayersTurn(game, activePlayerId, newControllerMod.getInfo());
        }
    }

    private void resetCounts() {
        for (Phase phase : this.phases) {
            phase.resetCount();
        }
    }

    private boolean playExtraPhases(Game game, TurnPhase afterPhase) {
        TurnMod extraPhaseMod;
        while ((extraPhaseMod = game.getState().getTurnMods().useNextExtraPhase(this.activePlayerId, afterPhase)) != null) {
            Phase phase;
            TurnPhase extraPhase = extraPhaseMod.getExtraPhase();
            if (extraPhase == null) {
                throw new IllegalStateException("Wrong code usage: miss data in turn mod's extra phase - " + extraPhaseMod.getInfo());
            }
            switch (extraPhase) {
                case BEGINNING: {
                    phase = new BeginningPhase(true);
                    break;
                }
                case PRECOMBAT_MAIN: {
                    phase = new PreCombatMainPhase();
                    break;
                }
                case COMBAT: {
                    phase = new CombatPhase();
                    break;
                }
                case POSTCOMBAT_MAIN: {
                    phase = new PostCombatMainPhase();
                    break;
                }
                case END: {
                    phase = new EndPhase();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown phase type: " + (Object)((Object)extraPhase));
                }
            }
            PhaseStep skipAllButExtraStep = extraPhaseMod.getSkipAllButExtraStep();
            if (skipAllButExtraStep != null) {
                phase.keepOnlyStep(skipAllButExtraStep);
            }
            this.currentPhase = phase;
            game.fireEvent(new PhaseChangedEvent(this.activePlayerId, extraPhaseMod));
            Player activePlayer = game.getPlayer(this.activePlayerId);
            if (activePlayer != null) {
                game.informPlayers(String.format("%s starts an additional %s phase%s", activePlayer.getLogName(), phase.getType().toString(), extraPhaseMod.getInfo()));
            }
            phase.play(game, this.activePlayerId);
            afterPhase = extraPhase;
        }
        return false;
    }

    public void endTurn(Game game, Ability source) {
        Permanent permanent;
        this.setEndTurnRequested(true);
        while (!game.hasEnded() && !game.getStack().isEmpty()) {
            StackObject stackObject = (StackObject)game.getStack().peekFirst();
            if (stackObject instanceof Spell) {
                ((Spell)stackObject).moveToExile(null, "", source, game);
                continue;
            }
            game.getStack().remove(stackObject, game);
        }
        for (UUID attackerId : game.getCombat().getAttackers()) {
            permanent = game.getPermanent(attackerId);
            if (permanent != null) {
                permanent.removeFromCombat(game);
            }
            game.getCombat().removeAttacker(attackerId, game);
        }
        for (UUID blockerId : game.getCombat().getBlockers()) {
            permanent = game.getPermanent(blockerId);
            if (permanent == null) continue;
            permanent.removeFromCombat(game);
        }
        game.getState().clearTriggeredAbilities();
        game.checkStateAndTriggered();
    }

    public boolean isDeclareAttackersStepStarted() {
        return this.declareAttackersStepStarted;
    }

    public void setDeclareAttackersStepStarted(boolean declareAttackersStepStarted) {
        this.declareAttackersStepStarted = declareAttackersStepStarted;
    }

    public void setEndTurnRequested(boolean endTurn) {
        this.endTurn = endTurn;
    }

    public boolean isEndTurnRequested() {
        return this.endTurn;
    }

    public Turn copy() {
        return new Turn(this);
    }

    public String getValue(int turnNum) {
        StringBuilder sb = threadLocalBuilder.get();
        sb.append('[').append(turnNum).append(':').append((Object)this.currentPhase.getType()).append(':').append((Object)this.currentPhase.getStep().getType()).append(']');
        return sb.toString();
    }

    private void logStartOfTurn(Game game, Player player) {
        String infoTurn = String.format("TURN %d%s for %s", game.getState().getTurnNum(), game.getState().isExtraTurn() ? " (extra)" : "", player.getLogName());
        String infoLife = game.getPlayers().values().stream().map(p -> String.valueOf(p.getLife())).collect(Collectors.joining(" - "));
        game.fireStatusEvent(infoTurn + " (" + infoLife + ")", true, false);
    }
}

