/*
 * Decompiled with CFR 0.152.
 */
package mage.players;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import mage.ConditionalMana;
import mage.Emptiable;
import mage.MageObject;
import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.effects.mana.ManaEffect;
import mage.constants.Duration;
import mage.constants.ManaType;
import mage.constants.PhaseStep;
import mage.constants.TurnPhase;
import mage.filter.Filter;
import mage.filter.FilterMana;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ManaEvent;
import mage.game.events.ManaPaidEvent;
import mage.game.stack.Spell;
import mage.players.ManaPoolItem;
import mage.util.CardUtil;

public class ManaPool
implements Serializable {
    private final UUID playerId;
    private final List<ManaPoolItem> manaItems = new ArrayList<ManaPoolItem>();
    private boolean autoPayment;
    private boolean autoPaymentRestricted;
    private ManaType unlockedManaType;
    private boolean forcedToPay;
    private final List<ManaPoolItem> poolBookmark = new ArrayList<ManaPoolItem>();
    private final Set<ManaType> doNotEmptyManaTypes = new HashSet<ManaType>();
    private boolean manaBecomesBlack = false;
    private boolean manaBecomesColorless = false;

    public ManaPool(UUID playerId) {
        this.playerId = playerId;
        this.autoPayment = true;
        this.autoPaymentRestricted = true;
        this.unlockedManaType = null;
        this.forcedToPay = false;
    }

    protected ManaPool(ManaPool pool) {
        this.playerId = pool.playerId;
        for (ManaPoolItem item : pool.manaItems) {
            this.manaItems.add(item.copy());
        }
        this.autoPayment = pool.autoPayment;
        this.autoPaymentRestricted = pool.autoPaymentRestricted;
        this.unlockedManaType = pool.unlockedManaType;
        this.forcedToPay = pool.forcedToPay;
        for (ManaPoolItem item : pool.poolBookmark) {
            this.poolBookmark.add(item.copy());
        }
        this.doNotEmptyManaTypes.addAll(pool.doNotEmptyManaTypes);
        this.manaBecomesBlack = pool.manaBecomesBlack;
        this.manaBecomesColorless = pool.manaBecomesColorless;
    }

    public int getRed() {
        return this.get(ManaType.RED);
    }

    public int getGreen() {
        return this.get(ManaType.GREEN);
    }

    public int getBlue() {
        return this.get(ManaType.BLUE);
    }

    public int getWhite() {
        return this.get(ManaType.WHITE);
    }

    public int getBlack() {
        return this.get(ManaType.BLACK);
    }

    public boolean pay(ManaType manaType, Ability ability, Filter filter, Game game, Cost costToPay, Mana usedManaToPay) {
        ConditionalManaInfo manaInfo;
        if (!this.isAutoPayment() && manaType != this.unlockedManaType) {
            return false;
        }
        ManaType possibleAsThoughPoolManaType = null;
        if (this.isAutoPayment() && this.isAutoPaymentRestricted() && !this.wasManaAddedBeyondStock() && manaType != this.unlockedManaType) {
            if (this.unlockedManaType != null) {
                ManaPoolItem checkItem = new ManaPoolItem();
                checkItem.add(this.unlockedManaType, 1);
                possibleAsThoughPoolManaType = game.getContinuousEffects().asThoughMana(manaType, checkItem, ability.getSourceId(), ability, ability.getControllerId(), game);
            }
            if (possibleAsThoughPoolManaType == null || possibleAsThoughPoolManaType != this.unlockedManaType) {
                return false;
            }
        }
        if ((manaInfo = this.getConditional(manaType, ability, filter, game, costToPay, possibleAsThoughPoolManaType)) != null) {
            this.removeConditional(manaInfo, ability, game, costToPay, usedManaToPay);
            this.lockManaType();
            return true;
        }
        for (ManaPoolItem mana : this.manaItems) {
            ManaType usableManaType;
            if (filter != null && !filter.match(mana.getSourceObject(), game)) {
                if (ability.getSourceId().equals(mana.getSourceId()) || !(mana.getSourceObject() instanceof Spell)) continue;
                if (((Spell)mana.getSourceObject()).getAbilities(game).stream().flatMap(a -> a.getAllEffects().stream()).anyMatch(ManaEffect.class::isInstance)) continue;
            }
            if (possibleAsThoughPoolManaType == null && manaType != this.unlockedManaType && this.isAutoPayment() && this.isAutoPaymentRestricted() && mana.count() == mana.getStock() || (usableManaType = game.getContinuousEffects().asThoughMana(manaType, mana, ability.getSourceId(), ability, ability.getControllerId(), game)) == null || mana.get(usableManaType) <= 0) continue;
            ManaPaidEvent event = new ManaPaidEvent(ability, mana.getSourceId(), mana.getFlag(), mana.getOriginalId(), mana.getSourceObject(), usableManaType);
            game.fireEvent(event);
            usedManaToPay.increase(usableManaType);
            mana.remove(usableManaType);
            if (mana.count() == 0) {
                this.manaItems.remove(mana);
            }
            this.lockManaType();
            return true;
        }
        return false;
    }

    public int get(ManaType manaType) {
        return this.getMana().get(manaType);
    }

    private ConditionalManaInfo getConditional(ManaType manaType, Ability ability, Filter filter, Game game, Cost costToPay, ManaType possibleAsThoughPoolManaType) {
        if (ability == null || this.getConditionalMana().isEmpty()) {
            return null;
        }
        for (ManaPoolItem mana : this.manaItems) {
            if (!mana.isConditional()) continue;
            ManaType manaTypeToUse = null;
            if (mana.getConditionalMana().get(manaType) > 0) {
                manaTypeToUse = manaType;
            } else {
                if (possibleAsThoughPoolManaType == null) {
                    possibleAsThoughPoolManaType = game.getContinuousEffects().asThoughMana(manaType, mana, ability.getSourceId(), ability, ability.getControllerId(), game);
                }
                if (possibleAsThoughPoolManaType != null && mana.getConditionalMana().get(possibleAsThoughPoolManaType) > 0) {
                    manaTypeToUse = possibleAsThoughPoolManaType;
                }
            }
            if (manaTypeToUse == null || !mana.getConditionalMana().apply(ability, game, mana.getSourceId(), costToPay) || filter != null && !filter.match(mana.getSourceObject(), game)) continue;
            return new ConditionalManaInfo(manaTypeToUse, mana.getSourceObject());
        }
        return null;
    }

    public int getConditionalCount(Ability ability, Game game, FilterMana filter, Cost costToPay) {
        if (ability == null || this.getConditionalMana().isEmpty()) {
            return 0;
        }
        int count = 0;
        for (ConditionalMana mana : this.getConditionalMana()) {
            if (!mana.apply(ability, game, mana.getManaProducerId(), costToPay)) continue;
            count += mana.count(filter);
        }
        return count;
    }

    public int getColorless() {
        return this.get(ManaType.COLORLESS);
    }

    public void clearEmptyManaPoolRules() {
        this.doNotEmptyManaTypes.clear();
        this.manaBecomesBlack = false;
        this.manaBecomesColorless = false;
    }

    public void addDoNotEmptyManaType(ManaType manaType) {
        this.doNotEmptyManaTypes.add(manaType);
    }

    public void setManaBecomesBlack(boolean manaBecomesBlack) {
        this.manaBecomesBlack = manaBecomesBlack;
    }

    public void setManaBecomesColorless(boolean manaBecomesColorless) {
        this.manaBecomesColorless = manaBecomesColorless;
    }

    public void init() {
        this.manaItems.clear();
    }

    public boolean canLostManaOnEmpty() {
        for (ManaPoolItem item : this.manaItems) {
            for (ManaType manaType : ManaType.values()) {
                if (item.get(manaType) == 0 || this.doNotEmptyManaTypes.contains((Object)manaType) || this.manaBecomesBlack || this.manaBecomesColorless) continue;
                return true;
            }
        }
        return false;
    }

    public int emptyPool(Game game) {
        int total = 0;
        Iterator<ManaPoolItem> it = this.manaItems.iterator();
        while (it.hasNext()) {
            ManaPoolItem item = it.next();
            ConditionalMana conditionalItem = item.getConditionalMana();
            for (ManaType manaType : ManaType.values()) {
                if (this.doNotEmptyManaTypes.contains((Object)manaType)) continue;
                if (item.get(manaType) > 0) {
                    total += this.emptyItem(item, item, game, manaType);
                }
                if (conditionalItem == null || conditionalItem.get(manaType) <= 0) continue;
                total += this.emptyItem(item, conditionalItem, game, manaType);
            }
            if (item.count() != 0) continue;
            it.remove();
        }
        return total;
    }

    private int emptyItem(ManaPoolItem item, Emptiable toEmpty, Game game, ManaType manaType) {
        switch (item.getDuration()) {
            case EndOfTurn: {
                if (game.getTurnPhaseType() == TurnPhase.END) break;
                return 0;
            }
            case EndOfCombat: {
                if (game.getTurnPhaseType() == TurnPhase.COMBAT && game.getTurnStepType() == PhaseStep.END_COMBAT) break;
                return 0;
            }
        }
        if (this.manaBecomesBlack) {
            int amount = toEmpty.get(manaType);
            toEmpty.clear(manaType);
            toEmpty.add(ManaType.BLACK, amount);
            return 0;
        }
        if (this.manaBecomesColorless) {
            int amount = toEmpty.get(manaType);
            toEmpty.clear(manaType);
            toEmpty.add(ManaType.COLORLESS, amount);
            return 0;
        }
        int amount = toEmpty.get(manaType);
        toEmpty.clear(manaType);
        return amount;
    }

    public Mana getMana() {
        Mana m = new Mana();
        for (ManaPoolItem item : this.manaItems) {
            m.add(item.getMana());
        }
        return m;
    }

    public Mana getMana(FilterMana filter) {
        if (filter == null) {
            return this.getMana();
        }
        Mana test = this.getMana();
        Mana m = new Mana();
        if (filter.isBlack()) {
            m.setBlack(test.getBlack());
        }
        if (filter.isBlue()) {
            m.setBlue(test.getBlue());
        }
        if (filter.isGreen()) {
            m.setGreen(test.getGreen());
        }
        if (filter.isRed()) {
            m.setRed(test.getRed());
        }
        if (filter.isWhite()) {
            m.setWhite(test.getWhite());
        }
        if (filter.isColorless()) {
            m.setColorless(test.getColorless());
        }
        if (filter.isGeneric()) {
            m.setGeneric(test.getGeneric());
        }
        return m;
    }

    public void addMana(Mana manaToAdd, Game game, Ability source) {
        this.addMana(manaToAdd, game, source, false);
    }

    public void addMana(Mana manaToAdd, Game game, Ability source, boolean dontLoseUntilEOT) {
        this.addMana(manaToAdd, game, source, dontLoseUntilEOT ? Duration.EndOfTurn : null);
    }

    public void addMana(Mana manaToAdd, Game game, Ability source, Duration duration) {
        if (manaToAdd != null) {
            Mana mana = manaToAdd.copy();
            if (!game.replaceEvent(new ManaEvent(GameEvent.EventType.ADD_MANA, source.getId(), source, this.playerId, mana))) {
                if (mana instanceof ConditionalMana) {
                    ConditionalMana conditionalMana = (ConditionalMana)mana;
                    ManaPoolItem item = new ManaPoolItem(conditionalMana, source.getSourceObject(game), conditionalMana.getManaProducerOriginalId() != null ? conditionalMana.getManaProducerOriginalId() : source.getOriginalId());
                    if (duration != null) {
                        item.setDuration(duration);
                    }
                    this.manaItems.add(item);
                } else {
                    ManaPoolItem item = new ManaPoolItem(mana.getRed(), mana.getGreen(), mana.getBlue(), mana.getWhite(), mana.getBlack(), mana.getGeneric() + mana.getColorless(), source.getSourceObject(game), source.getOriginalId(), mana.getFlag());
                    if (duration != null) {
                        item.setDuration(duration);
                    }
                    this.manaItems.add(item);
                }
                ManaEvent manaEvent = new ManaEvent(GameEvent.EventType.MANA_ADDED, source.getId(), source, this.playerId, mana);
                manaEvent.setData(mana.toString());
                game.fireEvent(manaEvent);
            }
        }
    }

    public List<ConditionalMana> getConditionalMana() {
        ArrayList<ConditionalMana> conditionalMana = new ArrayList<ConditionalMana>();
        for (ManaPoolItem item : this.manaItems) {
            if (!item.isConditional()) continue;
            conditionalMana.add(item.getConditionalMana());
        }
        return conditionalMana;
    }

    public boolean conditionalManaHasManaType(ManaType manaType) {
        for (ManaPoolItem item : this.manaItems) {
            if (!item.isConditional() || item.getConditionalMana().get(manaType) <= 0) continue;
            return true;
        }
        return false;
    }

    public int count() {
        int x = 0;
        for (ManaPoolItem item : this.manaItems) {
            x += item.count();
        }
        return x;
    }

    public ManaPool copy() {
        return new ManaPool(this);
    }

    private void removeConditional(ConditionalManaInfo manaInfo, Ability ability, Game game, Cost costToPay, Mana usedManaToPay) {
        for (ConditionalMana mana : this.getConditionalMana()) {
            if (mana.get(manaInfo.manaType) <= 0 || !mana.apply(ability, game, mana.getManaProducerId(), costToPay)) continue;
            mana.set(manaInfo.manaType, CardUtil.overflowDec(mana.get(manaInfo.manaType), 1));
            usedManaToPay.increase(manaInfo.manaType);
            ManaPaidEvent event = new ManaPaidEvent(ability, mana.getManaProducerId(), mana.getFlag(), mana.getManaProducerOriginalId(), manaInfo.sourceObject, manaInfo.manaType);
            game.fireEvent(event);
            break;
        }
    }

    public boolean isAutoPayment() {
        return this.autoPayment || this.forcedToPay;
    }

    public void setAutoPayment(boolean autoPayment) {
        this.autoPayment = autoPayment;
    }

    public boolean isAutoPaymentRestricted() {
        return this.autoPaymentRestricted || this.forcedToPay;
    }

    public void setAutoPaymentRestricted(boolean autoPaymentRestricted) {
        this.autoPaymentRestricted = autoPaymentRestricted;
    }

    public ManaType getUnlockedManaType() {
        return this.unlockedManaType;
    }

    public void unlockManaType(ManaType manaType) {
        this.unlockedManaType = manaType;
    }

    public void lockManaType() {
        this.unlockedManaType = null;
    }

    public void setStock() {
        for (ManaPoolItem mana : this.manaItems) {
            mana.setStock(mana.count());
        }
    }

    private boolean wasManaAddedBeyondStock() {
        for (ManaPoolItem mana : this.manaItems) {
            if (mana.getStock() >= mana.count()) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.count() == 0;
    }

    public List<ManaPoolItem> getManaItems() {
        ArrayList<ManaPoolItem> itemsCopy = new ArrayList<ManaPoolItem>();
        for (ManaPoolItem manaItem : this.manaItems) {
            itemsCopy.add(manaItem.copy());
        }
        return itemsCopy;
    }

    public void setForcedToPay(boolean forcedToPay) {
        this.forcedToPay = forcedToPay;
    }

    public boolean isForcedToPay() {
        return this.forcedToPay;
    }

    public UUID getPlayerId() {
        return this.playerId;
    }

    public void storeMana() {
        this.poolBookmark.clear();
        this.poolBookmark.addAll(this.getManaItems());
    }

    public List<ManaPoolItem> getPoolBookmark() {
        ArrayList<ManaPoolItem> itemsCopy = new ArrayList<ManaPoolItem>();
        for (ManaPoolItem manaItem : this.poolBookmark) {
            itemsCopy.add(manaItem.copy());
        }
        return itemsCopy;
    }

    public void restoreMana(List<ManaPoolItem> manaList) {
        this.manaItems.clear();
        if (!manaList.isEmpty()) {
            ArrayList<ManaPoolItem> itemsCopy = new ArrayList<ManaPoolItem>();
            for (ManaPoolItem manaItem : manaList) {
                itemsCopy.add(manaItem.copy());
            }
            this.manaItems.addAll(itemsCopy);
        }
    }

    public int getColoredAmount(ManaType manaType) {
        switch (manaType) {
            case BLACK: {
                return this.getBlack();
            }
            case BLUE: {
                return this.getBlue();
            }
            case GREEN: {
                return this.getGreen();
            }
            case RED: {
                return this.getRed();
            }
            case WHITE: {
                return this.getWhite();
            }
        }
        throw new IllegalArgumentException("Wrong mana type " + (Object)((Object)manaType));
    }

    public String toString() {
        return this.getMana().toString();
    }

    private static final class ConditionalManaInfo {
        private final ManaType manaType;
        private final MageObject sourceObject;

        private ConditionalManaInfo(ManaType conditionalMana, MageObject sourceObject) {
            this.manaType = conditionalMana;
            this.sourceObject = sourceObject;
        }
    }
}

