/*
 * Decompiled with CFR 0.152.
 */
package mage.players;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import mage.abilities.ActivatedAbility;
import mage.players.PlayableObjectStats;
import mage.util.Copyable;

public class PlayableObjectsList
implements Serializable,
Copyable<PlayableObjectsList> {
    Map<UUID, PlayableObjectStats> objects = new HashMap<UUID, PlayableObjectStats>();

    public PlayableObjectsList() {
    }

    public PlayableObjectsList(Map<UUID, List<ActivatedAbility>> playableObjects) {
        this.load(playableObjects);
    }

    protected PlayableObjectsList(PlayableObjectsList source) {
        source.objects.entrySet().forEach(entry -> this.objects.put((UUID)entry.getKey(), ((PlayableObjectStats)entry.getValue()).copy()));
    }

    @Override
    public PlayableObjectsList copy() {
        return new PlayableObjectsList(this);
    }

    public void load(Map<UUID, List<ActivatedAbility>> playableObjects) {
        this.objects.clear();
        playableObjects.forEach((objectId, list) -> this.objects.put((UUID)objectId, new PlayableObjectStats((List<ActivatedAbility>)list)));
    }

    public boolean containsObject(UUID objectId) {
        return this.objects.containsKey(objectId);
    }

    public boolean isEmpty() {
        return this.objects.isEmpty();
    }

    public PlayableObjectStats getStats(UUID objectId) {
        if (this.objects.containsKey(objectId)) {
            return this.objects.get(objectId).copy();
        }
        return new PlayableObjectStats();
    }

    public int getPlayableAmount(UUID objectId) {
        if (this.objects.containsKey(objectId)) {
            return this.objects.get(objectId).getPlayableAmount();
        }
        return 0;
    }

    public Map<UUID, PlayableObjectStats> getObjects() {
        return this.objects;
    }
}

