/*
 * Decompiled with CFR 0.152.
 */
package mage.players;

import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.ApprovingObject;
import mage.ConditionalMana;
import mage.MageIdentifier;
import mage.MageItem;
import mage.MageObject;
import mage.Mana;
import mage.abilities.Abilities;
import mage.abilities.AbilitiesImpl;
import mage.abilities.Ability;
import mage.abilities.ActivatedAbility;
import mage.abilities.ActivatedAbilityImpl;
import mage.abilities.Mode;
import mage.abilities.PlayLandAbility;
import mage.abilities.SpecialAction;
import mage.abilities.SpellAbility;
import mage.abilities.TriggeredAbility;
import mage.abilities.common.PassAbility;
import mage.abilities.common.PlayLandAsCommanderAbility;
import mage.abilities.common.WhileSearchingPlayFromLibraryAbility;
import mage.abilities.costs.AlternativeCost;
import mage.abilities.costs.AlternativeCostSourceAbility;
import mage.abilities.costs.AlternativeSourceCosts;
import mage.abilities.costs.Cost;
import mage.abilities.costs.Costs;
import mage.abilities.costs.DynamicCost;
import mage.abilities.costs.mana.AlternateManaPaymentAbility;
import mage.abilities.costs.mana.ManaCost;
import mage.abilities.costs.mana.ManaCosts;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.RestrictionEffect;
import mage.abilities.effects.RestrictionUntapNotMoreThanEffect;
import mage.abilities.keyword.BestowAbility;
import mage.abilities.keyword.HexproofBaseAbility;
import mage.abilities.keyword.InfectAbility;
import mage.abilities.keyword.LifelinkAbility;
import mage.abilities.keyword.MorphAbility;
import mage.abilities.keyword.ProtectionAbility;
import mage.abilities.keyword.ShroudAbility;
import mage.abilities.keyword.SquirrellinkAbility;
import mage.abilities.keyword.ToxicAbility;
import mage.abilities.mana.ActivatedManaAbilityImpl;
import mage.abilities.mana.ManaOptions;
import mage.cards.Card;
import mage.cards.CardWithSpellOption;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.cards.ModalDoubleFacedCard;
import mage.cards.ModalDoubleFacedCardHalf;
import mage.cards.SplitCard;
import mage.cards.decks.Deck;
import mage.choices.ChoiceImpl;
import mage.constants.AbilityType;
import mage.constants.AsThoughEffectType;
import mage.constants.EmptyNames;
import mage.constants.ManaType;
import mage.constants.Outcome;
import mage.constants.PhaseStep;
import mage.constants.PlanarDieRollResult;
import mage.constants.PlayerAction;
import mage.constants.RangeOfInfluence;
import mage.constants.RollDieType;
import mage.constants.SpellAbilityType;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.counters.Counter;
import mage.counters.CounterType;
import mage.counters.Counters;
import mage.designations.Designation;
import mage.designations.DesignationType;
import mage.designations.Speed;
import mage.filter.FilterCard;
import mage.filter.FilterMana;
import mage.filter.StaticFilters;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.common.FilterCreatureForCombat;
import mage.filter.common.FilterCreatureForCombatBlock;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.permanent.PermanentIdPredicate;
import mage.game.ExileZone;
import mage.game.Game;
import mage.game.Graveyard;
import mage.game.Table;
import mage.game.ZoneChangeInfo;
import mage.game.ZonesHandler;
import mage.game.combat.CombatGroup;
import mage.game.command.CommandObject;
import mage.game.events.CounterRemovedEvent;
import mage.game.events.CountersRemovedEvent;
import mage.game.events.DamageEvent;
import mage.game.events.DamagePlayerEvent;
import mage.game.events.DamagedPlayerEvent;
import mage.game.events.DiceRolledEvent;
import mage.game.events.DieRolledEvent;
import mage.game.events.DiscardedCardsEvent;
import mage.game.events.DrawCardEvent;
import mage.game.events.DrawTwoOrMoreCardsEvent;
import mage.game.events.DrewCardEvent;
import mage.game.events.EnchantPlayerEvent;
import mage.game.events.EnchantedPlayerEvent;
import mage.game.events.FlipCoinEvent;
import mage.game.events.FlipCoinsEvent;
import mage.game.events.GameEvent;
import mage.game.events.LibrarySearchedEvent;
import mage.game.events.LifeLostEvent;
import mage.game.events.MilledCardEvent;
import mage.game.events.PreventDamageEvent;
import mage.game.events.PreventedDamageEvent;
import mage.game.events.RemoveCounterEvent;
import mage.game.events.RemoveCountersEvent;
import mage.game.events.RollDiceEvent;
import mage.game.events.RollDieEvent;
import mage.game.events.SearchLibraryEvent;
import mage.game.events.TargetEvent;
import mage.game.events.UnattachEvent;
import mage.game.events.UnattachedEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.match.MatchPlayer;
import mage.game.permanent.Permanent;
import mage.game.permanent.PermanentCard;
import mage.game.permanent.PermanentToken;
import mage.game.permanent.token.SquirrelToken;
import mage.game.stack.Spell;
import mage.game.stack.StackAbility;
import mage.game.stack.StackObject;
import mage.game.turn.Step;
import mage.players.Library;
import mage.players.ManaPool;
import mage.players.PlayableObjectsList;
import mage.players.Player;
import mage.players.PlayerList;
import mage.players.net.UserData;
import mage.target.Target;
import mage.target.TargetAmount;
import mage.target.TargetCard;
import mage.target.TargetPermanent;
import mage.target.common.TargetCardInLibrary;
import mage.target.common.TargetControlledCreaturePermanent;
import mage.target.common.TargetDiscard;
import mage.util.CardUtil;
import mage.util.GameLog;
import mage.util.RandomUtil;
import org.apache.log4j.Logger;

public abstract class PlayerImpl
implements Player,
Serializable {
    private static final Logger logger = Logger.getLogger(PlayerImpl.class);
    static final Map<PhaseStep, Step.StepPart> SILENT_PHASES_STEPS = ImmutableMap.builder().put((Object)PhaseStep.DECLARE_ATTACKERS, (Object)Step.StepPart.PRE).build();
    protected boolean abort;
    protected final UUID playerId;
    protected String name;
    protected boolean human;
    protected int life;
    protected boolean wins;
    protected boolean draws;
    protected boolean loses;
    protected Library library;
    protected Cards sideboard;
    protected Cards hand;
    protected Graveyard graveyard;
    protected Set<UUID> commandersIds = new HashSet<UUID>();
    protected Abilities<Ability> abilities;
    protected Counters counters;
    protected int landsPlayed;
    protected int landsPerTurn = 1;
    protected int maxHandSize = 7;
    protected int maxAttackedBy = Integer.MAX_VALUE;
    protected ManaPool manaPool;
    protected boolean passed;
    protected boolean passedTurn;
    protected boolean passedTurnSkipStack;
    protected boolean passedUntilEndOfTurn;
    protected boolean passedUntilNextMain;
    protected boolean passedUntilStackResolved;
    protected Date dateLastAddedToStack;
    protected boolean passedUntilEndStepBeforeMyTurn;
    protected boolean skippedAtLeastOnce;
    protected boolean passedAllTurns;
    protected AbilityType justActivatedType;
    protected int turns;
    protected int storedBookmark = -1;
    protected int priorityTimeLeft = Integer.MAX_VALUE;
    protected int bufferTimeLeft = 0;
    protected boolean left;
    protected boolean quit;
    protected boolean timerTimeout;
    protected boolean idleTimeout;
    protected RangeOfInfluence range;
    protected Set<UUID> inRange = new HashSet<UUID>();
    protected boolean isTestMode = false;
    protected boolean isFastFailInTestMode = true;
    protected boolean canGainLife = true;
    protected boolean canLoseLife = true;
    protected EnumSet<Player.PayLifeCostRestriction> payLifeCostRestrictions = EnumSet.noneOf(Player.PayLifeCostRestriction.class);
    protected boolean loseByZeroOrLessLife = true;
    protected boolean canPlotFromTopOfLibrary = false;
    protected boolean drawsFromBottom = false;
    protected boolean drawsOnOpponentsTurn = false;
    protected int speed = 0;
    protected List<AlternativeSourceCosts> alternativeSourceCosts = new ArrayList<AlternativeSourceCosts>();
    protected boolean isGameUnderControl = true;
    protected UUID turnController;
    protected List<UUID> turnControllers = new ArrayList<UUID>();
    protected Set<UUID> playersUnderYourControl = new HashSet<UUID>();
    protected Set<UUID> usersAllowedToSeeHandCards = new HashSet<UUID>();
    protected List<UUID> attachments = new ArrayList<UUID>();
    protected boolean topCardRevealed = false;
    protected boolean reachedNextTurnAfterLeaving = false;
    protected Map<UUID, Set<MageIdentifier>> castSourceIdWithAlternateMana = new HashMap<UUID, Set<MageIdentifier>>();
    protected Map<UUID, Map<MageIdentifier, ManaCosts<ManaCost>>> castSourceIdManaCosts = new HashMap<UUID, Map<MageIdentifier, ManaCosts<ManaCost>>>();
    protected Map<UUID, Map<MageIdentifier, Costs<Cost>>> castSourceIdCosts = new HashMap<UUID, Map<MageIdentifier, Costs<Cost>>>();
    protected boolean payManaMode = false;
    protected UserData userData;
    protected MatchPlayer matchPlayer;
    protected List<Designation> designations = new ArrayList<Designation>();
    protected FilterMana phyrexianColors;
    protected final List<List<Mana>> availableTriggeredManaList = new ArrayList<List<Mana>>();

    protected PlayerImpl(String name, RangeOfInfluence range) {
        this(UUID.randomUUID());
        this.name = name;
        this.range = range;
        this.hand = new CardsImpl();
        this.graveyard = new Graveyard();
        this.abilities = new AbilitiesImpl<Ability>();
        this.counters = new Counters(new Counter[0]);
        this.manaPool = new ManaPool(this.playerId);
        this.library = new Library(this.playerId);
        this.sideboard = new CardsImpl();
        this.phyrexianColors = null;
    }

    protected PlayerImpl(UUID id) {
        this.playerId = id;
    }

    protected PlayerImpl(PlayerImpl player) {
        this.abort = player.abort;
        this.playerId = player.playerId;
        this.name = player.name;
        this.human = player.human;
        this.life = player.life;
        this.wins = player.wins;
        this.draws = player.draws;
        this.loses = player.loses;
        this.library = player.library.copy();
        this.sideboard = player.sideboard.copy();
        this.hand = player.hand.copy();
        this.graveyard = player.graveyard.copy();
        this.commandersIds = player.commandersIds;
        this.abilities = player.abilities.copy();
        this.counters = player.counters.copy();
        this.landsPlayed = player.landsPlayed;
        this.landsPerTurn = player.landsPerTurn;
        this.maxHandSize = player.maxHandSize;
        this.maxAttackedBy = player.maxAttackedBy;
        this.manaPool = player.manaPool.copy();
        this.turns = player.turns;
        this.left = player.left;
        this.quit = player.quit;
        this.timerTimeout = player.timerTimeout;
        this.idleTimeout = player.idleTimeout;
        this.range = player.range;
        this.canGainLife = player.canGainLife;
        this.canLoseLife = player.canLoseLife;
        this.loseByZeroOrLessLife = player.loseByZeroOrLessLife;
        this.canPlotFromTopOfLibrary = player.canPlotFromTopOfLibrary;
        this.drawsFromBottom = player.drawsFromBottom;
        this.drawsOnOpponentsTurn = player.drawsOnOpponentsTurn;
        this.speed = player.speed;
        this.attachments.addAll(player.attachments);
        this.inRange.addAll(player.inRange);
        this.userData = player.userData;
        this.matchPlayer = player.matchPlayer;
        this.payLifeCostRestrictions = player.payLifeCostRestrictions;
        this.alternativeSourceCosts = CardUtil.deepCopyObject(player.alternativeSourceCosts);
        this.storedBookmark = player.storedBookmark;
        this.topCardRevealed = player.topCardRevealed;
        this.usersAllowedToSeeHandCards.addAll(player.usersAllowedToSeeHandCards);
        this.isTestMode = player.isTestMode;
        this.isGameUnderControl = player.isGameUnderControl;
        this.turnController = player.turnController;
        this.turnControllers.addAll(player.turnControllers);
        this.playersUnderYourControl.addAll(player.playersUnderYourControl);
        this.passed = player.passed;
        this.passedTurn = player.passedTurn;
        this.passedTurnSkipStack = player.passedTurnSkipStack;
        this.passedUntilEndOfTurn = player.passedUntilEndOfTurn;
        this.passedUntilNextMain = player.passedUntilNextMain;
        this.passedUntilStackResolved = player.passedUntilStackResolved;
        this.dateLastAddedToStack = player.dateLastAddedToStack;
        this.passedUntilEndStepBeforeMyTurn = player.passedUntilEndStepBeforeMyTurn;
        this.skippedAtLeastOnce = player.skippedAtLeastOnce;
        this.passedAllTurns = player.passedAllTurns;
        this.justActivatedType = player.justActivatedType;
        this.priorityTimeLeft = player.getPriorityTimeLeft();
        this.bufferTimeLeft = player.getBufferTimeLeft();
        this.reachedNextTurnAfterLeaving = player.reachedNextTurnAfterLeaving;
        this.castSourceIdWithAlternateMana = CardUtil.deepCopyObject(player.castSourceIdWithAlternateMana);
        this.castSourceIdManaCosts = CardUtil.deepCopyObject(player.castSourceIdManaCosts);
        this.castSourceIdCosts = CardUtil.deepCopyObject(player.castSourceIdCosts);
        this.payManaMode = player.payManaMode;
        this.phyrexianColors = player.getPhyrexianColors() != null ? player.phyrexianColors.copy() : null;
        this.designations = CardUtil.deepCopyObject(player.designations);
    }

    @Override
    public void restore(Player player) {
        if (!(player instanceof PlayerImpl)) {
            throw new IllegalArgumentException("Wrong code usage: can't restore from player class " + player.getClass().getName());
        }
        this.name = player.getName();
        this.human = player.isHuman();
        this.life = player.getLife();
        this.passed = player.isPassed();
        this.library = player.getLibrary().copy();
        this.sideboard = player.getSideboard().copy();
        this.hand = player.getHand().copy();
        this.graveyard = player.getGraveyard().copy();
        this.commandersIds = new HashSet<UUID>(player.getCommandersIds());
        this.abilities = player.getAbilities().copy();
        this.counters = player.getCountersAsCopy();
        this.landsPlayed = player.getLandsPlayed();
        this.landsPerTurn = player.getLandsPerTurn();
        this.maxHandSize = player.getMaxHandSize();
        this.maxAttackedBy = player.getMaxAttackedBy();
        this.manaPool = player.getManaPool().copy();
        this.manaPool.setAutoPayment(this.getUserData().isManaPoolAutomatic());
        this.manaPool.setAutoPaymentRestricted(this.getUserData().isManaPoolAutomaticRestricted());
        this.turns = player.getTurns();
        this.range = player.getRange();
        this.canGainLife = player.isCanGainLife();
        this.canLoseLife = player.isCanLoseLife();
        this.attachments.clear();
        this.attachments.addAll(player.getAttachments());
        this.inRange.clear();
        this.inRange.addAll(((PlayerImpl)player).inRange);
        this.payLifeCostRestrictions = player.getPayLifeCostRestrictions();
        this.loseByZeroOrLessLife = player.canLoseByZeroOrLessLife();
        this.canPlotFromTopOfLibrary = player.canPlotFromTopOfLibrary();
        this.drawsFromBottom = player.isDrawsFromBottom();
        this.drawsOnOpponentsTurn = player.isDrawsOnOpponentsTurn();
        this.alternativeSourceCosts = CardUtil.deepCopyObject(((PlayerImpl)player).alternativeSourceCosts);
        this.speed = player.getSpeed();
        this.topCardRevealed = player.isTopCardRevealed();
        this.isGameUnderControl = player.isGameUnderControl();
        this.turnController = this.getId().equals(player.getTurnControlledBy()) ? null : player.getTurnControlledBy();
        this.turnControllers.clear();
        this.turnControllers.addAll(player.getTurnControllers());
        this.playersUnderYourControl.clear();
        this.playersUnderYourControl.addAll(player.getPlayersUnderYourControl());
        this.reachedNextTurnAfterLeaving = player.hasReachedNextTurnAfterLeaving();
        this.clearCastSourceIdManaCosts();
        for (Map.Entry<UUID, Set<MageIdentifier>> entry : player.getCastSourceIdWithAlternateMana().entrySet()) {
            this.castSourceIdWithAlternateMana.put(entry.getKey(), entry.getValue() == null ? null : new HashSet(entry.getValue()));
        }
        for (Map.Entry<UUID, Object> entry : player.getCastSourceIdManaCosts().entrySet()) {
            this.castSourceIdManaCosts.put(entry.getKey(), new HashMap());
            for (Map.Entry subEntry : ((Map)entry.getValue()).entrySet()) {
                this.castSourceIdManaCosts.get(entry.getKey()).put((MageIdentifier)((Object)subEntry.getKey()), (ManaCosts<ManaCost>)(subEntry.getValue() == null ? null : ((ManaCosts)subEntry.getValue()).copy()));
            }
        }
        for (Map.Entry<UUID, Object> entry : player.getCastSourceIdCosts().entrySet()) {
            this.castSourceIdCosts.put(entry.getKey(), new HashMap());
            for (Map.Entry subEntry : ((Map)entry.getValue()).entrySet()) {
                this.castSourceIdCosts.get(entry.getKey()).put((MageIdentifier)((Object)subEntry.getKey()), (Costs<Cost>)(subEntry.getValue() == null ? null : ((Costs)subEntry.getValue()).copy()));
            }
        }
        this.phyrexianColors = player.getPhyrexianColors() != null ? player.getPhyrexianColors().copy() : null;
        this.designations.clear();
        for (Designation designation : player.getDesignations()) {
            this.designations.add(designation.copy());
        }
    }

    @Override
    public void useDeck(Deck deck, Game game) {
        this.library.clear();
        this.library.addAll(deck.getMaindeckCards(), game);
        this.sideboard.clear();
        for (Card card : deck.getSideboard()) {
            this.sideboard.add(card);
        }
    }

    @Override
    public void init(Game game) {
        this.abort = false;
        this.life = game.getStartingLife();
        this.wins = false;
        this.draws = false;
        this.loses = false;
        this.library.reset();
        this.sideboard.clear();
        this.hand.clear();
        this.graveyard.clear();
        this.commandersIds.clear();
        this.abilities.clear();
        this.counters.clear();
        this.landsPlayed = 0;
        this.landsPerTurn = 1;
        this.maxHandSize = 7;
        this.maxAttackedBy = Integer.MAX_VALUE;
        this.getManaPool().init();
        this.passed = false;
        this.passedTurn = false;
        this.passedTurnSkipStack = false;
        this.passedUntilEndOfTurn = false;
        this.passedUntilNextMain = false;
        this.passedUntilStackResolved = false;
        this.dateLastAddedToStack = null;
        this.passedUntilEndStepBeforeMyTurn = false;
        this.skippedAtLeastOnce = false;
        this.passedAllTurns = false;
        this.justActivatedType = null;
        this.turns = 0;
        this.storedBookmark = -1;
        this.priorityTimeLeft = Integer.MAX_VALUE;
        this.bufferTimeLeft = 0;
        this.left = false;
        this.quit = false;
        this.timerTimeout = false;
        this.idleTimeout = false;
        this.inRange.clear();
        this.canGainLife = true;
        this.canLoseLife = true;
        this.payLifeCostRestrictions.clear();
        this.loseByZeroOrLessLife = true;
        this.canPlotFromTopOfLibrary = false;
        this.drawsFromBottom = false;
        this.drawsOnOpponentsTurn = false;
        this.speed = 0;
        this.alternativeSourceCosts.clear();
        this.isGameUnderControl = true;
        this.turnController = null;
        this.turnControllers.clear();
        this.playersUnderYourControl.clear();
        this.attachments.clear();
        this.topCardRevealed = false;
        this.reachedNextTurnAfterLeaving = false;
        this.clearCastSourceIdManaCosts();
        this.payManaMode = false;
        this.designations.clear();
        this.phyrexianColors = null;
        this.availableTriggeredManaList.clear();
    }

    @Override
    public void reset() {
        this.abilities.clear();
        this.landsPerTurn = 1;
        this.maxHandSize = 7;
        this.maxAttackedBy = Integer.MAX_VALUE;
        this.canGainLife = true;
        this.canLoseLife = true;
        this.payLifeCostRestrictions.clear();
        this.loseByZeroOrLessLife = true;
        this.canPlotFromTopOfLibrary = false;
        this.drawsFromBottom = false;
        this.drawsOnOpponentsTurn = false;
        this.topCardRevealed = false;
        this.alternativeSourceCosts.clear();
        this.clearCastSourceIdManaCosts();
        this.getManaPool().clearEmptyManaPoolRules();
        this.phyrexianColors = null;
    }

    @Override
    public Counters getCountersAsCopy() {
        return this.counters.copy();
    }

    @Override
    public void beginTurn(Game game) {
        this.resetLandsPlayed();
        this.updateRange(game);
        game.getState().removeTurnStartEffect(game);
    }

    @Override
    public RangeOfInfluence getRange() {
        return this.range;
    }

    @Override
    public void updateRange(Game game) {
        this.inRange.clear();
        this.inRange.add(this.playerId);
        this.inRange.addAll(this.getAllNearPlayers(game, true));
        this.inRange.addAll(this.getAllNearPlayers(game, false));
    }

    private Set<UUID> getAllNearPlayers(Game game, boolean needPrevious) {
        HashSet<UUID> foundedList = new HashSet<UUID>();
        PlayerList players = game.getState().getPlayerList(this.playerId);
        int needAmount = this.getRange().getRange();
        for (int foundedAmount = 0; needAmount == 0 || foundedAmount < needAmount; ++foundedAmount) {
            Player foundedPlayer;
            Player player = foundedPlayer = needPrevious ? players.getPrevious(game) : players.getNext(game, false);
            if (foundedPlayer == null || foundedPlayer.getId().equals(this.playerId) || foundedList.contains(foundedPlayer.getId())) break;
            foundedList.add(foundedPlayer.getId());
        }
        return foundedList;
    }

    @Override
    public boolean hasPlayerInRange(UUID checkingPlayerId) {
        if (this.inRange.isEmpty()) {
            throw new IllegalStateException("Wrong code usage (game is not started, but you call hasPlayerInRange in some effects).");
        }
        return this.inRange.contains(checkingPlayerId);
    }

    @Override
    public Set<UUID> getPlayersUnderYourControl() {
        return this.playersUnderYourControl;
    }

    @Override
    public boolean controlPlayersTurn(Game game, UUID playerUnderControlId, String info) {
        Player playerUnderControl = game.getPlayer(playerUnderControlId);
        if (this.isComputer()) {
            game.informPlayers(this.getLogName() + " is AI and can't take control over " + playerUnderControl.getLogName() + info);
            return false;
        }
        playerUnderControl.setTurnControlledBy(this.getId());
        game.informPlayers(this.getLogName() + " taken turn control of " + playerUnderControl.getLogName() + info);
        if (!playerUnderControlId.equals(this.getId())) {
            this.playersUnderYourControl.add(playerUnderControlId);
            if (!playerUnderControl.hasLeft() && !playerUnderControl.hasLost()) {
                playerUnderControl.setGameUnderYourControl(game, false);
            }
        }
        return true;
    }

    @Override
    public void setTurnControlledBy(UUID playerId) {
        if (playerId == null) {
            throw new IllegalArgumentException("Can't add unknown player to turn controllers: " + playerId);
        }
        this.turnController = playerId;
        this.turnControllers.add(playerId);
    }

    @Override
    public List<UUID> getTurnControllers() {
        return this.turnControllers;
    }

    @Override
    public UUID getTurnControlledBy() {
        return this.turnController == null ? this.getId() : this.turnController;
    }

    @Override
    public void resetOtherTurnsControlled() {
        this.playersUnderYourControl.clear();
    }

    @Override
    public boolean isGameUnderControl() {
        return this.isGameUnderControl;
    }

    @Override
    public void setGameUnderYourControl(Game game, boolean value) {
        this.setGameUnderYourControl(game, value, true);
    }

    @Override
    public void setGameUnderYourControl(Game game, boolean value, boolean fullRestore) {
        this.isGameUnderControl = value;
        if (this.isGameUnderControl) {
            this.removeMeFromPlayersUnderControl(game);
            if (fullRestore) {
                this.turnControllers.clear();
                this.turnController = null;
                this.isGameUnderControl = true;
            } else {
                if (!this.turnControllers.isEmpty()) {
                    this.turnControllers.remove(this.turnControllers.size() - 1);
                }
                if (this.turnControllers.isEmpty()) {
                    this.turnController = null;
                    this.isGameUnderControl = true;
                } else {
                    this.turnController = this.turnControllers.get(this.turnControllers.size() - 1);
                    this.isGameUnderControl = false;
                    this.addMeToPlayersUnderControl(game, this.turnController);
                }
            }
        }
    }

    private void removeMeFromPlayersUnderControl(Game game) {
        game.getPlayers().values().forEach(p -> p.getPlayersUnderYourControl().remove(this.getId()));
    }

    private void addMeToPlayersUnderControl(Game game, UUID newTurnController) {
        game.getPlayers().values().forEach(p -> {
            if (p.getId().equals(newTurnController)) {
                p.getPlayersUnderYourControl().add(this.getId());
            }
        });
    }

    @Override
    public void endOfTurn(Game game) {
        this.passedTurn = false;
        this.passedTurnSkipStack = false;
    }

    @Override
    public boolean canBeTargetedBy(MageObject sourceObject, UUID sourceControllerId, Ability source, Game game) {
        if (this.hasLost() || this.hasLeft()) {
            return false;
        }
        if (sourceObject != null) {
            if (this.abilities.containsKey(ShroudAbility.getInstance().getId()) && game.getContinuousEffects().asThough(this.getId(), AsThoughEffectType.SHROUD, null, sourceControllerId, game).isEmpty()) {
                return false;
            }
            if (sourceControllerId != null && this.hasOpponent(sourceControllerId, game) && game.getContinuousEffects().asThough(this.getId(), AsThoughEffectType.HEXPROOF, null, sourceControllerId, game).isEmpty()) {
                if (this.abilities.stream().filter(HexproofBaseAbility.class::isInstance).map(HexproofBaseAbility.class::cast).anyMatch(ability -> ability.checkObject(sourceObject, source, game))) {
                    return false;
                }
            }
            if (this.hasProtectionFrom(sourceObject, game)) {
                return false;
            }
            return !game.getContinuousEffects().preventedByRuleModification(new TargetEvent(this, sourceObject.getId(), sourceControllerId), null, game, true);
        }
        return true;
    }

    @Override
    public boolean hasProtectionFrom(MageObject source, Game game) {
        for (ProtectionAbility ability : this.abilities.getProtectionAbilities()) {
            if (ability.canTarget(source, game)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int drawCards(int num, Ability source, Game game) {
        return this.drawCards(num, source, game, null);
    }

    @Override
    public int drawCards(int num, Ability source, Game game, GameEvent event) {
        if (num == 0) {
            return 0;
        }
        if (num >= 2) {
            DrawTwoOrMoreCardsEvent multiDrawEvent = new DrawTwoOrMoreCardsEvent(this.getId(), source, event, num);
            if (game.replaceEvent(multiDrawEvent)) {
                return multiDrawEvent.getCardsDrawn();
            }
            num = multiDrawEvent.getAmount();
        }
        int numDrawn = 0;
        for (int i = 0; i < num; ++i) {
            Card card;
            DrawCardEvent drawCardEvent = new DrawCardEvent(this.getId(), source, event);
            if (game.replaceEvent(drawCardEvent)) {
                numDrawn += drawCardEvent.getCardsDrawn();
                continue;
            }
            Card card2 = card = this.isDrawsFromBottom() ? this.getLibrary().drawFromBottom(game) : this.getLibrary().drawFromTop(game);
            if (card == null) continue;
            card.moveToZone(Zone.HAND, source, game, false);
            if (this.isTopCardRevealed() && !this.isDrawsFromBottom()) {
                game.fireInformEvent(this.getLogName() + " draws a revealed card  (" + card.getLogName() + ')');
            }
            game.fireEvent(new DrewCardEvent(card.getId(), this.getId(), source, event));
            ++numDrawn;
        }
        if ((!this.isTopCardRevealed() || this.isDrawsFromBottom()) && numDrawn > 0) {
            game.fireInformEvent(this.getLogName() + " draws " + CardUtil.numberToText(numDrawn, "a") + " card" + (numDrawn > 1 ? "s" : "") + (this.isDrawsFromBottom() ? " from the bottom of their library" : ""));
        }
        if (event instanceof DrawCardEvent) {
            ((DrawCardEvent)event).incrementCardsDrawn(numDrawn);
        }
        if (event instanceof DrawTwoOrMoreCardsEvent) {
            ((DrawTwoOrMoreCardsEvent)event).incrementCardsDrawn(numDrawn);
        }
        return numDrawn;
    }

    @Override
    public void discardToMax(Game game) {
        if (this.hand.size() > this.maxHandSize) {
            if (!game.isSimulation()) {
                game.informPlayers(this.getLogName() + " discards down to " + this.maxHandSize + (this.maxHandSize == 1 ? " hand card" : " hand cards"));
            }
            this.discard(this.hand.size() - this.maxHandSize, false, false, null, game);
        }
    }

    @Override
    public boolean removeFromHand(Card card, Game game) {
        return this.hand.remove(card.getId());
    }

    @Override
    public boolean removeFromLibrary(Card card, Game game) {
        if (card == null) {
            return false;
        }
        this.library.remove(card.getId(), game);
        return true;
    }

    @Override
    public Card discardOne(boolean random, boolean payForCost, Ability source, Game game) {
        return this.discard(1, random, payForCost, source, game).getRandom(game);
    }

    @Override
    public Cards discard(int amount, boolean random, boolean payForCost, Ability source, Game game) {
        if (random) {
            return this.discard(this.getRandomToDiscard(amount, source, game), payForCost, source, game);
        }
        return this.discard(amount, amount, payForCost, source, game);
    }

    @Override
    public Cards discard(int minAmount, int maxAmount, boolean payForCost, Ability source, Game game) {
        return this.discard(this.getToDiscard(minAmount, maxAmount, source, game), payForCost, source, game);
    }

    @Override
    public Cards discard(Cards cards, boolean payForCost, Ability source, Game game) {
        CardsImpl discardedCards = new CardsImpl();
        if (cards == null) {
            return discardedCards;
        }
        for (Card card : cards.getCards(game)) {
            if (!this.doDiscard(card, source, game, payForCost, false)) continue;
            discardedCards.add(card);
        }
        if (!discardedCards.isEmpty()) {
            game.fireEvent(new DiscardedCardsEvent(source, this.playerId, discardedCards.size(), discardedCards));
        }
        return discardedCards;
    }

    @Override
    public boolean discard(Card card, boolean payForCost, Ability source, Game game) {
        return this.doDiscard(card, source, game, payForCost, true);
    }

    private Cards getToDiscard(int minAmount, int maxAmount, Ability source, Game game) {
        CardsImpl toDiscard = new CardsImpl();
        if (minAmount > maxAmount) {
            return this.getToDiscard(maxAmount, minAmount, source, game);
        }
        if (maxAmount < 1) {
            return toDiscard;
        }
        if (this.getHand().size() <= minAmount) {
            toDiscard.addAll(this.getHand());
            return toDiscard;
        }
        TargetDiscard target = new TargetDiscard(minAmount, maxAmount, StaticFilters.FILTER_CARD, this.getId());
        target.choose(Outcome.Discard, this.getId(), source, game);
        toDiscard.addAll(target.getTargets());
        return toDiscard;
    }

    private Cards getRandomToDiscard(int amount, Ability source, Game game) {
        CardsImpl toDiscard = new CardsImpl();
        Cards theHand = this.getHand().copy();
        for (int i = 0; i < amount && !theHand.isEmpty(); ++i) {
            Card card = theHand.getRandom(game);
            theHand.remove(card);
            toDiscard.add(card);
        }
        return toDiscard;
    }

    private boolean doDiscard(Card card, Ability source, Game game, boolean payForCost, boolean fireFinalEvent) {
        if (card == null) {
            return false;
        }
        GameEvent gameEvent = GameEvent.getEvent(GameEvent.EventType.DISCARD_CARD, card.getId(), source, this.playerId);
        gameEvent.setFlag(!payForCost);
        if (game.replaceEvent(gameEvent, source)) {
            return false;
        }
        if (!game.isSimulation()) {
            game.informPlayers(this.getLogName() + " discards " + card.getLogName() + CardUtil.getSourceLogName(game, source));
        }
        card.moveToZone(Zone.GRAVEYARD, source, game, false);
        game.fireEvent(GameEvent.getEvent(GameEvent.EventType.DISCARDED_CARD, card.getId(), source, this.playerId));
        if (fireFinalEvent) {
            game.fireEvent(new DiscardedCardsEvent(source, this.playerId, 1, new CardsImpl(card)));
        }
        return true;
    }

    @Override
    public List<UUID> getAttachments() {
        return this.attachments;
    }

    @Override
    public boolean addAttachment(UUID permanentId, Ability source, Game game) {
        if (!this.attachments.contains(permanentId)) {
            Permanent aura = game.getPermanent(permanentId);
            if (aura == null) {
                aura = game.getPermanentEntering(permanentId);
            }
            if (aura != null && !game.replaceEvent(new EnchantPlayerEvent(this.playerId, aura, source))) {
                this.attachments.add(permanentId);
                aura.attachTo(this.playerId, source, game);
                game.fireEvent(new EnchantedPlayerEvent(this.playerId, aura, source));
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean removeAttachment(Permanent attachment, Ability source, Game game) {
        if (this.attachments.contains(attachment.getId()) && !game.replaceEvent(new UnattachEvent(this.playerId, attachment.getId(), attachment, source))) {
            this.attachments.remove(attachment.getId());
            attachment.attachTo(null, source, game);
            game.fireEvent(new UnattachedEvent(this.playerId, attachment.getId(), attachment, source));
            return true;
        }
        return false;
    }

    @Override
    public boolean removeFromBattlefield(Permanent permanent, Ability source, Game game) {
        Permanent pairedCard;
        permanent.removeFromCombat(game, false);
        game.getBattlefield().removePermanent(permanent.getId());
        if (permanent.getAttachedTo() != null) {
            Permanent attachedTo = game.getPermanent(permanent.getAttachedTo());
            if (attachedTo != null) {
                attachedTo.removeAttachment(permanent.getId(), source, game);
            } else {
                Player attachedToPlayer = game.getPlayer(permanent.getAttachedTo());
                if (attachedToPlayer != null) {
                    attachedToPlayer.removeAttachment(permanent, source, game);
                } else {
                    Card attachedToCard = game.getCard(permanent.getAttachedTo());
                    if (attachedToCard != null) {
                        attachedToCard.removeAttachment(permanent.getId(), source, game);
                    }
                }
            }
        }
        if (permanent.getPairedCard() != null && (pairedCard = permanent.getPairedCard().getPermanent(game)) != null) {
            pairedCard.clearPairedCard();
        }
        if (permanent.getBandedCards() != null && !permanent.getBandedCards().isEmpty()) {
            for (UUID bandedId : permanent.getBandedCards()) {
                Permanent banded = game.getPermanent(bandedId);
                if (banded == null) continue;
                banded.removeBandedCard(permanent.getId());
            }
        }
        return true;
    }

    @Override
    public boolean putInGraveyard(Card card, Game game) {
        if (!card.isOwnedBy(this.playerId)) {
            return game.getPlayer(card.getOwnerId()).putInGraveyard(card, game);
        }
        this.graveyard.add(card);
        return true;
    }

    @Override
    public boolean removeFromGraveyard(Card card, Game game) {
        return this.graveyard.remove(card);
    }

    @Override
    public boolean putCardsOnBottomOfLibrary(Card card, Game game, Ability source) {
        return this.putCardsOnBottomOfLibrary(new CardsImpl(card), game, source, false);
    }

    @Override
    public boolean putCardsOnBottomOfLibrary(Cards cardsToLibrary, Game game, Ability source, boolean anyOrder) {
        block5: {
            if (cardsToLibrary.isEmpty()) break block5;
            CardsImpl cards = new CardsImpl(cardsToLibrary);
            if (!anyOrder) {
                ArrayList<UUID> ids = new ArrayList<UUID>(cards);
                Collections.shuffle(ids);
                for (UUID id : ids) {
                    this.moveObjectToLibrary(id, source, game, false);
                }
            } else {
                UUID targetObjectId;
                UUID cardOwner = cards.getRandom(game).getOwnerId();
                TargetCard target = new TargetCard(Zone.ALL, new FilterCard("card ORDER to put on the BOTTOM of " + (cardOwner.equals(this.playerId) ? "your" : game.getPlayer(cardOwner).getName() + "'s") + " library (last one chosen will be bottommost)"));
                target.setRequired(true);
                while (cards.size() > 1 && this.canRespond() && this.choose(Outcome.Neutral, cards, target, source, game) && (targetObjectId = target.getFirstTarget()) != null) {
                    cards.remove(targetObjectId);
                    this.moveObjectToLibrary(targetObjectId, source, game, false);
                    target.clearChosen();
                }
                for (UUID c : cards) {
                    this.moveObjectToLibrary(c, source, game, false);
                }
            }
        }
        return true;
    }

    @Override
    public boolean shuffleCardsToLibrary(Cards cards, Game game, Ability source) {
        if (cards.isEmpty()) {
            return true;
        }
        game.informPlayers(this.getLogName() + " shuffles " + CardUtil.numberToText(cards.size(), "a") + " card" + (cards.size() == 1 ? "" : "s") + " into their library" + CardUtil.getSourceLogName(game, source));
        boolean status = this.moveCards(cards, Zone.LIBRARY, source, game);
        this.shuffleLibrary(source, game);
        return status;
    }

    @Override
    public boolean shuffleCardsToLibrary(Card card, Game game, Ability source) {
        if (card == null) {
            return true;
        }
        return this.shuffleCardsToLibrary(new CardsImpl(card), game, source);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean putCardOnTopXOfLibrary(Card card, Game game, Ability source, int xFromTheTop, boolean withName) {
        if (!card.isOwnedBy(this.getId())) return game.getPlayer(card.getOwnerId()).putCardOnTopXOfLibrary(card, game, source, xFromTheTop, withName);
        if (this.library.size() + 1 < xFromTheTop) {
            this.putCardsOnBottomOfLibrary(new CardsImpl(card), game, source, true);
            return true;
        } else {
            if (!card.moveToZone(Zone.LIBRARY, source, game, true) || card instanceof PermanentToken || card.isCopy()) return false;
            Card cardInLib = this.getLibrary().getFromTop(game);
            if (cardInLib == null || !cardInLib.getId().equals(card.getMainCard().getId())) return true;
            cardInLib = this.getLibrary().removeFromTop(game);
            this.getLibrary().putCardToTopXPos(cardInLib, xFromTheTop, game);
            game.informPlayers((withName ? cardInLib.getLogName() : "A card") + " is put into " + this.getLogName() + "'s library " + CardUtil.numberToOrdinalText(xFromTheTop) + " from the top" + CardUtil.getSourceLogName(game, source, cardInLib.getId()));
        }
        return true;
    }

    @Override
    public boolean putCardsOnTopOfLibrary(Cards cardsToLibrary, Game game, Ability source, boolean anyOrder) {
        block5: {
            if (cardsToLibrary == null || cardsToLibrary.isEmpty()) break block5;
            CardsImpl cards = new CardsImpl(cardsToLibrary);
            if (!anyOrder) {
                ArrayList<UUID> ids = new ArrayList<UUID>(cards);
                Collections.shuffle(ids);
                for (UUID id : ids) {
                    this.moveObjectToLibrary(id, source, game, true);
                }
            } else {
                UUID targetObjectId;
                UUID cardOwner = cards.getRandom(game).getOwnerId();
                TargetCard target = new TargetCard(Zone.ALL, new FilterCard("card ORDER to put on the TOP of " + (cardOwner.equals(this.playerId) ? "your" : game.getPlayer(cardOwner).getName() + "'s") + " library (last one chosen will be topmost)"));
                target.setRequired(true);
                while (cards.size() > 1 && this.canRespond() && this.choose(Outcome.Neutral, cards, target, source, game) && (targetObjectId = target.getFirstTarget()) != null) {
                    cards.remove(targetObjectId);
                    this.moveObjectToLibrary(targetObjectId, source, game, true);
                    target.clearChosen();
                }
                for (UUID c : cards) {
                    this.moveObjectToLibrary(c, source, game, true);
                }
            }
        }
        return true;
    }

    @Override
    public boolean putCardsOnTopOfLibrary(Card cardToLibrary, Game game, Ability source, boolean anyOrder) {
        if (cardToLibrary != null) {
            return this.putCardsOnTopOfLibrary(new CardsImpl(cardToLibrary), game, source, anyOrder);
        }
        return true;
    }

    private void moveObjectToLibrary(UUID objectId, Ability source, Game game, boolean toTop) {
        Spell spellNoCopy;
        MageObject mageObject = game.getObject(objectId);
        if (mageObject instanceof Spell && mageObject.isCopy() && (spellNoCopy = game.getStack().getSpell(source.getSourceId(), false)) != null) {
            mageObject = spellNoCopy;
        }
        if (mageObject != null) {
            Zone fromZone = game.getState().getZone(objectId);
            if (mageObject instanceof Permanent) {
                this.moveCardToLibraryWithInfo((Permanent)mageObject, source, game, fromZone, toTop, false);
            } else if (mageObject instanceof Card) {
                this.moveCardToLibraryWithInfo((Card)mageObject, source, game, fromZone, toTop, false);
            }
        }
    }

    @Override
    public void setCastSourceIdWithAlternateMana(UUID sourceId, ManaCosts<ManaCost> manaCosts, Costs<Cost> costs, MageIdentifier identifier) {
        this.castSourceIdWithAlternateMana.computeIfAbsent(sourceId, k -> new HashSet()).add(identifier);
        this.castSourceIdManaCosts.computeIfAbsent(sourceId, k -> new HashMap()).put(identifier, manaCosts != null ? manaCosts.copy() : null);
        this.castSourceIdCosts.computeIfAbsent(sourceId, k -> new HashMap()).put(identifier, costs != null ? costs.copy() : null);
    }

    @Override
    public Map<UUID, Set<MageIdentifier>> getCastSourceIdWithAlternateMana() {
        return this.castSourceIdWithAlternateMana;
    }

    @Override
    public Map<UUID, Map<MageIdentifier, Costs<Cost>>> getCastSourceIdCosts() {
        return this.castSourceIdCosts;
    }

    @Override
    public Map<UUID, Map<MageIdentifier, ManaCosts<ManaCost>>> getCastSourceIdManaCosts() {
        return this.castSourceIdManaCosts;
    }

    @Override
    public void clearCastSourceIdManaCosts() {
        this.castSourceIdCosts.clear();
        this.castSourceIdManaCosts.clear();
        this.castSourceIdWithAlternateMana.clear();
    }

    @Override
    public void setPayManaMode(boolean payManaMode) {
        this.payManaMode = payManaMode;
    }

    @Override
    public boolean isInPayManaMode() {
        return this.payManaMode;
    }

    @Override
    public boolean playCard(Card card, Game game, boolean noMana, ApprovingObject approvingObject) {
        boolean result;
        if (card == null) {
            return false;
        }
        if (card.isLand(game)) {
            result = this.playLand(card, game, true);
        } else {
            game.getState().setValue("PlayFromNotOwnHandZone" + card.getId(), Boolean.TRUE);
            result = this.cast(this.chooseAbilityForCast(card, game, noMana), game, noMana, approvingObject);
            game.getState().setValue("PlayFromNotOwnHandZone" + card.getId(), null);
        }
        if (!result) {
            game.informPlayer(this, "You can't play " + card.getIdName() + '.');
        }
        return result;
    }

    @Override
    public boolean cast(SpellAbility originalAbility, Game game, boolean noMana, ApprovingObject approvingObject) {
        if (game == null || originalAbility == null) {
            return false;
        }
        SpellAbility ability = originalAbility.copy();
        Set<MageIdentifier> allowedIdentifiers = originalAbility.spellCanBeActivatedNow(this.getId(), game);
        ability.setControllerId(this.getId());
        ability.initSourceObjectZoneChangeCounter(game, true);
        if (ability.getSourceId() == null) {
            logger.error((Object)("Ability without sourceId turn " + game.getTurnNum() + ". Ability: " + ability.getRule()));
            return false;
        }
        Card card = game.getCard(ability.getSourceId());
        if (card != null) {
            Zone fromZone = game.getState().getZone(card.getMainCard().getId());
            GameEvent castEvent = GameEvent.getEvent(GameEvent.EventType.CAST_SPELL, ability.getId(), (Ability)ability, this.playerId, approvingObject);
            castEvent.setZone(fromZone);
            if (!game.replaceEvent(castEvent, ability)) {
                MageIdentifier identifier;
                int bookmark = game.bookmarkState();
                this.setStoredBookmark(bookmark);
                card.cast(game, fromZone, ability, this.playerId);
                Spell spell = game.getStack().getSpell(ability.getId());
                if (spell == null) {
                    logger.error((Object)("Got no spell from stack. ability: " + ability.getRule()));
                    return false;
                }
                if (card.isCopy()) {
                    spell.setCopy(true, null);
                }
                ability.initSourceObjectZoneChangeCounter(game, true);
                MageIdentifier mageIdentifier = identifier = approvingObject == null ? MageIdentifier.Default : approvingObject.getApprovingAbility().getIdentifier();
                if (!this.getCastSourceIdWithAlternateMana().getOrDefault(ability.getSourceId(), Collections.emptySet()).contains((Object)identifier)) {
                    identifier = MageIdentifier.Default;
                }
                if (this.getCastSourceIdWithAlternateMana().getOrDefault(ability.getSourceId(), Collections.emptySet()).contains((Object)identifier)) {
                    SpellAbility spellAbility = spell.getSpellAbility();
                    ManaCosts<ManaCost> alternateCosts = this.getCastSourceIdManaCosts().get(ability.getSourceId()).get((Object)identifier);
                    Costs<Cost> costs = this.getCastSourceIdCosts().get(ability.getSourceId()).get((Object)identifier);
                    if (alternateCosts == null) {
                        noMana = true;
                    } else {
                        spellAbility.clearManaCosts();
                        spellAbility.clearManaCostsToPay();
                        spellAbility.addCost(alternateCosts.copy());
                    }
                    spellAbility.clearCosts();
                    spellAbility.addCost(costs);
                }
                this.clearCastSourceIdManaCosts();
                castEvent = GameEvent.getEvent(GameEvent.EventType.CAST_SPELL, spell.getSpellAbility().getId(), (Ability)spell.getSpellAbility(), this.playerId, approvingObject);
                castEvent.setZone(fromZone);
                game.fireEvent(castEvent);
                if (spell.activate(game, allowedIdentifiers, noMana)) {
                    game.processAction();
                    GameEvent castedEvent = GameEvent.getEvent(GameEvent.EventType.SPELL_CAST, ability.getId(), (Ability)ability, this.playerId, approvingObject);
                    castedEvent.setZone(fromZone);
                    game.fireEvent(castedEvent);
                    if (!game.isSimulation()) {
                        game.informPlayers(this.getLogName() + spell.getActivatedMessage(game, fromZone));
                    }
                    game.removeBookmark(bookmark);
                    this.resetStoredBookmark(game);
                    return true;
                }
                this.restoreState(bookmark, ability.getRule(), game);
            }
        }
        return false;
    }

    @Override
    public boolean playLand(Card card, Game game, boolean ignoreTiming) {
        if (card == null) {
            return false;
        }
        ActivatedAbility playLandAbility = null;
        for (Ability ability : card.getAbilities(game)) {
            if (!(ability instanceof PlayLandAbility)) continue;
            playLandAbility = (ActivatedAbility)ability;
        }
        if (playLandAbility == null) {
            return false;
        }
        ActivatedAbility.ActivationStatus activationStatus = playLandAbility.canActivate(this.playerId, game);
        if (ignoreTiming ? !this.canPlayLand() || !this.isActivePlayer(game) : !activationStatus.canActivate()) {
            return false;
        }
        ApprovingObjectResult approvingResult = this.chooseApprovingObject(game, activationStatus.getApprovingObjects().stream().collect(Collectors.toList()), false);
        if (approvingResult.status.equals((Object)ApprovingObjectResultStatus.NOT_REQUIRED_NO_CHOICE)) {
            return false;
        }
        if (!game.replaceEvent(GameEvent.getEvent(GameEvent.EventType.PLAY_LAND, card.getId(), (Ability)playLandAbility, this.playerId, approvingResult.approvingObject))) {
            Zone cardZoneBefore = game.getState().getZone(card.getId());
            GameEvent landEventBefore = GameEvent.getEvent(GameEvent.EventType.PLAY_LAND, card.getId(), (Ability)playLandAbility, this.playerId, approvingResult.approvingObject);
            landEventBefore.setZone(cardZoneBefore);
            game.fireEvent(landEventBefore);
            if (this.moveCards(card, Zone.BATTLEFIELD, (Ability)playLandAbility, game, false, false, false, null)) {
                this.incrementLandsPlayed();
                GameEvent landEventAfter = GameEvent.getEvent(GameEvent.EventType.LAND_PLAYED, card.getId(), (Ability)playLandAbility, this.playerId, approvingResult.approvingObject);
                landEventAfter.setZone(cardZoneBefore);
                game.fireEvent(landEventAfter);
                String playText = this.getLogName() + " plays " + card.getLogName();
                if (card instanceof ModalDoubleFacedCardHalf) {
                    ModalDoubleFacedCard mdfCard = (ModalDoubleFacedCard)card.getMainCard();
                    playText = this.getLogName() + " plays " + GameLog.replaceNameByColoredName(card, card.getName(), mdfCard) + " as MDF side of " + GameLog.getColoredObjectIdName(mdfCard);
                }
                game.fireInformEvent(playText);
                this.resetStoredBookmark(game);
                return true;
            }
        }
        return true;
    }

    private ApprovingObjectResult chooseApprovingObject(Game game, List<ApprovingObject> possibleApprovingObjects, boolean required) {
        if (possibleApprovingObjects.isEmpty()) {
            return new ApprovingObjectResult(ApprovingObjectResultStatus.NO_POSSIBLE_CHOICE, null);
        }
        HashMap<String, String> keyChoices = new HashMap<String, String>();
        int i = 0;
        for (ApprovingObject possibleApprovingObject : possibleApprovingObjects) {
            MageObject mageObject = game.getObject(possibleApprovingObject.getApprovingAbility().getSourceId());
            String choiceValue = "";
            MageIdentifier identifier = possibleApprovingObject.getApprovingAbility().getIdentifier();
            if (!identifier.getAdditionalText().isEmpty()) {
                choiceValue = choiceValue + identifier.getAdditionalText() + ": ";
            }
            if (mageObject == null) {
                choiceValue = choiceValue + possibleApprovingObject.getApprovingAbility().getRule();
            } else {
                choiceValue = choiceValue + mageObject.getIdName() + ": ";
                String moreDetails = possibleApprovingObject.getApprovingAbility().getRule(mageObject.getName());
                choiceValue = choiceValue + (moreDetails.isEmpty() ? "Cast normally" : moreDetails);
            }
            keyChoices.put(i++ + "", choiceValue);
        }
        int choice = 0;
        if (!game.inCheckPlayableState() && keyChoices.size() > 1) {
            ChoiceImpl choicePermitting = new ChoiceImpl(required);
            choicePermitting.setMessage("Choose the permitting object");
            choicePermitting.setKeyChoices(keyChoices);
            if (this.canRespond()) {
                if (this.choose(Outcome.Neutral, choicePermitting, game)) {
                    String choiceKey = choicePermitting.getChoiceKey();
                    if (choiceKey != null) {
                        choice = Integer.parseInt(choiceKey);
                    }
                } else {
                    return new ApprovingObjectResult(ApprovingObjectResultStatus.NOT_REQUIRED_NO_CHOICE, null);
                }
            }
        }
        return new ApprovingObjectResult(ApprovingObjectResultStatus.CHOSEN, possibleApprovingObjects.get(choice));
    }

    protected boolean playManaAbility(ActivatedManaAbilityImpl ability, Game game) {
        int bookmark = game.bookmarkState();
        if (ability.activate(game, false) && ability.resolve(game)) {
            if (ability.isUndoPossible()) {
                if (this.storedBookmark == -1 || this.storedBookmark > bookmark) {
                    this.setStoredBookmark(bookmark);
                }
            } else {
                this.resetStoredBookmark(game);
            }
            return true;
        }
        this.restoreState(bookmark, ability.getRule(), game);
        return false;
    }

    protected boolean playAbility(ActivatedAbility ability, Game game) {
        int bookmark = game.bookmarkState();
        if (ability.isUsesStack()) {
            this.setStoredBookmark(bookmark);
            ability.newId();
            ability.setControllerId(this.playerId);
            game.getStack().push(game, new StackAbility(ability, this.playerId));
            if (ability.activate(game, false)) {
                game.fireEvent(GameEvent.getEvent(GameEvent.EventType.ACTIVATED_ABILITY, ability.getId(), ability, this.playerId));
                if (!game.isSimulation()) {
                    game.informPlayers(this.getLogName() + ability.getGameLogMessage(game));
                }
                game.removeBookmark(bookmark);
                this.resetStoredBookmark(game);
                return true;
            }
            this.restoreState(bookmark, ability.getRule(), game);
        } else if (ability.activate(game, false)) {
            ability.resolve(game);
            game.removeBookmark(bookmark);
            this.resetStoredBookmark(game);
            return true;
        }
        this.restoreState(bookmark, ability.getRule(), game);
        return false;
    }

    protected boolean specialAction(SpecialAction action, Game game) {
        if (!game.replaceEvent(GameEvent.getEvent(GameEvent.EventType.TAKE_SPECIAL_ACTION, action.getId(), action, this.getId()))) {
            int bookmark = game.bookmarkState();
            if (action.activate(game, false)) {
                game.fireEvent(GameEvent.getEvent(GameEvent.EventType.TAKEN_SPECIAL_ACTION, action.getId(), action, this.getId()));
                if (!game.isSimulation()) {
                    game.informPlayers(this.getLogName() + action.getGameLogMessage(game));
                }
                if (action.resolve(game)) {
                    game.removeBookmark(bookmark);
                    this.resetStoredBookmark(game);
                    return true;
                }
            }
            this.restoreState(bookmark, action.getRule(), game);
        }
        return false;
    }

    protected boolean specialManaPayment(SpecialAction action, Game game) {
        if (!game.replaceEvent(GameEvent.getEvent(GameEvent.EventType.TAKE_SPECIAL_MANA_PAYMENT, action.getId(), action, this.getId()))) {
            int bookmark = game.bookmarkState();
            if (action.activate(game, false)) {
                game.fireEvent(GameEvent.getEvent(GameEvent.EventType.TAKEN_SPECIAL_MANA_PAYMENT, action.getId(), action, this.getId()));
                if (!game.isSimulation()) {
                    game.informPlayers(this.getLogName() + action.getGameLogMessage(game));
                }
                if (action.resolve(game)) {
                    game.removeBookmark(bookmark);
                    this.resetStoredBookmark(game);
                    return true;
                }
            }
            this.restoreState(bookmark, action.getRule(), game);
        }
        return false;
    }

    @Override
    public boolean activateAbility(ActivatedAbility ability, Game game) {
        boolean result;
        if (ability == null) {
            return false;
        }
        if (ability instanceof PassAbility) {
            this.pass(game);
            return true;
        }
        Card card = game.getCard(ability.getSourceId());
        if (ability instanceof PlayLandAsCommanderAbility) {
            ActivatedAbility.ActivationStatus activationStatus = ability.canActivate(this.playerId, game);
            if (!activationStatus.canActivate() || !this.canPlayLand()) {
                return false;
            }
            if (card == null) {
                return false;
            }
            ActivatedAbility activatingAbility = ability.copy();
            result = activatingAbility.activate(game, false) ? this.playLand(card, game, false) : false;
        } else if (ability instanceof PlayLandAbility) {
            result = this.playLand(card, game, false);
        } else {
            ActivatedAbility.ActivationStatus activationStatus = ability.canActivate(this.playerId, game);
            if (!activationStatus.canActivate()) {
                return false;
            }
            switch (ability.getAbilityType()) {
                case SPECIAL_ACTION: {
                    result = this.specialAction((SpecialAction)ability.copy(), game);
                    break;
                }
                case SPECIAL_MANA_PAYMENT: {
                    result = this.specialManaPayment((SpecialAction)ability.copy(), game);
                    break;
                }
                case ACTIVATED_MANA: {
                    result = this.playManaAbility((ActivatedManaAbilityImpl)ability.copy(), game);
                    break;
                }
                case SPELL: {
                    ApprovingObjectResult approvingResult = this.chooseApprovingObject(game, activationStatus.getApprovingObjects().stream().collect(Collectors.toList()), false);
                    if (approvingResult.status.equals((Object)ApprovingObjectResultStatus.NOT_REQUIRED_NO_CHOICE)) {
                        return false;
                    }
                    result = this.cast((SpellAbility)ability, game, false, approvingResult.approvingObject);
                    break;
                }
                default: {
                    result = this.playAbility(ability.copy(), game);
                }
            }
        }
        this.justActivatedType = null;
        if (result) {
            if (this.isHuman() && (ability.getAbilityType() == AbilityType.SPELL || ability.getAbilityType().isActivatedAbility()) && ability.isUsesStack()) {
                this.setJustActivatedType(ability.getAbilityType());
            }
            game.getPlayers().resetPassed();
        }
        return result;
    }

    @Override
    public boolean triggerAbility(TriggeredAbility triggeredAbility, Game game) {
        if (triggeredAbility == null) {
            logger.warn((Object)"Null source in triggerAbility method");
            throw new IllegalArgumentException("source TriggeredAbility  must not be null");
        }
        int bookmark = game.bookmarkState();
        TriggeredAbility ability = triggeredAbility.copy();
        ability.adjustTargets(game);
        if (ability.canChooseTarget(game, this.playerId)) {
            if (ability.isUsesStack()) {
                game.getStack().push(game, new StackAbility(ability, this.playerId));
            }
            if (ability.activate(game, false)) {
                if ((ability.isUsesStack() || ability.getRuleVisible()) && !game.isSimulation()) {
                    game.informPlayers(this.getLogName() + " - " + ability.getGameLogMessage(game));
                }
                if (!ability.isUsesStack()) {
                    ability.resolve(game);
                } else {
                    game.fireEvent(new GameEvent(GameEvent.EventType.TRIGGERED_ABILITY, ability.getId(), ability, ability.getControllerId()));
                }
                game.removeBookmark_v2(bookmark);
                return true;
            }
        }
        this.restoreState(bookmark, triggeredAbility.getRule(), game);
        return false;
    }

    public static Map<UUID, SpellAbility> getCastableSpellAbilities(Game game, UUID playerId, MageObject object, Zone zone, boolean noMana) {
        LinkedHashMap<UUID, SpellAbility> useable = new LinkedHashMap<UUID, SpellAbility>();
        Abilities<Ability> allAbilities = object instanceof Card ? ((Card)object).getAbilities(game) : object.getAbilities();
        block6: for (SpellAbility spellAbility : allAbilities.stream().filter(SpellAbility.class::isInstance).map(SpellAbility.class::cast).collect(Collectors.toList())) {
            Set<MageIdentifier> allowedToBeCastNow;
            switch (spellAbility.getSpellAbilityType()) {
                case BASE_ALTERNATE: {
                    if (noMana) continue block6;
                    allowedToBeCastNow = spellAbility.spellCanBeActivatedNow(playerId, game);
                    if (allowedToBeCastNow.contains((Object)MageIdentifier.Default) || allowedToBeCastNow.contains((Object)spellAbility.getIdentifier())) {
                        useable.put(spellAbility.getId(), spellAbility);
                    }
                    return useable;
                }
                case SPLIT_FUSED: {
                    if (zone == Zone.HAND && spellAbility.canChooseTarget(game, playerId)) {
                        useable.put(spellAbility.getId(), spellAbility);
                    }
                }
                case SPLIT: {
                    if (((SplitCard)object).getLeftHalfCard().getSpellAbility().canChooseTarget(game, playerId)) {
                        useable.put(((SplitCard)object).getLeftHalfCard().getSpellAbility().getId(), ((SplitCard)object).getLeftHalfCard().getSpellAbility());
                    }
                    if (((SplitCard)object).getRightHalfCard().getSpellAbility().canChooseTarget(game, playerId)) {
                        useable.put(((SplitCard)object).getRightHalfCard().getSpellAbility().getId(), ((SplitCard)object).getRightHalfCard().getSpellAbility());
                    }
                    return useable;
                }
                case SPLIT_AFTERMATH: {
                    if (zone == Zone.GRAVEYARD) {
                        if (((SplitCard)object).getRightHalfCard().getSpellAbility().canChooseTarget(game, playerId)) {
                            useable.put(((SplitCard)object).getRightHalfCard().getSpellAbility().getId(), ((SplitCard)object).getRightHalfCard().getSpellAbility());
                        }
                    } else if (((SplitCard)object).getLeftHalfCard().getSpellAbility().canChooseTarget(game, playerId)) {
                        useable.put(((SplitCard)object).getLeftHalfCard().getSpellAbility().getId(), ((SplitCard)object).getLeftHalfCard().getSpellAbility());
                    }
                    return useable;
                }
            }
            allowedToBeCastNow = spellAbility.spellCanBeActivatedNow(playerId, game);
            if (!allowedToBeCastNow.contains((Object)MageIdentifier.Default) && !allowedToBeCastNow.contains((Object)spellAbility.getIdentifier())) continue;
            useable.put(spellAbility.getId(), spellAbility);
        }
        return useable;
    }

    @Override
    public Map<UUID, ActivatedAbility> getPlayableActivatedAbilities(MageObject object, Zone zone, Game game) {
        LinkedHashMap<UUID, ActivatedAbility> useable = new LinkedHashMap<UUID, ActivatedAbility>();
        if (object instanceof StackAbility || object == null) {
            return useable;
        }
        Set<UUID> needIds = CardUtil.getObjectParts(object);
        List<ActivatedAbility> allPlayable = this.getPlayable(game, true, zone, false);
        for (ActivatedAbility ability : allPlayable) {
            if (!needIds.contains(ability.getSourceId())) continue;
            useable.putIfAbsent(ability.getId(), ability);
        }
        return useable;
    }

    protected Map<UUID, ActivatedManaAbilityImpl> getUseableManaAbilities(MageObject object, Zone zone, Game game) {
        LinkedHashMap<UUID, ActivatedManaAbilityImpl> useable = new LinkedHashMap<UUID, ActivatedManaAbilityImpl>();
        boolean canUse = !(object instanceof Permanent) || ((Permanent)object).canUseActivatedAbilities(game);
        for (ActivatedManaAbilityImpl ability : object.getAbilities().getActivatedManaAbilities(zone)) {
            if (!canUse && ability.getAbilityType() != AbilityType.SPECIAL_ACTION || !ability.canActivate(this.playerId, game).canActivate()) continue;
            useable.put(ability.getId(), ability);
        }
        return useable;
    }

    @Override
    public void incrementLandsPlayed() {
        ++this.landsPlayed;
    }

    @Override
    public void resetLandsPlayed() {
        this.landsPlayed = 0;
    }

    @Override
    public int getLandsPlayed() {
        return this.landsPlayed;
    }

    @Override
    public boolean canPlayLand() {
        return this.landsPlayed < this.landsPerTurn;
    }

    protected boolean isActivePlayer(Game game) {
        return game.isActivePlayer(this.playerId);
    }

    @Override
    public void shuffleLibrary(Ability source, Game game) {
        if (!game.replaceEvent(GameEvent.getEvent(GameEvent.EventType.SHUFFLE_LIBRARY, this.playerId, source, this.playerId))) {
            this.library.shuffle();
            if (!game.isSimulation()) {
                game.informPlayers(this.getLogName() + "'s library is shuffled" + CardUtil.getSourceLogName(game, source));
            }
            game.fireEvent(GameEvent.getEvent(GameEvent.EventType.LIBRARY_SHUFFLED, this.playerId, source, this.playerId));
        }
    }

    @Override
    public void revealCards(Ability source, Cards cards, Game game) {
        this.revealCards(source, null, cards, game, true);
    }

    @Override
    public void revealCards(String titleSuffix, Cards cards, Game game) {
        this.revealCards(titleSuffix, cards, game, true);
    }

    @Override
    public void revealCards(String titleSuffix, Cards cards, Game game, boolean postToLog) {
        this.revealCards(null, titleSuffix, cards, game, postToLog);
    }

    @Override
    public void revealCards(Ability source, String titleSuffix, Cards cards, Game game) {
        this.revealCards(source, titleSuffix, cards, game, true);
    }

    @Override
    public void revealCards(Ability source, String titleSuffix, Cards cards, Game game, boolean postToLog) {
        if (cards == null || cards.isEmpty()) {
            return;
        }
        if (postToLog) {
            game.getState().getRevealed().add(CardUtil.createObjectRelatedWindowTitle(source, game, titleSuffix), cards);
        } else {
            game.getState().getRevealed().update(CardUtil.createObjectRelatedWindowTitle(source, game, titleSuffix), cards);
        }
        if (postToLog && !game.isSimulation()) {
            StringBuilder sb = new StringBuilder(this.getLogName()).append(" reveals ");
            int current = 0;
            int last = cards.size();
            for (Card card : cards.getCards(game)) {
                ++current;
                if (card instanceof PermanentCard && card.isFaceDown(game)) {
                    sb.append(GameLog.getColoredObjectName(card.getMainCard()));
                } else {
                    sb.append(GameLog.getColoredObjectName(card));
                }
                if (current >= last) continue;
                sb.append(", ");
            }
            sb.append(CardUtil.getSourceLogName(game, source));
            game.informPlayers(sb.toString());
        }
    }

    @Override
    public void lookAtCards(String titleSuffix, Card card, Game game) {
        game.getState().getLookedAt(this.playerId).add(titleSuffix, card);
        game.fireUpdatePlayersEvent();
    }

    @Override
    public void lookAtCards(String titleSuffix, Cards cards, Game game) {
        this.lookAtCards(null, titleSuffix, cards, game);
    }

    @Override
    public void lookAtCards(Ability source, String titleSuffix, Cards cards, Game game) {
        game.getState().getLookedAt(this.playerId).add(CardUtil.createObjectRelatedWindowTitle(source, game, titleSuffix), cards);
        game.fireUpdatePlayersEvent();
    }

    @Override
    public void phasing(Game game) {
        List<Permanent> phasedOut = game.getBattlefield().getPhasedOut(this.playerId);
        for (Permanent permanent : game.getBattlefield().getPhasingOut(game, this.playerId)) {
            Permanent attachedTo = game.getPermanent(permanent.getAttachedTo());
            if (attachedTo != null && attachedTo.isControlledBy(this.getId())) continue;
            permanent.phaseOut(game, false);
        }
        for (Permanent permanent : phasedOut) {
            if (permanent.isPhasedOutIndirectly()) continue;
            permanent.phaseIn(game);
        }
    }

    @Override
    public void untap(Game game) {
        HashMap<Map.Entry<RestrictionUntapNotMoreThanEffect, Set<Ability>>, Integer> notMoreThanEffectsUsage = new HashMap<Map.Entry<RestrictionUntapNotMoreThanEffect, Set<Ability>>, Integer>();
        for (Map.Entry<RestrictionUntapNotMoreThanEffect, Set<Ability>> entry : game.getContinuousEffects().getApplicableRestrictionUntapNotMoreThanEffects(this, game).entrySet()) {
            notMoreThanEffectsUsage.put(entry, entry.getKey().getNumber());
        }
        if (!notMoreThanEffectsUsage.isEmpty()) {
            boolean playerCanceledSelection;
            ArrayList<Permanent> canBeUntapped = new ArrayList<Permanent>();
            for (Permanent permanent : game.getBattlefield().getAllActivePermanents(this.playerId)) {
                boolean untap = true;
                for (RestrictionEffect effect : game.getContinuousEffects().getApplicableRestrictionEffects(permanent, game).keySet()) {
                    untap &= effect.canBeUntapped(permanent, null, game, true);
                }
                if (!untap) continue;
                canBeUntapped.add(permanent);
            }
            ArrayList<Permanent> arrayList = new ArrayList<Permanent>();
            do {
                playerCanceledSelection = false;
                block4: for (Map.Entry handledEntry : notMoreThanEffectsUsage.entrySet()) {
                    int numberToUntap = (Integer)handledEntry.getValue();
                    if (numberToUntap <= 0) continue;
                    List<Permanent> leftForUntap = this.getPermanentsThatCanBeUntapped(game, canBeUntapped, (RestrictionUntapNotMoreThanEffect)((Map.Entry)handledEntry.getKey()).getKey(), notMoreThanEffectsUsage);
                    FilterControlledPermanent filter = ((RestrictionUntapNotMoreThanEffect)((Map.Entry)handledEntry.getKey()).getKey()).getFilter().copy();
                    String message = filter.getMessage();
                    for (Permanent permanent : arrayList) {
                        filter.add(Predicates.not(new PermanentIdPredicate(permanent.getId())));
                    }
                    while (this.canRespond() && !leftForUntap.isEmpty() && numberToUntap > 0) {
                        Ability ability = (Ability)((Set)((Map.Entry)handledEntry.getKey()).getValue()).iterator().next();
                        if (ability == null) continue;
                        StringBuilder sb = new StringBuilder(message).append(" to untap").append(" (").append(Math.min(leftForUntap.size(), numberToUntap)).append(" in total");
                        MageObject effectSource = game.getObject(ability.getSourceId());
                        if (effectSource != null) {
                            sb.append(" from ").append(effectSource.getLogName());
                        }
                        sb.append(')');
                        filter.setMessage(sb.toString());
                        TargetPermanent target = new TargetPermanent(1, 1, filter, true);
                        if (!this.chooseTarget(Outcome.Untap, target, ability, game)) {
                            playerCanceledSelection = true;
                            continue block4;
                        }
                        Permanent selectedPermanent = game.getPermanent(target.getFirstTarget());
                        if (leftForUntap.contains(selectedPermanent)) {
                            arrayList.add(selectedPermanent);
                            --numberToUntap;
                            filter.add(Predicates.not(new PermanentIdPredicate(selectedPermanent.getId())));
                            for (Map.Entry entry : notMoreThanEffectsUsage.entrySet()) {
                                if ((Integer)entry.getValue() <= 0 || !((RestrictionUntapNotMoreThanEffect)((Map.Entry)entry.getKey()).getKey()).getFilter().match(selectedPermanent, game)) continue;
                                entry.setValue((Integer)entry.getValue() - 1);
                            }
                            leftForUntap = this.getPermanentsThatCanBeUntapped(game, canBeUntapped, (RestrictionUntapNotMoreThanEffect)((Map.Entry)handledEntry.getKey()).getKey(), notMoreThanEffectsUsage);
                            for (Permanent permanent : arrayList) {
                                leftForUntap.remove(permanent);
                            }
                            continue;
                        }
                        filter.add(Predicates.not(new PermanentIdPredicate(selectedPermanent.getId())));
                        if (!this.isHuman() || game.isSimulation()) continue;
                        game.informPlayer(this, "This permanent can't be untapped because of other restricting effect.");
                    }
                }
            } while (this.canRespond() && playerCanceledSelection);
            if (!game.isSimulation()) {
                for (Permanent permanent : arrayList) {
                    game.informPlayers(this.getLogName() + " untapped " + permanent.getLogName());
                }
            }
            for (Permanent permanent : canBeUntapped) {
                boolean doUntap = true;
                if (!arrayList.contains(permanent)) {
                    for (Map.Entry notMoreThanEffect : notMoreThanEffectsUsage.entrySet()) {
                        if (!((RestrictionUntapNotMoreThanEffect)((Map.Entry)notMoreThanEffect.getKey()).getKey()).getFilter().match(permanent, game)) continue;
                        doUntap = false;
                        break;
                    }
                }
                if (permanent == null || !doUntap) continue;
                permanent.untap(game);
            }
        } else {
            for (Permanent permanent : game.getBattlefield().getAllActivePermanents(this.playerId)) {
                boolean untap = true;
                for (RestrictionEffect effect : game.getContinuousEffects().getApplicableRestrictionEffects(permanent, game).keySet()) {
                    untap &= effect.canBeUntapped(permanent, null, game, true);
                }
                if (!untap) continue;
                permanent.untap(game);
            }
        }
    }

    private List<Permanent> getPermanentsThatCanBeUntapped(Game game, List<Permanent> canBeUntapped, RestrictionUntapNotMoreThanEffect handledEffect, Map<Map.Entry<RestrictionUntapNotMoreThanEffect, Set<Ability>>, Integer> notMoreThanEffectsUsage) {
        ArrayList<Permanent> leftForUntap = new ArrayList<Permanent>();
        for (Permanent permanent : canBeUntapped) {
            if (!handledEffect.getFilter().match(permanent, game)) continue;
            boolean canBeSelected = true;
            for (Map.Entry<Map.Entry<RestrictionUntapNotMoreThanEffect, Set<Ability>>, Integer> notMoreThanEffect : notMoreThanEffectsUsage.entrySet()) {
                if (!notMoreThanEffect.getKey().getKey().getFilter().match(permanent, game) || notMoreThanEffect.getValue() != 0) continue;
                canBeSelected = false;
                break;
            }
            if (!canBeSelected) continue;
            leftForUntap.add(permanent);
        }
        return leftForUntap;
    }

    @Override
    public UUID getId() {
        return this.playerId;
    }

    @Override
    public Cards getHand() {
        return this.hand;
    }

    @Override
    public Graveyard getGraveyard() {
        return this.graveyard;
    }

    @Override
    public ManaPool getManaPool() {
        return this.manaPool;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getLogName() {
        return GameLog.getColoredPlayerName(this.name);
    }

    @Override
    public boolean isHuman() {
        return this.human;
    }

    @Override
    public Library getLibrary() {
        return this.library;
    }

    @Override
    public Cards getSideboard() {
        return this.sideboard;
    }

    @Override
    public int getLife() {
        return this.life;
    }

    @Override
    public void initLife(int life) {
        this.life = life;
    }

    @Override
    public void setLife(int life, Game game, Ability source) {
        if (life > this.life) {
            this.gainLife(life - this.life, game, source);
        } else if (life < this.life) {
            this.loseLife(this.life - life, game, source, false);
        }
    }

    @Override
    public void setLifeTotalCanChange(boolean lifeTotalCanChange) {
        this.canGainLife = lifeTotalCanChange;
        this.canLoseLife = lifeTotalCanChange;
    }

    @Override
    public boolean isLifeTotalCanChange() {
        return this.canGainLife || this.canLoseLife;
    }

    @Override
    public List<AlternativeSourceCosts> getAlternativeSourceCosts() {
        return this.alternativeSourceCosts;
    }

    @Override
    public boolean isCanLoseLife() {
        return this.canLoseLife;
    }

    @Override
    public void setCanLoseLife(boolean canLoseLife) {
        this.canLoseLife = canLoseLife;
    }

    @Override
    public int loseLife(int amount, Game game, Ability source, boolean atCombat, UUID attackerId) {
        if (!this.canLoseLife || !this.isInGame()) {
            return 0;
        }
        GameEvent event = new GameEvent(GameEvent.EventType.LOSE_LIFE, this.playerId, source, this.playerId, amount, atCombat);
        if (!game.replaceEvent(event)) {
            this.life = CardUtil.overflowDec(this.life, event.getAmount());
            if (!game.isSimulation()) {
                UUID needId = attackerId;
                if (needId == null) {
                    needId = source == null ? null : source.getSourceId();
                }
                game.informPlayers(this.getLogName() + " loses " + event.getAmount() + " life" + (atCombat ? " at combat" : "") + CardUtil.getSourceLogName(game, " from ", needId, "", ""));
            }
            if (event.getAmount() > 0) {
                LifeLostEvent lifeLostEvent = new LifeLostEvent(this.playerId, source, event.getAmount(), atCombat);
                game.fireEvent(lifeLostEvent);
                game.getState().addSimultaneousLifeLossToBatch(lifeLostEvent, game);
            }
            return event.getAmount();
        }
        return 0;
    }

    @Override
    public int loseLife(int amount, Game game, Ability source, boolean atCombat) {
        return this.loseLife(amount, game, source, atCombat, null);
    }

    @Override
    public boolean isCanGainLife() {
        return this.canGainLife;
    }

    @Override
    public void setCanGainLife(boolean canGainLife) {
        this.canGainLife = canGainLife;
    }

    @Override
    public int gainLife(int amount, Game game, Ability source) {
        if (!this.canGainLife || amount <= 0) {
            return 0;
        }
        GameEvent event = new GameEvent(GameEvent.EventType.GAIN_LIFE, this.playerId, source, this.playerId, amount, false);
        if (!game.replaceEvent(event)) {
            this.life = CardUtil.overflowInc(this.life, event.getAmount());
            if (!game.isSimulation()) {
                game.informPlayers(this.getLogName() + " gains " + event.getAmount() + " life" + CardUtil.getSourceLogName(game, source));
            }
            game.fireEvent(GameEvent.getEvent(GameEvent.EventType.GAINED_LIFE, this.playerId, source, this.playerId, event.getAmount()));
            return event.getAmount();
        }
        return 0;
    }

    @Override
    public void exchangeLife(Player player, Ability source, Game game) {
        int lifePlayer2;
        int lifePlayer1 = this.getLife();
        if (lifePlayer1 != (lifePlayer2 = player.getLife()) && this.isLifeTotalCanChange() && player.isLifeTotalCanChange() && (lifePlayer1 >= lifePlayer2 || this.isCanGainLife() && player.isCanLoseLife()) && (lifePlayer1 <= lifePlayer2 || this.isCanLoseLife() && player.isCanGainLife())) {
            this.setLife(lifePlayer2, game, source);
            player.setLife(lifePlayer1, game, source);
        }
    }

    @Override
    public int damage(int damage, Ability source, Game game) {
        return this.doDamage(damage, source.getSourceId(), source, game, false, true, null);
    }

    @Override
    public int damage(int damage, UUID attackerId, Ability source, Game game) {
        return this.doDamage(damage, attackerId, source, game, false, true, null);
    }

    @Override
    public int damage(int damage, UUID attackerId, Ability source, Game game, boolean combatDamage, boolean preventable) {
        return this.doDamage(damage, attackerId, source, game, combatDamage, preventable, null);
    }

    @Override
    public int damage(int damage, UUID attackerId, Ability source, Game game, boolean combatDamage, boolean preventable, List<UUID> appliedEffects) {
        return this.doDamage(damage, attackerId, source, game, combatDamage, preventable, appliedEffects);
    }

    private int doDamage(int damage, UUID attackerId, Ability source, Game game, boolean combat, boolean preventable, List<UUID> appliedEffects) {
        if (!this.isInGame()) {
            return 0;
        }
        if (damage < 1) {
            return 0;
        }
        DamagePlayerEvent event = new DamagePlayerEvent(this.playerId, attackerId, this.playerId, damage, preventable, combat);
        event.setAppliedEffects(appliedEffects);
        game.getState().addBatchDamageCouldHaveBeenFired(combat, game);
        if (game.replaceEvent(event)) {
            return 0;
        }
        int actualDamage = this.checkProtectionAbilities(event, attackerId, source, game);
        if (actualDamage < 1) {
            return 0;
        }
        UUID sourceControllerId = null;
        Abilities<Ability> sourceAbilities = null;
        MageObject attacker = game.getPermanentOrLKIBattlefield(attackerId);
        if (attacker == null) {
            StackObject stackObject = game.getStack().getStackObject(attackerId);
            attacker = stackObject != null ? stackObject.getStackAbility().getSourceObject(game) : game.getObject(attackerId);
            if (attacker instanceof Spell) {
                sourceAbilities = ((Spell)attacker).getAbilities(game);
                sourceControllerId = ((Spell)attacker).getControllerId();
            } else if (attacker instanceof Card) {
                sourceAbilities = ((Card)attacker).getAbilities(game);
                sourceControllerId = ((Card)attacker).getOwnerId();
            } else if (attacker instanceof CommandObject) {
                sourceControllerId = ((CommandObject)attacker).getControllerId();
                sourceAbilities = attacker.getAbilities();
            }
        } else {
            sourceAbilities = attacker.getAbilities(game);
            sourceControllerId = attacker.getControllerId();
        }
        if (event.isAsThoughInfect() || sourceAbilities != null && sourceAbilities.containsKey(InfectAbility.getInstance().getId())) {
            this.addCounters(CounterType.POISON.createInstance(actualDamage), sourceControllerId, source, game);
        } else {
            GameEvent damageToLifeLossEvent = new GameEvent(GameEvent.EventType.DAMAGE_CAUSES_LIFE_LOSS, this.playerId, source, this.playerId, actualDamage, combat);
            if (!game.replaceEvent(damageToLifeLossEvent)) {
                this.loseLife(damageToLifeLossEvent.getAmount(), game, source, combat, attackerId);
            }
        }
        if (sourceAbilities != null && sourceAbilities.containsKey(LifelinkAbility.getInstance().getId())) {
            if (combat) {
                game.getPermanent(attackerId).markLifelink(actualDamage);
            } else {
                Player player = game.getPlayer(sourceControllerId);
                player.gainLife(actualDamage, game, source);
            }
        }
        if (combat && sourceAbilities != null && sourceAbilities.containsClass(ToxicAbility.class)) {
            int countersToAdd = CardUtil.castStream(sourceAbilities.stream(), ToxicAbility.class).mapToInt(ToxicAbility::getAmount).sum();
            this.addCounters(CounterType.POISON.createInstance(countersToAdd), sourceControllerId, source, game);
        }
        if (sourceAbilities != null && sourceAbilities.containsKey(SquirrellinkAbility.getInstance().getId())) {
            Player player = game.getPlayer(sourceControllerId);
            new SquirrelToken().putOntoBattlefield(actualDamage, game, source, player.getId());
        }
        DamagedPlayerEvent damagedEvent = new DamagedPlayerEvent(this.playerId, attackerId, this.playerId, actualDamage, combat);
        game.fireEvent(damagedEvent);
        game.getState().addSimultaneousDamage(damagedEvent, game);
        return actualDamage;
    }

    private int checkProtectionAbilities(GameEvent event, UUID attackerId, Ability source, Game game) {
        PreventDamageEvent preventEvent;
        MageObject attacker = game.getObject(attackerId);
        if (attacker != null && this.hasProtectionFrom(attacker, game) && !game.replaceEvent(preventEvent = new PreventDamageEvent(this.playerId, attackerId, source, this.playerId, event.getAmount(), ((DamageEvent)event).isCombatDamage()))) {
            int preventedDamage = event.getAmount();
            event.setAmount(0);
            game.fireEvent(new PreventedDamageEvent(this.playerId, attackerId, source, this.playerId, preventedDamage));
            game.informPlayers(preventedDamage + " damage from " + attacker.getLogName() + " to " + this.getLogName() + (preventedDamage > 1 ? " were" : "was") + " prevented because of protection");
            return 0;
        }
        return event.getAmount();
    }

    @Override
    public boolean addCounters(Counter counter, UUID playerAddingCounters, Ability source, Game game) {
        boolean returnCode = true;
        GameEvent addingAllEvent = GameEvent.getEvent(GameEvent.EventType.ADD_COUNTERS, this.playerId, source, playerAddingCounters, counter.getName(), counter.getCount());
        if (!game.replaceEvent(addingAllEvent)) {
            int amount;
            int finalAmount = amount = addingAllEvent.getAmount();
            boolean isEffectFlag = addingAllEvent.getFlag();
            for (int i = 0; i < amount; ++i) {
                Counter eventCounter = counter.copy();
                eventCounter.remove(eventCounter.getCount() - 1);
                GameEvent addingOneEvent = GameEvent.getEvent(GameEvent.EventType.ADD_COUNTER, this.playerId, source, playerAddingCounters, counter.getName(), 1);
                addingOneEvent.setFlag(isEffectFlag);
                if (!game.replaceEvent(addingOneEvent)) {
                    this.counters.addCounter(eventCounter);
                    GameEvent addedOneEvent = GameEvent.getEvent(GameEvent.EventType.COUNTER_ADDED, this.playerId, source, playerAddingCounters, counter.getName(), 1);
                    addedOneEvent.setFlag(addingOneEvent.getFlag());
                    game.fireEvent(addedOneEvent);
                    continue;
                }
                --finalAmount;
                returnCode = false;
            }
            if (finalAmount > 0) {
                GameEvent addedAllEvent = GameEvent.getEvent(GameEvent.EventType.COUNTERS_ADDED, this.playerId, source, playerAddingCounters, counter.getName(), amount);
                addedAllEvent.setFlag(addingAllEvent.getFlag());
                game.fireEvent(addedAllEvent);
            }
        } else {
            returnCode = false;
        }
        return returnCode;
    }

    @Override
    public void loseCounters(String counterName, int amount, Ability source, Game game) {
        RemoveCountersEvent removeCountersEvent = new RemoveCountersEvent(counterName, this, source, amount, false);
        if (game.replaceEvent(removeCountersEvent)) {
            return;
        }
        int finalAmount = 0;
        for (int i = 0; i < amount; ++i) {
            GameEvent event = new RemoveCounterEvent(counterName, this, source, false);
            if (game.replaceEvent(event)) continue;
            if (!this.counters.removeCounter(counterName, 1)) break;
            event = new CounterRemovedEvent(counterName, this, source, false);
            game.fireEvent(event);
            ++finalAmount;
        }
        CountersRemovedEvent event = new CountersRemovedEvent(counterName, this, source, finalAmount, false);
        game.fireEvent(event);
    }

    @Override
    public int loseAllCounters(Ability source, Game game) {
        int amountBefore = this.getCountersTotalCount();
        for (Counter counter : this.getCountersAsCopy().values()) {
            this.loseCounters(counter.getName(), counter.getCount(), source, game);
        }
        int amountAfter = this.getCountersTotalCount();
        return Math.max(0, amountBefore - amountAfter);
    }

    @Override
    public int loseAllCounters(String counterName, Ability source, Game game) {
        int amountBefore = this.getCountersCount(counterName);
        this.loseCounters(counterName, amountBefore, source, game);
        int amountAfter = this.getCountersCount(counterName);
        return Math.max(0, amountBefore - amountAfter);
    }

    @Override
    public int getCountersCount(CounterType counterType) {
        return this.counters.getCount(counterType);
    }

    @Override
    public int getCountersCount(String counterName) {
        return this.counters.getCount(counterName);
    }

    @Override
    public int getCountersTotalCount() {
        return this.counters.getTotalCount();
    }

    @Override
    public Abilities<Ability> getAbilities() {
        return this.abilities;
    }

    @Override
    public void addAbility(Ability ability) {
        ability.setSourceId(this.playerId);
        this.abilities.add(ability);
        this.abilities.addAll(ability.getSubAbilities());
    }

    @Override
    public int getLandsPerTurn() {
        return this.landsPerTurn;
    }

    @Override
    public void setLandsPerTurn(int landsPerTurn) {
        this.landsPerTurn = landsPerTurn;
    }

    @Override
    public int getMaxHandSize() {
        return this.maxHandSize;
    }

    @Override
    public void setMaxHandSize(int maxHandSize) {
        this.maxHandSize = maxHandSize;
    }

    @Override
    public void setMaxAttackedBy(int maxAttackedBy) {
        this.maxAttackedBy = maxAttackedBy;
    }

    @Override
    public int getMaxAttackedBy() {
        return this.maxAttackedBy;
    }

    @Override
    public void setResponseString(String responseString) {
    }

    @Override
    public void setResponseManaType(UUID manaTypePlayerId, ManaType responseManaType) {
    }

    @Override
    public void setResponseUUID(UUID responseUUID) {
    }

    @Override
    public void setResponseBoolean(Boolean responseBoolean) {
    }

    @Override
    public void setResponseInteger(Integer responseInteger) {
    }

    @Override
    public boolean isPassed() {
        return this.passed;
    }

    @Override
    public void pass(Game game) {
        this.passed = true;
        this.resetStoredBookmark(game);
    }

    @Override
    public void resetPassed() {
        this.passed = this.loses || this.hasLeft();
    }

    @Override
    public void resetPlayerPassedActions() {
        this.passed = false;
        this.passedTurn = false;
        this.passedTurnSkipStack = false;
        this.passedUntilEndOfTurn = false;
        this.passedUntilNextMain = false;
        this.passedUntilStackResolved = false;
        this.dateLastAddedToStack = null;
        this.passedUntilEndStepBeforeMyTurn = false;
        this.skippedAtLeastOnce = false;
        this.passedAllTurns = false;
        this.justActivatedType = null;
    }

    @Override
    public void quit(Game game) {
        this.quit = true;
        this.concede(game);
        logger.debug((Object)(this.getName() + " quits the match."));
        game.informPlayers(this.getLogName() + " quits the match.");
    }

    @Override
    public void timerTimeout(Game game) {
        this.quit = true;
        this.timerTimeout = true;
        this.concede(game);
        game.informPlayers(this.getLogName() + " has run out of time, losing the match.");
    }

    @Override
    public void idleTimeout(Game game) {
        this.quit = true;
        this.idleTimeout = true;
        this.concede(game);
        game.informPlayers(this.getLogName() + " was idle for too long, losing the Match.");
    }

    @Override
    public void concede(Game game) {
        game.setConcedingPlayer(this.playerId);
        this.lost(game);
    }

    @Override
    public void sendPlayerAction(PlayerAction playerAction, Game game, Object data) {
        switch (playerAction) {
            case PASS_PRIORITY_UNTIL_MY_NEXT_TURN: {
                this.resetPlayerPassedActions();
                this.passedAllTurns = true;
                this.skip();
                break;
            }
            case PASS_PRIORITY_UNTIL_TURN_END_STEP: {
                this.resetPlayerPassedActions();
                this.passedUntilEndOfTurn = true;
                this.skippedAtLeastOnce = PhaseStep.END_TURN != game.getTurnStepType();
                this.skip();
                break;
            }
            case PASS_PRIORITY_UNTIL_NEXT_TURN: {
                this.resetPlayerPassedActions();
                this.passedTurn = true;
                this.skip();
                break;
            }
            case PASS_PRIORITY_UNTIL_NEXT_TURN_SKIP_STACK: {
                this.resetPlayerPassedActions();
                this.passedTurnSkipStack = true;
                this.skip();
                break;
            }
            case PASS_PRIORITY_UNTIL_NEXT_MAIN_PHASE: {
                this.resetPlayerPassedActions();
                this.passedUntilNextMain = true;
                this.skippedAtLeastOnce = game.getTurnStepType() != PhaseStep.POSTCOMBAT_MAIN && game.getTurnStepType() != PhaseStep.PRECOMBAT_MAIN;
                this.skip();
                break;
            }
            case PASS_PRIORITY_UNTIL_STACK_RESOLVED: {
                if (game.getStack().isEmpty()) break;
                this.resetPlayerPassedActions();
                this.passedUntilStackResolved = true;
                this.dateLastAddedToStack = game.getStack().getDateLastAdded();
                this.skip();
                break;
            }
            case PASS_PRIORITY_UNTIL_END_STEP_BEFORE_MY_NEXT_TURN: {
                this.resetPlayerPassedActions();
                this.passedUntilEndStepBeforeMyTurn = true;
                this.skip();
                break;
            }
            case PASS_PRIORITY_CANCEL_ALL_ACTIONS: {
                this.resetPlayerPassedActions();
                break;
            }
            case PERMISSION_REQUESTS_ALLOWED_OFF: {
                this.userData.setAllowRequestShowHandCards(false);
                break;
            }
            case PERMISSION_REQUESTS_ALLOWED_ON: {
                this.userData.setAllowRequestShowHandCards(true);
                this.userData.resetRequestedHandPlayersList(game.getId());
            }
        }
        logger.trace((Object)("PASS Priority: " + (Object)((Object)playerAction)));
    }

    @Override
    public void leave() {
        this.passed = true;
        this.loses = true;
        this.left = true;
        this.abort();
        this.hand.clear();
        this.graveyard.clear();
        this.library.clear();
    }

    @Override
    public boolean hasLeft() {
        return this.left;
    }

    @Override
    public void lost(Game game) {
        if (this.canLose(game)) {
            this.lostForced(game);
        }
    }

    @Override
    public void lostForced(Game game) {
        logger.debug((Object)(this.getName() + " has lost gameId: " + game.getId()));
        if (!this.wins) {
            this.loses = true;
            game.fireEvent(GameEvent.getEvent(GameEvent.EventType.LOST, null, null, this.playerId));
            game.informPlayers(this.getLogName() + " has lost the game.");
        } else {
            logger.debug((Object)(this.getName() + " has already won - stop lost"));
        }
        if (!this.hasLeft()) {
            logger.debug((Object)("Game over playerId: " + this.playerId));
            game.setConcedingPlayer(this.playerId);
        }
    }

    @Override
    public boolean canLose(Game game) {
        return this.hasLeft() || !game.replaceEvent(new GameEvent(GameEvent.EventType.LOSES, null, null, this.playerId));
    }

    @Override
    public void won(Game game) {
        Player opponent;
        boolean opponentInGame = false;
        for (UUID opponentId : game.getOpponents(this.playerId)) {
            opponent = game.getPlayer(opponentId);
            if (opponent == null || !opponent.isInGame()) continue;
            opponentInGame = true;
            break;
        }
        if (!opponentInGame || !game.replaceEvent(new GameEvent(GameEvent.EventType.WINS, null, null, this.playerId))) {
            logger.debug((Object)("player won -> start: " + this.getName()));
            if (!this.loses) {
                for (UUID opponentId : game.getOpponents(this.playerId)) {
                    opponent = game.getPlayer(opponentId);
                    if (opponent == null || opponent.hasLost()) continue;
                    logger.debug((Object)("player won -> calling opponent lost: " + this.getName() + "  opponent: " + opponent.getName()));
                    opponent.lostForced(game);
                }
                int opponentsAlive = 0;
                for (UUID playerIdToCheck : game.getPlayerList()) {
                    Player opponent2;
                    if (!game.isOpponent(this, playerIdToCheck) || (opponent2 = game.getPlayer(playerIdToCheck)) == null || opponent2.hasLost()) continue;
                    ++opponentsAlive;
                }
                if (opponentsAlive == 0 && !this.hasWon()) {
                    logger.debug((Object)("player won -> No more opponents alive game won: " + this.getName()));
                    game.informPlayers(this.getLogName() + " has won the game");
                    this.wins = true;
                    game.end();
                }
            } else {
                logger.debug((Object)("player won -> but already lost before or other players still alive: " + this.getName()));
            }
        }
    }

    @Override
    public void drew(Game game) {
        if (!this.hasLost()) {
            this.draws = true;
            game.fireEvent(GameEvent.getEvent(GameEvent.EventType.DRAW_PLAYER, null, null, this.playerId));
            game.informPlayers("For " + this.getLogName() + " the game is a draw.");
            game.setConcedingPlayer(this.playerId);
        }
    }

    @Override
    public boolean hasLost() {
        return this.loses;
    }

    @Override
    public boolean isInGame() {
        return !this.hasQuit() && !this.hasLost() && !this.hasWon() && !this.hasDrew() && !this.hasLeft();
    }

    @Override
    public boolean canRespond() {
        return this.isInGame() && !this.abort && !Thread.currentThread().isInterrupted();
    }

    @Override
    public boolean hasWon() {
        return !this.loses && this.wins;
    }

    @Override
    public boolean hasDrew() {
        return this.draws;
    }

    @Override
    public void declareAttacker(UUID attackerId, UUID defenderId, Game game, boolean allowUndo) {
        Permanent attacker;
        if (allowUndo) {
            this.setStoredBookmark(game.bookmarkState());
        }
        if ((attacker = game.getPermanent(attackerId)) != null && attacker.canAttack(defenderId, game) && attacker.isControlledBy(this.playerId) && !game.getCombat().declareAttacker(attackerId, defenderId, this.playerId, game)) {
            game.undo(this.playerId);
        }
    }

    @Override
    public void declareBlocker(UUID defenderId, UUID blockerId, UUID attackerId, Game game) {
        this.declareBlocker(defenderId, blockerId, attackerId, game, true);
    }

    @Override
    public void declareBlocker(UUID defenderId, UUID blockerId, UUID attackerId, Game game, boolean allowUndo) {
        if (this.isHuman() && allowUndo) {
            this.setStoredBookmark(game.bookmarkState());
        }
        Permanent blocker = game.getPermanent(blockerId);
        CombatGroup group = game.getCombat().findGroup(attackerId);
        if (blocker != null && group != null && group.canBlock(blocker, game)) {
            group.addBlocker(blockerId, this.playerId, game);
            game.getCombat().addBlockingGroup(blockerId, attackerId, this.playerId, game);
        } else if (this.isHuman() && !game.isSimulation()) {
            game.informPlayer(this, "You can't block this creature.");
        }
    }

    @Override
    public boolean searchLibrary(TargetCardInLibrary target, Ability source, Game game) {
        return this.searchLibrary(target, source, game, this.playerId);
    }

    @Override
    public boolean searchLibrary(TargetCardInLibrary target, Ability source, Game game, UUID targetPlayerId) {
        block14: {
            LibrarySearchedEvent searchedEvent;
            SearchLibraryEvent searchEvent = new SearchLibraryEvent(targetPlayerId, source, this.playerId, Integer.MAX_VALUE);
            if (game.replaceEvent(searchEvent)) {
                return false;
            }
            Player targetPlayer = game.getPlayer(targetPlayerId);
            PlayerImpl searchingPlayer = this;
            Player searchingController = game.getPlayer(searchEvent.getSearchingControllerId());
            if (targetPlayer == null || searchingController == null) {
                return false;
            }
            String searchInfo = searchingPlayer.getLogName();
            if (!searchingPlayer.getId().equals(searchingController.getId())) {
                searchInfo = searchInfo + " under control of " + searchingPlayer.getLogName();
            }
            searchInfo = targetPlayer.getId().equals(searchingPlayer.getId()) ? searchInfo + " searches their library" : searchInfo + " searches the library of " + targetPlayer.getLogName();
            if (!game.isSimulation()) {
                game.informPlayers(searchInfo + CardUtil.getSourceLogName(game, source));
            }
            boolean takeControl = false;
            if (!searchingPlayer.getId().equals(searchingController.getId())) {
                CardUtil.takeControlUnderPlayerStart(game, source, searchingController, searchingPlayer, true);
                takeControl = true;
            }
            Library searchingLibrary = targetPlayer.getLibrary();
            TargetCardInLibrary newTarget = target.copy();
            int librarySearchLimit = searchEvent.getAmount();
            ArrayList<Card> cardsFromTop = null;
            while (true) {
                int count;
                if (librarySearchLimit == Integer.MAX_VALUE) {
                    count = searchingLibrary.count(target.getFilter(), game);
                } else {
                    if (cardsFromTop == null) {
                        cardsFromTop = new ArrayList<Card>(searchingLibrary.getTopCards(game, librarySearchLimit));
                    } else {
                        cardsFromTop.retainAll(searchingLibrary.getCards(game));
                    }
                    newTarget.setCardLimit(Math.min(librarySearchLimit, cardsFromTop.size()));
                    count = Math.min(searchingLibrary.count(target.getFilter(), game), librarySearchLimit);
                }
                if (count < target.getMinNumberOfTargets()) {
                    newTarget.setMinNumberOfTargets(count);
                }
                if (!targetPlayer.getId().equals(searchingPlayer.getId()) || !this.handleCastableCardsWhileLibrarySearching(this.library, targetPlayer, source, game)) break;
                newTarget.clearChosen();
            }
            if (newTarget.choose(Outcome.Neutral, searchingController.getId(), targetPlayer.getId(), source, game)) {
                target.getTargets().clear();
                for (UUID targetId : newTarget.getTargets()) {
                    target.add(targetId, game);
                }
            }
            if (takeControl) {
                CardUtil.takeControlUnderPlayerEnd(game, source, searchingController, searchingPlayer);
            }
            if (game.replaceEvent(searchedEvent = new LibrarySearchedEvent(targetPlayer.getId(), source, searchingPlayer.getId(), target))) break block14;
            game.fireEvent(searchedEvent);
        }
        return true;
    }

    @Override
    public boolean seekCard(FilterCard filter, Ability source, Game game) {
        Set cards = this.getLibrary().getCards(game).stream().filter(card -> filter.match((Card)card, this.getId(), source, game)).collect(Collectors.toSet());
        Card card2 = (Card)RandomUtil.randomFromCollection(cards);
        if (card2 == null) {
            return false;
        }
        game.informPlayers(this.getLogName() + " seeks a card from their library");
        this.moveCards(card2, Zone.HAND, source, game);
        return true;
    }

    @Override
    public void lookAtAllLibraries(Ability source, Game game) {
        for (UUID playerId : game.getState().getPlayersInRange(this.getId(), game)) {
            Player player = game.getPlayer(playerId);
            String playerName = this.getName().equals(player.getName()) ? "Your " : player.getName() + "'s ";
            playerName = playerName + "library";
            CardsImpl cardsInLibrary = new CardsImpl(player.getLibrary().getTopCards(game, player.getLibrary().size()));
            this.lookAtCards(playerName, cardsInLibrary, game);
        }
    }

    private boolean handleCastableCardsWhileLibrarySearching(Library library, Player targetPlayer, Ability source, Game game) {
        List<UUID> castableCards = library.getCards(game).stream().filter(card -> card.getAbilities(game).containsClass(WhileSearchingPlayFromLibraryAbility.class)).map(MageItem::getId).collect(Collectors.toList());
        if (castableCards.isEmpty()) {
            return false;
        }
        if (targetPlayer.isComputer()) {
            return false;
        }
        if (!targetPlayer.chooseUse(Outcome.AIDontUseIt, "There are " + castableCards.size() + " cards you can cast while searching your library. Cast any of them?", null, game)) {
            return false;
        }
        boolean casted = false;
        TargetCard targetCard = new TargetCard(0, 1, Zone.LIBRARY, StaticFilters.FILTER_CARD);
        targetCard.withTargetName("card to cast from library");
        targetCard.withNotTarget(true);
        while (!castableCards.isEmpty()) {
            Card card2;
            targetCard.clearChosen();
            if (!targetPlayer.choose(Outcome.AIDontUseIt, new CardsImpl((Collection<UUID>)castableCards), targetCard, source, game) || (card2 = game.getCard(targetCard.getFirstTarget())) == null) break;
            game.getState().setValue("PlayFromNotOwnHandZone" + card2.getId(), Boolean.TRUE);
            targetPlayer.cast(targetPlayer.chooseAbilityForCast(card2, game, false), game, false, null);
            game.getState().setValue("PlayFromNotOwnHandZone" + card2.getId(), null);
            castableCards.remove(card2.getId());
            casted = true;
        }
        return casted;
    }

    @Override
    public boolean flipCoin(Ability source, Game game, boolean winnable) {
        return this.flipCoins(source, game, 1, winnable).get(0);
    }

    @Override
    public List<Boolean> flipCoins(Ability source, Game game, int amount, boolean winnable) {
        ArrayList<Boolean> results = new ArrayList<Boolean>();
        FlipCoinsEvent flipsEvent = new FlipCoinsEvent(this.getId(), amount, source);
        game.replaceEvent(flipsEvent);
        for (int i = 0; i < flipsEvent.getAmount(); ++i) {
            boolean chosen;
            if (flipsEvent.isHeadsAndWon()) {
                if (winnable) {
                    game.informPlayers(this.getLogName() + " chose " + CardUtil.booleanToFlipName(true));
                }
                game.informPlayers(this.getLogName() + " flipped " + CardUtil.booleanToFlipName(true) + CardUtil.getSourceLogName(game, source));
                if (winnable) {
                    game.informPlayers(this.getLogName() + " won the flip" + CardUtil.getSourceLogName(game, source));
                }
                game.fireEvent(new FlipCoinEvent(this.playerId, source, true, true, true).createFlippedEvent());
                results.add(true);
                continue;
            }
            if (winnable) {
                chosen = this.chooseUse(Outcome.Benefit, "Heads or tails?", "", "Heads", "Tails", source, game);
                game.informPlayers(this.getLogName() + " chose " + CardUtil.booleanToFlipName(chosen));
            } else {
                chosen = false;
            }
            boolean result = this.flipCoinResult(game);
            FlipCoinEvent event = new FlipCoinEvent(this.playerId, source, result, chosen, winnable);
            game.replaceEvent(event);
            game.informPlayers(this.getLogName() + " flipped " + CardUtil.booleanToFlipName(event.getResult()) + CardUtil.getSourceLogName(game, source));
            if (event.getFlipCount() > 1) {
                boolean canChooseHeads = event.getResult();
                boolean canChooseTails = !event.getResult();
                for (int j = 1; j < event.getFlipCount(); ++j) {
                    boolean tempFlip = this.flipCoinResult(game);
                    canChooseHeads = canChooseHeads || tempFlip;
                    canChooseTails = canChooseTails || !tempFlip;
                    game.informPlayers(this.getLogName() + " flipped " + CardUtil.booleanToFlipName(tempFlip));
                }
                if (canChooseHeads && canChooseTails) {
                    event.setResult(this.chooseUse(Outcome.Benefit, "Choose which flip to keep", event.isWinnable() ? "(You called " + event.getChosenName() + ")" : null, "Heads", "Tails", source, game));
                } else {
                    event.setResult(canChooseHeads);
                }
                game.informPlayers(this.getLogName() + " chose to keep " + CardUtil.booleanToFlipName(event.getResult()));
            }
            if (event.isWinnable()) {
                game.informPlayers(this.getLogName() + " " + (event.getResult() == event.getChosen() ? "won" : "lost") + " the flip" + CardUtil.getSourceLogName(game, source));
            }
            game.fireEvent(event.createFlippedEvent());
            results.add(event.isWinnable() ? event.getResult() == event.getChosen() : event.getResult());
        }
        return results;
    }

    @Override
    public boolean flipCoinResult(Game game) {
        return RandomUtil.nextBoolean();
    }

    @Override
    public int rollDieResult(int sides, Game game) {
        return RandomUtil.nextInt(sides) + 1;
    }

    private Object rollDieInner(Outcome outcome, Game game, Ability source, RollDieType rollDieType, int sidesAmount, int chaosSidesAmount, int planarSidesAmount, int rollsAmount) {
        if (rollsAmount == 1) {
            return this.rollDieInnerWithReplacement(game, source, rollDieType, sidesAmount, chaosSidesAmount, planarSidesAmount);
        }
        LinkedHashSet<Object> choices = new LinkedHashSet<Object>();
        for (int j = 0; j < rollsAmount; ++j) {
            choices.add(this.rollDieInnerWithReplacement(game, source, rollDieType, sidesAmount, chaosSidesAmount, planarSidesAmount));
        }
        if (choices.size() == 1) {
            return choices.stream().findFirst().orElse(0);
        }
        if (this.isComputer()) {
            if (rollDieType == RollDieType.NUMERICAL) {
                if (outcome.isGood()) {
                    return choices.stream().map(Integer.class::cast).max(Comparator.naturalOrder()).orElse(null);
                }
                return choices.stream().map(Integer.class::cast).min(Comparator.naturalOrder()).orElse(null);
            }
            return choices.stream().map(PlanarDieRollResult.class::cast).max(Comparator.comparingInt(PlanarDieRollResult::getAIPriority)).orElse(null);
        }
        ChoiceImpl choice = new ChoiceImpl(true);
        choice.setMessage("Choose which die roll result to keep (the rest will be ignored)");
        choice.setChoices(choices.stream().sorted().map(Object::toString).collect(Collectors.toSet()));
        this.choose(Outcome.Neutral, choice, game);
        Object defaultChoice = choices.iterator().next();
        return choices.stream().filter(o -> o.toString().equals(choice.getChoice())).findFirst().orElse(defaultChoice);
    }

    private Object rollDieInnerWithReplacement(Game game, Ability source, RollDieType rollDieType, int numSides, int numChaosSides, int numPlanarSides) {
        switch (rollDieType) {
            case NUMERICAL: {
                int result = this.rollDieResult(numSides, game);
                if (numSides == 6 && result == 3 && game.replaceEvent(GameEvent.getEvent(GameEvent.EventType.REPLACE_ROLLED_DIE, source.getControllerId(), source, source.getControllerId())) && this.chooseUse(Outcome.Neutral, "Re-roll the 3?", source, game)) {
                    result = this.rollDieResult(numSides, game);
                }
                return result;
            }
            case PLANAR: {
                int result;
                if (numChaosSides + numPlanarSides > numSides) {
                    numChaosSides = 2;
                    numPlanarSides = 2;
                }
                PlanarDieRollResult roll = (result = this.rollDieResult(numSides, game)) <= numChaosSides ? PlanarDieRollResult.CHAOS_ROLL : (result > numSides - numPlanarSides ? PlanarDieRollResult.PLANAR_ROLL : PlanarDieRollResult.BLANK_ROLL);
                return roll;
            }
        }
        throw new IllegalArgumentException("Unknown roll die type " + (Object)((Object)rollDieType));
    }

    @Override
    public List<Integer> rollDice(Outcome outcome, Ability source, Game game, int sidesAmount, int rollsAmount, int ignoreLowestAmount) {
        return this.rollDiceInner(outcome, source, game, RollDieType.NUMERICAL, sidesAmount, 0, 0, rollsAmount, ignoreLowestAmount).stream().map(Integer.class::cast).collect(Collectors.toList());
    }

    private List<Object> rollDiceInner(Outcome outcome, Ability source, Game game, RollDieType rollDieType, int sidesAmount, int chaosSidesAmount, int planarSidesAmount, int rollsAmount, int ignoreLowestAmount) {
        String message;
        String ignoreMessage;
        RollDiceEvent rollDiceEvent = new RollDiceEvent(source, this.getId(), rollDieType, sidesAmount, rollsAmount);
        if (ignoreLowestAmount > 0) {
            rollDiceEvent.incIgnoreLowestAmount(ignoreLowestAmount);
        }
        game.replaceEvent(rollDiceEvent);
        ArrayList<Object> dieResults = new ArrayList<Object>();
        ArrayList<RollDieResult> dieRolls = new ArrayList<RollDieResult>();
        for (int i = 0; i < rollDiceEvent.getAmount(); ++i) {
            Object rollResult;
            RollDieEvent rollDieEvent = new RollDieEvent(source, this.getId(), rollDiceEvent.getRollDieType(), rollDiceEvent.getSides());
            game.replaceEvent(rollDieEvent);
            if (rollDieEvent.getRollDieType() == RollDieType.NUMERICAL && rollDieEvent.getBigIdeaRollsAmount() > 0) {
                int totalSum = 0;
                for (int j = 0; j < rollDieEvent.getBigIdeaRollsAmount() + 1; ++j) {
                    int singleResult = (Integer)this.rollDieInner(outcome, game, source, rollDieEvent.getRollDieType(), rollDieEvent.getSides(), chaosSidesAmount, planarSidesAmount, rollDieEvent.getRollsAmount());
                    totalSum += singleResult;
                    dieRolls.add(new RollDieResult(singleResult, rollDieEvent.getResultModifier(), null));
                }
                rollResult = totalSum;
            } else {
                switch (rollDieEvent.getRollDieType()) {
                    default: {
                        int naturalResult = (Integer)this.rollDieInner(outcome, game, source, rollDieEvent.getRollDieType(), rollDieEvent.getSides(), chaosSidesAmount, planarSidesAmount, rollDieEvent.getRollsAmount());
                        dieRolls.add(new RollDieResult(naturalResult, rollDieEvent.getResultModifier(), null));
                        rollResult = naturalResult;
                        break;
                    }
                    case PLANAR: {
                        PlanarDieRollResult planarResult = (PlanarDieRollResult)((Object)this.rollDieInner(outcome, game, source, rollDieEvent.getRollDieType(), rollDieEvent.getSides(), chaosSidesAmount, planarSidesAmount, rollDieEvent.getRollsAmount()));
                        dieRolls.add(new RollDieResult(0, 0, planarResult));
                        rollResult = planarResult;
                        break;
                    }
                }
            }
            dieResults.add(rollResult);
        }
        int diceRolledTotal = dieRolls.size();
        if (rollDiceEvent.getRollDieType() == RollDieType.NUMERICAL && rollDiceEvent.getIgnoreLowestAmount() > 0) {
            ArrayList ignoredResults = new ArrayList();
            for (int i = 0; i < rollDiceEvent.getIgnoreLowestAmount(); ++i) {
                int min = dieResults.stream().map(Integer.class::cast).mapToInt(Integer::intValue).min().orElse(0);
                dieResults.remove((Object)min);
                ignoredResults.add(min);
            }
            ignoreMessage = String.format(ignoredResults.size() > 1 ? ", ignoring [%s]" : ", ignoring %s", ignoredResults.stream().map(x -> "" + x).collect(Collectors.joining(", ")));
            ArrayList<RollDieResult> newRolls = new ArrayList<RollDieResult>();
            for (RollDieResult rollDieResult : dieRolls) {
                if (ignoredResults.contains(rollDieResult.getResult())) {
                    ignoredResults.remove((Object)rollDieResult.getResult());
                    continue;
                }
                newRolls.add(rollDieResult);
            }
            dieRolls.clear();
            dieRolls.addAll(newRolls);
        } else {
            ignoreMessage = "";
        }
        for (RollDieResult result : dieRolls) {
            game.fireEvent(new DieRolledEvent(source, this.getId(), rollDiceEvent.getRollDieType(), rollDiceEvent.getSides(), result.naturalResult, result.modifier, result.planarResult));
        }
        game.fireEvent(new DiceRolledEvent(rollDiceEvent.getSides(), dieResults, source, this.getId()));
        String resultString = dieResults.stream().map(Object::toString).collect(Collectors.joining(", "));
        switch (rollDiceEvent.getRollDieType()) {
            default: {
                message = String.format("[Roll a die] %s rolled %sd%s, result%s: %s%s%s", this.getLogName(), diceRolledTotal > 1 ? Integer.valueOf(diceRolledTotal) : "a ", rollDiceEvent.getSides(), dieResults.size() > 1 ? Character.valueOf('s') : "", dieResults.size() > 1 ? '[' + resultString + ']' : resultString, ignoreMessage, CardUtil.getSourceLogName(game, source));
                break;
            }
            case PLANAR: {
                message = String.format("[Roll a planar die] %s rolled %s%s", this.getLogName(), dieResults.size() > 1 ? '[' + resultString + ']' : resultString, CardUtil.getSourceLogName(game, source));
            }
        }
        game.informPlayers(message);
        return dieResults;
    }

    @Override
    public PlanarDieRollResult rollPlanarDie(Outcome outcome, Ability source, Game game, int chaosSidesAmount, int planarSidesAmount) {
        return this.rollDiceInner(outcome, source, game, RollDieType.PLANAR, 9, chaosSidesAmount, planarSidesAmount, 1, 0).stream().map(o -> (PlanarDieRollResult)((Object)((Object)o))).findFirst().orElse(PlanarDieRollResult.BLANK_ROLL);
    }

    @Override
    public List<Permanent> getAvailableAttackers(Game game) {
        return this.getAvailableAttackers(null, game);
    }

    @Override
    public List<Permanent> getAvailableAttackers(UUID defenderId, Game game) {
        FilterCreatureForCombat filter = new FilterCreatureForCombat();
        List<Permanent> attackers = game.getBattlefield().getAllActivePermanents(filter, this.playerId, game);
        attackers.removeIf(entry -> !entry.canAttack(defenderId, game));
        return attackers;
    }

    @Override
    public List<Permanent> getAvailableBlockers(Game game) {
        FilterCreatureForCombatBlock blockFilter = new FilterCreatureForCombatBlock();
        return game.getBattlefield().getAllActivePermanents(blockFilter, this.playerId, game);
    }

    @Override
    public ManaOptions getManaAvailable(Game originalGame) {
        Game game = originalGame.createSimulationForPlayableCalc();
        ManaOptions availableMana = new ManaOptions();
        availableMana.addMana(this.manaPool.getMana());
        for (ConditionalMana conditionalMana : this.manaPool.getConditionalMana()) {
            availableMana.addMana(conditionalMana);
        }
        ArrayList<Abilities<ActivatedManaAbilityImpl>> sourceWithoutManaCosts = new ArrayList<Abilities<ActivatedManaAbilityImpl>>();
        ArrayList<Abilities<ActivatedManaAbilityImpl>> sourceWithCosts = new ArrayList<Abilities<ActivatedManaAbilityImpl>>();
        for (Card card : this.getHand().getCards(game)) {
            Abilities<ActivatedManaAbilityImpl> manaAbilities = card.getAbilities(game).getAvailableActivatedManaAbilities(Zone.HAND, this.playerId, game);
            for (ActivatedManaAbilityImpl ability : manaAbilities) {
                AbilitiesImpl noTapAbilities = new AbilitiesImpl((Ability[])new ActivatedManaAbilityImpl[]{ability});
                if (ability.getManaCosts().isEmpty() && !ability.isPoolDependant()) {
                    sourceWithoutManaCosts.add(noTapAbilities);
                    continue;
                }
                sourceWithCosts.add(noTapAbilities);
            }
        }
        for (Permanent permanent : game.getBattlefield().getActivePermanents(this.playerId, game)) {
            Boolean canUse = null;
            boolean canAdd = false;
            boolean useLater = false;
            Abilities<ActivatedManaAbilityImpl> manaAbilities = permanent.getAbilities(game).getAvailableActivatedManaAbilities(Zone.BATTLEFIELD, this.playerId, game);
            Iterator it = manaAbilities.iterator();
            while (it.hasNext()) {
                ActivatedManaAbilityImpl ability = (ActivatedManaAbilityImpl)it.next();
                if (canUse == null) {
                    canUse = permanent.canUseActivatedAbilities(game);
                }
                if (!canUse.booleanValue()) continue;
                if (!ability.hasTapCost()) {
                    it.remove();
                    AbilitiesImpl noTapAbilities = new AbilitiesImpl((Ability[])new ActivatedManaAbilityImpl[]{ability});
                    if (ability.getManaCosts().isEmpty() && !ability.isPoolDependant()) {
                        sourceWithoutManaCosts.add(noTapAbilities);
                        continue;
                    }
                    sourceWithCosts.add(noTapAbilities);
                    continue;
                }
                canAdd = true;
                if (ability.getManaCosts().isEmpty() && !ability.isPoolDependant()) continue;
                useLater = true;
                break;
            }
            if (!canAdd) continue;
            if (useLater) {
                sourceWithCosts.add(manaAbilities);
                continue;
            }
            sourceWithoutManaCosts.add(manaAbilities);
        }
        for (Abilities abilities : sourceWithoutManaCosts) {
            availableMana.addMana(abilities, game);
        }
        boolean anAbilityWasUsed = true;
        boolean bl = false;
        while (anAbilityWasUsed && !sourceWithCosts.isEmpty()) {
            boolean bl2;
            anAbilityWasUsed = false;
            Iterator iterator = sourceWithCosts.iterator();
            while (iterator.hasNext()) {
                boolean used;
                Abilities manaAbilities = (Abilities)iterator.next();
                if (!bl2 && manaAbilities.hasPoolDependantAbilities() || !(used = manaAbilities.hasPoolDependantAbilities() ? availableMana.addManaPoolDependant(manaAbilities, game) : availableMana.addManaWithCost(manaAbilities, game))) continue;
                iterator.remove();
                anAbilityWasUsed = true;
            }
            if (anAbilityWasUsed || bl2) continue;
            bl2 = true;
            anAbilityWasUsed = true;
        }
        availableMana.removeFullyIncludedVariations();
        availableMana.remove(new Mana());
        return availableMana.copy();
    }

    @Override
    public void addAvailableTriggeredMana(List<Mana> netManaAvailable) {
        this.availableTriggeredManaList.add(netManaAvailable);
    }

    @Override
    public List<List<Mana>> getAvailableTriggeredMana() {
        return this.availableTriggeredManaList;
    }

    protected List<MageObject> getAvailableManaProducers(Game game) {
        ArrayList<MageObject> result = new ArrayList<MageObject>();
        for (Permanent permanent : game.getBattlefield().getActivePermanents(this.playerId, game)) {
            Boolean canUse = null;
            boolean canAdd = false;
            for (ActivatedManaAbilityImpl ability : permanent.getAbilities().getActivatedManaAbilities(Zone.BATTLEFIELD)) {
                if (!ability.getManaCosts().isEmpty()) {
                    canAdd = false;
                    break;
                }
                if (canUse == null) {
                    canUse = permanent.canUseActivatedAbilities(game);
                }
                if (!canUse.booleanValue() || !ability.canActivate(this.playerId, game).canActivate()) continue;
                canAdd = true;
            }
            if (!canAdd) continue;
            result.add(permanent);
        }
        for (Card card : this.getHand().getCards(game)) {
            boolean canAdd = false;
            for (ActivatedManaAbilityImpl ability : card.getAbilities(game).getActivatedManaAbilities(Zone.HAND)) {
                if (!ability.getManaCosts().isEmpty()) {
                    canAdd = false;
                    break;
                }
                if (!ability.canActivate(this.playerId, game).canActivate()) continue;
                canAdd = true;
            }
            if (!canAdd) continue;
            result.add(card);
        }
        return result;
    }

    public List<Permanent> getAvailableManaProducersWithCost(Game game) {
        ArrayList<Permanent> result = new ArrayList<Permanent>();
        block0: for (Permanent permanent : game.getBattlefield().getActivePermanents(this.playerId, game)) {
            Boolean canUse = null;
            for (ActivatedManaAbilityImpl ability : permanent.getAbilities().getActivatedManaAbilities(Zone.BATTLEFIELD)) {
                if (canUse == null) {
                    canUse = permanent.canUseActivatedAbilities(game);
                }
                if (!canUse.booleanValue() || !ability.canActivate(this.playerId, game).canActivate() || ability.getManaCosts().isEmpty()) continue;
                result.add(permanent);
                continue block0;
            }
        }
        return result;
    }

    protected boolean canPlay(ActivatedAbility ability, ManaOptions availableMana, MageObject sourceObject, Game game) {
        if (!ability.isManaActivatedAbility()) {
            ActivatedAbility copy = ability.copy();
            if (!copy.canActivate(this.playerId, game).canActivate()) {
                return false;
            }
            copy.adjustX(game);
            if (availableMana != null) {
                game.getContinuousEffects().costModification(copy, game);
            }
            boolean canBeCastRegularly = true;
            Set<MageIdentifier> allowedIdentifiers = null;
            if (copy instanceof SpellAbility) {
                if (copy.getManaCosts().isEmpty() && copy.getCosts().isEmpty()) {
                    canBeCastRegularly = false;
                }
                if (!(allowedIdentifiers = ((SpellAbility)copy).spellCanBeActivatedNow(this.playerId, game)).contains((Object)MageIdentifier.Default)) {
                    canBeCastRegularly = false;
                }
            }
            if (canBeCastRegularly && this.canPayMinimumManaCost(copy, availableMana, game)) {
                return true;
            }
            for (MageIdentifier identifier : (Set)this.getCastSourceIdWithAlternateMana().getOrDefault(copy.getSourceId(), new HashSet())) {
                if (allowedIdentifiers != null && !allowedIdentifiers.contains((Object)MageIdentifier.Default) && !allowedIdentifiers.contains((Object)identifier)) continue;
                ManaCosts<ManaCost> alternateCosts = this.getCastSourceIdManaCosts().get(copy.getSourceId()).get((Object)identifier);
                Costs<Cost> costs = this.getCastSourceIdCosts().get(copy.getSourceId()).get((Object)identifier);
                boolean canPutToPlay = true;
                if (alternateCosts != null && !alternateCosts.canPay(copy, copy, this.playerId, game)) {
                    canPutToPlay = false;
                }
                if (costs != null && !costs.canPay(copy, copy, this.playerId, game)) {
                    canPutToPlay = false;
                }
                if (!canPutToPlay) continue;
                return true;
            }
            if (AbilityType.SPELL.equals((Object)ability.getAbilityType())) {
                return this.canPlayCardByAlternateCost(game.getCard(ability.getSourceId()), availableMana, copy, game);
            }
        }
        return false;
    }

    protected boolean canPayMinimumManaCost(ActivatedAbility ability, ManaOptions availableMana, Game game) {
        ManaOptions abilityOptions = ability.getMinimumCostToActivate(this.playerId, game);
        if (abilityOptions.isEmpty()) {
            return true;
        }
        if (availableMana == null) {
            return true;
        }
        if (this.getPhyrexianColors() != null) {
            this.addPhyrexianLikePayOptions(abilityOptions);
        }
        Set<ApprovingObject> approvingObjects = game.getContinuousEffects().asThough(ability.getSourceId(), AsThoughEffectType.SPEND_OTHER_MANA, ability, ability.getControllerId(), game);
        for (Mana mana : abilityOptions) {
            if (mana.count() == 0) {
                return true;
            }
            for (Mana avail : availableMana) {
                if (!approvingObjects.isEmpty() && mana.count() <= avail.count()) {
                    return true;
                }
                if (avail instanceof ConditionalMana && !((ConditionalMana)avail).apply(ability, game, this.getId(), ability.getManaCosts()) || !mana.enough(avail)) continue;
                return true;
            }
        }
        return false;
    }

    private void addPhyrexianLikePayOptions(ManaOptions abilityOptions) {
        int maxLifeMana = this.getLife() / 2;
        if (maxLifeMana > 0) {
            HashSet<Mana> phyrexianOptions = new HashSet<Mana>();
            for (Mana mana : abilityOptions) {
                if (this.getPhyrexianColors().isBlack()) {
                    this.createReducedManaPayOption(maxLifeMana, mana, phyrexianOptions, ManaType.BLACK);
                }
                if (this.getPhyrexianColors().isBlue()) {
                    this.createReducedManaPayOption(maxLifeMana, mana, phyrexianOptions, ManaType.BLUE);
                }
                if (this.getPhyrexianColors().isRed()) {
                    this.createReducedManaPayOption(maxLifeMana, mana, phyrexianOptions, ManaType.RED);
                }
                if (this.getPhyrexianColors().isGreen()) {
                    this.createReducedManaPayOption(maxLifeMana, mana, phyrexianOptions, ManaType.GREEN);
                }
                if (!this.getPhyrexianColors().isWhite()) continue;
                this.createReducedManaPayOption(maxLifeMana, mana, phyrexianOptions, ManaType.WHITE);
            }
            abilityOptions.addAll(phyrexianOptions);
        }
    }

    private int createReducedManaPayOption(int availableLifeMana, Mana oldPayOption, Set<Mana> phyrexianOptions, ManaType manaType) {
        if (oldPayOption.get(manaType) > 0) {
            int restVal;
            Mana manaCopy = oldPayOption.copy();
            if (availableLifeMana > oldPayOption.get(manaType)) {
                restVal = 0;
                availableLifeMana -= oldPayOption.get(manaType);
            } else {
                restVal = CardUtil.overflowDec(oldPayOption.get(manaType), availableLifeMana);
                availableLifeMana = 0;
            }
            manaCopy.set(manaType, restVal);
            phyrexianOptions.add(manaCopy);
        }
        return availableLifeMana;
    }

    protected boolean canPlayCardByAlternateCost(Card sourceObject, ManaOptions availableMana, Ability ability, Game game) {
        Ability copyAbility;
        ManaCostsImpl manaCosts;
        if (sourceObject == null || sourceObject instanceof Permanent) {
            return false;
        }
        Set<MageIdentifier> allowedIdentifiers = null;
        if (ability instanceof SpellAbility) {
            allowedIdentifiers = ((SpellAbility)ability).spellCanBeActivatedNow(this.getId(), game);
        }
        for (Ability alternateSourceCostsAbility : sourceObject.getAbilities(game)) {
            if (!(alternateSourceCostsAbility instanceof AlternativeSourceCosts) || !((AlternativeSourceCosts)alternateSourceCostsAbility).isAvailable(ability, game) || !alternateSourceCostsAbility.getCosts().canPay(ability, ability, this.playerId, game) || allowedIdentifiers != null && !allowedIdentifiers.contains((Object)MageIdentifier.Default) && !allowedIdentifiers.contains((Object)alternateSourceCostsAbility.getIdentifier())) continue;
            manaCosts = new ManaCostsImpl();
            for (Cost cost : alternateSourceCostsAbility.getCosts()) {
                if (cost instanceof AlternativeCost) {
                    if (!(((AlternativeCost)cost).getCost() instanceof ManaCost)) continue;
                    manaCosts.add((ManaCost)((AlternativeCost)cost).getCost());
                    continue;
                }
                if (!(cost instanceof ManaCost)) continue;
                manaCosts.add((ManaCost)cost);
            }
            if (manaCosts.isEmpty()) {
                return true;
            }
            if (availableMana == null) {
                return true;
            }
            copyAbility = ability.copy();
            copyAbility.clearManaCostsToPay();
            copyAbility.addManaCostsToPay(manaCosts.copy());
            copyAbility.adjustX(game);
            game.getContinuousEffects().costModification(copyAbility, game);
            if (copyAbility.getManaCostsToPay().isEmpty()) {
                return true;
            }
            for (Mana mana : copyAbility.getManaCostsToPay().getOptions()) {
                if (!availableMana.enough(mana)) continue;
                return true;
            }
        }
        for (AlternativeSourceCosts alternateSourceCosts : this.getAlternativeSourceCosts()) {
            DynamicCost dynamicCost;
            if (!(alternateSourceCosts instanceof Ability) || !alternateSourceCosts.isAvailable(ability, game) || !alternateSourceCosts.getCosts().canPay(ability, ability, this.playerId, game) || allowedIdentifiers != null && !allowedIdentifiers.contains((Object)MageIdentifier.Default) && !allowedIdentifiers.contains((Object)alternateSourceCosts.getIdentifier())) continue;
            manaCosts = new ManaCostsImpl();
            for (Cost cost : alternateSourceCosts.getCosts()) {
                if (cost instanceof AlternativeCost) {
                    if (!(((AlternativeCost)cost).getCost() instanceof ManaCost)) continue;
                    manaCosts.add((ManaCost)((AlternativeCost)cost).getCost());
                    continue;
                }
                if (!(cost instanceof ManaCost)) continue;
                manaCosts.add((ManaCost)cost);
            }
            if (alternateSourceCosts instanceof AlternativeCostSourceAbility && (dynamicCost = ((AlternativeCostSourceAbility)alternateSourceCosts).getDynamicCost()) != null) {
                Cost cost;
                cost = dynamicCost.getCost(ability, game);
                if (cost instanceof AlternativeCost) {
                    cost = ((AlternativeCost)cost).getCost();
                }
                if (cost instanceof ManaCost) {
                    manaCosts.add((ManaCost)cost);
                }
            }
            if (manaCosts.isEmpty()) {
                return true;
            }
            if (availableMana == null) {
                return true;
            }
            copyAbility = ability.copy();
            copyAbility.clearManaCostsToPay();
            copyAbility.addManaCostsToPay(manaCosts.copy());
            copyAbility.adjustX(game);
            game.getContinuousEffects().costModification(copyAbility, game);
            if (copyAbility.getManaCostsToPay().isEmpty()) {
                return true;
            }
            for (Mana mana : copyAbility.getManaCostsToPay().getOptions()) {
                if (!availableMana.enough(mana)) continue;
                return true;
            }
        }
        return false;
    }

    protected ActivatedAbility findActivatedAbilityFromPlayable(MageObject object, ManaOptions availableMana, Ability ability, Game game) {
        ManaOptions manaFull = availableMana.copy();
        if (ability instanceof SpellAbility) {
            for (AlternateManaPaymentAbility altAbility : CardUtil.getAbilities(object, game).stream().filter(AlternateManaPaymentAbility.class::isInstance).map(a -> (AlternateManaPaymentAbility)((Object)a)).collect(Collectors.toList())) {
                ManaOptions manaSpecial = altAbility.getManaOptions(ability, game, ability.getManaCostsToPay());
                manaFull.addMana(manaSpecial);
            }
        }
        if (ability instanceof ActivatedManaAbilityImpl) {
            if (((ActivatedManaAbilityImpl)ability).canActivate(this.getId(), game).canActivate()) {
                return (ActivatedManaAbilityImpl)ability;
            }
        } else {
            if (ability instanceof AlternativeSourceCosts) {
                return this.findActivatedAbilityFromAlternativeSourceCost(object, manaFull, ability, game);
            }
            if (ability instanceof ActivatedAbility && this.canPlay((ActivatedAbility)ability, manaFull, object, game)) {
                return (ActivatedAbility)ability;
            }
        }
        return null;
    }

    protected ActivatedAbility findActivatedAbilityFromAlternativeSourceCost(MageObject object, ManaOptions availableMana, Ability ability, Game game) {
        if (ability instanceof AlternativeSourceCosts && object != null && !(object instanceof Permanent)) {
            ActivatedAbilityImpl playAbility = null;
            if (object.isLand(game)) {
                playAbility = CardUtil.getAbilities(object, game).stream().filter(PlayLandAbility.class::isInstance).findFirst().orElse(null);
            } else if (object instanceof Card) {
                playAbility = ((Card)object).getSpellAbility();
            }
            if (playAbility == null) {
                return null;
            }
            boolean canUse = ability instanceof MorphAbility && object instanceof Card && (game.canPlaySorcery(this.getId()) || !game.getContinuousEffects().asThough(object.getId(), AsThoughEffectType.CAST_AS_INSTANT, playAbility, this.getId(), game).isEmpty()) ? this.canPlayCardByAlternateCost((Card)object, availableMana, playAbility, game) : this.canPlay(playAbility, availableMana, object, game);
            if (canUse) {
                return playAbility;
            }
        }
        return null;
    }

    private void getPlayableFromObjectAll(Game game, Zone fromZone, MageObject object, ManaOptions availableMana, List<ActivatedAbility> output) {
        if (fromZone == null || object == null) {
            return;
        }
        if (object instanceof SplitCard) {
            SplitCard mainCard = (SplitCard)object;
            this.getPlayableFromObjectSingle(game, fromZone, mainCard.getLeftHalfCard(), mainCard.getLeftHalfCard().getAbilities(game), availableMana, output);
            this.getPlayableFromObjectSingle(game, fromZone, mainCard.getRightHalfCard(), mainCard.getRightHalfCard().getAbilities(game), availableMana, output);
            this.getPlayableFromObjectSingle(game, fromZone, mainCard, mainCard.getSharedAbilities(game), availableMana, output);
        } else if (object instanceof ModalDoubleFacedCard) {
            ModalDoubleFacedCard mainCard = (ModalDoubleFacedCard)object;
            this.getPlayableFromObjectSingle(game, fromZone, mainCard.getLeftHalfCard(), mainCard.getLeftHalfCard().getAbilities(game), availableMana, output);
            this.getPlayableFromObjectSingle(game, fromZone, mainCard.getRightHalfCard(), mainCard.getRightHalfCard().getAbilities(game), availableMana, output);
            this.getPlayableFromObjectSingle(game, fromZone, mainCard, mainCard.getSharedAbilities(game), availableMana, output);
        } else if (object instanceof CardWithSpellOption) {
            CardWithSpellOption cardWithSpellOption = (CardWithSpellOption)object;
            this.getPlayableFromObjectSingle(game, fromZone, cardWithSpellOption.getSpellCard(), cardWithSpellOption.getSpellCard().getAbilities(game), availableMana, output);
            this.getPlayableFromObjectSingle(game, fromZone, cardWithSpellOption, cardWithSpellOption.getSharedAbilities(game), availableMana, output);
        } else if (object instanceof Card) {
            this.getPlayableFromObjectSingle(game, fromZone, object, ((Card)object).getAbilities(game), availableMana, output);
        } else if (!(object instanceof StackObject)) {
            this.getPlayableFromObjectSingle(game, fromZone, object, object.getAbilities(), availableMana, output);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getPlayableFromObjectSingle(Game game, Zone fromZone, MageObject object, Abilities<Ability> candidateAbilities, ManaOptions availableMana, List<ActivatedAbility> output) {
        for (Ability ability : candidateAbilities) {
            boolean possibleToPlay;
            Set<ApprovingObject> approvingObjects;
            if (!(ability instanceof ActivatedAbility)) continue;
            boolean isPlaySpell = ability instanceof SpellAbility;
            boolean isPlayLand = ability instanceof PlayLandAbility;
            if (isPlayLand && game.getContinuousEffects().preventedByRuleModification(GameEvent.getEvent(GameEvent.EventType.PLAY_LAND, ability.getSourceId(), ability, this.getId()), ability, game, true)) continue;
            GameEvent castEvent = GameEvent.getEvent(GameEvent.EventType.CAST_SPELL, ability.getId(), ability, this.getId());
            castEvent.setZone(fromZone);
            if (isPlaySpell && game.getContinuousEffects().preventedByRuleModification(castEvent, ability, game, true)) continue;
            GameEvent castLateEvent = GameEvent.getEvent(GameEvent.EventType.CAST_SPELL_LATE, ability.getId(), ability, this.getId());
            castLateEvent.setZone(fromZone);
            if (isPlaySpell && game.getContinuousEffects().preventedByRuleModification(castLateEvent, ability, game, true)) continue;
            if ((isPlaySpell || isPlayLand) && fromZone != Zone.BATTLEFIELD) {
                approvingObjects = new HashSet();
                approvingObjects.addAll(game.getContinuousEffects().asThough(object.getId(), AsThoughEffectType.PLAY_FROM_NOT_OWN_HAND_ZONE, ability, this.getId(), game));
                if (isPlaySpell) {
                    approvingObjects.addAll(game.getContinuousEffects().asThough(object.getId(), AsThoughEffectType.CAST_FROM_NOT_OWN_HAND_ZONE, ability, this.getId(), game));
                }
                if (approvingObjects.isEmpty() && isPlaySpell && ((SpellAbility)ability).getSpellAbilityType().equals((Object)SpellAbilityType.ADVENTURE_SPELL)) {
                    approvingObjects = game.getContinuousEffects().asThough(object.getId(), AsThoughEffectType.CAST_ADVENTURE_FROM_NOT_OWN_HAND_ZONE, ability, this.getId(), game);
                }
                Player simPlayer = game.getPlayer(this.getId());
                this.castSourceIdCosts = new HashMap<UUID, Map<MageIdentifier, Costs<Cost>>>(simPlayer.getCastSourceIdCosts());
                this.castSourceIdManaCosts = new HashMap<UUID, Map<MageIdentifier, ManaCosts<ManaCost>>>(simPlayer.getCastSourceIdManaCosts());
                this.castSourceIdWithAlternateMana = new HashMap<UUID, Set<MageIdentifier>>(simPlayer.getCastSourceIdWithAlternateMana());
            } else {
                approvingObjects = new HashSet<ApprovingObject>();
            }
            boolean bl = possibleToPlay = !approvingObjects.isEmpty() && ability.getZone().match(Zone.HAND) && (isPlaySpell || isPlayLand);
            if (fromZone != Zone.ALL && ability.getZone().match(fromZone)) {
                possibleToPlay = true;
            }
            if (!possibleToPlay) continue;
            ActivatedAbility playAbility = this.findActivatedAbilityFromPlayable(object, availableMana, ability, game);
            if (playAbility != null && !output.contains(playAbility)) {
                output.add(playAbility);
                continue;
            }
            if (approvingObjects.isEmpty() || ability.getControllerId() == this.getId()) continue;
            UUID savedControllerId = ability.getControllerId();
            ability.setControllerId(this.getId());
            try {
                playAbility = this.findActivatedAbilityFromPlayable(object, availableMana, ability, game);
                if (playAbility == null || output.contains(playAbility)) continue;
                output.add(playAbility);
            }
            finally {
                ability.setControllerId(savedControllerId);
            }
        }
    }

    @Override
    public List<ActivatedAbility> getPlayable(Game game, boolean hidden) {
        return this.getPlayable(game, hidden, Zone.ALL, true);
    }

    public List<ActivatedAbility> getPlayable(Game originalGame, boolean hidden, Zone fromZone, boolean hideDuplicatedAbilities) {
        Object player;
        ArrayList<ActivatedAbility> playable = new ArrayList<ActivatedAbility>();
        if (PlayerImpl.shouldSkipGettingPlayable(originalGame)) {
            return playable;
        }
        Game game = originalGame.createSimulationForPlayableCalc();
        ManaOptions availableMana = this.getManaAvailable(game);
        boolean fromAll = fromZone.equals((Object)Zone.ALL);
        if (hidden && (fromAll || fromZone == Zone.HAND)) {
            for (Card card : this.hand.getCards(game)) {
                for (Ability ability : card.getAbilities(game)) {
                    ActivatedAbility playAbility;
                    if (!ability.getZone().match(Zone.HAND)) continue;
                    boolean isPlaySpell = ability instanceof SpellAbility;
                    boolean isPlayLand = ability instanceof PlayLandAbility;
                    if (isPlayLand && game.getContinuousEffects().preventedByRuleModification(GameEvent.getEvent(GameEvent.EventType.PLAY_LAND, ability.getSourceId(), ability, this.getId()), ability, game, true)) continue;
                    GameEvent castEvent = GameEvent.getEvent(GameEvent.EventType.CAST_SPELL, ability.getId(), ability, this.getId());
                    castEvent.setZone(fromZone);
                    if (isPlaySpell && game.getContinuousEffects().preventedByRuleModification(castEvent, ability, game, true)) continue;
                    GameEvent castLateEvent = GameEvent.getEvent(GameEvent.EventType.CAST_SPELL_LATE, ability.getId(), ability, this.getId());
                    castLateEvent.setZone(fromZone);
                    if (isPlaySpell && game.getContinuousEffects().preventedByRuleModification(castLateEvent, ability, game, true) || (playAbility = this.findActivatedAbilityFromPlayable(card, availableMana, ability, game)) == null || playable.contains(playAbility)) continue;
                    playable.add(playAbility);
                }
            }
        }
        if (fromAll || fromZone == Zone.GRAVEYARD) {
            for (UUID playerId : game.getState().getPlayersInRange(this.getId(), game)) {
                player = game.getPlayer(playerId);
                if (player == null) continue;
                for (Card card : player.getGraveyard().getCards(game)) {
                    this.getPlayableFromObjectAll(game, Zone.GRAVEYARD, card, availableMana, playable);
                }
            }
        }
        if (fromAll || fromZone == Zone.EXILED) {
            for (ExileZone exile : game.getExile().getExileZones()) {
                for (Card card : exile.getCards(game)) {
                    this.getPlayableFromObjectAll(game, Zone.EXILED, card, availableMana, playable);
                }
            }
        }
        if (fromAll) {
            for (Cards revealedCards : game.getState().getRevealed().values()) {
                for (Card card : revealedCards.getCards(game)) {
                    this.getPlayableFromObjectAll(game, game.getState().getZone(card.getId()), card, availableMana, playable);
                }
            }
        }
        if (fromAll || fromZone == Zone.OUTSIDE) {
            for (Cards companionCards : game.getState().getCompanion().values()) {
                for (Card card : companionCards.getCards(game)) {
                    this.getPlayableFromObjectAll(game, Zone.OUTSIDE, card, availableMana, playable);
                }
            }
            for (UUID sideboardCardId : this.getSideboard()) {
                Card sideboardCard = game.getCard(sideboardCardId);
                if (sideboardCard == null) continue;
                this.getPlayableFromObjectAll(game, Zone.OUTSIDE, sideboardCard, availableMana, playable);
            }
        }
        if (fromAll || fromZone == Zone.LIBRARY) {
            for (UUID playerInRangeId : game.getState().getPlayersInRange(this.getId(), game)) {
                Card card;
                player = game.getPlayer(playerInRangeId);
                if (player == null || !player.getLibrary().hasCards() || (card = player.getLibrary().getFromTop(game)) == null) continue;
                this.getPlayableFromObjectAll(game, Zone.LIBRARY, card, availableMana, playable);
            }
        }
        if (fromAll || fromZone == Zone.HAND) {
            for (UUID playerInRangeId : game.getState().getPlayersInRange(this.getId(), game)) {
                player = game.getPlayer(playerInRangeId);
                if (player == null || player.getHand().isEmpty()) continue;
                for (Card card : player.getHand().getCards(game)) {
                    if (card == null) continue;
                    this.getPlayableFromObjectAll(game, Zone.HAND, card, availableMana, playable);
                }
            }
        }
        HashMap<String, ActivatedAbility> activatedUnique = new HashMap<String, ActivatedAbility>();
        ArrayList<ActivatedAbility> activatedAll = new ArrayList<ActivatedAbility>();
        if (fromAll || fromZone == Zone.BATTLEFIELD) {
            for (Permanent permanent : game.getBattlefield().getAllActivePermanents()) {
                boolean canUseActivated = permanent.canUseActivatedAbilities(game);
                ArrayList<ActivatedAbility> currentPlayable = new ArrayList<ActivatedAbility>();
                this.getPlayableFromObjectAll(game, Zone.BATTLEFIELD, permanent, availableMana, currentPlayable);
                for (ActivatedAbility ability : currentPlayable) {
                    if (!(ability instanceof SpecialAction) && !canUseActivated) continue;
                    activatedUnique.putIfAbsent(ability.toString(), ability);
                    activatedAll.add(ability);
                }
            }
        }
        if (fromAll || fromZone == Zone.STACK) {
            for (StackObject stackObject : game.getState().getStack()) {
                ArrayList<ActivatedAbility> currentPlayable = new ArrayList<ActivatedAbility>();
                this.getPlayableFromObjectAll(game, Zone.STACK, stackObject, availableMana, currentPlayable);
                for (ActivatedAbility ability : currentPlayable) {
                    activatedUnique.put(ability.toString(), ability);
                    activatedAll.add(ability);
                }
            }
        }
        if (fromAll || fromZone == Zone.COMMAND) {
            for (CommandObject commandObject : game.getState().getCommand()) {
                ArrayList<ActivatedAbility> currentPlayable = new ArrayList<ActivatedAbility>();
                this.getPlayableFromObjectAll(game, Zone.COMMAND, commandObject, availableMana, currentPlayable);
                for (ActivatedAbility ability : currentPlayable) {
                    activatedUnique.put(ability.toString(), ability);
                    activatedAll.add(ability);
                }
            }
        }
        if (hideDuplicatedAbilities) {
            playable.addAll(activatedUnique.values());
        } else {
            playable.addAll(activatedAll);
        }
        return playable.stream().map(ActivatedAbility::copy).collect(Collectors.toList());
    }

    @Override
    public PlayableObjectsList getPlayableObjects(Game game, Zone zone) {
        List<ActivatedAbility> playableAbilities = this.getPlayable(game, true, zone, false);
        HashMap<UUID, List<ActivatedAbility>> playableObjects = new HashMap<UUID, List<ActivatedAbility>>();
        for (ActivatedAbility ability : playableAbilities) {
            if (ability.getSourceId() != null) {
                Spell spell;
                this.putToPlayableObjects(playableObjects, ability.getSourceId(), ability);
                Card card = game.getCard(ability.getSourceId());
                if (card != null && card.getMainCard().getId() != card.getId()) {
                    this.putToPlayableObjects(playableObjects, card.getMainCard().getId(), ability);
                }
                if ((spell = game.getSpell(ability.getSourceId())) == null) continue;
                this.putToPlayableObjects(playableObjects, spell.getId(), ability);
                continue;
            }
            throw new IllegalStateException("Wrong code usage: ability without source id");
        }
        return new PlayableObjectsList(playableObjects);
    }

    private void putToPlayableObjects(Map<UUID, List<ActivatedAbility>> playableObjects, UUID objectId, ActivatedAbility ability) {
        if (!playableObjects.containsKey(objectId)) {
            playableObjects.put(objectId, new ArrayList());
        }
        playableObjects.get(objectId).add(ability);
    }

    private static boolean shouldSkipGettingPlayable(Game game) {
        if (game.getStep() == null) {
            return true;
        }
        for (Map.Entry<PhaseStep, Step.StepPart> phaseStep : SILENT_PHASES_STEPS.entrySet()) {
            if (game.getPhase() == null || game.getPhase().getStep() == null || phaseStep.getKey() != game.getPhase().getStep().getType() || phaseStep.getValue() != null && phaseStep.getValue() != game.getPhase().getStep().getStepPart()) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<Ability> getPlayableOptions(Ability ability, Game game) {
        ArrayList<Ability> options = new ArrayList<Ability>();
        if (ability.isModal()) {
            this.addModeOptions(options, ability, game);
        } else if (ability.getTargets().getNextUnchosen(game) != null) {
            if (!ability.getManaCosts().getVariableCosts().isEmpty()) {
                this.addVariableXOptions(options, ability, 0, game);
            } else {
                this.addTargetOptions(options, ability, 0, game);
            }
        } else if (ability.getCosts().getTargets().getNextUnchosen(game) != null) {
            this.addCostTargetOptions(options, ability, 0, game);
        }
        return options;
    }

    private void addModeOptions(List<Ability> options, Ability option, Game game) {
        for (Mode mode : option.getModes().values()) {
            Ability newOption = option.copy();
            newOption.getModes().clearSelectedModes();
            newOption.getModes().addSelectedMode(mode.getId());
            newOption.getModes().setActiveMode(mode);
            if (newOption.getTargets().getNextUnchosen(game) != null) {
                if (!newOption.getManaCosts().getVariableCosts().isEmpty()) {
                    this.addVariableXOptions(options, newOption, 0, game);
                    continue;
                }
                this.addTargetOptions(options, newOption, 0, game);
                continue;
            }
            if (newOption.getCosts().getTargets().getNextUnchosen(game) != null) {
                this.addCostTargetOptions(options, newOption, 0, game);
                continue;
            }
            options.add(newOption);
        }
    }

    protected void addVariableXOptions(List<Ability> options, Ability option, int targetNum, Game game) {
        this.addTargetOptions(options, option, targetNum, game);
    }

    protected void addTargetOptions(List<Ability> options, Ability option, int targetNum, Game game) {
        if (targetNum >= option.getTargets().size()) {
            return;
        }
        Target currentTarget = (Target)option.getTargets().get(targetNum);
        if (currentTarget.isChoiceSelected()) {
            return;
        }
        for (Target target : currentTarget.getTargetOptions(option, game)) {
            Ability newOption = option.copy();
            if (target instanceof TargetAmount) {
                for (UUID targetId : target.getTargets()) {
                    int amount = target.getTargetAmount(targetId);
                    ((Target)newOption.getTargets().get(targetNum)).addTarget(targetId, amount, newOption, game, true);
                }
            } else {
                for (UUID targetId : target.getTargets()) {
                    ((Target)newOption.getTargets().get(targetNum)).addTarget(targetId, newOption, game, true);
                }
            }
            ((Target)newOption.getTargets().get(targetNum)).setSkipChoice(target.isSkipChoice());
            if (targetNum + 1 < option.getTargets().size()) {
                this.addTargetOptions(options, newOption, targetNum + 1, game);
                continue;
            }
            if (!option.getCosts().getTargets().isEmpty()) {
                this.addCostTargetOptions(options, newOption, 0, game);
                continue;
            }
            options.add(newOption);
        }
    }

    private void addCostTargetOptions(List<Ability> options, Ability option, int targetNum, Game game) {
        for (UUID targetId : ((Target)option.getCosts().getTargets().get(targetNum)).possibleTargets(this.playerId, option, game)) {
            Ability newOption = option.copy();
            ((Target)newOption.getCosts().getTargets().get(targetNum)).addTarget(targetId, option, game, true);
            if (targetNum < option.getCosts().getTargets().size() - 1) {
                this.addCostTargetOptions(options, newOption, targetNum + 1, game);
                continue;
            }
            options.add(newOption);
        }
    }

    @Override
    public boolean isTestMode() {
        return this.isTestMode;
    }

    @Override
    public void setTestMode(boolean value) {
        this.isTestMode = value;
    }

    @Override
    public boolean isFastFailInTestMode() {
        return this.isFastFailInTestMode;
    }

    @Override
    public void setFastFailInTestMode(boolean value) {
        this.isFastFailInTestMode = value;
    }

    @Override
    public boolean isTopCardRevealed() {
        return this.topCardRevealed;
    }

    @Override
    public void setTopCardRevealed(boolean topCardRevealed) {
        this.topCardRevealed = topCardRevealed;
    }

    @Override
    public UserData getUserData() {
        return this.userData;
    }

    @Override
    public UserData getControllingPlayersUserData(Game game) {
        Player player;
        if (!this.isGameUnderControl() && (player = game.getPlayer(this.getTurnControlledBy())).isHuman()) {
            return player.getUserData();
        }
        return this.userData;
    }

    @Override
    public void setUserData(UserData userData) {
        this.userData = userData;
        this.getManaPool().setAutoPayment(userData.isManaPoolAutomatic());
        this.getManaPool().setAutoPaymentRestricted(userData.isManaPoolAutomaticRestricted());
    }

    @Override
    public void setAllowBadMoves(boolean allowBadMoves) {
    }

    @Override
    public boolean canPayLifeCost(Ability ability) {
        if (!this.isLifeTotalCanChange()) {
            return false;
        }
        boolean canPay = true;
        for (Player.PayLifeCostRestriction restriction : this.payLifeCostRestrictions) {
            switch (restriction) {
                case CAST_SPELLS: {
                    canPay &= ability.getAbilityType() != AbilityType.SPELL;
                    break;
                }
                case ACTIVATE_NON_MANA_ABILITIES: {
                    canPay &= !ability.isNonManaActivatedAbility();
                    break;
                }
                case ACTIVATE_MANA_ABILITIES: {
                    canPay &= !ability.isManaActivatedAbility();
                }
            }
        }
        return canPay;
    }

    @Override
    public EnumSet<Player.PayLifeCostRestriction> getPayLifeCostRestrictions() {
        return this.payLifeCostRestrictions;
    }

    @Override
    public void addPayLifeCostRestriction(Player.PayLifeCostRestriction payLifeCostRestriction) {
        this.payLifeCostRestrictions.add(payLifeCostRestriction);
    }

    @Override
    public boolean canPaySacrificeCost(Permanent permanent, Ability source, UUID controllerId, Game game) {
        if (!permanent.canBeSacrificed()) {
            return false;
        }
        String sourceIdString = source.getId().toString();
        return !game.replaceEvent(GameEvent.getEvent(GameEvent.EventType.PAY_SACRIFICE_COST, permanent.getId(), source, controllerId, sourceIdString, 1));
    }

    @Override
    public boolean canLoseByZeroOrLessLife() {
        return this.loseByZeroOrLessLife;
    }

    @Override
    public void setLoseByZeroOrLessLife(boolean loseByZeroOrLessLife) {
        this.loseByZeroOrLessLife = loseByZeroOrLessLife;
    }

    @Override
    public boolean canPlotFromTopOfLibrary() {
        return this.canPlotFromTopOfLibrary;
    }

    @Override
    public void setPlotFromTopOfLibrary(boolean canPlotFromTopOfLibrary) {
        this.canPlotFromTopOfLibrary = canPlotFromTopOfLibrary;
    }

    @Override
    public void setDrawsFromBottom(boolean drawsFromBottom) {
        this.drawsFromBottom = drawsFromBottom;
    }

    @Override
    public boolean isDrawsFromBottom() {
        return this.drawsFromBottom;
    }

    @Override
    public void setDrawsOnOpponentsTurn(boolean drawsOnOpponentsTurn) {
        this.drawsOnOpponentsTurn = drawsOnOpponentsTurn;
    }

    @Override
    public boolean isDrawsOnOpponentsTurn() {
        return this.drawsOnOpponentsTurn;
    }

    @Override
    public int getSpeed() {
        return this.speed;
    }

    @Override
    public void initSpeed(Game game) {
        if (this.speed > 0) {
            return;
        }
        this.speed = 1;
        game.getState().addDesignation(new Speed(), game, this.getId());
        game.informPlayers(this.getLogName() + "'s speed is now 1.");
    }

    @Override
    public void increaseSpeed(Game game) {
        if (this.speed < 4) {
            ++this.speed;
            game.informPlayers(this.getLogName() + "'s speed has increased to " + this.speed);
        }
    }

    @Override
    public void decreaseSpeed(Game game) {
        if (this.speed > 1) {
            --this.speed;
            game.informPlayers(this.getLogName() + "'s speed has decreased to " + this.speed);
        }
    }

    @Override
    public boolean autoLoseGame() {
        return false;
    }

    @Override
    public void becomesActivePlayer() {
        this.passedAllTurns = false;
        this.passedUntilEndStepBeforeMyTurn = false;
        ++this.turns;
    }

    @Override
    public int getTurns() {
        return this.turns;
    }

    @Override
    public int getStoredBookmark() {
        return this.storedBookmark;
    }

    @Override
    public void setStoredBookmark(int storedBookmark) {
        this.storedBookmark = storedBookmark;
    }

    @Override
    public synchronized void resetStoredBookmark(Game game) {
        if (this.storedBookmark != -1) {
            game.removeBookmark(this.storedBookmark);
        }
        this.setStoredBookmark(-1);
    }

    @Override
    public boolean lookAtFaceDownCard(Card card, Game game, int abilitiesToActivate) {
        String lookNo;
        String lookYes;
        String lookMessage;
        if (!game.getContinuousEffects().asThough(card.getId(), AsThoughEffectType.LOOK_AT_FACE_DOWN, null, this.getId(), game).isEmpty() && this.chooseUse(Outcome.Benefit, lookMessage = "Look at " + card.getIdName(), "", lookYes = "Yes, look at the card", lookNo = "No, play/activate the card/ability", null, game)) {
            CardsImpl cards = new CardsImpl(card);
            this.lookAtCards(this.getName() + " - " + card.getIdName() + " - " + CardUtil.sdf.format(System.currentTimeMillis()), cards, game);
            return true;
        }
        return false;
    }

    @Override
    public void setPriorityTimeLeft(int timeLeft) {
        this.priorityTimeLeft = timeLeft;
    }

    @Override
    public int getPriorityTimeLeft() {
        return this.priorityTimeLeft;
    }

    @Override
    public void setBufferTimeLeft(int timeLeft) {
        this.bufferTimeLeft = timeLeft;
    }

    @Override
    public int getBufferTimeLeft() {
        return this.bufferTimeLeft;
    }

    @Override
    public boolean hasQuit() {
        return this.quit;
    }

    @Override
    public boolean hasTimerTimeout() {
        return this.timerTimeout;
    }

    @Override
    public boolean hasIdleTimeout() {
        return this.idleTimeout;
    }

    @Override
    public void setReachedNextTurnAfterLeaving(boolean reachedNextTurnAfterLeaving) {
        this.reachedNextTurnAfterLeaving = reachedNextTurnAfterLeaving;
    }

    @Override
    public boolean hasReachedNextTurnAfterLeaving() {
        return this.reachedNextTurnAfterLeaving;
    }

    @Override
    public boolean canJoinTable(Table table) {
        return !table.userIsBanned(this.name);
    }

    @Override
    public void addCommanderId(UUID commanderId) {
        this.commandersIds.add(commanderId);
    }

    @Override
    public Set<UUID> getCommandersIds() {
        return this.commandersIds;
    }

    @Override
    public boolean moveCards(Card card, Zone toZone, Ability source, Game game) {
        return this.moveCards(card, toZone, source, game, false, false, false, null);
    }

    @Override
    public boolean moveCards(Card card, Zone toZone, Ability source, Game game, boolean tapped, boolean faceDown, boolean byOwner, List<UUID> appliedEffects) {
        HashSet<Card> cardList = new HashSet<Card>();
        if (card != null) {
            cardList.add(card);
        }
        return this.moveCards(cardList, toZone, source, game, tapped, faceDown, byOwner, appliedEffects);
    }

    @Override
    public boolean moveCards(Cards cards, Zone toZone, Ability source, Game game) {
        return this.moveCards(cards.getCards(game), toZone, source, game);
    }

    @Override
    public boolean moveCards(Set<? extends Card> cards, Zone toZone, Ability source, Game game) {
        return this.moveCards(cards, toZone, source, game, false, false, false, null);
    }

    @Override
    public boolean moveCards(Set<? extends Card> cards, Zone toZone, Ability source, Game game, boolean tapped, boolean faceDown, boolean byOwner, List<UUID> appliedEffects) {
        if (cards.isEmpty()) {
            return true;
        }
        Set<Object> successfulMovedCards = new LinkedHashSet();
        Zone fromZone = null;
        switch (toZone) {
            case GRAVEYARD: {
                fromZone = game.getState().getZone(cards.iterator().next().getId());
                successfulMovedCards = this.moveCardsToGraveyardWithInfo(cards, source, game, fromZone);
                return !successfulMovedCards.isEmpty();
            }
            case BATTLEFIELD: {
                List<ZoneChangeInfo> infoList = new ArrayList<ZoneChangeInfo>();
                for (Card card : cards) {
                    SpellAbility auraSpellAbility;
                    fromZone = game.getState().getZone(card.getId());
                    Boolean enterTransformed = (Boolean)game.getState().getValue("EnterTransformed" + card.getId());
                    if (enterTransformed != null && enterTransformed.booleanValue() && !card.isTransformable()) continue;
                    if (card.hasSubtype(SubType.AURA, game) && !(source instanceof BestowAbility) && (auraSpellAbility = source instanceof SpellAbility && card.getAbilities(game).contains(source) ? (SpellAbility)source : card.getSpellAbility()) != null) {
                        if (auraSpellAbility.getTargets().isEmpty()) {
                            throw new IllegalArgumentException("Something wrong, found etb aura with empty spell ability or without any targets: " + card + ", source: " + source);
                        }
                        if (!((Target)auraSpellAbility.getTargets().get(0)).copy().withNotTarget(true).canChooseOrAlreadyChosen(byOwner ? card.getOwnerId() : this.getId(), source, game)) continue;
                    }
                    ZoneChangeEvent event = new ZoneChangeEvent(card.getId(), source, byOwner ? card.getOwnerId() : this.getId(), fromZone, Zone.BATTLEFIELD, appliedEffects);
                    infoList.add(new ZoneChangeInfo.Battlefield(event, faceDown, tapped, source));
                }
                infoList = ZonesHandler.moveCards(infoList, source, game);
                for (ZoneChangeInfo zoneChangeInfo : infoList) {
                    Permanent permanent = game.getPermanent(zoneChangeInfo.event.getTargetId());
                    if (permanent == null) continue;
                    successfulMovedCards.add(permanent);
                    if (game.isSimulation()) continue;
                    Player eventPlayer = game.getPlayer(zoneChangeInfo.event.getPlayerId());
                    fromZone = zoneChangeInfo.event.getFromZone();
                    if (eventPlayer == null || fromZone == null) continue;
                    game.informPlayers(eventPlayer.getLogName() + " puts " + GameLog.getColoredObjectIdName(permanent) + " from " + fromZone.toString().toLowerCase(Locale.ENGLISH) + " onto the Battlefield" + CardUtil.getSourceLogName(game, source, permanent.getId()));
                }
                game.applyEffects();
                break;
            }
            case HAND: {
                for (Card card : cards) {
                    boolean hideCard;
                    if (!this.moveCardToHandWithInfo(card, source, game, !(hideCard = (fromZone = game.getState().getZone(card.getId())) == Zone.LIBRARY || card.isFaceDown(game) && fromZone != Zone.STACK && fromZone != Zone.BATTLEFIELD))) continue;
                    successfulMovedCards.add(card);
                }
                break;
            }
            case EXILED: {
                for (Card card : cards) {
                    boolean withName;
                    if (!this.moveCardToExileWithInfo(card, null, "", source, game, fromZone, withName = (fromZone = game.getState().getZone(card.getId())) == Zone.BATTLEFIELD || fromZone == Zone.STACK || !card.isFaceDown(game))) continue;
                    successfulMovedCards.add(card);
                }
                break;
            }
            case LIBRARY: {
                Iterator<? extends Card> iterator = cards.iterator();
                while (iterator.hasNext()) {
                    boolean hideCard;
                    Card card;
                    fromZone = (card = iterator.next()) instanceof Spell ? game.getState().getZone(((Spell)card).getSourceId()) : game.getState().getZone(card.getId());
                    if (!this.moveCardToLibraryWithInfo(card, source, game, fromZone, true, !(hideCard = fromZone == Zone.HAND || fromZone == Zone.LIBRARY))) continue;
                    successfulMovedCards.add(card);
                }
                break;
            }
            case COMMAND: {
                for (Card card : cards) {
                    if (!this.moveCardToCommandWithInfo(card, source, game, fromZone = game.getState().getZone(card.getId()))) continue;
                    successfulMovedCards.add(card);
                }
                break;
            }
            case OUTSIDE: {
                for (Card card : cards) {
                    if (!(card instanceof Permanent)) continue;
                    game.getBattlefield().removePermanent(card.getId());
                    ZoneChangeEvent event = new ZoneChangeEvent((Permanent)card, source, byOwner ? card.getOwnerId() : this.getId(), Zone.BATTLEFIELD, Zone.OUTSIDE, appliedEffects);
                    game.fireEvent(event);
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException("to Zone" + (Object)((Object)toZone) + " not supported yet");
            }
        }
        return !successfulMovedCards.isEmpty();
    }

    @Override
    public boolean moveCardsToExile(Card card, Ability source, Game game, boolean withName, UUID exileId, String exileZoneName) {
        HashSet<Card> cards = new HashSet<Card>();
        if (card != null) {
            cards.add(card);
        }
        return this.moveCardsToExile(cards, source, game, withName, exileId, exileZoneName);
    }

    @Override
    public boolean moveCardsToExile(Set<Card> cards, Ability source, Game game, boolean withName, UUID exileId, String exileZoneName) {
        if (cards.isEmpty()) {
            return true;
        }
        boolean result = false;
        for (Card card : cards) {
            Zone fromZone = game.getState().getZone(card.getId());
            result |= this.moveCardToExileWithInfo(card, exileId, exileZoneName, source, game, fromZone, withName);
        }
        return result;
    }

    @Override
    public boolean moveCardsToHandWithInfo(Cards cards, Ability source, Game game, boolean withName) {
        PlayerImpl player = this;
        for (Card card : cards.getCards(game)) {
            player.moveCardToHandWithInfo(card, source, game, withName);
        }
        return true;
    }

    @Override
    public boolean moveCardToHandWithInfo(Card card, Ability source, Game game, boolean withName) {
        boolean result = false;
        Zone fromZone = game.getState().getZone(card.getId());
        if (fromZone == Zone.BATTLEFIELD && !(card instanceof Permanent)) {
            card = game.getPermanent(card.getId());
        }
        if (card.moveToZone(Zone.HAND, source, game, false)) {
            if (card instanceof PermanentCard && game.getCard(card.getId()) != null) {
                card = game.getCard(card.getId());
            }
            if (!game.isSimulation()) {
                game.informPlayers(this.getLogName() + " puts " + (withName ? card.getLogName() : (card.isFaceDown(game) ? "a face down card" : "a card")) + " from " + fromZone.toString().toLowerCase(Locale.ENGLISH) + ' ' + (card.isOwnedBy(this.getId()) ? "into their hand" : "into its owner's hand" + CardUtil.getSourceLogName(game, source, card.getId())));
            }
            result = true;
        }
        return result;
    }

    @Override
    public Set<Card> moveCardsToGraveyardWithInfo(Set<? extends Card> allCards, Ability source, Game game, Zone fromZone) {
        LinkedHashSet<Card> movedCards = new LinkedHashSet<Card>();
        while (!allCards.isEmpty()) {
            CardsImpl cards = new CardsImpl();
            UUID ownerId = null;
            Iterator<? extends Card> it = allCards.iterator();
            while (it.hasNext()) {
                Card card = it.next();
                if (cards.isEmpty()) {
                    ownerId = card.getOwnerId();
                }
                if (!card.isOwnedBy(ownerId)) continue;
                it.remove();
                cards.add(card);
            }
            if (cards.isEmpty()) continue;
            Player choosingPlayer = this;
            if (!Objects.equals(ownerId, this.getId())) {
                choosingPlayer = game.getPlayer(ownerId);
            }
            if (choosingPlayer == null) continue;
            boolean chooseOrder = false;
            if (this.userData.askMoveToGraveOrder() && cards.size() > 1) {
                chooseOrder = choosingPlayer.chooseUse(Outcome.Neutral, "Choose the order in which the cards go to the graveyard?", source, game);
            }
            if (chooseOrder) {
                Card card;
                TargetCard target = new TargetCard(fromZone, new FilterCard("card to put on the top of your graveyard (last one chosen will be topmost)"));
                target.setRequired(true);
                while (choosingPlayer.canRespond() && cards.size() > 1) {
                    choosingPlayer.chooseTarget(Outcome.Neutral, cards, target, source, game);
                    UUID targetObjectId = target.getFirstTarget();
                    Card card2 = cards.get(targetObjectId, game);
                    cards.remove(targetObjectId);
                    if (card2 != null && choosingPlayer.moveCardToGraveyardWithInfo(card2, source, game, fromZone = game.getState().getZone(card2.getId()))) {
                        movedCards.add(card2);
                    }
                    target.clearChosen();
                }
                if (cards.size() != 1 || (card = cards.getCards(game).iterator().next()) == null || !choosingPlayer.moveCardToGraveyardWithInfo(card, source, game, fromZone)) continue;
                movedCards.add(card);
                continue;
            }
            for (Card card : cards.getCards(game)) {
                if (!choosingPlayer.moveCardToGraveyardWithInfo(card, source, game, fromZone)) continue;
                movedCards.add(card);
            }
        }
        return movedCards;
    }

    @Override
    public boolean moveCardToGraveyardWithInfo(Card card, Ability source, Game game, Zone fromZone) {
        if (card == null) {
            return false;
        }
        boolean result = false;
        if (card.moveToZone(Zone.GRAVEYARD, source, game, false)) {
            if (!game.isSimulation()) {
                if (card instanceof PermanentCard && game.getCard(card.getId()) != null) {
                    card = game.getCard(card.getId());
                }
                StringBuilder sb = new StringBuilder(this.getLogName()).append(" puts ").append(card.getLogName()).append(' ').append(card.isCopy() ? "(Copy) " : "").append(fromZone != null ? "from " + fromZone.toString().toLowerCase(Locale.ENGLISH) + ' ' : "");
                if (card.isOwnedBy(this.getId())) {
                    sb.append("into their graveyard");
                } else {
                    sb.append("it into its owner's graveyard");
                }
                sb.append(CardUtil.getSourceLogName(game, source, card.getId()));
                game.informPlayers(sb.toString());
            }
            result = true;
        }
        return result;
    }

    @Override
    public boolean moveCardToLibraryWithInfo(Card card, Ability source, Game game, Zone fromZone, boolean toTop, boolean withName) {
        if (card == null) {
            return false;
        }
        boolean result = false;
        if (card.moveToZone(Zone.LIBRARY, source, game, toTop)) {
            if (!game.isSimulation()) {
                if (card instanceof PermanentCard && game.getCard(card.getId()) != null) {
                    card = game.getCard(card.getId());
                }
                StringBuilder sb = new StringBuilder(this.getLogName()).append(" puts ").append(withName ? card.getLogName() : "a card").append(' ');
                if (fromZone != null) {
                    sb.append("from ").append(fromZone.toString().toLowerCase(Locale.ENGLISH)).append(' ');
                }
                sb.append("to the ").append(toTop ? "top" : "bottom");
                if (card.isOwnedBy(this.getId())) {
                    sb.append(" of their library");
                } else {
                    Player player = game.getPlayer(card.getOwnerId());
                    if (player != null) {
                        sb.append(" of ").append(player.getLogName()).append("'s library");
                    }
                }
                sb.append(CardUtil.getSourceLogName(game, source, card.getId()));
                game.informPlayers(sb.toString());
            }
            result = true;
        }
        return result;
    }

    @Override
    public boolean moveCardToCommandWithInfo(Card card, Ability source, Game game, Zone fromZone) {
        if (card == null) {
            return false;
        }
        boolean result = false;
        if (card.moveToZone(Zone.COMMAND, source, game, true)) {
            if (!game.isSimulation()) {
                if (card instanceof PermanentCard && game.getCard(card.getId()) != null) {
                    card = game.getCard(card.getId());
                }
                StringBuilder sb = new StringBuilder(this.getLogName()).append(" puts ").append(card.getLogName()).append(' ');
                if (fromZone != null) {
                    sb.append("from ").append(fromZone.toString().toLowerCase(Locale.ENGLISH)).append(' ');
                }
                if (card.isOwnedBy(this.getId())) {
                    sb.append(" to their command zone");
                } else {
                    Player player = game.getPlayer(card.getOwnerId());
                    if (player != null) {
                        sb.append(" to ").append(player.getLogName()).append("'s command zone");
                    }
                }
                sb.append(CardUtil.getSourceLogName(game, source, card.getId()));
                game.informPlayers(sb.toString());
            }
            result = true;
        }
        return result;
    }

    @Override
    public boolean moveCardToExileWithInfo(Card card, UUID exileId, String exileName, Ability source, Game game, Zone fromZone, boolean withName) {
        if (card == null) {
            return false;
        }
        boolean result = false;
        if (card.moveToExile(exileId, exileName, source, game)) {
            if (!game.isSimulation()) {
                Spell spell;
                if (card instanceof PermanentCard) {
                    Card basicCard = game.getCard(card.getId());
                    if (basicCard != null) {
                        card = basicCard;
                    }
                } else if (card instanceof Spell && (spell = (Spell)card).isCopy()) {
                    game.getStack().remove(spell, game);
                }
                if (Zone.EXILED.equals((Object)game.getState().getZone(card.getId()))) {
                    String visibleName;
                    if (withName) {
                        if (card.getName().isEmpty()) {
                            throw new IllegalStateException("Wrong code usage: method must find real card name, but found nothing", new Throwable());
                        }
                        visibleName = card.getLogName() + (card.isCopy() ? " (Copy)" : "");
                    } else {
                        visibleName = "a " + GameLog.getNeutralObjectIdName(EmptyNames.FACE_DOWN_CARD.getObjectName(), card.getId());
                    }
                    game.informPlayers(this.getLogName() + " moves " + visibleName + (fromZone != null ? " from " + fromZone.toString().toLowerCase(Locale.ENGLISH) : "") + " to the exile zone" + CardUtil.getSourceLogName(game, source, card.getId()));
                }
            }
            result = true;
        }
        return result;
    }

    @Override
    public Cards millCards(int toMill, Ability source, Game game) {
        GameEvent event = GameEvent.getEvent(GameEvent.EventType.MILL_CARDS, this.getId(), source, this.getId(), toMill);
        if (game.replaceEvent(event)) {
            return new CardsImpl();
        }
        CardsImpl cards = new CardsImpl(this.getLibrary().getTopCards(game, event.getAmount()));
        this.moveCards(cards, Zone.GRAVEYARD, source, game);
        for (Card card : cards.getCards(game)) {
            MilledCardEvent milledEvent = new MilledCardEvent(card, this.getId(), source);
            game.fireEvent(milledEvent);
            game.getState().addSimultaneousMilledCardToBatch(milledEvent, game);
        }
        return cards;
    }

    @Override
    public boolean hasOpponent(UUID playerToCheckId, Game game) {
        return !this.getId().equals(playerToCheckId) && game.isOpponent(this, playerToCheckId) && this.hasPlayerInRange(playerToCheckId);
    }

    @Override
    public void cleanUpOnMatchEnd() {
    }

    @Override
    public boolean getPassedAllTurns() {
        return this.passedAllTurns;
    }

    @Override
    public boolean getPassedUntilNextMain() {
        return this.passedUntilNextMain;
    }

    @Override
    public boolean getPassedUntilEndOfTurn() {
        return this.passedUntilEndOfTurn;
    }

    @Override
    public boolean getPassedTurn() {
        return this.passedTurn;
    }

    @Override
    public boolean getPassedUntilStackResolved() {
        return this.passedUntilStackResolved;
    }

    @Override
    public boolean getPassedUntilEndStepBeforeMyTurn() {
        return this.passedUntilEndStepBeforeMyTurn;
    }

    @Override
    public AbilityType getJustActivatedType() {
        return this.justActivatedType;
    }

    @Override
    public void setJustActivatedType(AbilityType justActivatedType) {
        this.justActivatedType = justActivatedType;
    }

    @Override
    public void revokePermissionToSeeHandCards() {
        this.usersAllowedToSeeHandCards.clear();
    }

    @Override
    public void addPermissionToShowHandCards(UUID watcherUserId) {
        this.usersAllowedToSeeHandCards.add(watcherUserId);
    }

    @Override
    public boolean isPlayerAllowedToRequestHand(UUID gameId, UUID requesterPlayerId) {
        return this.userData.isAllowRequestHandToPlayer(gameId, requesterPlayerId);
    }

    @Override
    public void addPlayerToRequestedHandList(UUID gameId, UUID requesterPlayerId) {
        this.userData.addPlayerToRequestedHandList(gameId, requesterPlayerId);
    }

    @Override
    public boolean hasUserPermissionToSeeHand(UUID userId) {
        return this.usersAllowedToSeeHandCards.contains(userId);
    }

    @Override
    public Set<UUID> getUsersAllowedToSeeHandCards() {
        return this.usersAllowedToSeeHandCards;
    }

    @Override
    public void setMatchPlayer(MatchPlayer matchPlayer) {
        this.matchPlayer = matchPlayer;
    }

    @Override
    public MatchPlayer getMatchPlayer() {
        return this.matchPlayer;
    }

    @Override
    public void abortReset() {
        this.abort = false;
    }

    @Override
    public void signalPlayerConcede(boolean stopCurrentChooseDialog) {
    }

    @Override
    public void signalPlayerCheat() {
    }

    @Override
    public boolean scry(int value, Ability source, Game game) {
        GameEvent event = new GameEvent(GameEvent.EventType.SCRY, this.getId(), source, this.getId(), value, true);
        if (game.replaceEvent(event)) {
            return false;
        }
        game.informPlayers(this.getLogName() + " scries " + event.getAmount() + CardUtil.getSourceLogName(game, source));
        CardsImpl cards = new CardsImpl();
        cards.addAllCards(this.getLibrary().getTopCards(game, event.getAmount()));
        if (!cards.isEmpty()) {
            TargetCard target = new TargetCard(0, cards.size(), Zone.LIBRARY, new FilterCard("card" + (cards.size() == 1 ? "" : "s") + " to PUT on the BOTTOM of your library (Scry)"));
            this.chooseTarget(Outcome.Benefit, cards, target, source, game);
            this.putCardsOnBottomOfLibrary(new CardsImpl((Collection<UUID>)target.getTargets()), game, source, true);
            if (!target.getTargets().isEmpty()) {
                game.fireEvent(GameEvent.getEvent(GameEvent.EventType.SCRY_TO_BOTTOM, this.getId(), source, this.getId(), target.getTargets().size()));
            }
            cards.removeIf(target.getTargets()::contains);
            this.putCardsOnTopOfLibrary(cards, game, source, true);
        }
        game.fireEvent(new GameEvent(GameEvent.EventType.SCRIED, this.getId(), source, this.getId(), event.getAmount(), true));
        return true;
    }

    @Override
    public Player.SurveilResult doSurveil(int value, Ability source, Game game) {
        GameEvent event = new GameEvent(GameEvent.EventType.SURVEIL, this.getId(), source, this.getId(), value, true);
        if (game.replaceEvent(event) || event.getAmount() < 1) {
            return Player.SurveilResult.noSurveil();
        }
        game.informPlayers(this.getLogName() + " surveils " + event.getAmount() + CardUtil.getSourceLogName(game, source));
        CardsImpl cards = new CardsImpl();
        cards.addAllCards(this.getLibrary().getTopCards(game, event.getAmount()));
        int totalCount = cards.size();
        if (!cards.isEmpty()) {
            TargetCard target = new TargetCard(0, cards.size(), Zone.LIBRARY, new FilterCard("card" + (cards.size() == 1 ? "" : "s") + " to PUT into your GRAVEYARD (Surveil)"));
            this.chooseTarget(Outcome.Benefit, cards, target, source, game);
            this.moveCards(new CardsImpl((Collection<UUID>)target.getTargets()), Zone.GRAVEYARD, source, game);
            cards.removeIf(target.getTargets()::contains);
            this.putCardsOnTopOfLibrary(cards, game, source, true);
        }
        game.fireEvent(new GameEvent(GameEvent.EventType.SURVEILED, this.getId(), source, this.getId(), event.getAmount(), true));
        return Player.SurveilResult.surveil(totalCount - cards.size(), cards.size());
    }

    @Override
    public boolean addTargets(Ability ability, Game game) {
        return true;
    }

    @Override
    public boolean hasDesignation(DesignationType designationName) {
        for (Designation designation : this.designations) {
            if (!designation.getDesignationType().equals((Object)designationName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addDesignation(Designation designation) {
        if (!designation.isUnique() || !this.hasDesignation(designation.getDesignationType())) {
            this.designations.add(designation);
        }
    }

    @Override
    public List<Designation> getDesignations() {
        return this.designations;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Player obj = (Player)o;
        if (this.getId() == null || obj.getId() == null) {
            return false;
        }
        return this.getId().equals(obj.getId());
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + Objects.hashCode(this.playerId);
        return hash;
    }

    @Override
    public void addPhyrexianToColors(FilterMana colors) {
        if (this.phyrexianColors == null) {
            this.phyrexianColors = colors.copy();
        } else {
            if (colors.isWhite()) {
                this.phyrexianColors.setWhite(true);
            }
            if (colors.isBlue()) {
                this.phyrexianColors.setBlue(true);
            }
            if (colors.isBlack()) {
                this.phyrexianColors.setBlack(true);
            }
            if (colors.isRed()) {
                this.phyrexianColors.setRed(true);
            }
            if (colors.isGreen()) {
                this.phyrexianColors.setGreen(true);
            }
        }
    }

    @Override
    public FilterMana getPhyrexianColors() {
        return this.phyrexianColors;
    }

    @Override
    public Permanent getRingBearer(Game game) {
        return game.getBattlefield().getActivePermanents(StaticFilters.FILTER_CONTROLLED_RINGBEARER, this.getId(), null, game).stream().filter(Objects::nonNull).findFirst().orElse(null);
    }

    @Override
    public void chooseRingBearer(Game game) {
        UUID newBearerId;
        Permanent currentBearer = this.getRingBearer(game);
        UUID currentBearerId = currentBearer == null ? null : currentBearer.getId();
        List ids = game.getBattlefield().getActivePermanents(StaticFilters.FILTER_CONTROLLED_CREATURE, this.getId(), null, game).stream().filter(Objects::nonNull).map(p -> p.getId()).collect(Collectors.toList());
        if (ids.isEmpty()) {
            game.informPlayers(this.getLogName() + " has no creature to be Ring-bearer.");
            return;
        }
        if (ids.size() == 1) {
            newBearerId = (UUID)ids.get(0);
        } else {
            boolean mustChoose;
            boolean choosing = mustChoose = currentBearer == null || !currentBearer.isCreature(game);
            if (!mustChoose) {
                choosing = this.chooseUse(Outcome.Neutral, "Choose a new Ring-bearer?", null, game);
            }
            if (choosing) {
                TargetControlledCreaturePermanent target = new TargetControlledCreaturePermanent();
                target.withNotTarget(true);
                target.withChooseHint("to be your Ring-bearer");
                target.choose(Outcome.Neutral, this.getId(), null, null, game);
                newBearerId = target.getFirstTarget();
            } else {
                newBearerId = currentBearerId;
            }
        }
        if (currentBearerId != null && currentBearerId == newBearerId) {
            game.informPlayers(this.getLogName() + " did not choose a new Ring-bearer. It is still " + (currentBearer == null ? "" : currentBearer.getLogName()) + ".");
            game.fireEvent(GameEvent.getEvent(GameEvent.EventType.RING_BEARER_CHOSEN, currentBearerId, null, this.getId()));
        } else {
            Permanent ringBearer = game.getPermanent(newBearerId);
            if (ringBearer != null) {
                ringBearer.setRingBearer(game, true);
                game.informPlayers(this.getLogName() + " has chosen " + ringBearer.getLogName() + " as Ring-bearer.");
                game.fireEvent(GameEvent.getEvent(GameEvent.EventType.RING_BEARER_CHOSEN, newBearerId, null, this.getId()));
            }
        }
    }

    @Override
    public ActivatedAbility chooseLandOrSpellAbility(Card card, Game game, boolean noMana) {
        return card.getSpellAbility();
    }

    @Override
    public SpellAbility chooseAbilityForCast(Card card, Game game, boolean noMana) {
        return card.getSpellAbility();
    }

    public String toString() {
        return this.getName() + " (" + super.getClass().getSimpleName() + ")";
    }

    @Override
    public Player getRealPlayer() {
        return this;
    }

    private static final class RollDieResult {
        private final int naturalResult;
        private final int modifier;
        private final PlanarDieRollResult planarResult;

        RollDieResult(int naturalResult, int modifier, PlanarDieRollResult planarResult) {
            this.naturalResult = naturalResult;
            this.modifier = modifier;
            this.planarResult = planarResult;
        }

        public int getResult() {
            return this.naturalResult + this.modifier;
        }

        public PlanarDieRollResult getPlanarResult() {
            return this.planarResult;
        }
    }

    private static class ApprovingObjectResult {
        public final ApprovingObjectResultStatus status;
        public final ApprovingObject approvingObject;

        private ApprovingObjectResult(ApprovingObjectResultStatus status, ApprovingObject approvingObject) {
            this.status = status;
            this.approvingObject = approvingObject;
        }
    }

    private static enum ApprovingObjectResultStatus {
        CHOSEN,
        NO_POSSIBLE_CHOICE,
        NOT_REQUIRED_NO_CHOICE;

    }
}

