/*
 * Decompiled with CFR 0.152.
 */
package mage.target;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.StaticValue;
import mage.cards.Cards;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetImpl;
import mage.target.TargetOptimization;
import mage.util.CardUtil;

public abstract class TargetAmount
extends TargetImpl {
    boolean amountWasSet = false;
    DynamicValue amount;
    int remainingAmount;

    protected TargetAmount(DynamicValue amount, int minNumberOfTargets, int maxNumberOfTargets) {
        this.amount = amount;
        this.setMinNumberOfTargets(minNumberOfTargets);
        this.setMaxNumberOfTargets(maxNumberOfTargets);
    }

    protected TargetAmount(TargetAmount target) {
        super(target);
        this.amount = target.amount;
        this.remainingAmount = target.remainingAmount;
        this.amountWasSet = target.amountWasSet;
    }

    @Override
    public abstract TargetAmount copy();

    public int getAmountRemaining() {
        return this.remainingAmount;
    }

    @Override
    public boolean isChosen(Game game) {
        if (!super.isChosen(game)) {
            return false;
        }
        if (!this.amountWasSet) {
            return false;
        }
        if (this.getMinNumberOfTargets() == 0 && this.targets.isEmpty()) {
            return true;
        }
        return this.remainingAmount == 0;
    }

    @Override
    public boolean isChoiceCompleted(UUID abilityControllerId, Ability source, Game game, Cards fromCards) {
        if (!this.isChoiceSelected()) {
            return false;
        }
        if (!this.isChosen(game)) {
            return false;
        }
        if (this.getSize() >= this.getMaxNumberOfTargets()) {
            return true;
        }
        return true;
    }

    @Override
    public void clearChosen() {
        super.clearChosen();
        this.amountWasSet = false;
    }

    public void setAmountDefinition(DynamicValue amount) {
        this.amount = amount;
    }

    public void prepareAmount(Ability source, Game game) {
        if (!this.amountWasSet) {
            this.remainingAmount = this.amount.calculate(game, source, null);
            this.amountWasSet = true;
        }
    }

    public DynamicValue getAmount() {
        return this.amount;
    }

    public int getAmountTotal(Game game, Ability source) {
        return this.amount.calculate(game, source, null);
    }

    @Override
    public void addTarget(UUID id, int amount, Ability source, Game game, boolean skipEvent) {
        this.prepareAmount(source, game);
        if (amount <= this.remainingAmount) {
            this.remainingAmount -= amount;
            super.addTarget(id, amount, source, game, skipEvent);
        }
    }

    @Override
    public void remove(UUID id) {
        int usedAmount = this.getTargetAmount(id);
        super.remove(id);
        this.remainingAmount += usedAmount;
    }

    @Override
    public boolean choose(Outcome outcome, UUID playerId, UUID sourceId, Ability source, Game game) {
        throw new IllegalArgumentException("Wrong code usage. TargetAmount must be called by player.chooseTarget, not player.choose");
    }

    @Override
    @Deprecated
    public boolean chooseTarget(Outcome outcome, UUID playerId, Ability source, Game game) {
        int prevTargetsCount;
        Player targetController = this.getTargetController(game, playerId);
        if (targetController == null) {
            return false;
        }
        this.prepareAmount(source, game);
        this.chosen = false;
        do {
            prevTargetsCount = this.getTargets().size();
            if (!targetController.canRespond()) break;
            if (this.isRandom()) {
                throw new IllegalArgumentException("Wrong code usage. TargetAmount do not support random choices");
            }
            if (!targetController.chooseTargetAmount(outcome, this, source, game)) break;
            this.chosen = this.isChosen(game);
        } while (!this.isChoiceCompleted(targetController.getId(), source, game, null) && prevTargetsCount != this.getTargets().size());
        this.chosen = this.isChosen(game);
        return this.chosen && !this.getTargets().isEmpty();
    }

    public final List<? extends TargetAmount> getTargetOptions(Ability source, Game game) {
        this.prepareAmount(source, game);
        ArrayList<TargetAmount> options = new ArrayList<TargetAmount>();
        Set<UUID> possibleTargets = this.possibleTargets(source.getControllerId(), source, game);
        TargetOptimization.printTargetsVariationsForTargetAmount("target amount - before optimize", game, possibleTargets, options, false);
        int maxPossibleTargetsToSimulate = CardUtil.overflowMultiply(this.remainingAmount, 2);
        TargetOptimization.optimizePossibleTargets(source, game, possibleTargets, maxPossibleTargetsToSimulate);
        TargetOptimization.printTargetsVariationsForTargetAmount("target amount - after optimize", game, possibleTargets, options, false);
        this.addTargets(this, possibleTargets, options, source, game);
        TargetOptimization.printTargetsVariationsForTargetAmount("target amount - after calc", game, possibleTargets, options, true);
        return options;
    }

    protected final void addTargets(TargetAmount target, Set<UUID> possibleTargets, List<TargetAmount> options, Ability source, Game game) {
        HashSet<UUID> usedTargets = new HashSet<UUID>();
        for (UUID targetId : possibleTargets) {
            usedTargets.add(targetId);
            for (int n = 1; n <= target.remainingAmount; ++n) {
                TargetAmount t = target.copy();
                t.addTarget(targetId, n, source, game, true);
                if (t.remainingAmount > 0) {
                    if (possibleTargets.size() <= 1) continue;
                    Set<UUID> newPossibleTargets = possibleTargets.stream().filter(newTarget -> !usedTargets.contains(newTarget)).collect(Collectors.toSet());
                    this.addTargets(t, newPossibleTargets, options, source, game);
                    continue;
                }
                options.add(t);
            }
        }
    }

    public void setTargetAmount(UUID targetId, int amount, Ability source, Game game) {
        this.prepareAmount(source, game);
        this.remainingAmount -= amount - this.getTargetAmount(targetId);
        this.setTargetAmount(targetId, amount, game);
    }

    @Override
    protected boolean getUseAnyNumber() {
        int min = this.getMinNumberOfTargets();
        int max = this.getMaxNumberOfTargets();
        if (min != 0) {
            return false;
        }
        if (max == Integer.MAX_VALUE) {
            return true;
        }
        return this.amount instanceof StaticValue && max == ((StaticValue)this.amount).getValue();
    }

    @Override
    public String toString() {
        if (this.amountWasSet) {
            return super.toString() + String.format(" (remain amount %d of %s)", this.remainingAmount, this.amount.toString());
        }
        return super.toString() + String.format(" (remain not prepared, %s)", this.amount.toString());
    }
}

