/*
 * Decompiled with CFR 0.152.
 */
package mage.target;

import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.cards.Card;
import mage.cards.Cards;
import mage.constants.CommanderCardType;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.game.events.TargetEvent;
import mage.players.Player;
import mage.target.TargetObject;

public class TargetCard
extends TargetObject {
    protected final FilterCard filter;

    protected TargetCard(Zone zone) {
        this(1, 1, zone, new FilterCard());
    }

    public TargetCard(Zone zone, FilterCard filter) {
        this(1, 1, zone, filter);
    }

    public TargetCard(int numTargets, Zone zone, FilterCard filter) {
        this(numTargets, numTargets, zone, filter);
    }

    public TargetCard(int minNumTargets, int maxNumTargets, Zone zone, FilterCard filter) {
        super(minNumTargets, maxNumTargets, zone, false);
        this.filter = filter;
        this.targetName = filter.getMessage();
    }

    protected TargetCard(TargetCard target) {
        super(target);
        this.filter = target.filter.copy();
    }

    @Override
    public FilterCard getFilter() {
        return this.filter;
    }

    @Override
    public TargetCard withNotTarget(boolean notTarget) {
        super.withNotTarget(notTarget);
        return this;
    }

    @Override
    public boolean canChoose(UUID sourceControllerId, Ability source, Game game) {
        return this.canChooseFromPossibleTargets(sourceControllerId, source, game);
    }

    @Override
    public Set<UUID> possibleTargets(UUID sourceControllerId, Ability source, Game game) {
        HashSet<UUID> possibleTargets = new HashSet<UUID>();
        block8: for (UUID playerId : game.getState().getPlayersInRange(sourceControllerId, game)) {
            Player player = game.getPlayer(playerId);
            if (player == null) continue;
            switch (this.zone) {
                case HAND: {
                    possibleTargets.addAll(TargetCard.getAllPossibleTargetInHand(game, player, sourceControllerId, source, this.filter, this.isNotTarget()));
                    continue block8;
                }
                case GRAVEYARD: {
                    possibleTargets.addAll(TargetCard.getAllPossibleTargetInGraveyard(game, player, sourceControllerId, source, this.filter, this.isNotTarget()));
                    continue block8;
                }
                case LIBRARY: {
                    possibleTargets.addAll(TargetCard.getAllPossibleTargetInLibrary(game, player, sourceControllerId, source, this.filter, this.isNotTarget()));
                    continue block8;
                }
                case EXILED: {
                    possibleTargets.addAll(TargetCard.getAllPossibleTargetInExile(game, player, sourceControllerId, source, this.filter, this.isNotTarget()));
                    continue block8;
                }
                case COMMAND: {
                    possibleTargets.addAll(TargetCard.getAllPossibleTargetInCommandZone(game, player, sourceControllerId, source, this.filter, this.isNotTarget()));
                    continue block8;
                }
                case ALL: {
                    possibleTargets.addAll(TargetCard.getAllPossibleTargetInAnyZone(game, player, sourceControllerId, source, this.filter, this.isNotTarget()));
                    continue block8;
                }
            }
            throw new IllegalArgumentException("Unsupported TargetCard zone: " + (Object)((Object)this.zone));
        }
        return this.keepValidPossibleTargets(possibleTargets, sourceControllerId, source, game);
    }

    protected static Set<UUID> getAllPossibleTargetInHand(Game game, Player player, UUID sourceControllerId, Ability source, FilterCard filter, boolean isNotTarget) {
        HashSet<UUID> possibleTargets = new HashSet<UUID>();
        for (Card card : player.getHand().getCards(filter, sourceControllerId, source, game)) {
            possibleTargets.add(card.getId());
        }
        return possibleTargets;
    }

    protected static Set<UUID> getAllPossibleTargetInGraveyard(Game game, Player player, UUID sourceControllerId, Ability source, FilterCard filter, boolean isNotTarget) {
        HashSet<UUID> possibleTargets = new HashSet<UUID>();
        for (Card card : player.getGraveyard().getCards(filter, sourceControllerId, source, game)) {
            possibleTargets.add(card.getId());
        }
        return possibleTargets;
    }

    protected static Set<UUID> getAllPossibleTargetInLibrary(Game game, Player player, UUID sourceControllerId, Ability source, FilterCard filter, boolean isNotTarget) {
        HashSet<UUID> possibleTargets = new HashSet<UUID>();
        for (Card card : player.getLibrary().getUniqueCards(game)) {
            if (!filter.match(card, sourceControllerId, source, game)) continue;
            possibleTargets.add(card.getId());
        }
        return possibleTargets;
    }

    protected static Set<UUID> getAllPossibleTargetInExile(Game game, Player player, UUID sourceControllerId, Ability source, FilterCard filter, boolean isNotTarget) {
        HashSet<UUID> possibleTargets = new HashSet<UUID>();
        UUID sourceId = source != null ? source.getSourceId() : null;
        for (Card card : game.getExile().getCardsInRange(game, sourceControllerId)) {
            if (!filter.match(card, sourceControllerId, source, game)) continue;
            possibleTargets.add(card.getId());
        }
        return possibleTargets;
    }

    protected static Set<UUID> getAllPossibleTargetInCommandZone(Game game, Player player, UUID sourceControllerId, Ability source, FilterCard filter, boolean isNotTarget) {
        HashSet<UUID> possibleTargets = new HashSet<UUID>();
        UUID sourceId = source != null ? source.getSourceId() : null;
        List possibleCards = game.getCommandersIds(player, CommanderCardType.ANY, false).stream().map(game::getCard).filter(Objects::nonNull).filter(card -> game.getState().getZone(card.getId()).equals((Object)Zone.COMMAND)).filter(card -> filter.match((Card)card, sourceControllerId, source, game)).collect(Collectors.toList());
        for (Card card2 : possibleCards) {
            if (sourceId != null && !isNotTarget && game.replaceEvent(new TargetEvent(card2, sourceId, sourceControllerId))) continue;
            possibleTargets.add(card2.getId());
        }
        return possibleTargets;
    }

    protected static Set<UUID> getAllPossibleTargetInAnyZone(Game game, Player player, UUID sourceControllerId, Ability source, FilterCard filter, boolean isNotTarget) {
        HashSet<UUID> possibleTargets = new HashSet<UUID>();
        for (Card card : game.getCards()) {
            if (!filter.match(card, sourceControllerId, source, game)) continue;
            possibleTargets.add(card.getId());
        }
        return possibleTargets;
    }

    @Override
    public boolean canTarget(UUID id, Ability source, Game game) {
        Card card = game.getCard(id);
        return card != null && this.zone != null && this.zone.match(game.getState().getZone(id)) && this.getFilter() != null && this.getFilter().match(card, game);
    }

    @Override
    public boolean canTarget(UUID playerId, UUID id, Ability source, Game game) {
        Card card = game.getCard(id);
        return card != null && this.zone != null && this.zone.match(game.getState().getZone(id)) && this.getFilter() != null && this.getFilter().match(card, playerId, source, game);
    }

    public boolean canTarget(UUID playerId, UUID id, Ability source, Cards cards, Game game) {
        return cards.contains(id) && this.canTarget(playerId, id, source, game);
    }

    @Override
    public TargetCard copy() {
        return new TargetCard(this);
    }
}

