/*
 * Decompiled with CFR 0.152.
 */
package mage.target;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.MageObject;
import mage.abilities.Ability;
import mage.cards.Card;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetAmount;
import mage.target.TargetImpl;
import mage.util.DebugUtil;
import mage.util.RandomUtil;

public class TargetOptimization {
    public static int AI_MAX_POSSIBLE_TARGETS_TO_CHOOSE = 7;

    public static void optimizePossibleTargets(Ability source, Game game, Set<UUID> possibleTargets, int maxPossibleTargetsToSimulate) {
        String groupKey2;
        if (possibleTargets.size() < maxPossibleTargetsToSimulate) {
            return;
        }
        HashMap<UUID, String> targetGroups = new HashMap<UUID, String>();
        possibleTargets.forEach(id -> {
            MageObject object;
            String groupKey = "";
            Player player = game.getPlayer((UUID)id);
            if (player != null) {
                groupKey = TargetOptimization.getTargetGroupKeyAsPlayer(player);
            }
            if ((object = game.getObject((UUID)id)) != null) {
                groupKey = object.getName();
                groupKey = object instanceof Permanent ? groupKey + TargetOptimization.getTargetGroupKeyAsPermanent(game, (Permanent)object) : (object instanceof Card ? groupKey + TargetOptimization.getTargetGroupKeyAsCard(game, (Card)object) : groupKey + TargetOptimization.getTargetGroupKeyAsOther(game, object));
            }
            if (groupKey.isEmpty()) {
                groupKey = id.toString();
            }
            targetGroups.put((UUID)id, groupKey);
        });
        HashMap<String, List> groups = new HashMap<String, List>();
        targetGroups.forEach((id, groupKey) -> {
            groups.computeIfAbsent((String)groupKey, k -> new ArrayList());
            ((List)groups.get(groupKey)).add(id);
        });
        HashSet<UUID> newPossibleTargets = new HashSet<UUID>();
        groups.forEach((groupKey, groupTargets) -> {
            UUID targetId = (UUID)RandomUtil.randomFromCollection(groupTargets);
            if (targetId != null) {
                newPossibleTargets.add(targetId);
                groupTargets.remove(targetId);
            }
        });
        while (newPossibleTargets.size() < maxPossibleTargetsToSimulate && (groupKey2 = (String)RandomUtil.randomFromCollection(groups.keySet())) != null) {
            List groupTargets2 = groups.getOrDefault(groupKey2, null);
            if (groupTargets2 == null || groupTargets2.isEmpty()) {
                groups.remove(groupKey2);
                continue;
            }
            UUID targetId = (UUID)RandomUtil.randomFromCollection(groupTargets2);
            if (targetId == null) continue;
            newPossibleTargets.add(targetId);
            groupTargets2.remove(targetId);
        }
        possibleTargets.clear();
        possibleTargets.addAll(newPossibleTargets);
    }

    private static String getTargetGroupKeyAsPlayer(Player player) {
        return String.join((CharSequence)";", Arrays.asList(player.getName(), String.valueOf(player.getId().hashCode())));
    }

    private static String getTargetGroupKeyAsPermanent(Game game, Permanent permanent) {
        return String.join((CharSequence)";", Arrays.asList(permanent.getName(), String.valueOf(permanent.getControllerId().hashCode()), String.valueOf(permanent.getOwnerId().hashCode()), String.valueOf(permanent.isTapped()), String.valueOf(permanent.getPower().getValue()), String.valueOf(permanent.getToughness().getValue()), String.valueOf(permanent.getDamage()), String.valueOf(permanent.getCardType(game).toString().hashCode()), String.valueOf(permanent.getSubtype(game).toString().hashCode()), String.valueOf(permanent.getCounters(game).getTotalCount()), String.valueOf(permanent.getAbilities(game).size()), String.valueOf(permanent.getRules(game).toString().hashCode())));
    }

    private static String getTargetGroupKeyAsCard(Game game, Card card) {
        return String.join((CharSequence)";", Arrays.asList(card.getName(), String.valueOf(card.getOwnerId().hashCode()), String.valueOf(card.getCardType(game).toString().hashCode()), String.valueOf(card.getSubtype(game).toString().hashCode()), String.valueOf(card.getCounters(game).getTotalCount()), String.valueOf(card.getAbilities(game).size()), String.valueOf(card.getRules(game).toString().hashCode())));
    }

    private static String getTargetGroupKeyAsOther(Game game, MageObject item) {
        return String.join((CharSequence)";", Arrays.asList(item.getName(), String.valueOf(item.getId().hashCode())));
    }

    public static void printTargetsVariationsForTarget(String info, Game game, Set<UUID> possibleTargets, List<TargetImpl> options, boolean isPrintOptions) {
        List<Target> usedOptions = options.stream().filter(Objects::nonNull).map(TargetImpl.class::cast).collect(Collectors.toList());
        TargetOptimization.printTargetsTableAndVariationsInner(info, game, possibleTargets, usedOptions, isPrintOptions);
    }

    public static void printTargetsVariationsForTargetAmount(String info, Game game, Set<UUID> possibleTargets, List<TargetAmount> options, boolean isPrintOptions) {
        List<Target> usedOptions = options.stream().filter(Objects::nonNull).map(TargetImpl.class::cast).collect(Collectors.toList());
        TargetOptimization.printTargetsTableAndVariationsInner(info, game, possibleTargets, usedOptions, isPrintOptions);
    }

    private static void printTargetsTableAndVariationsInner(String info, Game game, Set<UUID> possibleTargets, List<Target> options, boolean isPrintOptions) {
        if (!DebugUtil.AI_SHOW_TARGET_OPTIMIZATION_LOGS) {
            return;
        }
        ArrayList<UUID> list = new ArrayList<UUID>(possibleTargets);
        Collections.sort(list);
        HashMap targetNumbers = new HashMap();
        System.out.println();
        System.out.println(String.format("Targets (%s): %d", info, list.size()));
        for (int i = 0; i < list.size(); ++i) {
            MageObject object;
            targetNumbers.put(list.get(i), i);
            Player player = game.getPlayer((UUID)list.get(i));
            String targetName = player != null ? player.toString() : ((object = game.getObject((UUID)list.get(i))) != null ? object.toString() : "unknown");
            System.out.println(String.format("%d. %s", i, targetName));
        }
        System.out.println();
        if (!isPrintOptions) {
            return;
        }
        List res = options.stream().map(t -> t.getTargets().stream().map(id -> targetNumbers.get(id) + (t instanceof TargetAmount ? " -> " + t.getTargetAmount((UUID)id) : "")).sorted().collect(Collectors.joining("; "))).sorted().collect(Collectors.toList());
        System.out.println();
        System.out.println(String.format("Target variations (info): %d", options.size()));
        System.out.println(String.join((CharSequence)"\n", res));
        System.out.println();
    }
}

