/*
 * Decompiled with CFR 0.152.
 */
package mage.target;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.MageItem;
import mage.abilities.Ability;
import mage.constants.Zone;
import mage.filter.FilterSpell;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.game.stack.StackObject;
import mage.target.TargetObject;

public class TargetSpell
extends TargetObject {
    protected final FilterSpell filter;
    private final Set<UUID> sourceIds = new HashSet<UUID>();

    public TargetSpell() {
        this(1, 1, StaticFilters.FILTER_SPELL);
    }

    public TargetSpell(FilterSpell filter) {
        this(1, 1, filter);
    }

    public TargetSpell(int numTargets, FilterSpell filter) {
        this(numTargets, numTargets, filter);
    }

    public TargetSpell(int minNumTargets, int maxNumTargets, FilterSpell filter) {
        this.minNumberOfTargets = minNumTargets;
        this.maxNumberOfTargets = maxNumTargets;
        this.zone = Zone.STACK;
        this.filter = filter;
        this.targetName = filter.getMessage();
    }

    protected TargetSpell(TargetSpell target) {
        super(target);
        this.filter = target.filter.copy();
        this.sourceIds.addAll(target.sourceIds);
    }

    @Override
    public FilterSpell getFilter() {
        return this.filter;
    }

    @Override
    public boolean canTarget(UUID id, Ability source, Game game) {
        if (source == null || source.getId().equals(id)) {
            return false;
        }
        Spell spell = game.getStack().getSpell(id);
        return this.filter.match(spell, source.getControllerId(), source, game);
    }

    @Override
    public boolean canChoose(UUID sourceControllerId, Ability source, Game game) {
        return this.canChooseFromPossibleTargets(sourceControllerId, source, game);
    }

    @Override
    public Set<UUID> possibleTargets(UUID sourceControllerId, Ability source, Game game) {
        Set<UUID> possibleTargets = game.getStack().stream().filter(stackObject -> this.canBeChosen((StackObject)stackObject, sourceControllerId, source, game)).map(MageItem::getId).collect(Collectors.toSet());
        return this.keepValidPossibleTargets(possibleTargets, sourceControllerId, source, game);
    }

    @Override
    public TargetSpell copy() {
        return new TargetSpell(this);
    }

    private boolean canBeChosen(StackObject stackObject, UUID sourceControllerId, Ability source, Game game) {
        boolean isSelfTarget = source.getSourceId() != null && source.getSourceId().equals(stackObject.getSourceId());
        return stackObject instanceof Spell && !isSelfTarget && game.getState().getPlayersInRange(sourceControllerId, game).contains(stackObject.getControllerId()) && this.canTarget(sourceControllerId, stackObject.getId(), source, game);
    }

    @Override
    public void addTarget(UUID id, Ability source, Game game, boolean skipEvent) {
        Spell spell = game.getStack().getSpell(id);
        if (spell != null) {
            this.sourceIds.add(spell.getSourceId());
        }
        super.addTarget(id, source, game, skipEvent);
    }

    public Set<UUID> getSourceIds() {
        return this.sourceIds;
    }
}

