/*
 * Decompiled with CFR 0.152.
 */
package mage.target.common;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.cards.Card;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;

public class TargetCardInOpponentsGraveyard
extends TargetCard {
    protected final boolean allFromOneOpponent;

    public TargetCardInOpponentsGraveyard(FilterCard filter) {
        this(1, 1, filter, false);
    }

    public TargetCardInOpponentsGraveyard(int minNumTargets, int maxNumTargets, FilterCard filter) {
        this(minNumTargets, maxNumTargets, filter, false);
    }

    public TargetCardInOpponentsGraveyard(int minNumTargets, int maxNumTargets, FilterCard filter, boolean allFromOneOpponent) {
        super(minNumTargets, maxNumTargets, Zone.GRAVEYARD, filter);
        this.allFromOneOpponent = allFromOneOpponent;
    }

    protected TargetCardInOpponentsGraveyard(TargetCardInOpponentsGraveyard target) {
        super(target);
        this.allFromOneOpponent = target.allFromOneOpponent;
    }

    @Override
    public boolean canTarget(UUID playerId, UUID id, Ability source, Game game) {
        Card card = game.getCard(id);
        if (card != null && this.zone.match(game.getState().getZone(id)) && game.getPlayer(source.getControllerId()).hasOpponent(card.getOwnerId(), game)) {
            Card firstCard;
            if (this.allFromOneOpponent && !this.targets.isEmpty() && (firstCard = game.getCard((UUID)this.targets.keySet().iterator().next())) != null && !card.isOwnedBy(firstCard.getOwnerId())) {
                return false;
            }
            return this.filter.match(card, playerId, source, game);
        }
        return false;
    }

    @Override
    public boolean canTarget(UUID id, Ability source, Game game) {
        Card card = game.getCard(id);
        if (card != null && game.getState().getZone(card.getId()) == Zone.GRAVEYARD && game.getPlayer(source.getControllerId()).hasOpponent(card.getOwnerId(), game)) {
            Card firstCard;
            if (this.allFromOneOpponent && !this.targets.isEmpty() && (firstCard = game.getCard((UUID)this.targets.keySet().iterator().next())) != null && !card.isOwnedBy(firstCard.getOwnerId())) {
                return false;
            }
            return this.filter.match(card, game);
        }
        return false;
    }

    @Override
    public Set<UUID> possibleTargets(UUID sourceControllerId, Ability source, Game game) {
        HashSet<UUID> possibleTargets = new HashSet<UUID>();
        Player sourceController = game.getPlayer(sourceControllerId);
        for (UUID playerId : game.getState().getPlayersInRange(sourceControllerId, game)) {
            Player player;
            if (!sourceController.hasOpponent(playerId, game) || (player = game.getPlayer(playerId)) == null) continue;
            HashSet<UUID> targetsInThisGraveyeard = new HashSet<UUID>();
            for (Card card : player.getGraveyard().getCards(this.filter, sourceControllerId, source, game)) {
                targetsInThisGraveyeard.add(card.getId());
            }
            if (this.allFromOneOpponent && targetsInThisGraveyeard.size() < this.minNumberOfTargets) continue;
            possibleTargets.addAll(targetsInThisGraveyeard);
        }
        return this.keepValidPossibleTargets(possibleTargets, sourceControllerId, source, game);
    }

    @Override
    public TargetCardInOpponentsGraveyard copy() {
        return new TargetCardInOpponentsGraveyard(this);
    }
}

