/*
 * Decompiled with CFR 0.152.
 */
package mage.target.common;

import java.util.Objects;
import java.util.UUID;
import mage.MageInt;
import mage.MageObject;
import mage.abilities.Ability;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.TargetPermanent;

public class TargetCreaturesWithDifferentPowers
extends TargetPermanent {
    private static final FilterPermanent filter = new FilterCreaturePermanent("creatures with different powers");

    public TargetCreaturesWithDifferentPowers() {
        super(0, Integer.MAX_VALUE, filter, false);
    }

    private TargetCreaturesWithDifferentPowers(TargetCreaturesWithDifferentPowers target) {
        super(target);
    }

    @Override
    public TargetCreaturesWithDifferentPowers copy() {
        return new TargetCreaturesWithDifferentPowers(this);
    }

    @Override
    public boolean canTarget(UUID playerId, UUID id, Ability source, Game game) {
        if (!super.canTarget(playerId, id, source, game)) {
            return false;
        }
        Permanent creature = game.getPermanent(id);
        if (creature == null) {
            return false;
        }
        return this.getTargets().stream().map(game::getPermanent).filter(Objects::nonNull).map(MageObject::getPower).mapToInt(MageInt::getValue).noneMatch(p -> creature.getPower().getValue() == p);
    }
}

