/*
 * Decompiled with CFR 0.152.
 */
package mage.target.common;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.cards.Card;
import mage.constants.Zone;
import mage.filter.Filter;
import mage.filter.common.FilterPermanentOrSuspendedCard;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.TargetImpl;

public class TargetPermanentOrSuspendedCard
extends TargetImpl {
    protected final FilterPermanentOrSuspendedCard filter;

    public TargetPermanentOrSuspendedCard() {
        this(new FilterPermanentOrSuspendedCard(), false);
    }

    public TargetPermanentOrSuspendedCard(FilterPermanentOrSuspendedCard filter, boolean notTarget) {
        this(filter, notTarget, 1, 1);
    }

    public TargetPermanentOrSuspendedCard(FilterPermanentOrSuspendedCard filter, boolean notTarget, int minTargets, int maxTargets) {
        super(notTarget);
        this.filter = filter;
        this.zone = Zone.ALL;
        this.targetName = filter.getMessage();
        this.minNumberOfTargets = minTargets;
        this.maxNumberOfTargets = maxTargets;
    }

    protected TargetPermanentOrSuspendedCard(TargetPermanentOrSuspendedCard target) {
        super(target);
        this.filter = target.filter.copy();
    }

    @Override
    public Filter<MageObject> getFilter() {
        return this.filter;
    }

    @Override
    public TargetPermanentOrSuspendedCard copy() {
        return new TargetPermanentOrSuspendedCard(this);
    }

    @Override
    public boolean canChoose(UUID sourceControllerId, Ability source, Game game) {
        return this.canChooseFromPossibleTargets(sourceControllerId, source, game);
    }

    @Override
    public Set<UUID> possibleTargets(UUID sourceControllerId, Ability source, Game game) {
        HashSet<UUID> possibleTargets = new HashSet<UUID>();
        for (Permanent permanent : game.getBattlefield().getActivePermanents(this.filter.getPermanentFilter(), sourceControllerId, game)) {
            if (!this.filter.match(permanent, sourceControllerId, source, game)) continue;
            possibleTargets.add(permanent.getId());
        }
        for (Card card : game.getExile().getCardsInRange(game, sourceControllerId)) {
            if (!this.filter.match(card, sourceControllerId, source, game)) continue;
            possibleTargets.add(card.getId());
        }
        return this.keepValidPossibleTargets(possibleTargets, sourceControllerId, source, game);
    }

    @Override
    public boolean canTarget(UUID id, Ability source, Game game) {
        Permanent permanent = game.getPermanent(id);
        if (permanent != null) {
            if (source != null) {
                return (this.isNotTarget() || permanent.canBeTargetedBy(game.getObject(source), source.getControllerId(), source, game)) && this.filter.match(permanent, source.getControllerId(), source, game);
            }
            return this.filter.match(permanent, game);
        }
        Card card = game.getExile().getCard(id, game);
        return this.filter.match(card, game);
    }

    @Override
    public boolean canTarget(UUID playerId, UUID id, Ability source, Game game) {
        return this.canTarget(id, source, game);
    }

    @Override
    public String getTargetedName(Game game) {
        StringBuilder sb = new StringBuilder();
        for (UUID targetId : this.getTargets()) {
            Permanent permanent = game.getPermanent(targetId);
            if (permanent != null) {
                sb.append(permanent.getLogName()).append(' ');
                continue;
            }
            Card card = game.getExile().getCard(targetId, game);
            if (card == null) continue;
            sb.append(card.getLogName()).append(' ');
        }
        return sb.toString().trim();
    }
}

