/*
 * Decompiled with CFR 0.152.
 */
package mage.target.targetadjustment;

import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.game.Game;
import mage.target.Target;
import mage.target.targetadjustment.TargetAdjuster;

public class ConditionalTargetAdjuster
implements TargetAdjuster {
    private final Condition condition;
    private final boolean keepBlueprintTarget;
    private final Target replacementTarget;
    private Target blueprintTarget;

    public ConditionalTargetAdjuster(Condition condition, Target replacementTarget) {
        this(condition, null, false, replacementTarget);
    }

    public ConditionalTargetAdjuster(Condition condition, boolean keepBlueprintTarget, Target replacementTarget) {
        this(condition, null, keepBlueprintTarget, replacementTarget);
    }

    public ConditionalTargetAdjuster(Condition condition, Target blueprintTarget, Target replacementTarget) {
        this(condition, blueprintTarget, false, replacementTarget);
    }

    public ConditionalTargetAdjuster(Condition condition, Target blueprintTarget, boolean keepBlueprintTarget, Target replacementTarget) {
        this.condition = condition;
        this.keepBlueprintTarget = keepBlueprintTarget;
        this.blueprintTarget = blueprintTarget;
        this.replacementTarget = replacementTarget;
    }

    @Override
    public void addDefaultTargets(Ability ability) {
        if (this.blueprintTarget == null && !ability.getTargets().isEmpty()) {
            this.blueprintTarget = ((Target)ability.getTargets().get(0)).copy();
        }
    }

    @Override
    public void clearDefaultTargets() {
        this.blueprintTarget = null;
    }

    @Override
    public void adjustTargets(Ability ability, Game game) {
        ability.getTargets().clear();
        boolean result = this.condition.apply(game, ability);
        if ((this.keepBlueprintTarget || !result) && this.blueprintTarget != null) {
            ability.addTarget(this.blueprintTarget.copy());
        }
        if (result) {
            ability.addTarget(this.replacementTarget.copy());
        }
    }
}

