/*
 * Decompiled with CFR 0.152.
 */
package mage.target.targetadjustment;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.effects.Effect;
import mage.filter.Filter;
import mage.game.Game;
import mage.target.Target;
import mage.target.targetadjustment.GenericTargetAdjuster;

public class TargetsCountAdjuster
extends GenericTargetAdjuster {
    private final DynamicValue dynamicValue;

    public TargetsCountAdjuster(DynamicValue value) {
        this.dynamicValue = value;
    }

    @Override
    public void adjustTargets(Ability ability, Game game) {
        int count = this.dynamicValue.calculate(game, ability, (Effect)ability.getEffects().get(0));
        ability.getTargets().clear();
        if (count <= 0) {
            return;
        }
        Target newTarget = this.blueprintTarget.copy();
        newTarget.setMaxNumberOfTargets(count);
        Filter filter = newTarget.getFilter();
        if (this.blueprintTarget.getMinNumberOfTargets() != 0) {
            newTarget.setMinNumberOfTargets(count);
            newTarget.withTargetName(filter.getMessage() + " (" + count + " targets)");
        } else {
            newTarget.withTargetName(filter.getMessage() + " (up to " + count + " targets)");
        }
        ability.addTarget(newTarget);
    }
}

