/*
 * Decompiled with CFR 0.152.
 */
package mage.target.targetadjustment;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.GetXValue;
import mage.abilities.effects.Effect;
import mage.constants.ComparisonType;
import mage.filter.Filter;
import mage.filter.predicate.mageobject.ToughnessPredicate;
import mage.game.Game;
import mage.target.Target;
import mage.target.targetadjustment.GenericTargetAdjuster;

public class ToughnessTargetAdjuster
extends GenericTargetAdjuster {
    private final DynamicValue dynamicValue;
    private final ComparisonType comparison;

    public ToughnessTargetAdjuster(DynamicValue value, ComparisonType compare) {
        this.dynamicValue = value;
        this.comparison = compare;
    }

    public ToughnessTargetAdjuster(ComparisonType comparison) {
        this(GetXValue.instance, comparison);
    }

    @Override
    public void adjustTargets(Ability ability, Game game) {
        Target newTarget = this.blueprintTarget.copy();
        int amount = this.dynamicValue.calculate(game, ability, (Effect)ability.getEffects().get(0));
        Filter filter = newTarget.getFilter();
        filter.add(new ToughnessPredicate(this.comparison, amount));
        newTarget.withTargetName(filter.getMessage() + " (Toughness " + (Object)((Object)this.comparison) + " " + amount + ")");
        ability.getTargets().clear();
        ability.addTarget(newTarget);
    }
}

