/*
 * Decompiled with CFR 0.152.
 */
package mage.target.targetpointer;

import java.util.HashMap;
import java.util.Map;
import mage.abilities.Ability;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;
import mage.players.Player;
import mage.target.Targets;
import mage.target.targetpointer.TargetPointer;

public abstract class TargetPointerImpl
implements TargetPointer {
    private Map<String, String> data;
    private boolean initialized = false;
    protected String targetDescription = null;

    protected TargetPointerImpl() {
    }

    protected TargetPointerImpl(TargetPointerImpl targetPointer) {
        if (targetPointer.data != null) {
            this.data = new HashMap<String, String>();
            this.data.putAll(targetPointer.data);
        }
        this.initialized = targetPointer.initialized;
        this.targetDescription = targetPointer.targetDescription;
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public void setInitialized() {
        this.initialized = true;
    }

    @Override
    public Player getControllerOfFirstTargetOrLKI(Game game, Ability source) {
        Player targetController = null;
        Permanent permanent = this.getFirstTargetPermanentOrLKI(game, source);
        if (permanent != null) {
            targetController = game.getPlayer(permanent.getControllerId());
        } else {
            Spell spell = game.getSpellOrLKIStack(this.getFirst(game, source));
            if (spell != null) {
                targetController = game.getPlayer(spell.getControllerId());
            }
        }
        return targetController;
    }

    @Override
    public String getData(String key) {
        if (this.data == null) {
            return "";
        }
        return this.data.getOrDefault(key, "");
    }

    @Override
    public TargetPointer withData(String key, String value) {
        if (this.data == null) {
            this.data = new HashMap<String, String>();
        }
        this.data.put(key, value);
        return this;
    }

    @Override
    public String describeTargets(Targets targets, String defaultDescription) {
        return this.targetDescription != null ? this.targetDescription : defaultDescription;
    }

    @Override
    public void setTargetDescription(String description) {
        this.targetDescription = description;
    }

    @Override
    public String getTargetDescription() {
        return this.targetDescription;
    }
}

