/*
 * Decompiled with CFR 0.152.
 */
package mage.util;

import com.google.common.collect.ImmutableList;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mage.ApprovingObject;
import mage.MageIdentifier;
import mage.MageObject;
import mage.MageObjectReference;
import mage.Mana;
import mage.abilities.Abilities;
import mage.abilities.Ability;
import mage.abilities.ActivatedAbility;
import mage.abilities.Mode;
import mage.abilities.PlayLandAbility;
import mage.abilities.SpellAbility;
import mage.abilities.condition.Condition;
import mage.abilities.costs.Cost;
import mage.abilities.costs.Costs;
import mage.abilities.costs.VariableCost;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.costs.mana.HybridManaCost;
import mage.abilities.costs.mana.ManaCost;
import mage.abilities.costs.mana.ManaCosts;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.costs.mana.MonoHybridManaCost;
import mage.abilities.costs.mana.SnowManaCost;
import mage.abilities.costs.mana.VariableManaCost;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.SavedDamageValue;
import mage.abilities.dynamicvalue.common.SavedDiscardValue;
import mage.abilities.dynamicvalue.common.SavedGainedLifeValue;
import mage.abilities.dynamicvalue.common.StaticValue;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.common.InfoEffect;
import mage.abilities.effects.common.asthought.CanPlayCardControllerEffect;
import mage.abilities.effects.common.asthought.YouMaySpendManaAsAnyColorToCastTargetEffect;
import mage.abilities.effects.common.counter.AddCountersTargetEffect;
import mage.abilities.hint.Hint;
import mage.abilities.hint.HintUtils;
import mage.cards.Card;
import mage.cards.CardWithHalves;
import mage.cards.CardWithSpellOption;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.cards.MeldCard;
import mage.cards.ModalDoubleFacedCard;
import mage.cards.ModalDoubleFacedCardHalf;
import mage.cards.SpellOptionCard;
import mage.cards.SplitCard;
import mage.cards.SplitCardHalf;
import mage.cards.SubCard;
import mage.constants.ColoredManaSymbol;
import mage.constants.Duration;
import mage.constants.EmptyNames;
import mage.constants.ManaType;
import mage.constants.Outcome;
import mage.constants.SpellAbilityType;
import mage.constants.TargetController;
import mage.constants.Zone;
import mage.counters.Counter;
import mage.filter.Filter;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.card.OwnerIdPredicate;
import mage.filter.predicate.mageobject.NamePredicate;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.game.CardState;
import mage.game.Game;
import mage.game.GameState;
import mage.game.command.Commander;
import mage.game.events.BatchEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.permanent.PermanentCard;
import mage.game.permanent.PermanentMeld;
import mage.game.permanent.PermanentToken;
import mage.game.permanent.token.Token;
import mage.game.stack.Spell;
import mage.players.Player;
import mage.players.PlayerList;
import mage.target.Target;
import mage.target.TargetCard;
import mage.target.targetpointer.FixedTarget;
import mage.util.Copyable;
import mage.watchers.Watcher;
import org.apache.log4j.Logger;

public final class CardUtil {
    private static final Logger logger = Logger.getLogger(CardUtil.class);
    public static final List<String> RULES_ERROR_INFO = ImmutableList.of((Object)"Exception occurred in rules generation");
    public static final String SOURCE_EXILE_ZONE_TEXT = "SourceExileZone";
    static final String[] numberStrings = new String[]{"zero", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "ten", "eleven", "twelve", "thirteen", "fourteen", "fifteen", "sixteen", "seventeen", "eighteen", "nineteen", "twenty"};
    static final String[] ordinalStrings = new String[]{"first", "second", "third", "fourth", "fifth", "sixth", "seventh", "eightth", "ninth", "tenth", "eleventh", "twelfth", "thirteenth", "fourteenth", "fifteenth", "sixteenth", "seventeenth", "eighteenth", "nineteenth", "twentieth"};
    public static final SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss.SSS");
    private static final List<String> costWords = Arrays.asList("put", "return", "exile", "discard", "mill", "sacrifice", "remove", "tap", "reveal", "pay", "have", "collect", "forage");
    public static final int TESTS_SET_CODE_MIN_LOOKUP_LENGTH = 3;
    public static final int TESTS_SET_CODE_MAX_LOOKUP_LENGTH = 6;
    public static final String TESTS_SET_CODE_DELIMETER = "-";
    private static final String vowels = "aeiouAEIOU8";
    private static final FilterCard defaultFilter = new FilterCard("card to cast");

    public static void increaseCost(Ability ability, int increaseCount) {
        CardUtil.adjustAbilityCost(ability, -increaseCount);
    }

    public static int calculateActualPossibleGenericManaReduction(Mana mana, int maxPossibleReduction, int notLessThan) {
        int nonGeneric = mana.count() - mana.getGeneric();
        int notPossibleGenericReduction = Math.max(0, notLessThan - nonGeneric);
        int actualPossibleGenericManaReduction = Math.max(0, mana.getGeneric() - notPossibleGenericReduction);
        if (actualPossibleGenericManaReduction > maxPossibleReduction) {
            actualPossibleGenericManaReduction = maxPossibleReduction;
        }
        return actualPossibleGenericManaReduction;
    }

    public static void reduceCost(Ability ability, int reduceCount) {
        CardUtil.adjustAbilityCost(ability, reduceCount);
    }

    public static void adjustCost(SpellAbility spellAbility, int reduceCount) {
        CardUtil.adjustAbilityCost(spellAbility, reduceCount);
    }

    public static ManaCosts<ManaCost> increaseCost(ManaCosts<ManaCost> manaCosts, int increaseCount) {
        return CardUtil.adjustCost(manaCosts, -increaseCount);
    }

    public static ManaCosts<ManaCost> reduceCost(ManaCosts<ManaCost> manaCosts, int reduceCount) {
        return CardUtil.adjustCost(manaCosts, reduceCount);
    }

    private static void adjustAbilityCost(Ability ability, int reduceCount) {
        ManaCosts<ManaCost> adjustedCost = CardUtil.adjustCost(ability.getManaCostsToPay(), reduceCount);
        ability.clearManaCostsToPay();
        ability.addManaCostsToPay(adjustedCost);
    }

    public static ManaCosts<ManaCost> adjustCost(ManaCosts<ManaCost> manaCosts, int reduceCount) {
        ManaCostsImpl<ManaCost> newCost = new ManaCostsImpl<ManaCost>();
        if (reduceCount == 0) {
            for (ManaCost manaCost2 : manaCosts) {
                newCost.add(manaCost2.copy());
            }
            return newCost;
        }
        LinkedHashMap<ManaCost, ManaCost> changedCost = new LinkedHashMap<ManaCost, ManaCost>();
        ArrayList<GenericManaCost> addedCost = new ArrayList<GenericManaCost>();
        manaCosts.forEach(manaCost -> changedCost.put((ManaCost)manaCost, (ManaCost)manaCost));
        if (reduceCount > 0) {
            int newColorless;
            int colorless;
            int restToReduce = reduceCount;
            for (ManaCost manaCost3 : manaCosts) {
                if (manaCost3 instanceof SnowManaCost || manaCost3.getOptions().isEmpty() || manaCost3.getOptions().size() > 1) continue;
                Mana mana = manaCost3.getOptions().getAtIndex(0);
                int n = colorless = mana != null ? mana.getGeneric() : 0;
                if (restToReduce == 0 || colorless <= 0) continue;
                if (colorless - restToReduce > 0) {
                    newColorless = colorless - restToReduce;
                    changedCost.put(manaCost3, new GenericManaCost(newColorless));
                    restToReduce = 0;
                    continue;
                }
                changedCost.put(manaCost3, null);
                restToReduce -= colorless;
            }
            for (ManaCost manaCost3 : manaCosts) {
                if (manaCost3.getOptions().size() <= 1 || !(manaCost3 instanceof MonoHybridManaCost)) continue;
                MonoHybridManaCost mono = (MonoHybridManaCost)manaCost3;
                colorless = mono.getOptions().getAtIndex(1).getGeneric();
                if (restToReduce == 0 || colorless <= 0) continue;
                if (colorless - restToReduce > 0) {
                    newColorless = colorless - restToReduce;
                    changedCost.put(manaCost3, new MonoHybridManaCost(mono.getManaColor(), newColorless));
                    restToReduce = 0;
                    continue;
                }
                changedCost.put(manaCost3, new MonoHybridManaCost(mono.getManaColor(), 0));
                restToReduce -= colorless;
            }
        }
        if (reduceCount < 0) {
            boolean added = false;
            for (ManaCost manaCost3 : manaCosts) {
                if (changedCost.get(manaCost3) == null || reduceCount == 0 || !(manaCost3 instanceof GenericManaCost)) continue;
                GenericManaCost gen = (GenericManaCost)manaCost3;
                changedCost.put(manaCost3, new GenericManaCost(gen.getOptions().getAtIndex(0).getGeneric() + -reduceCount));
                reduceCount = 0;
                added = true;
            }
            if (!added) {
                addedCost.add(new GenericManaCost(-reduceCount));
            }
        }
        addedCost.forEach(cost -> newCost.add(cost.copy()));
        changedCost.forEach((key, value) -> {
            if (value != null) {
                newCost.add(value.copy());
            }
        });
        Filter filter = manaCosts.stream().filter(manaCost -> !(manaCost instanceof SnowManaCost)).map(ManaCost::getSourceFilter).filter(Objects::nonNull).findFirst().orElse(null);
        if (filter != null) {
            newCost.setSourceFilter(filter);
        }
        return newCost;
    }

    public static void reduceCost(SpellAbility spellAbility, ManaCosts<ManaCost> manaCostsToReduce) {
        CardUtil.adjustCost(spellAbility, manaCostsToReduce, true);
    }

    public static void increaseCost(SpellAbility spellAbility, ManaCosts<ManaCost> manaCostsToIncrease) {
        ManaCost increasedCost = spellAbility.getManaCostsToPay().copy();
        for (ManaCost manaCost : manaCostsToIncrease) {
            increasedCost.add(manaCost.copy());
        }
        spellAbility.clearManaCostsToPay();
        spellAbility.addManaCostsToPay(increasedCost);
    }

    /*
     * WARNING - void declaration
     */
    public static void adjustCost(Ability ability, ManaCosts<ManaCost> manaCostsToReduce, boolean convertToGeneric) {
        void var7_13;
        ManaCosts<ManaCost> previousCost = ability.getManaCostsToPay();
        ManaCostsImpl adjustedCost = new ManaCostsImpl();
        for (VariableCost variableCost : previousCost.getVariableCosts()) {
            if (!(variableCost instanceof VariableManaCost)) continue;
            adjustedCost.add((VariableManaCost)variableCost);
        }
        Mana reduceMana = new Mana();
        for (ManaCost manaCost : manaCostsToReduce) {
            if (manaCost instanceof MonoHybridManaCost) {
                reduceMana.add(Mana.GenericMana(2));
                continue;
            }
            reduceMana.add(manaCost.getMana());
        }
        ManaCostsImpl manaCostsImpl = new ManaCostsImpl();
        for (ManaCost newManaCost : previousCost) {
            Mana mana = newManaCost.getMana();
            if (!(newManaCost instanceof MonoHybridManaCost) && mana.getGeneric() > 0) {
                manaCostsImpl.add(newManaCost);
                continue;
            }
            boolean hybridMana = newManaCost instanceof HybridManaCost;
            if (mana.getBlack() > 0 && reduceMana.getBlack() > 0) {
                if (reduceMana.getBlack() > mana.getBlack()) {
                    reduceMana.setBlack(reduceMana.getBlack() - mana.getBlack());
                    mana.setBlack(0);
                } else {
                    mana.setBlack(mana.getBlack() - reduceMana.getBlack());
                    reduceMana.setBlack(0);
                }
                if (hybridMana) continue;
            }
            if (mana.getRed() > 0 && reduceMana.getRed() > 0) {
                if (reduceMana.getRed() > mana.getRed()) {
                    reduceMana.setRed(reduceMana.getRed() - mana.getRed());
                    mana.setRed(0);
                } else {
                    mana.setRed(mana.getRed() - reduceMana.getRed());
                    reduceMana.setRed(0);
                }
                if (hybridMana) continue;
            }
            if (mana.getBlue() > 0 && reduceMana.getBlue() > 0) {
                if (reduceMana.getBlue() > mana.getBlue()) {
                    reduceMana.setBlue(reduceMana.getBlue() - mana.getBlue());
                    mana.setBlue(0);
                } else {
                    mana.setBlue(mana.getBlue() - reduceMana.getBlue());
                    reduceMana.setBlue(0);
                }
                if (hybridMana) continue;
            }
            if (mana.getGreen() > 0 && reduceMana.getGreen() > 0) {
                if (reduceMana.getGreen() > mana.getGreen()) {
                    reduceMana.setGreen(reduceMana.getGreen() - mana.getGreen());
                    mana.setGreen(0);
                } else {
                    mana.setGreen(mana.getGreen() - reduceMana.getGreen());
                    reduceMana.setGreen(0);
                }
                if (hybridMana) continue;
            }
            if (mana.getWhite() > 0 && reduceMana.getWhite() > 0) {
                if (reduceMana.getWhite() > mana.getWhite()) {
                    reduceMana.setWhite(reduceMana.getWhite() - mana.getWhite());
                    mana.setWhite(0);
                } else {
                    mana.setWhite(mana.getWhite() - reduceMana.getWhite());
                    reduceMana.setWhite(0);
                }
                if (hybridMana) continue;
            }
            if (mana.getColorless() > 0 && reduceMana.getColorless() > 0) {
                if (reduceMana.getColorless() > mana.getColorless()) {
                    reduceMana.setColorless(reduceMana.getColorless() - mana.getColorless());
                    mana.setColorless(0);
                } else {
                    mana.setColorless(mana.getColorless() - reduceMana.getColorless());
                    reduceMana.setColorless(0);
                }
            }
            if (mana.count() <= 0) continue;
            if (newManaCost instanceof MonoHybridManaCost && mana.count() == 2) {
                reduceMana.setGeneric(reduceMana.getGeneric() - 2);
                continue;
            }
            manaCostsImpl.add(newManaCost);
        }
        if (convertToGeneric) {
            int n = reduceMana.count();
        } else {
            int n = reduceMana.getGeneric();
        }
        if (var7_13 > 0) {
            for (ManaCost newManaCost : manaCostsImpl) {
                int n;
                Mana mana = newManaCost.getMana();
                if (mana.getGeneric() == 0 || !n) {
                    adjustedCost.add(newManaCost);
                    continue;
                }
                if (newManaCost instanceof MonoHybridManaCost) {
                    if (n <= true) continue;
                    n -= 2;
                    mana.clear();
                    continue;
                }
                if (mana.getGeneric() > 0) {
                    if (n > mana.getGeneric()) {
                        n -= mana.getGeneric();
                        mana.setGeneric(0);
                    } else {
                        mana.setGeneric(mana.getGeneric() - n);
                        n = 0;
                    }
                }
                if (mana.count() <= 0) continue;
                adjustedCost.add(0, new GenericManaCost(mana.count()));
            }
        } else {
            adjustedCost.addAll(manaCostsImpl);
        }
        if (adjustedCost.isEmpty()) {
            adjustedCost.add(new GenericManaCost(0));
        }
        adjustedCost.setSourceFilter(previousCost.getSourceFilter());
        ability.clearManaCostsToPay();
        ability.addManaCostsToPay(adjustedCost);
    }

    public static String numberToText(int number) {
        return CardUtil.numberToText(number, "one");
    }

    public static String numberToText(int number, String forOne) {
        if (number == 1 && forOne != null) {
            return forOne;
        }
        if (number >= 0 && number < 21) {
            return numberStrings[number];
        }
        if (number == Integer.MAX_VALUE) {
            return "any number of";
        }
        return Integer.toString(number);
    }

    public static String numberToText(String number) {
        return CardUtil.numberToText(number, "one");
    }

    public static String numberToText(String number, String forOne) {
        if (CardUtil.checkNumeric(number)) {
            return CardUtil.numberToText(Integer.parseInt(number), forOne);
        }
        return number;
    }

    public static String numberToOrdinalText(int number) {
        if (number >= 1 && number < 21) {
            return ordinalStrings[number - 1];
        }
        return number + "th";
    }

    public static String replaceSourceName(String message, String sourceName) {
        return message != null ? message.replace("{this}", sourceName) : null;
    }

    public static String booleanToFlipName(boolean flip) {
        if (flip) {
            return "Heads";
        }
        return "Tails";
    }

    public static boolean checkNumeric(String s) {
        return !s.isEmpty() && s.chars().allMatch(Character::isDigit);
    }

    public static int parseCardNumberAsInt(String cardNumber) {
        if (cardNumber == null || cardNumber.isEmpty()) {
            throw new IllegalArgumentException("Card number is empty.");
        }
        try {
            if (!Character.isDigit(cardNumber.charAt(0))) {
                return Integer.parseInt(cardNumber.substring(1));
            }
            if (!Character.isDigit(cardNumber.charAt(cardNumber.length() - 1))) {
                return Integer.parseInt(cardNumber.substring(0, cardNumber.length() - 1));
            }
            return Integer.parseInt(cardNumber);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public static UUID getCardExileZoneId(Game game, Ability source) {
        return CardUtil.getCardExileZoneId(game, source.getSourceId());
    }

    public static UUID getCardExileZoneId(Game game, UUID sourceId) {
        return CardUtil.getCardExileZoneId(game, sourceId, false);
    }

    public static UUID getCardExileZoneId(Game game, UUID sourceId, boolean previous) {
        return CardUtil.getExileZoneId(CardUtil.getCardZoneString(SOURCE_EXILE_ZONE_TEXT, sourceId, game, previous), game);
    }

    public static UUID getExileZoneId(Game game, Ability source) {
        return CardUtil.getExileZoneId(game, source, 0);
    }

    public static UUID getExileZoneId(Game game, Ability source, int offset) {
        return CardUtil.getExileZoneId(game, source.getSourceId(), source.getStackMomentSourceZCC() + offset);
    }

    public static UUID getExileZoneId(Game game, UUID objectId, int zoneChangeCounter) {
        return CardUtil.getExileZoneId(CardUtil.getObjectZoneString(SOURCE_EXILE_ZONE_TEXT, objectId, game, zoneChangeCounter, false), game);
    }

    public static UUID getExileZoneId(String key, Game game) {
        UUID exileId = (UUID)game.getState().getValue(key);
        if (exileId == null) {
            exileId = UUID.randomUUID();
            game.getState().setValue(key, exileId);
        }
        return exileId;
    }

    public static String getCardZoneString(String text, UUID cardId, Game game) {
        return CardUtil.getCardZoneString(text, cardId, game, false);
    }

    public static String getCardZoneString(String text, UUID cardId, Game game, boolean previous) {
        int zoneChangeCounter = 0;
        Card card = game.getCard(cardId);
        if (card != null) {
            zoneChangeCounter = card.getZoneChangeCounter(game);
        }
        return CardUtil.getObjectZoneString(text, cardId, game, zoneChangeCounter, previous);
    }

    public static String getObjectZoneString(String text, MageObject mageObject, Game game) {
        int zoneChangeCounter = 0;
        if (mageObject instanceof Permanent) {
            zoneChangeCounter = mageObject.getZoneChangeCounter(game);
        } else if (mageObject instanceof Card) {
            zoneChangeCounter = mageObject.getZoneChangeCounter(game);
        }
        return CardUtil.getObjectZoneString(text, mageObject.getId(), game, zoneChangeCounter, false);
    }

    public static String getObjectZoneString(String text, UUID objectId, Game game, int zoneChangeCounter, boolean previous) {
        StringBuilder uniqueString = new StringBuilder();
        if (text != null) {
            uniqueString.append(text);
        }
        uniqueString.append(objectId);
        uniqueString.append(previous ? zoneChangeCounter - 1 : zoneChangeCounter);
        return uniqueString.toString();
    }

    public static String addToolTipMarkTags(String text) {
        return "<font color = 'blue'>" + text + "</font>";
    }

    public static int overflowInc(int base, int increment) {
        return CardUtil.overflowResult((long)base + (long)increment);
    }

    public static int overflowDec(int base, int decrement) {
        return CardUtil.overflowResult((long)base - (long)decrement);
    }

    public static int overflowMultiply(int base, int multiply) {
        return CardUtil.overflowResult((long)base * (long)multiply);
    }

    private static int overflowResult(long value) {
        if (value >= Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (value <= Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        return (int)value;
    }

    public static boolean isPrime(int number) {
        if (number < 2) {
            return false;
        }
        if (number == 2 || number == 3) {
            return true;
        }
        int i = 2;
        while (i * i <= number) {
            if (number % i == 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String createObjectRelatedWindowTitle(Ability source, Game game, String textSuffix) {
        MageObject sourceObject;
        String title = source != null ? ((sourceObject = game.getObject(source)) != null ? sourceObject.getIdName() + " [" + source.getStackMomentSourceZCC() + "]" + (textSuffix == null ? "" : " " + textSuffix) : (textSuffix == null ? "" : textSuffix)) : (textSuffix == null ? "" : textSuffix);
        return title;
    }

    public static boolean haveSameNames(String name1, String name2, Boolean ignoreMtgRuleForEmptyNames) {
        if (ignoreMtgRuleForEmptyNames.booleanValue()) {
            return name1 != null && name1.equals(name2);
        }
        return !CardUtil.haveEmptyName(name1) && !CardUtil.haveEmptyName(name2) && name1.equals(name2);
    }

    public static boolean haveSameNames(String name1, String name2) {
        return CardUtil.haveSameNames(name1, name2, false);
    }

    public static boolean haveSameNames(MageObject object1, MageObject object2) {
        return object1 != null && object2 != null && CardUtil.haveSameNames(object1.getName(), object2.getName());
    }

    public static boolean haveSameNames(MageObject object, String needName, Game game) {
        return CardUtil.containsName(object, needName, game);
    }

    public static boolean containsName(MageObject object, String name, Game game) {
        return new NamePredicate(name).apply(object, game);
    }

    public static boolean haveEmptyName(String name) {
        return name == null || name.isEmpty() || EmptyNames.isEmptyName(name);
    }

    public static boolean haveEmptyName(MageObject object) {
        return object == null || CardUtil.haveEmptyName(object.getName());
    }

    public static UUID getMainCardId(Game game, UUID objectId) {
        Card card = game.getCard(objectId);
        return card != null ? card.getMainCard().getId() : objectId;
    }

    public static String urlEncode(String data) {
        if (data.isEmpty()) {
            return "";
        }
        try {
            return URLEncoder.encode(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public static String urlDecode(String encodedData) {
        if (encodedData.isEmpty()) {
            return "";
        }
        try {
            return URLDecoder.decode(encodedData, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public static boolean cardHadAbility(Ability ability, CardState cardState, UUID cardId, Game game) {
        Card card = game.getCard(cardId);
        if (card != null) {
            if (cardState != null) {
                if (cardState.getAbilities().contains(ability)) {
                    return true;
                }
                if (cardState.hasLostAllAbilities()) {
                    return false;
                }
            }
            return card.getAbilities().contains(ability);
        }
        return false;
    }

    public static List<String> concatManaSymbols(String delimeter, List<String> mana1, List<String> mana2) {
        ArrayList<String> res = new ArrayList<String>(mana1);
        if (res.size() > 0 && mana2.size() > 0 && delimeter != null && !delimeter.isEmpty()) {
            res.add(delimeter);
        }
        res.addAll(mana2);
        return res;
    }

    public static String concatManaSymbols(String delimeter, String mana1, String mana2) {
        String res = mana1;
        if (!(res.isEmpty() || mana2.isEmpty() || delimeter == null || delimeter.isEmpty())) {
            res = res + delimeter;
        }
        res = res + mana2;
        return res;
    }

    public static ColoredManaSymbol manaTypeToColoredManaSymbol(ManaType manaType) {
        switch (manaType) {
            case BLACK: {
                return ColoredManaSymbol.B;
            }
            case BLUE: {
                return ColoredManaSymbol.U;
            }
            case GREEN: {
                return ColoredManaSymbol.G;
            }
            case RED: {
                return ColoredManaSymbol.R;
            }
            case WHITE: {
                return ColoredManaSymbol.W;
            }
        }
        throw new IllegalArgumentException("Wrong mana type " + (Object)((Object)manaType));
    }

    public static String getBoostCountAsStr(DynamicValue power, DynamicValue toughness) {
        String p = power.toString();
        String t = toughness.toString();
        if (!p.startsWith(TESTS_SET_CODE_DELIMETER)) {
            String string = p = t.startsWith(TESTS_SET_CODE_DELIMETER) && p.equals("0") ? "-0" : "+" + p;
        }
        if (!t.startsWith(TESTS_SET_CODE_DELIMETER)) {
            t = p.startsWith(TESTS_SET_CODE_DELIMETER) && t.equals("0") ? "-0" : "+" + t;
        }
        return p + "/" + t;
    }

    public static String getBoostCountAsStr(int power, int toughness) {
        return CardUtil.getBoostCountAsStr(StaticValue.get(power), StaticValue.get(toughness));
    }

    public static String getBoostText(DynamicValue power, DynamicValue toughness, Duration duration) {
        String message;
        String d;
        String boostCount = CardUtil.getBoostCountAsStr(power, toughness);
        StringBuilder sb = new StringBuilder(boostCount);
        if (duration != Duration.EndOfGame && !(d = duration.toString()).isEmpty()) {
            sb.append(' ').append(d);
        }
        if ((message = power.getMessage()).isEmpty()) {
            message = toughness.getMessage();
        }
        if (!message.isEmpty()) {
            sb.append(boostCount.contains("X") ? ", where X is " : " for each ").append(message);
        }
        return sb.toString();
    }

    public static Outcome getBoostOutcome(DynamicValue power, DynamicValue toughness) {
        if (toughness.getSign() < 0) {
            return Outcome.Removal;
        }
        if (power.getSign() < 0) {
            return Outcome.UnboostCreature;
        }
        return Outcome.BoostCreature;
    }

    public static String getSimpleCountersText(int amount, String forOne, String counterType) {
        return CardUtil.numberToText(amount, forOne) + " " + counterType + " counter" + (amount == 1 ? "" : "s");
    }

    public static String getOneOneCountersText(int amount) {
        return CardUtil.getSimpleCountersText(amount, "a", "+1/+1");
    }

    public static String getAddRemoveCountersText(DynamicValue amount, Counter counter, String description, boolean add) {
        boolean targetPlayerGets = add && (description.endsWith("player") || description.endsWith("opponent"));
        StringBuilder sb = new StringBuilder();
        if (targetPlayerGets) {
            sb.append(description);
            sb.append(" gets ");
        } else {
            sb.append(add ? "put " : "remove ");
        }
        boolean xValue = amount.toString().equals("X");
        if (xValue) {
            sb.append("X ").append(counter.getName()).append(" counters");
        } else if (amount == SavedDamageValue.MANY || amount == SavedGainedLifeValue.MANY || amount == SavedDiscardValue.MANY) {
            sb.append("that many ").append(counter.getName()).append(" counters");
        } else {
            sb.append(counter.getDescription());
        }
        if (!targetPlayerGets) {
            sb.append(add ? " on " : " from ");
            if (description.contains("up to") && !description.contains("up to one")) {
                sb.append("each of ");
            }
            sb.append(description);
        }
        if (!amount.getMessage().isEmpty()) {
            sb.append(xValue ? ", where X is " : " for each ").append(amount.getMessage());
        }
        return sb.toString();
    }

    public static boolean isFusedPartAbility(Ability ability, Game game) {
        if (!(ability instanceof SpellAbility)) {
            return false;
        }
        if (((SpellAbility)ability).getSpellAbilityType() == SpellAbilityType.SPLICE) {
            return true;
        }
        Spell mainSpell = game.getSpell(ability.getId());
        if (mainSpell == null) {
            return true;
        }
        SpellAbility mainSpellAbility = mainSpell.getSpellAbility();
        return mainSpellAbility.getSpellAbilityType() == SpellAbilityType.SPLIT_FUSED && !ability.equals(mainSpellAbility);
    }

    public static Abilities<Ability> getAbilities(MageObject object, Game game) {
        if (object instanceof Card) {
            return ((Card)object).getAbilities(game);
        }
        if (object instanceof Commander && Zone.COMMAND.equals((Object)game.getState().getZone(object.getId()))) {
            Card card = game.getCard(object.getId());
            if (card != null) {
                return card.getAbilities(game);
            }
            return object.getAbilities();
        }
        return object.getAbilities();
    }

    public static String getTextWithFirstCharUpperCase(String text) {
        if (text != null && !text.isEmpty()) {
            return Character.toUpperCase(text.charAt(0)) + text.substring(1);
        }
        return text;
    }

    public static String getTextWithFirstCharLowerCase(String text) {
        if (text != null && !text.isEmpty()) {
            return Character.toLowerCase(text.charAt(0)) + text.substring(1);
        }
        return text;
    }

    public static String addArticle(String text) {
        if (text.startsWith("a ") || text.startsWith("an ") || text.startsWith("another ") || text.startsWith("any ") || text.startsWith("{this} ") || text.startsWith("your ") || text.startsWith("their ") || text.startsWith("one ")) {
            return text;
        }
        return !text.isEmpty() && vowels.contains(text.substring(0, 1)) ? "an " + text : "a " + text;
    }

    public static String italicizeWithEmDash(String text) {
        return "<i>" + text + "</i> &mdash; ";
    }

    public static String stripReminderText(String text) {
        return text.endsWith(")</i>") ? text.substring(0, text.indexOf(" <i>(")) : text;
    }

    public static Set<UUID> getAllSelectedTargets(Ability ability, Game game) {
        return ability.getModes().getSelectedModes().stream().map(ability.getModes()::get).map(Mode::getTargets).flatMap(Collection::stream).map(Target::getTargets).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public static Set<UUID> getAllPossibleTargets(Ability ability, Game game) {
        return ability.getModes().values().stream().map(Mode::getTargets).flatMap(Collection::stream).map(t -> t.possibleTargets(ability.getControllerId(), ability, game)).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public static Set<UUID> getAllPossibleTargets(Cost cost, Game game, Ability source) {
        return cost.getTargets().stream().map(t -> t.possibleTargets(source.getControllerId(), source, game)).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public static List<Integer> distributeValues(int count, int min, int max) {
        ArrayList<Integer> res = new ArrayList<Integer>();
        if (count <= 0 || min > max) {
            return res;
        }
        if (min == max) {
            res.add(min);
            return res;
        }
        int range = max - min + 1;
        if (range <= count) {
            for (int i = 0; i < range; ++i) {
                res.add(min + i);
            }
            return res;
        }
        double step = (double)(max - min) / (double)(count - 1);
        for (int i = 0; i < count; ++i) {
            res.add(min + (int)Math.round((double)i * step));
        }
        res.set(0, min);
        if (res.size() > 1) {
            res.set(res.size() - 1, max);
        }
        return res;
    }

    public static boolean checkCanTargetTotalValueLimit(Collection<UUID> selectedTargets, UUID checkTargetId, ToIntFunction<MageObject> valueMapper, int maxValue, Game game) {
        MageObject checkTarget = game.getObject(checkTargetId);
        if (checkTarget == null) {
            return false;
        }
        return maxValue >= selectedTargets.stream().map(game::getObject).filter(Objects::nonNull).mapToInt(valueMapper).sum() + (selectedTargets.contains(checkTargetId) ? 0 : valueMapper.applyAsInt(checkTarget));
    }

    public static Set<UUID> checkPossibleTargetsTotalValueLimit(Collection<UUID> selectedTargets, Set<UUID> possibleTargets, ToIntFunction<MageObject> valueMapper, int maxValue, Game game) {
        int selectedValue = selectedTargets.stream().map(game::getObject).filter(Objects::nonNull).mapToInt(valueMapper).sum();
        int remainingValue = maxValue - selectedValue;
        HashSet<UUID> validTargets = new HashSet<UUID>();
        for (UUID id : possibleTargets) {
            MageObject mageObject = game.getObject(id);
            if (mageObject == null || valueMapper.applyAsInt(mageObject) > remainingValue) continue;
            validTargets.add(id);
        }
        return validTargets;
    }

    public static void putCardOntoBattlefieldWithEffects(Ability source, Game game, Card newCard, Player player, boolean tapped) {
        if (source == null) {
            throw new IllegalArgumentException("Wrong code usage: must use source ability or fakeSourceAbility");
        }
        if (newCard instanceof PermanentCard) {
            throw new IllegalArgumentException("Wrong code usage: must put to battlefield only real cards, not PermanentCard");
        }
        Card permCard = CardUtil.getDefaultCardSideForBattlefield(game, newCard);
        permCard.setZone(Zone.BATTLEFIELD, game);
        permCard.setOwnerId(player.getId());
        PermanentCard permanent = permCard instanceof MeldCard ? new PermanentMeld(permCard, player.getId(), game) : new PermanentCard(permCard, player.getId(), game);
        game.getPermanentsEntering().put(permanent.getId(), permanent);
        permCard.applyEnterWithCounters(permanent, source, game);
        permanent.entersBattlefield(source, game, Zone.OUTSIDE, false);
        game.addPermanent(permanent, game.getState().getNextPermanentOrderNumber());
        game.getPermanentsEntering().remove(permanent.getId());
        if (tapped) {
            permanent.setTapped(true);
        }
        permanent.removeSummoningSickness();
        for (ContinuousEffect effect : game.getState().getContinuousEffects().getLayeredEffects(game)) {
            Optional ability = game.getState().getContinuousEffects().getLayeredEffectAbilities(effect).stream().findFirst();
            if (!ability.isPresent() || !permanent.getId().equals(((Ability)ability.get()).getSourceId())) continue;
            effect.init((Ability)ability.get(), game, player.getId());
        }
    }

    public static Card getDefaultCardSideForBattlefield(Game game, Card card) {
        if (card instanceof PermanentCard) {
            return card;
        }
        Card permCard = card instanceof SplitCard ? card : (card instanceof CardWithSpellOption ? card : (card instanceof ModalDoubleFacedCard ? ((ModalDoubleFacedCard)card).getLeftHalfCard() : card));
        if (permCard.isInstantOrSorcery(game)) {
            throw new IllegalArgumentException("Card side can't be put to battlefield: " + permCard.getName());
        }
        return permCard;
    }

    public static Permanent getPermanentFromCardPutToBattlefield(Card card, Game game) {
        return game.getPermanent(CardUtil.getDefaultCardSideForBattlefield(game, card).getId());
    }

    public static String getCardNameForSameNameSearch(Card card) {
        if (card instanceof SplitCard) {
            return ((SplitCard)card).getLeftHalfCard().getName();
        }
        if (card instanceof ModalDoubleFacedCard) {
            return ((ModalDoubleFacedCard)card).getLeftHalfCard().getName();
        }
        return card.getName();
    }

    public static List<String> getCardRulesWithAdditionalInfo(MageObject object, Abilities<Ability> rulesSource, Abilities<Ability> hintAbilities) {
        return CardUtil.getCardRulesWithAdditionalInfo(null, object, rulesSource, hintAbilities);
    }

    public static List<String> getCardRulesWithAdditionalInfo(Game game, MageObject object, Abilities<Ability> rulesSource, Abilities<Ability> hintsSource) {
        try {
            List<String> rules = rulesSource.getRules();
            if (game == null || game.getPhase() == null) {
                return rules;
            }
            CardState cardState = game.getState().getCardState(object.getId());
            if (cardState != null) {
                rules.addAll(cardState.getInfo().values());
            }
            ArrayList<String> abilityHints = new ArrayList<String>();
            for (Ability ability : hintsSource) {
                for (Hint hint : ability.getHints()) {
                    String s = hint.getText(game, ability);
                    if (s == null || s.isEmpty()) continue;
                    abilityHints.add(s);
                }
            }
            if (!abilityHints.isEmpty()) {
                rules.add("<br/><hintstart/>");
                HintUtils.appendHints(rules, abilityHints);
            }
            return rules;
        }
        catch (Exception e) {
            logger.error((Object)("Exception in rules generation for object: " + object.getName()), (Throwable)e);
            return RULES_ERROR_INFO;
        }
    }

    public static void takeControlUnderPlayerStart(Game game, Ability source, Player controller, Player playerUnderControl, boolean givePauseForResponse) {
        block2: {
            if (!controller.controlPlayersTurn(game, playerUnderControl.getId(), CardUtil.getSourceLogName(game, source))) {
                return;
            }
            if (!givePauseForResponse) break block2;
            while (controller.canRespond() && !controller.chooseUse(Outcome.Benefit, "You got control of " + playerUnderControl.getLogName() + ". Use switch hands button to view opponent's hand.", null, "Continue", "Wait", null, game)) {
            }
        }
    }

    public static void takeControlUnderPlayerEnd(Game game, Ability source, Player controller, Player playerUnderControl) {
        playerUnderControl.setGameUnderYourControl(game, true, false);
        if (!playerUnderControl.getTurnControlledBy().equals(controller.getId())) {
            game.informPlayers(controller.getLogName() + " return control of the turn to " + playerUnderControl.getLogName() + CardUtil.getSourceLogName(game, source));
            controller.getPlayersUnderYourControl().remove(playerUnderControl.getId());
        }
    }

    public static void makeCardPlayable(Game game, Ability source, Card card, boolean useCastSpellOnly, Duration duration, boolean anyColor) {
        CardUtil.makeCardPlayable(game, source, card, useCastSpellOnly, duration, anyColor, null, null);
    }

    public static void makeCardPlayable(Game game, Ability source, Card card, boolean useCastSpellOnly, Duration duration, boolean anyColor, UUID playerId, Condition condition) {
        UUID objectId = card.getMainCard().getId();
        int zcc = game.getState().getZoneChangeCounter(objectId);
        game.addEffect(new CanPlayCardControllerEffect(game, objectId, zcc, useCastSpellOnly, duration, playerId, condition), source);
        if (anyColor) {
            game.addEffect(new YouMaySpendManaAsAnyColorToCastTargetEffect(duration, playerId, condition).setTargetPointer(new FixedTarget(objectId, zcc)), source);
        }
    }

    public static List<Card> getCastableComponents(Card cardToCast, FilterCard filter, Ability source, Player player, Game game, SpellCastTracker spellCastTracker, boolean playLand) {
        UUID playerId = player.getId();
        ArrayList<Card> cards = new ArrayList<Card>();
        if (cardToCast instanceof CardWithHalves) {
            cards.add(((CardWithHalves)cardToCast).getLeftHalfCard());
            cards.add(((CardWithHalves)cardToCast).getRightHalfCard());
        } else if (cardToCast instanceof CardWithSpellOption) {
            cards.add(cardToCast);
            cards.add(((CardWithSpellOption)cardToCast).getSpellCard());
        } else {
            cards.add(cardToCast);
        }
        cards.removeIf(Objects::isNull);
        if (!(playLand && player.canPlayLand() && game.isActivePlayer(playerId))) {
            cards.removeIf(card -> card.isLand(game));
        }
        if (filter != null) {
            cards.removeIf(card -> !filter.match((Card)card, playerId, source, game));
        }
        if (spellCastTracker != null) {
            cards.removeIf(card -> !spellCastTracker.checkCard((Card)card, game));
        }
        return cards;
    }

    public static boolean castSpellWithAttributesForFree(Player player, Ability source, Game game, Card card) {
        return CardUtil.castSpellWithAttributesForFree(player, source, game, card, StaticFilters.FILTER_CARD);
    }

    public static boolean castSpellWithAttributesForFree(Player player, Ability source, Game game, Card card, FilterCard filter) {
        return CardUtil.castSpellWithAttributesForFree(player, source, game, new CardsImpl(card), filter);
    }

    public static boolean castSpellWithAttributesForFree(Player player, Ability source, Game game, Cards cards, FilterCard filter) {
        return CardUtil.castSpellWithAttributesForFree(player, source, game, cards, filter, null);
    }

    public static boolean castSpellWithAttributesForFree(Player player, Ability source, Game game, Cards cards, FilterCard filter, SpellCastTracker spellCastTracker) {
        return CardUtil.castSpellWithAttributesForFree(player, source, game, cards, filter, spellCastTracker, false);
    }

    public static boolean castSpellWithAttributesForFree(Player player, Ability source, Game game, Cards cards, FilterCard filter, SpellCastTracker spellCastTracker, boolean playLand) {
        Card cardToCast;
        HashMap<UUID, List<Card>> cardMap = new HashMap<UUID, List<Card>>();
        for (Card card2 : cards.getCards(game)) {
            List<Card> castableComponents = CardUtil.getCastableComponents(card2, filter, source, player, game, spellCastTracker, playLand);
            if (castableComponents.isEmpty()) continue;
            cardMap.put(card2.getId(), castableComponents);
        }
        switch (cardMap.size()) {
            case 0: {
                return false;
            }
            case 1: {
                cardToCast = cards.get(cardMap.keySet().stream().findFirst().orElse(null), game);
                break;
            }
            default: {
                CardsImpl castableCards = new CardsImpl((Collection<UUID>)cardMap.keySet());
                TargetCard target = new TargetCard(0, 1, Zone.ALL, defaultFilter);
                target.withNotTarget(true);
                player.choose(Outcome.PlayForFree, castableCards, target, source, game);
                cardToCast = castableCards.get(target.getFirstTarget(), game);
            }
        }
        if (cardToCast == null) {
            return false;
        }
        List partsToCast = (List)cardMap.get(cardToCast.getId());
        String partsInfo = partsToCast.stream().map(MageObject::getLogName).collect(Collectors.joining(" or "));
        if (partsToCast.size() < 1 || !player.chooseUse(Outcome.PlayForFree, "Cast spell without paying its mana cost (" + partsInfo + ")?", source, game)) {
            return false;
        }
        partsToCast.forEach(card -> game.getState().setValue("PlayFromNotOwnHandZone" + card.getId(), Boolean.TRUE));
        ActivatedAbility chosenAbility = playLand ? player.chooseLandOrSpellAbility(cardToCast, game, true) : player.chooseAbilityForCast(cardToCast, game, true);
        boolean result = false;
        if (chosenAbility instanceof SpellAbility) {
            result = player.cast((SpellAbility)chosenAbility, game, true, new ApprovingObject(source, game));
        } else if (playLand && chosenAbility instanceof PlayLandAbility) {
            Card land = game.getCard(chosenAbility.getSourceId());
            result = player.playLand(land, game, true);
        }
        partsToCast.forEach(card -> game.getState().setValue("PlayFromNotOwnHandZone" + card.getId(), null));
        if (result && spellCastTracker != null) {
            spellCastTracker.addCard(cardToCast, source, game);
        }
        if (player.isComputer() && !result) {
            cards.remove(cardToCast);
        }
        return result;
    }

    private static boolean cardsHasCastableParts(Cards cards, FilterCard filter, Ability source, Player player, Game game, SpellCastTracker spellCastTracker, boolean playLand) {
        return cards.getCards(game).stream().anyMatch(card -> !CardUtil.getCastableComponents(card, filter, source, player, game, spellCastTracker, playLand).isEmpty());
    }

    public static void castMultipleWithAttributeForFree(Player player, Ability source, Game game, Cards cards, FilterCard filter) {
        CardUtil.castMultipleWithAttributeForFree(player, source, game, cards, filter, Integer.MAX_VALUE);
    }

    public static void castMultipleWithAttributeForFree(Player player, Ability source, Game game, Cards cards, FilterCard filter, int maxSpells) {
        CardUtil.castMultipleWithAttributeForFree(player, source, game, cards, filter, maxSpells, null);
    }

    public static void castMultipleWithAttributeForFree(Player player, Ability source, Game game, Cards cards, FilterCard filter, int maxSpells, SpellCastTracker spellCastTracker) {
        CardUtil.castMultipleWithAttributeForFree(player, source, game, cards, filter, maxSpells, spellCastTracker, false);
    }

    public static void castMultipleWithAttributeForFree(Player player, Ability source, Game game, Cards cards, FilterCard filter, int maxSpells, SpellCastTracker spellCastTracker, boolean playLand) {
        if (maxSpells == 1) {
            CardUtil.castSpellWithAttributesForFree(player, source, game, cards, filter);
            return;
        }
        int castCount = 0;
        int maxCastCount = Integer.min(cards.size(), maxSpells);
        cards.removeZone(Zone.STACK, game);
        if (!CardUtil.cardsHasCastableParts(cards, filter, source, player, game, spellCastTracker, playLand)) {
            return;
        }
        while (player.canRespond()) {
            boolean wasCast = CardUtil.castSpellWithAttributesForFree(player, source, game, cards, filter, spellCastTracker, playLand);
            cards.removeZone(Zone.STACK, game);
            if (!cards.isEmpty() && CardUtil.cardsHasCastableParts(cards, filter, source, player, game, spellCastTracker, playLand) && !(wasCast ? ++castCount >= maxCastCount : player.isComputer() || !player.chooseUse(Outcome.PlayForFree, "Continue casting spells?", source, game))) continue;
            break;
        }
    }

    public static boolean castSingle(Player player, Ability source, Game game, Card card) {
        return CardUtil.castSingle(player, source, game, card, null);
    }

    public static boolean castSingle(Player player, Ability source, Game game, Card card, ManaCostsImpl<ManaCost> manaCost) {
        return CardUtil.castSingle(player, source, game, card, false, manaCost);
    }

    public static boolean castSingle(Player player, Ability source, Game game, Card card, boolean noMana, ManaCostsImpl<ManaCost> manaCost) {
        SubCard<SplitCard> rightHalfCard;
        SubCard<SplitCard> leftHalfCard;
        SubCard<SplitCard> rightHalfCard2;
        SubCard<SplitCard> leftHalfCard2;
        if (card instanceof SplitCard) {
            leftHalfCard2 = ((SplitCard)card).getLeftHalfCard();
            rightHalfCard2 = ((SplitCard)card).getRightHalfCard();
            if (manaCost != null) {
                Costs<Cost> additionalCostsLeft = leftHalfCard2.getSpellAbility().getCosts();
                Costs<Cost> additionalCostsRight = rightHalfCard2.getSpellAbility().getCosts();
                player.setCastSourceIdWithAlternateMana(leftHalfCard2.getId(), manaCost, additionalCostsLeft, MageIdentifier.Default);
                player.setCastSourceIdWithAlternateMana(rightHalfCard2.getId(), manaCost, additionalCostsRight, MageIdentifier.Default);
            }
            game.getState().setValue("PlayFromNotOwnHandZone" + leftHalfCard2.getId(), Boolean.TRUE);
            game.getState().setValue("PlayFromNotOwnHandZone" + rightHalfCard2.getId(), Boolean.TRUE);
        }
        if (card instanceof ModalDoubleFacedCard) {
            leftHalfCard2 = ((ModalDoubleFacedCard)card).getLeftHalfCard();
            rightHalfCard2 = ((ModalDoubleFacedCard)card).getRightHalfCard();
            if (manaCost != null) {
                if (!leftHalfCard2.isLand(game)) {
                    Costs<Cost> additionalCostsMDFCLeft = leftHalfCard2.getSpellAbility().getCosts();
                    player.setCastSourceIdWithAlternateMana(leftHalfCard2.getId(), manaCost, additionalCostsMDFCLeft, MageIdentifier.Default);
                }
                if (!rightHalfCard2.isLand(game)) {
                    Costs<Cost> additionalCostsMDFCRight = rightHalfCard2.getSpellAbility().getCosts();
                    player.setCastSourceIdWithAlternateMana(rightHalfCard2.getId(), manaCost, additionalCostsMDFCRight, MageIdentifier.Default);
                }
            }
            game.getState().setValue("PlayFromNotOwnHandZone" + leftHalfCard2.getId(), Boolean.TRUE);
            game.getState().setValue("PlayFromNotOwnHandZone" + rightHalfCard2.getId(), Boolean.TRUE);
        }
        if (card instanceof CardWithSpellOption) {
            Card creatureCard = card.getMainCard();
            SpellOptionCard spellCard = ((CardWithSpellOption)card).getSpellCard();
            if (manaCost != null) {
                Costs<Cost> additionalCostsCreature = creatureCard.getSpellAbility().getCosts();
                Costs<Cost> additionalCostsSpellCard = spellCard.getSpellAbility().getCosts();
                player.setCastSourceIdWithAlternateMana(creatureCard.getId(), manaCost, additionalCostsCreature, MageIdentifier.Default);
                player.setCastSourceIdWithAlternateMana(spellCard.getId(), manaCost, additionalCostsSpellCard, MageIdentifier.Default);
            }
            game.getState().setValue("PlayFromNotOwnHandZone" + creatureCard.getId(), Boolean.TRUE);
            game.getState().setValue("PlayFromNotOwnHandZone" + spellCard.getId(), Boolean.TRUE);
        }
        if (manaCost != null) {
            Costs<Cost> additionalCostsNormalCard = card.getSpellAbility().getCosts();
            player.setCastSourceIdWithAlternateMana(card.getMainCard().getId(), manaCost, additionalCostsNormalCard, MageIdentifier.Default);
        }
        game.getState().setValue("PlayFromNotOwnHandZone" + card.getMainCard().getId(), Boolean.TRUE);
        boolean result = player.cast(player.chooseAbilityForCast(card.getMainCard(), game, noMana), game, noMana, new ApprovingObject(source, game));
        if (card instanceof SplitCard) {
            leftHalfCard = ((SplitCard)card).getLeftHalfCard();
            rightHalfCard = ((SplitCard)card).getRightHalfCard();
            game.getState().setValue("PlayFromNotOwnHandZone" + leftHalfCard.getId(), null);
            game.getState().setValue("PlayFromNotOwnHandZone" + rightHalfCard.getId(), null);
        }
        if (card instanceof ModalDoubleFacedCard) {
            leftHalfCard = ((ModalDoubleFacedCard)card).getLeftHalfCard();
            rightHalfCard = ((ModalDoubleFacedCard)card).getRightHalfCard();
            game.getState().setValue("PlayFromNotOwnHandZone" + leftHalfCard.getId(), null);
            game.getState().setValue("PlayFromNotOwnHandZone" + rightHalfCard.getId(), null);
        }
        if (card instanceof CardWithSpellOption) {
            Card creatureCard = card.getMainCard();
            SpellOptionCard spellCard = ((CardWithSpellOption)card).getSpellCard();
            game.getState().setValue("PlayFromNotOwnHandZone" + creatureCard.getId(), null);
            game.getState().setValue("PlayFromNotOwnHandZone" + spellCard.getId(), null);
        }
        game.getState().setValue("PlayFromNotOwnHandZone" + card.getId(), null);
        return result;
    }

    public static boolean tryPayLife(int lifeToPay, Player player, Ability source, Game game) {
        if (lifeToPay == 0) {
            return true;
        }
        if (lifeToPay < 0) {
            return false;
        }
        if (lifeToPay > player.getLife()) {
            return false;
        }
        if (game.replaceEvent(GameEvent.getEvent(GameEvent.EventType.PAY_LIFE, player.getId(), source, player.getId(), lifeToPay))) {
            return true;
        }
        int lostLife = player.loseLife(lifeToPay, game, source, false);
        if (lostLife > 0) {
            game.fireEvent(GameEvent.getEvent(GameEvent.EventType.LIFE_PAID, player.getId(), source, player.getId(), lostLife));
            return true;
        }
        return false;
    }

    public static String getSourceName(Game game, Ability source) {
        MageObject sourceObject = source.getSourceObject(game);
        return sourceObject != null ? sourceObject.getName() : "";
    }

    public static String getSourceIdName(Game game, Ability source) {
        MageObject sourceObject = source.getSourceObject(game);
        return sourceObject != null ? sourceObject.getIdName() : "";
    }

    public static String getSourceLogName(Game game, String namePrefix, UUID sourceId, String namePostfix, String nonFoundText) {
        MageObject sourceObject = game.getObject(sourceId);
        return sourceObject == null ? nonFoundText : namePrefix + sourceObject.getLogName() + namePostfix;
    }

    public static String getSourceLogName(Game game, String namePrefix, Ability source, String namePostfix, String nonFoundText) {
        return CardUtil.getSourceLogName(game, namePrefix, source == null ? null : source.getSourceId(), namePostfix, nonFoundText);
    }

    public static String getSourceLogName(Game game, Ability source) {
        return CardUtil.getSourceLogName(game, " (source: ", source, ")", "");
    }

    public static String getSourceLogName(Game game, Ability source, UUID ignoreSourceId) {
        if (ignoreSourceId != null && source != null && ignoreSourceId.equals(source.getSourceId())) {
            return "";
        }
        return CardUtil.getSourceLogName(game, " (source: ", source, ")", "");
    }

    public static int getActualSourceObjectZoneChangeCounter(Game game, Ability source) {
        int zcc = source.getStackMomentSourceZCC();
        if (zcc == 0) {
            zcc = game.getState().getZoneChangeCounter(source.getSourceId());
        }
        return zcc;
    }

    public static MageObjectReference getSourceStackMomentReference(Game game, Ability ability) {
        MageObject sourceObject = ability.getSourceObject(game);
        Zone sourceObjectZone = game.getState().getZone(sourceObject.getId());
        int zcc = CardUtil.getActualSourceObjectZoneChangeCounter(game, ability);
        if (sourceObjectZone != Zone.STACK) {
            --zcc;
        }
        return new MageObjectReference(ability.getSourceId(), zcc, game);
    }

    public static Map<String, Object> getSourceCostsTagsMap(Game game, Ability source) {
        if (game == null) {
            return null;
        }
        Map<String, Object> costTags = source.getCostsTagMap();
        if (costTags != null) {
            return costTags;
        }
        Permanent permanent = source.getSourcePermanentOrLKI(game);
        if (permanent != null) {
            costTags = game.getPermanentCostsTags().get(CardUtil.getSourceStackMomentReference(game, source));
            return costTags;
        }
        Spell sourceObject = game.getSpellOrLKIStack(source.getSourceId());
        if (sourceObject != null) {
            return sourceObject.getSpellAbility().getCostsTagMap();
        }
        return null;
    }

    public static boolean checkSourceCostsTagExists(Game game, Ability source, String tag) {
        Map<String, Object> costTags = CardUtil.getSourceCostsTagsMap(game, source);
        return costTags != null && costTags.containsKey(tag);
    }

    public static <T> T getSourceCostsTag(Game game, Ability source, String tag, T defaultValue) {
        Map<String, Object> costTags = CardUtil.getSourceCostsTagsMap(game, source);
        if (costTags != null) {
            Object value = costTags.getOrDefault(tag, defaultValue);
            if (value == null) {
                throw new IllegalStateException("Wrong code usage: Costs tag " + tag + " has value stored of type null but is trying to be read. Use checkSourceCostsTagExists");
            }
            if (defaultValue != null && value.getClass() != defaultValue.getClass()) {
                throw new IllegalStateException("Wrong code usage: Costs tag " + tag + " has value stored of type " + value.getClass().getName() + " different from default of type " + defaultValue.getClass().getName());
            }
            return (T)value;
        }
        return defaultValue;
    }

    public static int getSourceCostsTagX(Game game, Ability source, int defaultValue) {
        return CardUtil.getSourceCostsTag(game, source, "X", defaultValue);
    }

    public static String addCostVerb(String text) {
        if (costWords.stream().anyMatch(text.toLowerCase(Locale.ENGLISH)::startsWith)) {
            return text;
        }
        return "pay " + text;
    }

    private static boolean isImmutableObject(Object o) {
        return o == null || o instanceof Number || o instanceof Boolean || o instanceof String || o instanceof MageObjectReference || o instanceof UUID || o instanceof Enum;
    }

    public static <T> T deepCopyObject(T value) {
        if (CardUtil.isImmutableObject(value)) {
            return value;
        }
        if (value instanceof Copyable) {
            return ((Copyable)value).copy();
        }
        if (value instanceof Watcher) {
            return ((Watcher)value).copy();
        }
        if (value instanceof Ability) {
            return (T)((Ability)value).copy();
        }
        if (value instanceof PlayerList) {
            return (T)((PlayerList)value).copy();
        }
        if (value instanceof EnumSet) {
            return (T)((EnumSet)value).clone();
        }
        if (value instanceof EnumMap) {
            return (T)CardUtil.deepCopyEnumMap((EnumMap)value);
        }
        if (value instanceof LinkedHashSet) {
            return (T)CardUtil.deepCopyLinkedHashSet((LinkedHashSet)value);
        }
        if (value instanceof LinkedHashMap) {
            return (T)CardUtil.deepCopyLinkedHashMap((LinkedHashMap)value);
        }
        if (value instanceof TreeSet) {
            return (T)CardUtil.deepCopyTreeSet((TreeSet)value);
        }
        if (value instanceof HashSet) {
            return (T)CardUtil.deepCopyHashSet((HashSet)value);
        }
        if (value instanceof HashMap) {
            return (T)CardUtil.deepCopyHashMap((HashMap)value);
        }
        if (value instanceof List) {
            return (T)CardUtil.deepCopyList((List)value);
        }
        if (value instanceof AbstractMap.SimpleImmutableEntry) {
            AbstractMap.SimpleImmutableEntry entryValue = (AbstractMap.SimpleImmutableEntry)value;
            return (T)new AbstractMap.SimpleImmutableEntry(CardUtil.deepCopyObject(entryValue.getKey()), CardUtil.deepCopyObject(entryValue.getValue()));
        }
        throw new IllegalStateException("Unhandled object " + value.getClass().getSimpleName() + " during deep copy, must add explicit handling of all Object types");
    }

    private static <T extends Comparable<T>> TreeSet<T> deepCopyTreeSet(TreeSet<T> original) {
        if (original.getClass() != TreeSet.class) {
            throw new IllegalStateException("Unhandled TreeSet type " + original.getClass().getSimpleName() + " in deep copy");
        }
        TreeSet<Comparable> newSet = new TreeSet<Comparable>();
        for (Comparable value : original) {
            newSet.add(CardUtil.deepCopyObject(value));
        }
        return newSet;
    }

    private static <T> HashSet<T> deepCopyHashSet(Set<T> original) {
        if (original.getClass() != HashSet.class) {
            throw new IllegalStateException("Unhandled HashSet type " + original.getClass().getSimpleName() + " in deep copy");
        }
        HashSet<T> newSet = new HashSet<T>(original.size());
        for (T value : original) {
            newSet.add(CardUtil.deepCopyObject(value));
        }
        return newSet;
    }

    private static <T> LinkedHashSet<T> deepCopyLinkedHashSet(LinkedHashSet<T> original) {
        if (original.getClass() != LinkedHashSet.class) {
            throw new IllegalStateException("Unhandled LinkedHashSet type " + original.getClass().getSimpleName() + " in deep copy");
        }
        LinkedHashSet newSet = new LinkedHashSet(original.size());
        for (Object value : original) {
            newSet.add(CardUtil.deepCopyObject(value));
        }
        return newSet;
    }

    private static <T> List<T> deepCopyList(List<T> original) {
        if (original.getClass() != ArrayList.class) {
            throw new IllegalStateException("Unhandled List type " + original.getClass().getSimpleName() + " in deep copy");
        }
        ArrayList<T> newList = new ArrayList<T>(original.size());
        for (T value : original) {
            newList.add(CardUtil.deepCopyObject(value));
        }
        return newList;
    }

    private static <K, V> HashMap<K, V> deepCopyHashMap(Map<K, V> original) {
        if (original.getClass() != HashMap.class) {
            throw new IllegalStateException("Unhandled HashMap type " + original.getClass().getSimpleName() + " in deep copy");
        }
        HashMap<K, V> newMap = new HashMap<K, V>(original.size());
        for (Map.Entry<K, V> entry : original.entrySet()) {
            newMap.put(CardUtil.deepCopyObject(entry.getKey()), CardUtil.deepCopyObject(entry.getValue()));
        }
        return newMap;
    }

    private static <K, V> LinkedHashMap<K, V> deepCopyLinkedHashMap(Map<K, V> original) {
        if (original.getClass() != LinkedHashMap.class) {
            throw new IllegalStateException("Unhandled LinkedHashMap type " + original.getClass().getSimpleName() + " in deep copy");
        }
        LinkedHashMap<K, V> newMap = new LinkedHashMap<K, V>(original.size());
        for (Map.Entry<K, V> entry : original.entrySet()) {
            newMap.put(CardUtil.deepCopyObject(entry.getKey()), CardUtil.deepCopyObject(entry.getValue()));
        }
        return newMap;
    }

    private static <K extends Enum<K>, V> EnumMap<K, V> deepCopyEnumMap(Map<K, V> original) {
        if (original.getClass() != EnumMap.class) {
            throw new IllegalStateException("Unhandled EnumMap type " + original.getClass().getSimpleName() + " in deep copy");
        }
        EnumMap<K, V> newMap = new EnumMap<K, V>(original);
        for (Map.Entry<K, V> entry : newMap.entrySet()) {
            entry.setValue(CardUtil.deepCopyObject(entry.getValue()));
        }
        return newMap;
    }

    public static Set<UUID> getObjectParts(MageObject object) {
        LinkedHashSet<UUID> res = new LinkedHashSet<UUID>();
        List<MageObject> allParts = CardUtil.getObjectPartsAsObjects(object);
        allParts.forEach(part -> res.add(part.getId()));
        return res;
    }

    public static List<MageObject> getObjectPartsAsObjects(MageObject object) {
        ArrayList<MageObject> res = new ArrayList<MageObject>();
        if (object == null) {
            return res;
        }
        if (object instanceof SplitCard || object instanceof SplitCardHalf) {
            SplitCard mainCard = (SplitCard)((Card)object).getMainCard();
            res.add(mainCard);
            res.add(mainCard.getLeftHalfCard());
            res.add(mainCard.getRightHalfCard());
        } else if (object instanceof ModalDoubleFacedCard || object instanceof ModalDoubleFacedCardHalf) {
            ModalDoubleFacedCard mainCard = (ModalDoubleFacedCard)((Card)object).getMainCard();
            res.add(mainCard);
            res.add(mainCard.getLeftHalfCard());
            res.add(mainCard.getRightHalfCard());
        } else if (object instanceof CardWithSpellOption || object instanceof SpellOptionCard) {
            CardWithSpellOption mainCard = (CardWithSpellOption)((Card)object).getMainCard();
            res.add(mainCard);
            res.add(mainCard.getSpellCard());
        } else if (object instanceof Spell) {
            res.add(object);
            res.addAll(CardUtil.getObjectPartsAsObjects(((Spell)object).getCard()));
        } else if (object instanceof Commander) {
            res.add(object);
            res.addAll(CardUtil.getObjectPartsAsObjects(((Commander)object).getSourceObject()));
        } else {
            res.add(object);
        }
        return res;
    }

    public static int parseIntWithDefault(String value, int defaultValue) {
        int res;
        try {
            res = Integer.parseInt(value);
        }
        catch (NumberFormatException ex) {
            res = defaultValue;
        }
        return res;
    }

    public static Map<UUID, MageObject> getOriginalToCopiedPartsMap(Card originalCard, Card copiedCard) {
        ArrayList<UUID> oldIds = new ArrayList<UUID>(CardUtil.getObjectParts(originalCard));
        ArrayList<MageObject> newObjects = new ArrayList<MageObject>(CardUtil.getObjectPartsAsObjects(copiedCard));
        if (oldIds.size() != newObjects.size()) {
            throw new IllegalStateException("Found wrong card parts after copy: " + originalCard.getName() + " -> " + copiedCard.getName());
        }
        HashMap<UUID, MageObject> mapOldToNew = new HashMap<UUID, MageObject>();
        for (int i = 0; i < oldIds.size(); ++i) {
            mapOldToNew.put((UUID)oldIds.get(i), (MageObject)newObjects.get(i));
        }
        return mapOldToNew;
    }

    public static String getTurnInfo(Game game) {
        return CardUtil.getTurnInfo(game == null ? null : game.getState());
    }

    public static String getTurnInfo(GameState gameState) {
        if (gameState == null) {
            return null;
        }
        if (gameState.getTurn().getStep() == null) {
            return "T" + gameState.getTurnNum();
        }
        return "T" + gameState.getTurnNum() + "." + gameState.getTurn().getStep().getType().getStepShortText();
    }

    public static String concatWithOr(List<String> strings) {
        return CardUtil.concatWith(strings, "or");
    }

    public static String concatWithAnd(List<String> strings) {
        return CardUtil.concatWith(strings, "and");
    }

    private static String concatWith(List<String> strings, String last) {
        switch (strings.size()) {
            case 0: {
                return "";
            }
            case 1: {
                return strings.get(0);
            }
            case 2: {
                return strings.get(0) + " " + last + " " + strings.get(1);
            }
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < strings.size(); ++i) {
            sb.append(strings.get(i));
            if (i == strings.size() - 1) break;
            sb.append(", ");
            if (i != strings.size() - 2) continue;
            sb.append(last);
            sb.append(' ');
        }
        return sb.toString();
    }

    public static <T> Optional<T> getEffectValueFromAbility(Ability ability, String key, Class<T> clazz) {
        return CardUtil.castStream(ability.getAllEffects().stream().map(effect -> effect.getValue(key)), clazz).findFirst();
    }

    public static <T> Stream<T> castStream(Collection<?> collection, Class<T> clazz) {
        return CardUtil.castStream(collection.stream(), clazz);
    }

    public static <T> Stream<T> castStream(Stream<?> stream, Class<T> clazz) {
        return stream.filter(clazz::isInstance).map(clazz::cast).filter(Objects::nonNull);
    }

    public static <T> boolean checkAnyPairs(Collection<T> collection, BiPredicate<T, T> predicate) {
        return CardUtil.streamPairsWithMap(collection, (t1, t2) -> predicate.test(t1, t2)).anyMatch(x -> x);
    }

    public static <T> Stream<T> streamAllPairwiseMatches(Collection<T> collection, BiPredicate<T, T> predicate) {
        return CardUtil.streamPairsWithMap(collection, (t1, t2) -> predicate.test(t1, t2) ? Stream.of(t1, t2) : Stream.empty()).flatMap(Function.identity()).distinct();
    }

    public static <T, U> Stream<U> streamPairsWithMap(Collection<T> collection, BiFunction<T, T, U> function) {
        if (collection.size() < 2) {
            return Stream.empty();
        }
        ArrayList list = collection instanceof List ? (ArrayList)collection : new ArrayList(collection);
        IntPairIterator it = new IntPairIterator(list.size());
        return Stream.generate(it::next).limit(it.getMax()).map(pair -> function.apply(list.get((Integer)pair.getKey()), list.get((Integer)pair.getValue())));
    }

    public static void AssertNoControllerOwnerPredicates(Target target) {
        ArrayList<Predicate> list = new ArrayList<Predicate>();
        Predicates.collectAllComponents(target.getFilter().getPredicates(), target.getFilter().getExtraPredicates(), list);
        if (list.stream().anyMatch(p -> p instanceof TargetController.ControllerPredicate || p instanceof TargetController.OwnerPredicate || p instanceof OwnerIdPredicate || p instanceof ControllerIdPredicate)) {
            throw new IllegalArgumentException("Wrong code usage: target adjuster will add controller/owner predicate, but target's filter already has one - " + target);
        }
    }

    public static boolean moveCardWithCounter(Game game, Ability source, Player controller, Card card, Zone toZone, Counter counter) {
        if (toZone == Zone.BATTLEFIELD) {
            throw new IllegalArgumentException("Wrong code usage - method doesn't support moving to battlefield zone");
        }
        if (!controller.moveCards(card, toZone, source, game)) {
            return false;
        }
        AddCountersTargetEffect effect = new AddCountersTargetEffect(counter);
        effect.setTargetPointer(new FixedTarget(card.getMainCard(), game));
        effect.apply(game, source);
        return true;
    }

    public static <T> int setOrIncrementValue(T u, Integer i) {
        return i == null ? 1 : Integer.sum(i, 1);
    }

    public static String convertLoyaltyOrDefense(int value) {
        switch (value) {
            case -2: {
                return "X";
            }
            case -1: {
                return "";
            }
        }
        return "" + value;
    }

    public static int convertLoyaltyOrDefense(String value) {
        switch (value) {
            case "X": {
                return -2;
            }
            case "": {
                return -1;
            }
        }
        return Integer.parseInt(value);
    }

    public static void checkSetParamForSerializationCompatibility(Set<String> data) {
        if (data != null && data.getClass().getName().endsWith("$KeySet")) {
            throw new IllegalArgumentException("Can't use KeySet as param, use new LinkedHashSet<>(data.keySet()) instead");
        }
    }

    public static String substring(String str, int maxLength) {
        return CardUtil.substring(str, maxLength, "");
    }

    public static String substring(String str, int maxLength, String overflowEnding) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        if (str.length() <= maxLength) {
            return str;
        }
        if (maxLength <= overflowEnding.length()) {
            return overflowEnding.substring(0, maxLength);
        }
        return (str + overflowEnding).substring(0, maxLength - overflowEnding.length()) + overflowEnding;
    }

    public static void copySetAndCardNumber(MageObject targetObject, MageObject copyFromObject) {
        boolean needUsesVariousArt = false;
        String needSetCode = copyFromObject.getExpansionSetCode();
        String needCardNumber = copyFromObject.getCardNumber();
        String needImageFileName = copyFromObject.getImageFileName();
        int needImageNumber = copyFromObject.getImageNumber();
        needUsesVariousArt = copyFromObject.getUsesVariousArt();
        if (targetObject instanceof Permanent) {
            CardUtil.copySetAndCardNumber((Permanent)targetObject, needSetCode, needCardNumber, needImageFileName, (Integer)needImageNumber, needUsesVariousArt);
        } else if (targetObject instanceof Token) {
            CardUtil.copySetAndCardNumber((Token)targetObject, needSetCode, needCardNumber, needImageFileName, (Integer)needImageNumber, needUsesVariousArt);
        } else if (targetObject instanceof Card) {
            CardUtil.copySetAndCardNumber((Card)targetObject, needSetCode, needCardNumber, needImageFileName, (Integer)needImageNumber, needUsesVariousArt);
        } else {
            throw new IllegalStateException("Unsupported target object class: " + targetObject.getClass().getSimpleName());
        }
    }

    private static void copySetAndCardNumber(Permanent targetPermanent, String newSetCode, String newCardNumber, String newImageFileName, Integer newImageNumber, boolean usesVariousArt) {
        if (!(targetPermanent instanceof PermanentCard) && !(targetPermanent instanceof PermanentToken)) {
            throw new IllegalArgumentException("Wrong code usage: un-supported target permanent type: " + targetPermanent.getClass().getSimpleName());
        }
        targetPermanent.setExpansionSetCode(newSetCode);
        targetPermanent.setUsesVariousArt(usesVariousArt);
        targetPermanent.setCardNumber(newCardNumber);
        targetPermanent.setImageFileName(newImageFileName);
        targetPermanent.setImageNumber(newImageNumber);
    }

    private static void copySetAndCardNumber(Token targetToken, String newSetCode, String newCardNumber, String newImageFileName, Integer newImageNumber, boolean newUsesVariousArt) {
        targetToken.setExpansionSetCode(newSetCode);
        targetToken.setCardNumber(newCardNumber);
        targetToken.setImageFileName(newImageFileName);
        targetToken.setImageNumber(newImageNumber);
        if (newUsesVariousArt && newCardNumber.isEmpty()) {
            throw new IllegalArgumentException("Wrong code usage: usesVariousArt can be used for token from card only");
        }
        targetToken.setUsesVariousArt(newUsesVariousArt);
    }

    private static void copySetAndCardNumber(Card targetCard, String newSetCode, String newCardNumber, String newImageFileName, Integer newImageNumber, boolean usesVariousArt) {
        targetCard.setExpansionSetCode(newSetCode);
        targetCard.setUsesVariousArt(usesVariousArt);
        targetCard.setCardNumber(newCardNumber);
        targetCard.setImageFileName(newImageFileName);
        targetCard.setImageNumber(newImageNumber);
    }

    public static Set<UUID> getEventTargets(GameEvent event) {
        HashSet<UUID> res = new HashSet<UUID>();
        if (event instanceof BatchEvent) {
            res.addAll(((BatchEvent)event).getTargetIds());
        } else if (event != null && event.getTargetId() != null) {
            res.add(event.getTargetId());
        }
        return res;
    }

    public static String getCardNameForGUI(String name, String imageFileName) {
        if (imageFileName.isEmpty()) {
            return name;
        }
        return imageFileName + (name.isEmpty() ? "" : ": " + name);
    }

    public static boolean canShowAsControlled(Card card, UUID createdForPlayer) {
        return card.getControllerOrOwnerId().equals(createdForPlayer);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isInformationAbility(Ability ability) {
        if (ability.getEffects().isEmpty()) return false;
        if (!ability.getEffects().stream().allMatch(InfoEffect.class::isInstance)) return false;
        return true;
    }

    private static class IntPairIterator
    implements Iterator<AbstractMap.SimpleImmutableEntry<Integer, Integer>> {
        private final int amount;
        private int firstCounter = 0;
        private int secondCounter = 1;

        IntPairIterator(int amount) {
            this.amount = amount;
        }

        @Override
        public boolean hasNext() {
            return this.firstCounter + 1 < this.amount;
        }

        @Override
        public AbstractMap.SimpleImmutableEntry<Integer, Integer> next() {
            AbstractMap.SimpleImmutableEntry<Integer, Integer> value = new AbstractMap.SimpleImmutableEntry<Integer, Integer>(this.firstCounter, this.secondCounter);
            ++this.secondCounter;
            if (this.secondCounter == this.amount) {
                ++this.firstCounter;
                this.secondCounter = this.firstCounter + 1;
            }
            return value;
        }

        public int getMax() {
            return (this.amount * this.amount - this.amount) / 2;
        }
    }

    public static interface SpellCastTracker {
        public boolean checkCard(Card var1, Game var2);

        public void addCard(Card var1, Ability var2, Game var3);
    }
}

