/*
 * Decompiled with CFR 0.152.
 */
package mage.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import mage.util.CardUtil;

public final class ClassScanner {
    private static void checkClassForInclusion(List<Class> cards, Class type, String name, ClassLoader cl) {
        try {
            Class<?> clazz = Class.forName(name, true, cl);
            if (clazz.getEnclosingClass() == null && type.isAssignableFrom(clazz)) {
                cards.add(clazz);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public static List<Class> findClasses(ClassLoader classLoader, List<String> packages, Class<?> type) {
        ArrayList<Class> cards = new ArrayList<Class>();
        try {
            if (classLoader == null) {
                classLoader = Thread.currentThread().getContextClassLoader();
            }
            assert (classLoader != null);
            HashMap<String, String> dirs = new HashMap<String, String>();
            TreeSet<String> jars = new TreeSet<String>();
            for (String string : packages) {
                String path = string.replace('.', '/');
                Enumeration<URL> resources = classLoader.getResources(path);
                while (resources.hasMoreElements()) {
                    URL resource = resources.nextElement();
                    String filePath = resource.getFile();
                    if (filePath.startsWith("file:")) {
                        filePath = filePath.substring("file:".length(), filePath.lastIndexOf(33));
                        jars.add(filePath);
                        continue;
                    }
                    try {
                        filePath = resource.toURI().getPath();
                    }
                    catch (URISyntaxException e) {
                        throw new RuntimeException(e);
                    }
                    dirs.put(filePath, string);
                }
            }
            for (Map.Entry entry : dirs.entrySet()) {
                cards.addAll(ClassScanner.findClasses(classLoader, new File((String)entry.getKey()), (String)entry.getValue(), type));
            }
            for (String string : jars) {
                File file = new File(CardUtil.urlDecode(string));
                cards.addAll(ClassScanner.findClassesInJar(classLoader, file, packages, type));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return cards;
    }

    private static List<Class> findClasses(ClassLoader classLoader, File directory, String packageName, Class<?> type) {
        ArrayList<Class> cards = new ArrayList<Class>();
        if (directory == null || !directory.exists()) {
            return cards;
        }
        for (File file : directory.listFiles()) {
            if (!file.getName().endsWith(".class")) continue;
            String name = packageName + '.' + file.getName().substring(0, file.getName().length() - 6);
            ClassScanner.checkClassForInclusion(cards, type, name, classLoader);
        }
        return cards;
    }

    private static List<Class> findClassesInJar(ClassLoader classLoader, File file, List<String> packages, Class<?> type) {
        ArrayList<Class> cards = new ArrayList<Class>();
        if (!file.exists()) {
            return cards;
        }
        try (JarInputStream jarFile = new JarInputStream(new FileInputStream(file));){
            JarEntry jarEntry;
            while ((jarEntry = jarFile.getNextJarEntry()) != null) {
                String className;
                int packageNameEnd;
                String packageName;
                if (!jarEntry.getName().endsWith(".class") || !packages.contains(packageName = (packageNameEnd = (className = jarEntry.getName().replace(".class", "").replace('/', '.')).lastIndexOf(46)) != -1 ? className.substring(0, packageNameEnd) : "")) continue;
                ClassScanner.checkClassForInclusion(cards, type, className, classLoader);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return cards;
    }
}

