/*
 * Decompiled with CFR 0.152.
 */
package mage.util;

import java.util.Map;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.EntersBattlefieldEffect;
import mage.abilities.keyword.PhasingAbility;
import mage.cards.Card;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

public class FuzzyTestsUtil {
    public static boolean ADD_RANDOM_PHASED_OUT_PERMANENTS = false;

    public static void addRandomPhasedOutPermanent(Permanent originalPermanent, Ability source, Game game) {
        if (!ADD_RANDOM_PHASED_OUT_PERMANENTS) {
            return;
        }
        Player samplePlayer = game.getPlayers().values().stream().findFirst().orElse(null);
        if (samplePlayer == null || !samplePlayer.isTestMode()) {
            return;
        }
        Card originalCardSide = game.getCard(originalPermanent.getId());
        Card originalCardMain = originalCardSide.getMainCard();
        if (!originalCardMain.hasAbility(PhasingAbility.getInstance(), game)) {
            boolean canCreate = true;
            Card doppelgangerCardMain = game.copyCard(originalCardMain, source, originalPermanent.getControllerId());
            Map<UUID, MageObject> mapOldToNew = CardUtil.getOriginalToCopiedPartsMap(originalCardMain, doppelgangerCardMain);
            Card doppelgangerCardSide = mapOldToNew.getOrDefault(originalCardSide.getId(), null);
            doppelgangerCardSide.addAbility(PhasingAbility.getInstance());
            doppelgangerCardSide.getAbilities().removeIf(a -> a.getEffects().stream().anyMatch(e -> e instanceof EntersBattlefieldEffect));
            if (doppelgangerCardSide.hasSubtype(SubType.AURA, game)) {
                canCreate = false;
            }
            if (canCreate) {
                doppelgangerCardSide.putOntoBattlefield(game, Zone.BATTLEFIELD, source, originalPermanent.getControllerId());
                Permanent doppelgangerPerm = CardUtil.getPermanentFromCardPutToBattlefield(doppelgangerCardSide, game);
                doppelgangerPerm.phaseOut(game, true);
            }
        }
    }

    static {
        String val = System.getProperty("xmage.tests.addRandomPhasedOutPermanents");
        if (val != null) {
            ADD_RANDOM_PHASED_OUT_PERMANENTS = Boolean.parseBoolean(val);
        }
    }
}

