/*
 * Decompiled with CFR 0.152.
 */
package mage.util;

import java.util.Iterator;
import java.util.Objects;
import java.util.UUID;
import mage.abilities.Mode;
import mage.abilities.Modes;
import mage.abilities.SpellAbility;
import mage.cards.Card;
import mage.game.stack.Spell;
import mage.target.Target;

public class TargetAddress {
    protected final int spellAbilityIndex;
    protected final UUID mode;
    protected final int targetIndex;

    public TargetAddress(int spellAbilityIndex, UUID mode, int targetIndex) {
        this.spellAbilityIndex = spellAbilityIndex;
        this.mode = mode;
        this.targetIndex = targetIndex;
    }

    public static Iterable<TargetAddress> walk(Card card) {
        return new TargetAddressIterable(card);
    }

    public Target getTarget(Spell spell) {
        return (Target)this.getMode(spell).getTargets().get(this.targetIndex);
    }

    public Target getTarget(Card card) {
        return (Target)this.getMode(card).getTargets().get(this.targetIndex);
    }

    public Mode getMode(Spell spell) {
        return this.getSpellAbility(spell).getModes().get(this.mode);
    }

    public Mode getMode(Card card) {
        return this.getSpellAbility(card).getModes().get(this.mode);
    }

    public SpellAbility getSpellAbility(Spell spell) {
        return spell.getSpellAbilities().get(this.spellAbilityIndex);
    }

    public SpellAbility getSpellAbility(Card card) {
        if (this.spellAbilityIndex > 0) {
            throw new IndexOutOfBoundsException("SpellAbility index " + this.spellAbilityIndex + " is out of bounds.");
        }
        return card.getSpellAbility();
    }

    public boolean equals(TargetAddress other) {
        return this.spellAbilityIndex == other.spellAbilityIndex && this.mode.equals(other.mode) && this.targetIndex == other.targetIndex;
    }

    public int hashCode() {
        return this.spellAbilityIndex ^ this.mode.hashCode() ^ this.targetIndex;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TargetAddress other = (TargetAddress)obj;
        if (this.spellAbilityIndex != other.spellAbilityIndex) {
            return false;
        }
        if (this.targetIndex != other.targetIndex) {
            return false;
        }
        return Objects.equals(this.mode, other.mode);
    }

    protected static class TargetAddressIterator
    implements Iterator<TargetAddress> {
        protected final Iterator<SpellAbility> spellAbilityIterator;
        protected Integer lastSpellAbilityIndex = null;
        protected Iterator<UUID> modeIterator = null;
        protected Modes modes = null;
        protected UUID lastMode = null;
        protected Iterator<Target> targetIterator = null;
        protected Integer lastTargetIndex = null;

        public TargetAddressIterator(Spell spell) {
            this.spellAbilityIterator = spell.getSpellAbilities().iterator();
            this.calcNext();
        }

        public TargetAddressIterator(Card card) {
            this.lastSpellAbilityIndex = 0;
            this.spellAbilityIterator = null;
            this.modes = card.getSpellAbility().getModes();
            this.modeIterator = this.modes.getSelectedModes().iterator();
            this.calcNext();
        }

        @Override
        public boolean hasNext() {
            return this.lastTargetIndex != null;
        }

        @Override
        public TargetAddress next() {
            TargetAddress ret = new TargetAddress(this.lastSpellAbilityIndex, this.lastMode, this.lastTargetIndex);
            this.calcNext();
            return ret;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        protected void calcNext() {
            Integer n;
            Integer n2;
            if (this.targetIterator == null) {
                if (this.modeIterator == null) {
                    if (this.spellAbilityIterator != null && this.spellAbilityIterator.hasNext()) {
                        if (this.lastSpellAbilityIndex == null) {
                            this.lastSpellAbilityIndex = 0;
                        } else {
                            n2 = this.lastSpellAbilityIndex;
                            n = this.lastSpellAbilityIndex = Integer.valueOf(this.lastSpellAbilityIndex + 1);
                        }
                        this.modes = this.spellAbilityIterator.next().getModes();
                        this.modeIterator = this.modes.getSelectedModes().iterator();
                    } else {
                        this.lastSpellAbilityIndex = null;
                        return;
                    }
                }
                if (this.modeIterator != null && this.modeIterator.hasNext()) {
                    this.lastMode = this.modeIterator.next();
                    this.targetIterator = this.modes.get(this.lastMode).getTargets().iterator();
                } else {
                    this.lastMode = null;
                    this.modes = null;
                    this.modeIterator = null;
                    this.calcNext();
                }
            }
            if (this.targetIterator != null && this.targetIterator.hasNext()) {
                if (this.lastTargetIndex == null) {
                    this.lastTargetIndex = 0;
                } else {
                    n2 = this.lastTargetIndex;
                    n = this.lastTargetIndex = Integer.valueOf(this.lastTargetIndex + 1);
                }
                this.targetIterator.next();
            } else {
                this.targetIterator = null;
                this.lastTargetIndex = null;
                this.calcNext();
            }
        }
    }

    protected static class TargetAddressIterable
    implements Iterable<TargetAddress> {
        protected final Card card;

        public TargetAddressIterable(Card card) {
            this.card = card;
        }

        @Override
        public Iterator<TargetAddress> iterator() {
            return new TargetAddressIterator(this.card);
        }
    }
}

