/*
 * Decompiled with CFR 0.152.
 */
package mage.util;

import com.google.common.base.Throwables;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.swing.SwingUtilities;

public final class ThreadUtils {
    public static final String THREAD_PREFIX_GAME = "GAME";
    public static final String THREAD_PREFIX_AI_SIMULATION_MAD = "AI-SIM-MAD";
    public static final String THREAD_PREFIX_AI_SIMULATION_MCTS = "AI-SIM-MCTS";
    public static final String THREAD_PREFIX_CALL_REQUEST = "CALL";
    public static final String THREAD_PREFIX_TOURNEY = "TOURNEY";
    public static final String THREAD_PREFIX_TOURNEY_DRAFT = "TOURNEY DRAFT";
    public static final String THREAD_PREFIX_TOURNEY_BOOSTERS_SEND = "TOURNEY BOOSTERS SEND";
    public static final String THREAD_PREFIX_GAME_JOIN_WAITING = "XMAGE game join waiting";
    public static final String THREAD_PREFIX_SERVICE_HEALTH = "XMAGE service health";
    public static final String THREAD_PREFIX_SERVICE_USERS_LIST_REFRESH = "XMAGE users list refresh";
    public static final String THREAD_PREFIX_SERVICE_CONNECTION_EXPIRED_CHECK = "XMAGE connection expired check";
    public static final String THREAD_PREFIX_SERVICE_LOBBY_REFRESH = "XMAGE lobby refresh";
    public static final String THREAD_PREFIX_SERVICE_NEWS_REFRESH = "XMAGE news refresh";
    public static final String THREAD_PREFIX_TIMEOUT = "XMAGE timeout";
    public static final String THREAD_PREFIX_TIMEOUT_IDLE = "XMAGE timeout_idle";
    public static final String THREAD_PREFIX_CLIENT_SYMBOLS_DOWNLOADER = "XMAGE symbols downloader";
    public static final String THREAD_PREFIX_CLIENT_IMAGES_DOWNLOADER = "XMAGE images downloader";
    public static final String THREAD_PREFIX_CLIENT_PING_SENDER = "XMAGE ping sender";
    public static final String THREAD_PREFIX_CLIENT_SUBMIT_TIMER = "XMAGE submit timer";
    public static final String THREAD_PREFIX_CLIENT_AUTO_CLOSE_TIMER = "XMAGE auto-close timer";
    public static final String THREAD_PREFIX_TESTS_AI_VS_AI_GAMES = "XMAGE tests ai vs ai";

    public static void sleep(int millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void wait(Object lock) {
        Object object = lock;
        synchronized (object) {
            try {
                lock.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public static Throwable findRunnableException(Runnable r, Throwable t) {
        if (t == null && r instanceof Future) {
            try {
                Object v = ((Future)((Object)r)).get();
            }
            catch (CancellationException ce) {
                t = ce;
            }
            catch (ExecutionException ee) {
                t = ee.getCause();
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
        }
        return t;
    }

    public static Throwable findRootException(Throwable t) {
        return Throwables.getRootCause((Throwable)t);
    }

    public static void ensureRunInGameThread() {
        if (!ThreadUtils.isRunGameThread()) {
            throw new IllegalArgumentException("Wrong code usage: game related code must run in GAME thread, but it used in " + Thread.currentThread().getName(), new Throwable());
        }
    }

    public static boolean isRunGameThread() {
        String name = Thread.currentThread().getName();
        if (name.startsWith(THREAD_PREFIX_GAME)) {
            return true;
        }
        if (name.startsWith(THREAD_PREFIX_AI_SIMULATION_MAD)) {
            return true;
        }
        return name.equals("main");
    }

    public static void ensureRunInCallThread() {
        String name = Thread.currentThread().getName();
        if (!name.startsWith(THREAD_PREFIX_CALL_REQUEST)) {
            throw new IllegalArgumentException("Wrong code usage: client commands code must run in CALL threads, but used in " + name, new Throwable());
        }
    }

    public static void ensureRunInGUISwingThread() {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalArgumentException("Wrong code usage: GUI related code must run in SWING thread by SwingUtilities.invokeLater", new Throwable());
        }
    }
}

