/*
 * Decompiled with CFR 0.152.
 */
package mage.util;

import java.util.ArrayList;
import java.util.List;

public class TreeNode<T> {
    protected T data;
    protected List<TreeNode<T>> children = new ArrayList<TreeNode<T>>();

    public TreeNode() {
    }

    public TreeNode(T data) {
        this();
        super.setData(data);
    }

    public List<TreeNode<T>> getChildren() {
        return this.children;
    }

    public int getNumberOfChildren() {
        return this.getChildren().size();
    }

    public boolean hasChildren() {
        return this.getNumberOfChildren() > 0;
    }

    public void setChildren(List<TreeNode<T>> children) {
        this.children = children;
    }

    public void addChild(TreeNode<T> child) {
        this.children.add(child);
    }

    public void addChild(T child) {
        this.children.add(new TreeNode<T>(child));
    }

    public void addChildAt(int index, TreeNode<T> child) throws IndexOutOfBoundsException {
        this.children.add(index, child);
    }

    public void removeChildren() {
        this.children.clear();
    }

    public void removeChildAt(int index) throws IndexOutOfBoundsException {
        this.children.remove(index);
    }

    public TreeNode<T> getChildAt(int index) throws IndexOutOfBoundsException {
        return this.children.get(index);
    }

    public T getData() {
        return this.data;
    }

    private void setData(T data) {
        this.data = data;
    }

    public String toString() {
        return this.getData().toString();
    }

    public int hashCode() {
        return this.getData().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TreeNode other = (TreeNode)obj;
        return this.data == other.data || this.data != null && this.data.equals(other.data);
    }
}

