/*
 * Decompiled with CFR 0.152.
 */
package mage.util.functions;

import mage.MageObject;
import mage.abilities.Abilities;
import mage.abilities.Ability;
import mage.abilities.effects.common.continuous.BecomesFaceDownCreatureEffect;
import mage.abilities.keyword.PrototypeAbility;
import mage.cards.Card;
import mage.constants.CardType;
import mage.constants.SuperType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.PermanentCard;
import mage.game.permanent.PermanentToken;
import mage.game.permanent.token.EmptyToken;
import mage.game.permanent.token.Token;
import mage.game.stack.Spell;
import mage.util.CardUtil;

public class CopyTokenFunction {
    protected final Token target;

    private CopyTokenFunction(Token target) {
        if (target == null) {
            throw new IllegalArgumentException("Target can't be null");
        }
        this.target = target;
    }

    public static Token createTokenCopy(Card source, Game game) {
        return CopyTokenFunction.createTokenCopy(source, game, null);
    }

    public static Token createTokenCopy(Card source, Game game, Spell spell) {
        return new CopyTokenFunction(new EmptyToken(source.isTransformable())).from(source, game, spell);
    }

    public void apply(Card source, Game game) {
        if (this.target == null) {
            throw new IllegalArgumentException("Target can't be null");
        }
        this.target.setEntersTransformed(source instanceof Permanent && ((Permanent)source).isTransformed());
        if (source instanceof PermanentToken) {
            Token sourceObj = ((PermanentToken)source).getToken();
            this.target.setCopySourceCard(sourceObj.getCopySourceCard());
            CopyTokenFunction.copyToToken(this.target, sourceObj, game);
            CardUtil.copySetAndCardNumber(this.target, source);
            if (sourceObj.getBackFace() != null) {
                CopyTokenFunction.copyToToken(this.target.getBackFace(), sourceObj.getBackFace(), game);
                CardUtil.copySetAndCardNumber(this.target.getBackFace(), sourceObj.getBackFace());
            }
            return;
        }
        if (source instanceof PermanentCard) {
            PermanentCard sourcePermanent = (PermanentCard)source;
            BecomesFaceDownCreatureEffect.FaceDownType faceDownType = BecomesFaceDownCreatureEffect.findFaceDownType(game, sourcePermanent);
            if (faceDownType != null) {
                BecomesFaceDownCreatureEffect.makeFaceDownObject(game, null, this.target, faceDownType, null);
                return;
            }
            Card sourceObj = sourcePermanent.getCard();
            this.target.setCopySourceCard(sourceObj);
            CopyTokenFunction.copyToToken(this.target, sourceObj, game);
            CardUtil.copySetAndCardNumber(this.target, sourceObj);
            if (sourceObj.isTransformable()) {
                CopyTokenFunction.copyToToken(this.target.getBackFace(), sourceObj.getSecondCardFace(), game);
                CardUtil.copySetAndCardNumber(this.target.getBackFace(), sourceObj.getSecondCardFace());
            }
            if (((PermanentCard)source).isPrototyped()) {
                Abilities<Ability> abilities = source.getAbilities();
                for (Ability ability : abilities) {
                    if (!(ability instanceof PrototypeAbility)) continue;
                    ((PrototypeAbility)ability).prototypePermanent(this.target, game);
                }
            }
            return;
        }
        Card sourceObj = CardUtil.getDefaultCardSideForBattlefield(game, source.getMainCard());
        this.target.setCopySourceCard(sourceObj);
        CopyTokenFunction.copyToToken(this.target, sourceObj, game);
        CardUtil.copySetAndCardNumber(this.target, sourceObj);
        if (source.isTransformable()) {
            if (this.target.getBackFace() == null) {
                throw new IllegalStateException("Wrong code usage: back face must be non null: " + this.target.getName() + " - " + this.target.getClass().getSimpleName());
            }
            CopyTokenFunction.copyToToken(this.target.getBackFace(), source.getSecondCardFace(), game);
            CardUtil.copySetAndCardNumber(this.target.getBackFace(), source.getSecondCardFace());
        }
    }

    private static void copyToToken(Token target, MageObject sourceObj, Game game) {
        target.setName(sourceObj.getName());
        target.getColor().setColor(sourceObj.getColor());
        target.getManaCost().clear();
        target.getManaCost().add(sourceObj.getManaCost().copy());
        target.removeAllCardTypes();
        for (CardType cardType : sourceObj.getCardType()) {
            target.addCardType(cardType);
        }
        target.getSubtype().copyFrom(sourceObj.getSubtype());
        target.getSuperType().clear();
        for (SuperType superType : sourceObj.getSuperType()) {
            target.addSuperType(superType);
        }
        target.getAbilities().clear();
        for (Ability ability : sourceObj.getAbilities()) {
            Ability ability2 = ability.copy();
            ability2.newOriginalId();
            target.addAbility(ability2, true);
        }
        target.setPower(sourceObj.getPower().getBaseValue());
        target.setToughness(sourceObj.getToughness().getBaseValue());
        target.setStartingLoyalty(sourceObj.getStartingLoyalty());
        target.setStartingDefense(sourceObj.getStartingDefense());
    }

    private Token from(Card source, Game game, Spell spell) {
        this.apply(source, game);
        if (spell != null) {
            this.target.setZoneChangeCounter(spell.getZoneChangeCounter(game), game);
            this.target.setStartingLoyalty(spell.getStartingLoyalty());
            this.target.setStartingDefense(spell.getStartingDefense());
        } else {
            this.target.setZoneChangeCounter(source.getZoneChangeCounter(game), game);
        }
        return this.target;
    }
}

