/*
 * Decompiled with CFR 0.152.
 */
package mage.util.functions;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.SuperType;
import mage.filter.predicate.mageobject.MageObjectReferencePredicate;
import mage.game.Game;
import mage.game.stack.StackObject;
import mage.util.functions.CopyApplier;
import mage.util.functions.StackObjectCopyApplier;

public class RemoveTypeCopyApplier
extends CopyApplier
implements StackObjectCopyApplier {
    private final CardType type;
    private final SuperType superType;
    private final SubType subType;

    public RemoveTypeCopyApplier(CardType type) {
        this.type = type;
        this.superType = null;
        this.subType = null;
    }

    public RemoveTypeCopyApplier(SuperType superType) {
        this.superType = superType;
        this.subType = null;
        this.type = null;
    }

    public RemoveTypeCopyApplier(SubType subType) {
        this.subType = subType;
        this.superType = null;
        this.type = null;
    }

    @Override
    public boolean apply(Game game, MageObject blueprint, Ability source, UUID targetObjectId) {
        if (this.type != null && blueprint.getCardType().contains((Object)this.type)) {
            blueprint.getCardType().remove((Object)this.type);
        } else if (this.superType != null && blueprint.getSuperType().contains((Object)this.superType)) {
            blueprint.getSuperType().remove((Object)this.superType);
        } else if (this.subType != null && blueprint.getSubtype().contains((Object)this.subType)) {
            blueprint.getSubtype().remove((Object)this.subType);
        }
        return true;
    }

    @Override
    public void modifySpell(StackObject stackObject, Game game) {
        if (this.type != null && stackObject.getCardType().contains((Object)this.type)) {
            stackObject.getCardType().remove((Object)this.type);
        } else if (this.superType != null && stackObject.getSuperType().contains((Object)this.superType)) {
            stackObject.getSuperType().remove((Object)this.superType);
        } else if (this.subType != null && stackObject.getSubtype().contains((Object)this.subType)) {
            stackObject.getSubtype().remove((Object)this.subType);
        }
    }

    @Override
    public MageObjectReferencePredicate getNextNewTargetType() {
        return null;
    }
}

