/*
 * Decompiled with CFR 0.152.
 */
package mage.watchers.common;

import java.util.HashMap;
import java.util.Map;
import mage.abilities.Ability;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.watchers.Watcher;

public class AbilityResolvedWatcher
extends Watcher {
    private final Map<String, Integer> resolutionMap = new HashMap<String, Integer>();

    public AbilityResolvedWatcher() {
        super(WatcherScope.GAME);
    }

    @Override
    public void watch(GameEvent event, Game game) {
        if (event.getType() == GameEvent.EventType.RESOLVING_ABILITY) {
            this.resolutionMap.merge(event.getTargetId().toString() + game.getState().getZoneChangeCounter(event.getSourceId()), 1, Integer::sum);
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.resolutionMap.clear();
    }

    public static int getResolutionCount(Game game, Ability source) {
        return game.getState().getWatcher(AbilityResolvedWatcher.class).resolutionMap.getOrDefault(source.getOriginalId().toString() + game.getState().getZoneChangeCounter(source.getSourceId()), 0);
    }
}

