/*
 * Decompiled with CFR 0.152.
 */
package mage.watchers.common;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.EntersTheBattlefieldEvent;
import mage.game.events.GameEvent;
import mage.watchers.Watcher;

public class ArtifactEnteredControllerWatcher
extends Watcher {
    private final Set<UUID> players = new HashSet<UUID>();

    public ArtifactEnteredControllerWatcher() {
        super(WatcherScope.GAME);
    }

    @Override
    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.ENTERS_THE_BATTLEFIELD) {
            return;
        }
        EntersTheBattlefieldEvent eEvent = (EntersTheBattlefieldEvent)event;
        if (eEvent.getTarget() != null && eEvent.getTarget().isArtifact(game)) {
            this.players.add(eEvent.getTarget().getControllerId());
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.players.clear();
    }

    public static boolean enteredArtifactForPlayer(UUID playerId, Game game) {
        return game.getState().getWatcher(ArtifactEnteredControllerWatcher.class).players.contains(playerId);
    }
}

