/*
 * Decompiled with CFR 0.152.
 */
package mage.watchers.common;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.watchers.Watcher;

public class AttackingBlockingDelayedWatcher
extends Watcher {
    private Set<UUID> attackers = new HashSet<UUID>();
    private Set<UUID> blockers = new HashSet<UUID>();

    public AttackingBlockingDelayedWatcher() {
        super(WatcherScope.GAME);
    }

    @Override
    public void watch(GameEvent event, Game game) {
        switch (event.getType()) {
            case LAND_PLAYED: 
            case TAKEN_SPECIAL_ACTION: 
            case RESOLVING_ABILITY: 
            case DAMAGED_BATCH_FOR_PERMANENTS: {
                this.attackers = game.getCombat().getAttackers();
                this.blockers = game.getCombat().getBlockers();
            }
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.attackers.clear();
        this.blockers.clear();
    }

    public boolean checkAttacker(UUID attacker) {
        return this.attackers.contains(attacker);
    }

    public boolean checkBlocker(UUID blocker) {
        return this.blockers.contains(blocker);
    }

    public long countBlockers() {
        return this.blockers.size();
    }

    public long countAttackers() {
        return this.attackers.size();
    }

    public static AttackingBlockingDelayedWatcher getWatcher(Game game) {
        return game.getState().getWatcher(AttackingBlockingDelayedWatcher.class);
    }
}

