/*
 * Decompiled with CFR 0.152.
 */
package mage.watchers.common;

import java.util.HashSet;
import java.util.Set;
import mage.MageObjectReference;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.watchers.Watcher;

public class BlockedThisTurnWatcher
extends Watcher {
    private final Set<MageObjectReference> blockedThisTurnCreatures = new HashSet<MageObjectReference>();

    public BlockedThisTurnWatcher() {
        super(WatcherScope.GAME);
    }

    @Override
    public void watch(GameEvent event, Game game) {
        if (event.getType() == GameEvent.EventType.BLOCKER_DECLARED) {
            this.blockedThisTurnCreatures.add(new MageObjectReference(event.getSourceId(), game));
        }
    }

    public Set<MageObjectReference> getBlockedThisTurnCreatures() {
        return this.blockedThisTurnCreatures;
    }

    public boolean checkIfBlocked(Permanent permanent, Game game) {
        return this.blockedThisTurnCreatures.stream().anyMatch(mor -> mor.refersTo(permanent, game));
    }

    @Override
    public void reset() {
        super.reset();
        this.blockedThisTurnCreatures.clear();
    }
}

