/*
 * Decompiled with CFR 0.152.
 */
package mage.watchers.common;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;
import mage.watchers.Watcher;

public class CardsAmountDrawnThisTurnWatcher
extends Watcher {
    private final Map<UUID, Integer> amountOfCardsDrawnThisTurn = new HashMap<UUID, Integer>();

    public CardsAmountDrawnThisTurnWatcher() {
        super(WatcherScope.GAME);
    }

    @Override
    public void watch(GameEvent event, Game game) {
        if (event.getType() == GameEvent.EventType.DREW_CARD) {
            this.amountOfCardsDrawnThisTurn.putIfAbsent(event.getPlayerId(), 0);
            this.amountOfCardsDrawnThisTurn.compute(event.getPlayerId(), (k, amount) -> amount + 1);
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.amountOfCardsDrawnThisTurn.clear();
    }

    public boolean opponentDrewXOrMoreCards(UUID playerId, int x, Game game) {
        Player player = game.getPlayer(playerId);
        if (player != null) {
            for (Map.Entry<UUID, Integer> entry : this.amountOfCardsDrawnThisTurn.entrySet()) {
                if (!game.isOpponent(player, entry.getKey()) || entry.getValue() < x) continue;
                return true;
            }
        }
        return false;
    }

    public int getAmountCardsDrawn(UUID playerId) {
        return this.amountOfCardsDrawnThisTurn.getOrDefault(playerId, 0);
    }
}

