/*
 * Decompiled with CFR 0.152.
 */
package mage.watchers.common;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.constants.PhaseStep;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.watchers.Watcher;

public class CardsDrawnDuringDrawStepWatcher
extends Watcher {
    private final Map<UUID, Integer> amountOfCardsDrawnThisTurn = new HashMap<UUID, Integer>();

    public CardsDrawnDuringDrawStepWatcher() {
        super(WatcherScope.GAME);
    }

    @Override
    public void watch(GameEvent event, Game game) {
        UUID playerId;
        if (event.getType() == GameEvent.EventType.DREW_CARD && game.getPhase() != null && game.getPhase().getStep().getType() == PhaseStep.DRAW && (playerId = event.getPlayerId()) != null) {
            this.amountOfCardsDrawnThisTurn.putIfAbsent(playerId, 0);
            this.amountOfCardsDrawnThisTurn.compute(playerId, (k, amount) -> amount + 1);
        }
    }

    public int getAmountCardsDrawn(UUID playerId) {
        return this.amountOfCardsDrawnThisTurn.getOrDefault(playerId, 0);
    }

    @Override
    public void reset() {
        super.reset();
        this.amountOfCardsDrawnThisTurn.clear();
    }
}

