/*
 * Decompiled with CFR 0.152.
 */
package mage.watchers.common;

import java.util.HashSet;
import java.util.Set;
import mage.MageObjectReference;
import mage.cards.Card;
import mage.constants.WatcherScope;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.MilledCardEvent;
import mage.watchers.Watcher;

public class CardsMilledWatcher
extends Watcher {
    private final Set<MageObjectReference> milledThisTurn = new HashSet<MageObjectReference>();

    public CardsMilledWatcher() {
        super(WatcherScope.GAME);
    }

    @Override
    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.MILLED_CARD) {
            return;
        }
        Card card = ((MilledCardEvent)event).getCard(game);
        if (card == null) {
            return;
        }
        Card mainCard = card.getMainCard();
        if (game.getState().getZone(mainCard.getId()) != Zone.GRAVEYARD) {
            return;
        }
        this.milledThisTurn.add(new MageObjectReference(mainCard, game));
    }

    @Override
    public void reset() {
        super.reset();
        this.milledThisTurn.clear();
    }

    public static boolean wasMilledThisTurn(MageObjectReference morMainCard, Game game) {
        CardsMilledWatcher watcher = game.getState().getWatcher(CardsMilledWatcher.class);
        return watcher != null && watcher.milledThisTurn.contains(morMainCard);
    }
}

