/*
 * Decompiled with CFR 0.152.
 */
package mage.watchers.common;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.watchers.Watcher;

public class CastFromGraveyardWatcher
extends Watcher {
    private final Map<UUID, Set<Integer>> spellsCastFromGraveyard = new HashMap<UUID, Set<Integer>>();

    public CastFromGraveyardWatcher() {
        super(WatcherScope.GAME);
    }

    @Override
    public void watch(GameEvent event, Game game) {
        Spell spell;
        if (event.getType() == GameEvent.EventType.SPELL_CAST && event.getZone() == Zone.GRAVEYARD && (spell = (Spell)game.getObject(event.getTargetId())) != null) {
            Set zcc = this.spellsCastFromGraveyard.computeIfAbsent(spell.getSourceId(), k -> new HashSet());
            zcc.add(spell.getZoneChangeCounter(game));
        }
    }

    public boolean spellWasCastFromGraveyard(UUID sourceId, int zcc) {
        Set<Integer> zccSet = this.spellsCastFromGraveyard.get(sourceId);
        return zccSet != null && zccSet.contains(zcc);
    }

    @Override
    public void reset() {
        super.reset();
        this.spellsCastFromGraveyard.clear();
    }
}

