/*
 * Decompiled with CFR 0.152.
 */
package mage.watchers.common;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.watchers.Watcher;

public class CompletedDungeonWatcher
extends Watcher {
    private final Map<UUID, Set<String>> playerMap = new HashMap<UUID, Set<String>>();
    private static final Set<String> emptySet = new HashSet<String>();

    public CompletedDungeonWatcher() {
        super(WatcherScope.GAME);
    }

    @Override
    public void watch(GameEvent event, Game game) {
        switch (event.getType()) {
            case DUNGEON_COMPLETED: {
                this.playerMap.computeIfAbsent(event.getPlayerId(), u -> new HashSet()).add(event.getData());
                return;
            }
            case BEGINNING_PHASE_PRE: {
                if (game.getTurnNum() != 1) break;
                this.playerMap.clear();
            }
        }
    }

    public static boolean checkPlayer(UUID playerId, Game game) {
        CompletedDungeonWatcher watcher = game.getState().getWatcher(CompletedDungeonWatcher.class);
        return watcher != null && !watcher.playerMap.getOrDefault(playerId, emptySet).isEmpty();
    }

    public static Set<String> getCompletedNames(UUID playerId, Game game) {
        CompletedDungeonWatcher watcher = game.getState().getWatcher(CompletedDungeonWatcher.class);
        return watcher != null ? watcher.playerMap.getOrDefault(playerId, emptySet) : emptySet;
    }
}

