/*
 * Decompiled with CFR 0.152.
 */
package mage.watchers.common;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mage.MageObjectReference;
import mage.cards.Card;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;
import mage.util.CardUtil;
import mage.watchers.Watcher;

public class ForetoldWatcher
extends Watcher {
    private final Set<MageObjectReference> foretoldCards = new HashSet<MageObjectReference>();
    private final Map<UUID, Integer> playerForetellCount = new HashMap<UUID, Integer>();

    public ForetoldWatcher() {
        super(WatcherScope.GAME);
    }

    @Override
    public void watch(GameEvent event, Game game) {
        Player player;
        if (event.getType() != GameEvent.EventType.CARD_FORETOLD) {
            return;
        }
        Card card = game.getCard(event.getTargetId());
        if (card != null) {
            this.foretoldCards.add(new MageObjectReference(card, game, 1));
        }
        if (event.getFlag() && (player = game.getPlayer(event.getPlayerId())) != null) {
            this.playerForetellCount.compute(player.getId(), CardUtil::setOrIncrementValue);
        }
    }

    public boolean checkForetold(UUID sourceId, Game game) {
        return this.foretoldCards.contains(new MageObjectReference(sourceId, game));
    }

    public int getPlayerForetellCountThisTurn(UUID playerId) {
        return this.playerForetellCount.getOrDefault(playerId, 0);
    }

    @Override
    public void reset() {
        super.reset();
        this.playerForetellCount.clear();
    }
}

