/*
 * Decompiled with CFR 0.152.
 */
package mage.watchers.common;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.cards.Card;
import mage.constants.WatcherScope;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.stack.Spell;
import mage.watchers.Watcher;

public class PermanentWasCastWatcher
extends Watcher {
    private final Set<UUID> permanentsCasted = new HashSet<UUID>();

    public PermanentWasCastWatcher() {
        super(WatcherScope.GAME);
    }

    @Override
    public void watch(GameEvent event, Game game) {
        Card card;
        Card card2;
        Spell spell;
        if (event.getType() == GameEvent.EventType.SPELL_CAST && (spell = (Spell)game.getObject(event.getTargetId())) != null && (card2 = game.getCard(spell.getSourceId())) != null && card2.isPermanent(game)) {
            this.permanentsCasted.add(card2.getId());
        }
        if (event.getType() == GameEvent.EventType.ZONE_CHANGE && ((ZoneChangeEvent)event).getFromZone() == Zone.BATTLEFIELD && (card = game.getCard(event.getTargetId())) != null && card.isPermanent(game)) {
            this.permanentsCasted.remove(card.getId());
        }
    }

    public boolean wasPermanentCastThisTurn(UUID permanentSourceId) {
        return this.permanentsCasted.contains(permanentSourceId);
    }

    @Override
    public void reset() {
        super.reset();
        this.permanentsCasted.clear();
    }
}

