/*
 * Decompiled with CFR 0.152.
 */
package mage.watchers.common;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.constants.RollDieType;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.DieRolledEvent;
import mage.game.events.GameEvent;
import mage.watchers.Watcher;

public class PlanarRollWatcher
extends Watcher {
    private final Map<UUID, Integer> numberTimesPlanarDieRolled = new HashMap<UUID, Integer>();

    public PlanarRollWatcher() {
        super(WatcherScope.GAME);
    }

    @Override
    public void watch(GameEvent event, Game game) {
        DieRolledEvent drEvent;
        UUID playerId;
        if (event.getType() == GameEvent.EventType.DIE_ROLLED && (playerId = (drEvent = (DieRolledEvent)event).getTargetId()) != null && drEvent.getRollDieType() == RollDieType.PLANAR) {
            Integer amount = this.numberTimesPlanarDieRolled.get(playerId);
            if (amount == null) {
                amount = 1;
            } else {
                Integer n = amount;
                Integer n2 = amount = Integer.valueOf(amount + 1);
            }
            this.numberTimesPlanarDieRolled.put(playerId, amount);
        }
    }

    public int getNumberTimesPlanarDieRolled(UUID playerId) {
        return this.numberTimesPlanarDieRolled.getOrDefault(playerId, 0);
    }

    @Override
    public void reset() {
        super.reset();
        this.numberTimesPlanarDieRolled.clear();
    }

    public void removePlanarDieRoll(UUID playerId) {
        Integer amount = this.numberTimesPlanarDieRolled.get(playerId);
        if (amount != null) {
            this.numberTimesPlanarDieRolled.put(playerId, amount - 1);
        }
    }
}

