/*
 * Decompiled with CFR 0.152.
 */
package mage.watchers.common;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.DamagedEvent;
import mage.game.events.GameEvent;
import mage.util.CardUtil;
import mage.watchers.Watcher;

public class PlayerDamagedBySourceWatcher
extends Watcher {
    private final Set<String> damageSourceIds = new HashSet<String>();
    private final Set<String> combatDamageSourceIds = new HashSet<String>();

    public PlayerDamagedBySourceWatcher() {
        super(WatcherScope.PLAYER);
    }

    @Override
    public void watch(GameEvent event, Game game) {
        if (event.getType() == GameEvent.EventType.DAMAGED_PLAYER && event.getTargetId().equals(this.controllerId)) {
            String sourceId = CardUtil.getCardZoneString(null, event.getSourceId(), game);
            this.damageSourceIds.add(sourceId);
            if (((DamagedEvent)event).isCombatDamage()) {
                this.combatDamageSourceIds.add(sourceId);
            }
        }
    }

    public boolean hasSourceDoneDamage(UUID sourceId, Game game) {
        return this.damageSourceIds.contains(CardUtil.getCardZoneString(null, sourceId, game));
    }

    public boolean hasSourceDoneCombatDamage(UUID sourceId, Game game) {
        return this.combatDamageSourceIds.contains(CardUtil.getCardZoneString(null, sourceId, game));
    }

    @Override
    public void reset() {
        super.reset();
        this.damageSourceIds.clear();
        this.combatDamageSourceIds.clear();
    }
}

