/*
 * Decompiled with CFR 0.152.
 */
package mage.game;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.SignatureSpellCastOnlyWithOathbreakerEffect;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.condition.Condition;
import mage.abilities.condition.common.OathbreakerOnBattlefieldCondition;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.InfoEffect;
import mage.abilities.effects.common.continuous.CommanderReplacementEffect;
import mage.abilities.effects.common.cost.CommanderCostModification;
import mage.abilities.hint.ConditionHint;
import mage.abilities.hint.Hint;
import mage.cards.Card;
import mage.constants.CommanderCardType;
import mage.constants.MultiplayerAttackOption;
import mage.constants.RangeOfInfluence;
import mage.game.Game;
import mage.game.GameCommanderImpl;
import mage.game.OathbreakerFreeForAllType;
import mage.game.match.MatchType;
import mage.game.mulligan.Mulligan;
import mage.players.Player;
import mage.watchers.common.CommanderInfoWatcher;

public class OathbreakerFreeForAll
extends GameCommanderImpl {
    private int numPlayers;
    private final Map<UUID, Set<UUID>> playerSignatureSpells = new HashMap<UUID, Set<UUID>>();
    private final Map<UUID, Set<UUID>> playerOathbreakers = new HashMap<UUID, Set<UUID>>();
    private static final String COMMANDER_NAME_OATHBREAKER = "Oathbreaker";
    private static final String COMMANDER_NAME_SIGNATURE_SPELL = "Signature Spell";

    public OathbreakerFreeForAll(MultiplayerAttackOption attackOption, RangeOfInfluence range, Mulligan mulligan, int startLife, int startHandSize) {
        super(attackOption, range, mulligan, 100, startLife, startHandSize);
        this.startingPlayerSkipsDraw = false;
    }

    public OathbreakerFreeForAll(OathbreakerFreeForAll game) {
        super((GameCommanderImpl)game);
        this.numPlayers = game.numPlayers;
        game.playerSignatureSpells.forEach((key, value) -> {
            Set cfr_ignored_0 = this.playerSignatureSpells.put((UUID)key, new HashSet(value));
        });
        game.playerOathbreakers.forEach((key, value) -> {
            Set cfr_ignored_0 = this.playerOathbreakers.put((UUID)key, new HashSet(value));
        });
    }

    private String getCommanderTypeName(Card commander) {
        return commander.isInstantOrSorcery() ? COMMANDER_NAME_SIGNATURE_SPELL : COMMANDER_NAME_OATHBREAKER;
    }

    public CommanderInfoWatcher initCommanderWatcher(Card commander, boolean checkCommanderDamage) {
        return new CommanderInfoWatcher(this.getCommanderTypeName(commander), commander.getId(), checkCommanderDamage);
    }

    public void initCommanderEffects(Card commander, Player player, Ability commanderAbility) {
        boolean isSignatureSpell = ((Set)this.playerSignatureSpells.getOrDefault(player.getId(), new HashSet())).contains(commander.getId());
        commanderAbility.addEffect((Effect)new CommanderReplacementEffect(commander.getId(), this.alsoHand, this.alsoLibrary, isSignatureSpell, this.getCommanderTypeName(commander)));
        commanderAbility.addEffect((Effect)new CommanderCostModification(commander));
        if (isSignatureSpell) {
            OathbreakerOnBattlefieldCondition condition = new OathbreakerOnBattlefieldCondition((Game)this, player.getId(), commander.getId(), (Set)this.playerOathbreakers.getOrDefault(player.getId(), new HashSet()));
            commanderAbility.addEffect((Effect)new SignatureSpellCastOnlyWithOathbreakerEffect((Condition)condition, commander.getId()));
            SimpleStaticAbility ability = new SimpleStaticAbility((Effect)new InfoEffect("Signature spell hint"));
            ability.addHint((Hint)new ConditionHint((Condition)condition, "Oathbreaker on battlefield (" + condition.getCompatibleNames() + ")"));
            ability.setRuleVisible(false);
            commander.addAbility((Ability)ability);
        }
    }

    private void addInnerCommander(Map<UUID, Set<UUID>> destList, UUID playerId, UUID cardId) {
        HashSet<UUID> list = destList.getOrDefault(playerId, null);
        if (list == null) {
            list = new HashSet<UUID>();
            destList.put(playerId, list);
        }
        list.add(cardId);
    }

    public void addCommander(Card card, Player player) {
        super.addCommander(card, player);
        if (card.isInstantOrSorcery()) {
            this.addInnerCommander(this.playerSignatureSpells, player.getId(), card.getId());
        } else {
            this.addInnerCommander(this.playerOathbreakers, player.getId(), card.getId());
        }
    }

    public MatchType getGameType() {
        return new OathbreakerFreeForAllType();
    }

    public int getNumPlayers() {
        return this.numPlayers;
    }

    public void setNumPlayers(int numPlayers) {
        this.numPlayers = numPlayers;
    }

    public OathbreakerFreeForAll copy() {
        return new OathbreakerFreeForAll(this);
    }

    public Set<UUID> getCommandersIds(Player player, CommanderCardType commanderCardType, boolean returnAllCardParts) {
        HashSet<UUID> res = new HashSet<UUID>();
        if (player != null) {
            Set commanders = this.playerOathbreakers.getOrDefault(player.getId(), new HashSet());
            Set spells = this.playerSignatureSpells.getOrDefault(player.getId(), new HashSet());
            block5: for (UUID commanderId : super.getCommandersIds(player, commanderCardType, returnAllCardParts)) {
                switch (commanderCardType) {
                    case ANY: {
                        res.add(commanderId);
                        continue block5;
                    }
                    case COMMANDER_OR_OATHBREAKER: {
                        if (!commanders.contains(commanderId)) continue block5;
                        res.add(commanderId);
                        continue block5;
                    }
                    case SIGNATURE_SPELL: {
                        if (!spells.contains(commanderId)) continue block5;
                        res.add(commanderId);
                        continue block5;
                    }
                }
                throw new IllegalStateException("Unknown commander type " + commanderCardType);
            }
        }
        return super.filterCommandersBySearchZone(res, returnAllCardParts);
    }
}

