/*
 * Decompiled with CFR 0.152.
 */
package mage.deck;

import java.util.HashMap;
import mage.cards.ExpansionSet;
import mage.cards.Sets;
import mage.cards.decks.Constructed;
import mage.cards.decks.Deck;
import mage.cards.decks.DeckValidatorErrorType;

public class EuropeanHighlander
extends Constructed {
    public EuropeanHighlander() {
        super("European Highlander", "EuroLander");
        for (ExpansionSet set : Sets.getInstance().values()) {
            if (!set.getSetType().isEternalLegal()) continue;
            this.setCodes.add(set.getCode());
        }
        this.banned.add("Ancestral Recall");
        this.banned.add("Balance");
        this.banned.add("Birthing Pod");
        this.banned.add("Black Lotus");
        this.banned.add("Flash");
        this.banned.add("Gifts Ungiven");
        this.banned.add("Library of Alexandria");
        this.banned.add("Mana Crypt");
        this.banned.add("Mana Vault");
        this.banned.add("Mind Twist");
        this.banned.add("Mystical Tutor");
        this.banned.add("Mox Emerald");
        this.banned.add("Mox Jet");
        this.banned.add("Mox Pearl");
        this.banned.add("Mox Ruby");
        this.banned.add("Mox Sapphire");
        this.banned.add("Natural Order");
        this.banned.add("Sensei's Divining Top");
        this.banned.add("Skullclamp");
        this.banned.add("Sol Ring");
        this.banned.add("Strip Mine");
        this.banned.add("Survival of the Fittest");
        this.banned.add("Time Vault");
        this.banned.add("Time Walk");
        this.banned.add("Tinker");
        this.banned.add("Tolarian Academy");
        this.banned.add("Treasure Cruise");
        this.banned.add("True-Name Nemesis");
        this.banned.add("Umezawa's Jitte");
        this.banned.add("Vampiric Tutor");
    }

    public int getDeckMinSize() {
        return 100;
    }

    public boolean validate(Deck deck) {
        this.errorsList.clear();
        boolean valid = super.validate(deck);
        if (deck.getMaindeckCards().size() < 100) {
            this.addError(DeckValidatorErrorType.DECK_SIZE, "Deck", "Must contain 100 or more singleton cards: has " + deck.getMaindeckCards().size() + " cards");
            valid = false;
        }
        if (!deck.getSideboard().isEmpty()) {
            this.addError(DeckValidatorErrorType.DECK_SIZE, "Sideboard", "Sideboard can't contain any cards: has " + deck.getSideboard().size() + " cards");
            valid = false;
        }
        HashMap counts = new HashMap();
        this.countCards(counts, deck.getCards());
        valid = this.checkCounts(1, counts) && valid;
        return valid;
    }
}

