/*
 * Decompiled with CFR 0.152.
 */
package mage.tournament;

import mage.constants.TournamentPlayerState;
import mage.game.draft.BoosterDraft;
import mage.game.draft.DraftOptions;
import mage.game.events.TableEvent;
import mage.game.tournament.TournamentOptions;
import mage.game.tournament.TournamentPlayer;
import mage.game.tournament.TournamentSwiss;

public class BoosterDraftSwissTournament
extends TournamentSwiss {
    protected TournamentStep currentStep = TournamentStep.START;

    public BoosterDraftSwissTournament(TournamentOptions options) {
        super(options);
    }

    protected void draft() {
        this.draft = new BoosterDraft((DraftOptions)this.options.getLimitedOptions(), this.getSets());
        for (TournamentPlayer player : this.players.values()) {
            this.draft.addPlayer(player.getPlayer());
            player.setState(TournamentPlayerState.DRAFTING);
        }
        this.tableEventSource.fireTableEvent(TableEvent.EventType.START_DRAFT, null, this.draft);
    }

    public void nextStep() {
        switch (this.currentStep) {
            case START: {
                this.currentStep = TournamentStep.DRAFT;
                this.draft();
                break;
            }
            case DRAFT: {
                this.currentStep = TournamentStep.CONSTRUCT;
                this.construct();
                break;
            }
            case CONSTRUCT: {
                this.currentStep = TournamentStep.COMPETE;
                this.runTournament();
                break;
            }
            case COMPETE: {
                this.currentStep = TournamentStep.WINNERS;
                this.winners();
                this.end();
            }
        }
    }

    protected static enum TournamentStep {
        START,
        DRAFT,
        CONSTRUCT,
        COMPETE,
        WINNERS;

    }
}

