/*
 * Decompiled with CFR 0.152.
 */
package mage.tournament;

import mage.constants.TournamentPlayerState;
import mage.game.draft.DraftOptions;
import mage.game.draft.RichManBoosterDraft;
import mage.game.events.TableEvent;
import mage.game.tournament.TournamentOptions;
import mage.game.tournament.TournamentPlayer;
import mage.tournament.BoosterDraftSwissTournament;

public class RichManDraftSwissTournament
extends BoosterDraftSwissTournament {
    public RichManDraftSwissTournament(TournamentOptions options) {
        super(options);
    }

    @Override
    protected void draft() {
        this.draft = new RichManBoosterDraft((DraftOptions)this.options.getLimitedOptions(), this.getSets());
        for (TournamentPlayer player : this.players.values()) {
            this.draft.addPlayer(player.getPlayer());
            player.setState(TournamentPlayerState.DRAFTING);
        }
        this.tableEventSource.fireTableEvent(TableEvent.EventType.START_DRAFT, null, this.draft);
    }

    @Override
    public void nextStep() {
        if (this.isAbort()) {
            this.currentStep = BoosterDraftSwissTournament.TournamentStep.COMPETE;
        }
        switch (this.currentStep) {
            case START: {
                this.currentStep = BoosterDraftSwissTournament.TournamentStep.DRAFT;
                this.draft();
                break;
            }
            case DRAFT: {
                this.currentStep = BoosterDraftSwissTournament.TournamentStep.CONSTRUCT;
                this.construct();
                break;
            }
            case CONSTRUCT: {
                this.currentStep = BoosterDraftSwissTournament.TournamentStep.COMPETE;
                this.runTournament();
                break;
            }
            case COMPETE: {
                this.currentStep = BoosterDraftSwissTournament.TournamentStep.WINNERS;
                this.winners();
                this.end();
            }
        }
    }
}

