/*
 * Decompiled with CFR 0.152.
 */
package mage.player.ai;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import mage.abilities.Ability;
import mage.abilities.ActivatedAbility;
import mage.abilities.common.PassAbility;
import mage.cards.Card;
import mage.constants.PhaseStep;
import mage.constants.RangeOfInfluence;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.combat.Combat;
import mage.game.combat.CombatGroup;
import mage.player.ai.ComputerPlayer;
import mage.player.ai.MCTSExecutor;
import mage.player.ai.MCTSNode;
import mage.player.ai.MCTSPlayer;
import mage.players.Player;
import mage.util.XmageThreadFactory;
import org.apache.log4j.Logger;

public class ComputerPlayerMCTS
extends ComputerPlayer {
    private static final int THINK_MIN_RATIO = 40;
    private static final int THINK_MAX_RATIO = 100;
    private static final double THINK_TIME_MULTIPLIER = 2.0;
    private static final boolean USE_MULTIPLE_THREADS = true;
    protected transient MCTSNode root;
    protected int maxThinkTime;
    private static final Logger logger = Logger.getLogger(ComputerPlayerMCTS.class);
    private int poolSize;
    private ExecutorService threadPoolSimulations = null;
    protected String lastPhase = "";
    protected long totalThinkTime = 0L;
    protected long totalSimulations = 0L;

    public ComputerPlayerMCTS(String name, RangeOfInfluence range, int skill) {
        super(name, range);
        this.human = false;
        this.maxThinkTime = (int)((double)skill * 2.0);
        this.poolSize = Runtime.getRuntime().availableProcessors();
    }

    protected ComputerPlayerMCTS(UUID id) {
        super(id);
    }

    public ComputerPlayerMCTS(ComputerPlayerMCTS player) {
        super((ComputerPlayer)player);
    }

    public ComputerPlayerMCTS copy() {
        return new ComputerPlayerMCTS(this);
    }

    public boolean priority(Game game) {
        if (game.getTurnStepType() == PhaseStep.UPKEEP && !this.lastPhase.equals(game.getTurn().getValue(game.getTurnNum()))) {
            this.logList(game.getTurn().getValue(game.getTurnNum()) + this.name + " hand: ", new ArrayList(this.hand.getCards(game)));
            this.lastPhase = game.getTurn().getValue(game.getTurnNum());
        }
        game.getState().setPriorityPlayerId(this.playerId);
        game.firePriorityEvent(this.playerId);
        this.getNextAction(game, MCTSPlayer.NextAction.PRIORITY);
        Ability ability = this.root.getAction();
        if (ability == null) {
            logger.fatal((Object)"null ability");
        }
        this.activateAbility((ActivatedAbility)ability, game);
        if (ability instanceof PassAbility) {
            return false;
        }
        this.logLife(game);
        logger.info((Object)("choose action:" + this.root.getAction() + " success ratio: " + this.root.getWinRatio()));
        return true;
    }

    protected void calculateActions(Game game, MCTSPlayer.NextAction action) {
        if (this.root == null) {
            Game sim = this.createMCTSGame(game);
            MCTSPlayer player = (MCTSPlayer)sim.getPlayer(this.playerId);
            player.setNextAction(action);
            this.root = new MCTSNode(this.playerId, sim);
        }
        this.applyMCTS(game, action);
        if (this.root != null && this.root.bestChild() != null) {
            this.root = this.root.bestChild();
            this.root.emancipate();
        }
    }

    protected void getNextAction(Game game, MCTSPlayer.NextAction nextAction) {
        if (this.root != null) {
            MCTSNode newRoot = this.root.getMatchingState(game.getState().getValue(game, this.playerId));
            if (newRoot != null) {
                newRoot.emancipate();
            } else {
                logger.info((Object)"unable to find matching state");
            }
            this.root = newRoot;
        }
        this.calculateActions(game, nextAction);
    }

    public void selectAttackers(Game game, UUID attackingPlayerId) {
        StringBuilder sb = new StringBuilder();
        sb.append(game.getTurn().getValue(game.getTurnNum())).append(" player ").append(this.name).append(" attacking with: ");
        this.getNextAction(game, MCTSPlayer.NextAction.SELECT_ATTACKERS);
        Combat combat = this.root.getCombat();
        UUID opponentId = (UUID)game.getCombat().getDefenders().iterator().next();
        for (UUID attackerId : combat.getAttackers()) {
            this.declareAttacker(attackerId, opponentId, game, false);
            sb.append(game.getPermanent(attackerId).getName()).append(',');
        }
        logger.info((Object)sb.toString());
        MCTSNode.logHitMiss();
    }

    public void selectBlockers(Ability source, Game game, UUID defendingPlayerId) {
        StringBuilder sb = new StringBuilder();
        sb.append(game.getTurn().getValue(game.getTurnNum())).append(" player ").append(this.name).append(" blocking: ");
        this.getNextAction(game, MCTSPlayer.NextAction.SELECT_BLOCKERS);
        Combat simulatedCombat = this.root.getCombat();
        List currentGroups = game.getCombat().getGroups();
        for (int i = 0; i < currentGroups.size(); ++i) {
            if (i >= simulatedCombat.getGroups().size()) continue;
            CombatGroup currentGroup = (CombatGroup)currentGroups.get(i);
            CombatGroup simulatedGroup = (CombatGroup)simulatedCombat.getGroups().get(i);
            sb.append(game.getPermanent((UUID)currentGroup.getAttackers().get(0)).getName()).append(" with: ");
            for (UUID blockerId : simulatedGroup.getBlockers()) {
                if (currentGroup.getBlockers().contains(blockerId)) continue;
                this.declareBlocker(this.getId(), blockerId, (UUID)currentGroup.getAttackers().get(0), game);
                sb.append(game.getPermanent(blockerId).getName()).append(',');
            }
            sb.append('|');
        }
        logger.info((Object)sb.toString());
        MCTSNode.logHitMiss();
    }

    protected void applyMCTS(Game game, MCTSPlayer.NextAction action) {
        int thinkTime = this.calculateThinkTime(game, action);
        if (thinkTime > 0) {
            ArrayList<MCTSExecutor> tasks;
            block8: {
                if (this.threadPoolSimulations == null) {
                    this.threadPoolSimulations = new ThreadPoolExecutor(this.poolSize, this.poolSize, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new XmageThreadFactory("AI-SIM-MCTS"));
                }
                tasks = new ArrayList<MCTSExecutor>();
                for (int i = 0; i < this.poolSize; ++i) {
                    Game sim = this.createMCTSGame(game);
                    MCTSPlayer mCTSPlayer = (MCTSPlayer)sim.getPlayer(this.playerId);
                    mCTSPlayer.setNextAction(action);
                    MCTSExecutor exec = new MCTSExecutor(sim, this.playerId, thinkTime);
                    tasks.add(exec);
                }
                try {
                    List runningTasks = this.threadPoolSimulations.invokeAll(tasks, thinkTime, TimeUnit.SECONDS);
                    for (Future future : runningTasks) {
                        future.get();
                    }
                }
                catch (InterruptedException | CancellationException e) {
                    logger.warn((Object)"applyMCTS timeout");
                }
                catch (ExecutionException e) {
                    if (!this.isTestMode() || !this.isFastFailInTestMode()) break block8;
                    throw new IllegalStateException("One of the simulated games raise the error: " + e, e);
                }
            }
            int simCount = 0;
            for (MCTSExecutor mCTSExecutor : tasks) {
                simCount += mCTSExecutor.getSimCount();
                this.root.merge(mCTSExecutor.getRoot());
                mCTSExecutor.clear();
            }
            tasks.clear();
            this.totalThinkTime += (long)thinkTime;
            this.totalSimulations += (long)simCount;
            logger.info((Object)("Player: " + this.name + " Simulated " + simCount + " games in " + thinkTime + " seconds - nodes in tree: " + this.root.size()));
            logger.info((Object)("Total: Simulated " + this.totalSimulations + " games in " + this.totalThinkTime + " seconds - Average: " + this.totalSimulations / this.totalThinkTime));
            MCTSNode.logHitMiss();
        }
    }

    private int calculateThinkTime(Game game, MCTSPlayer.NextAction action) {
        int nodeSizeRatio = 0;
        if (this.root.getNumChildren() > 0) {
            nodeSizeRatio = this.root.getVisits() / this.root.getNumChildren();
        }
        PhaseStep curStep = game.getTurnStepType();
        int thinkTime = action == MCTSPlayer.NextAction.SELECT_ATTACKERS || action == MCTSPlayer.NextAction.SELECT_BLOCKERS ? (nodeSizeRatio < 40 ? this.maxThinkTime : (nodeSizeRatio >= 100 ? 0 : this.maxThinkTime / 2)) : (game.isActivePlayer(this.playerId) && (curStep == PhaseStep.PRECOMBAT_MAIN || curStep == PhaseStep.POSTCOMBAT_MAIN) && game.getStack().isEmpty() ? (nodeSizeRatio < 40 ? this.maxThinkTime : (nodeSizeRatio >= 100 ? 0 : this.maxThinkTime / 2)) : (nodeSizeRatio < 40 ? this.maxThinkTime / 2 : 0));
        return thinkTime;
    }

    protected Game createMCTSGame(Game game) {
        Game mcts = game.createSimulationForAI();
        for (Player copyPlayer : mcts.getState().getPlayers().values()) {
            Player origPlayer = (Player)game.getState().getPlayers().get((Object)copyPlayer.getId());
            MCTSPlayer newPlayer = new MCTSPlayer(copyPlayer.getId());
            newPlayer.restore(origPlayer);
            newPlayer.setMatchPlayer(origPlayer.getMatchPlayer());
            if (!newPlayer.getId().equals(this.playerId)) {
                int handSize = newPlayer.getHand().size();
                newPlayer.getLibrary().addAll(newPlayer.getHand().getCards(mcts), mcts);
                newPlayer.getHand().clear();
                newPlayer.getLibrary().shuffle();
                for (int i = 0; i < handSize; ++i) {
                    Card card = newPlayer.getLibrary().drawFromTop(mcts);
                    card.setZone(Zone.HAND, mcts);
                    newPlayer.getHand().add(card);
                }
            } else {
                newPlayer.getLibrary().shuffle();
            }
            mcts.getState().getPlayers().put((Object)copyPlayer.getId(), (Object)newPlayer);
        }
        mcts.resume();
        return mcts;
    }

    protected void displayMemory() {
        long heapSize = Runtime.getRuntime().totalMemory();
        long heapMaxSize = Runtime.getRuntime().maxMemory();
        long heapFreeSize = Runtime.getRuntime().freeMemory();
        long heapUsedSize = heapSize - heapFreeSize;
        long mb = 0x100000L;
        logger.info((Object)("Max heap size: " + heapMaxSize / mb + " Heap size: " + heapSize / mb + " Used: " + heapUsedSize / mb));
    }

    protected void logLife(Game game) {
        StringBuilder sb = new StringBuilder();
        sb.append(game.getTurn().getValue(game.getTurnNum()));
        for (Player player : game.getPlayers().values()) {
            sb.append("[player ").append(player.getName()).append(':').append(player.getLife()).append(']');
        }
        logger.info((Object)sb.toString());
    }
}

